/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.formplugin;

import kd.bos.base.param.constant.OperationTypeEnum;
import kd.bos.base.param.utils.GatedLaunchUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.StringUtils;

public class GatedLaunchAppSaveOptPlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SaveValidate());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        GatedLaunchUtils.updateGrayAppUserInfo(e.getDataEntities(), OperationTypeEnum.SAVE);
    }

    static class SaveValidate
    extends AbstractValidator {
        SaveValidate() {
        }

        public void validate() {
            if ("save".equals(this.getOperateKey())) {
                for (ExtendedDataEntity dynamicObject : this.dataEntities) {
                    DynamicObject baseData = dynamicObject.getDataEntity();
                    String version = baseData.getString("version");
                    if (StringUtils.isEmpty((String)version)) {
                        this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"\u201c\u7248\u672c\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GatedLaunchAppSaveOptPlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]));
                    }
                    DynamicObjectCollection user = baseData.getDynamicObjectCollection("user");
                    DynamicObjectCollection userGroup = baseData.getDynamicObjectCollection("usergroup");
                    if (user != null && !user.isEmpty() || userGroup != null && !userGroup.isEmpty()) continue;
                    this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"\u201c\u4eba\u5458\u201d\u3001\u201c\u7528\u6237\u5206\u7ec4\u201d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"GatedLaunchAppSaveOptPlugin_0", (String)"bos-base-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

