/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.base.formplugin.GatedLaunchListDataProvider;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.UserScopeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class GatedLaunchListPluginListPlugin
extends AbstractListPlugin {
    private static final String BOS_USERTREELISTF7 = "bos_usertreelistf7";
    private static final String TREE_USERGROUP = "treeview";
    private static final String GATEDLAUNCH_LIST = "billlistap";
    private static final String PGCACHE_FILTER = "pgCache_initFilter";
    private static final String CACHEVALUE_NOFILTER = "noFilter";
    private static final String BARITEM_ADD = "btn_add";
    private static final String BARITEM_DELETE = "btn_delete";
    private static final String CALLBACKID_DEL = "delete_comfirm";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new GatedLaunchListDataProvider());
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)Long.parseLong(RequestContext.get().getUserId()));
        if (!isAdmin) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u4f7f\u7528\u7ba1\u7406\u5458\u529f\u80fd\u3002", (String)"GatedLaunchListPluginListPlugin_0", (String)"bos-base-formplugin", (Object[])new Object[0]));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemkey = evt.getItemKey();
        BillList billList = (BillList)this.getView().getControl(GATEDLAUNCH_LIST);
        ListSelectedRowCollection rows = billList.getSelectedRows();
        switch (itemkey.toLowerCase(Locale.ENGLISH)) {
            case "btn_add": {
                Long userId = Long.valueOf(RequestContext.get().getUserId());
                boolean isAdmin = PermissionServiceHelper.isAdminUser((long)userId);
                if (isAdmin) {
                    this.showUserF7TreeList(isAdmin);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u6743\u6dfb\u52a0\u7528\u6237", (String)"GatedLaunchListPluginListPlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void showUserF7TreeList(boolean isAdmin) {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        ArrayList<QFilter> rangeFilterList = new ArrayList<QFilter>();
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        rangeFilterList.add(enableFilter);
        UserScopeResult userScopeResult = PermissionServiceHelper.getAdminChargeUser((Long)userId);
        if (!userScopeResult.isAllUser()) {
            List userIds = userScopeResult.getUserIDs();
            rangeFilterList.add(enableFilter.and(new QFilter("id", "in", (Object)userIds)));
        }
        lsp.setListFilterParameter(new ListFilterParameter(rangeFilterList, null));
        lsp.setCustomParam("externalUserType", (Object)"all");
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BOS_USERTREELISTF7));
        this.getView().showForm((FormShowParameter)lsp);
    }

    private QFilter getAdminChargeUserQFilter() {
        QFilter adminChargeUserQFilter = null;
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        boolean isSuperAdmin = true;
        if (isSuperAdmin) {
            this.getPageCache().put(PGCACHE_FILTER, CACHEVALUE_NOFILTER);
            return adminChargeUserQFilter;
        }
        UserScopeResult userScopeResult = PermissionServiceHelper.getAdminChargeUser((Long)userId);
        if (!userScopeResult.isAllUser()) {
            List adminChargeUsers = userScopeResult.getUserIDs();
            adminChargeUserQFilter = adminChargeUsers != null ? (adminChargeUsers.size() == 0 ? new QFilter("id", "in", null) : new QFilter("id", "in", (Object)adminChargeUsers)) : new QFilter("id", "in", null);
            this.getPageCache().put(PGCACHE_FILTER, adminChargeUserQFilter.toSerializedString());
        } else {
            this.getPageCache().put(PGCACHE_FILTER, CACHEVALUE_NOFILTER);
        }
        return adminChargeUserQFilter;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (!(e.getReturnData() instanceof ListSelectedRowCollection)) {
            return;
        }
        ListSelectedRowCollection users = (ListSelectedRowCollection)e.getReturnData();
        if (users == null || users.size() <= 0) {
            return;
        }
        switch (actionId) {
            case "bos_usertreelistf7": {
                this.addNewUser(users);
                ((IListView)this.getView()).refresh();
                break;
            }
        }
    }

    private void addNewUser(ListSelectedRowCollection users) {
        String accountId = RequestContext.get().getAccountId();
        int insertNum = 0;
        int isHave = 0;
        try (TXHandle h = TX.required();){
            DynamicObjectCollection insertDoc = new DynamicObjectCollection();
            try {
                String groupIdStr = "";
                long groupId = 0L;
                for (ListSelectedRow user : users) {
                    DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"gated_launch_user");
                    object.set("user", user.getPrimaryKeyValue());
                    DynamicObject userExist = BusinessDataServiceHelper.loadSingle((String)"gated_launch_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("user", "=", user.getPrimaryKeyValue())});
                    if (userExist != null) {
                        ++isHave;
                        continue;
                    }
                    insertDoc.add((Object)object);
                    ++insertNum;
                }
                SaveServiceHelper.save((DynamicObject[])((DynamicObject[])insertDoc.toArray((Object[])new DynamicObject[0])));
                this.updateGrayUserInfo();
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        if (users.size() == 1) {
            if (isHave == 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7528\u6237\u5df2\u5b58\u5728", (String)"GatedLaunchListPluginListPlugin_2", (String)"bos-base-formplugin", (Object[])new Object[0]));
            }
        } else {
            String saveSuccess = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"GatedLaunchListPluginListPlugin_3", (String)"bos-base-formplugin", (Object[])new Object[0]);
            if (isHave == 0) {
                this.getView().showSuccessNotification(saveSuccess);
            } else {
                String user = ResManager.loadKDString((String)"\u4e2a\u7528\u6237", (String)"GatedLaunchListPluginListPlugin_4", (String)"bos-base-formplugin", (Object[])new Object[0]);
                String existUser = ResManager.loadKDString((String)"\u4e2a\u7528\u6237\u5df2\u5b58\u5728", (String)"GatedLaunchListPluginListPlugin_5", (String)"bos-base-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(saveSuccess + insertNum + user + "\uff0c" + isHave + existUser, MessageBoxOptions.OK);
            }
        }
    }

    private void updateGrayUserInfo() {
        try {
            DynamicObject[] users = BusinessDataServiceHelper.load((String)"gated_launch_user", (String)"user", null);
            if (users != null && users.length > 0) {
                HashMap<String, Object> usermap = new HashMap<String, Object>(2);
                String accountid = RequestContext.get().getAccountId();
                if (accountid != null) {
                    usermap.put("accountId", accountid);
                }
                ArrayList<String> userIdList = new ArrayList<String>(users.length);
                for (DynamicObject dynamicObject : users) {
                    userIdList.add(dynamicObject.getString("user.id"));
                }
                usermap.put("userList", userIdList);
                LoginMCService.create().updateGrayUserInfo(usermap);
            }
        }
        catch (Exception e) {
            throw new KDException(e.getMessage());
        }
    }
}

