/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.formplugin;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class WorkWxConfigSavePlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(WorkWxConfigSavePlugin.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new AddValidate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DLock lock = null;
        try {
            lock = DLock.create((String)"base_wx_config_lock");
            lock.lock();
            if (e.getDataEntities() != null && e.getDataEntities().length > 0) {
                DynamicObject entity = e.getDataEntities()[0];
                Object isDefault = entity.get("isscan");
                if (StringUtils.isNotBlank((Object)isDefault) && Boolean.parseBoolean(isDefault.toString())) {
                    Object number = entity.get("agentid");
                    Object corpId = entity.get("corpid");
                    String sql = "update t_bas_wxqyh set fisscan='0' where fid not in (select fid from (select fid from t_bas_wxqyh where fisscan='1' and fagentid=? and fcorpid=?) b)";
                    ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
                    params.add(new SqlParameter("FAGENTID", 12, number));
                    params.add(new SqlParameter("FCORPID", 12, corpId));
                    DB.update((DBRoute)DBRoute.base, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
                } else {
                    logger.error("isDefault:\u503c\u4e3a:" + isDefault.toString());
                }
            }
        }
        catch (Exception ignore) {
            logger.error("\u4f01\u4e1a\u5fae\u4fe1\u5e94\u7528\u4fdd\u5b58\u5f02\u5e38:", (Throwable)ignore);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    static DataSet getDefault(String sql) {
        return DB.queryDataSet((String)"workWxConfigSavePlugin", (DBRoute)DBRoute.base, (String)sql);
    }

    static class AddValidate
    extends AbstractValidator {
        AddValidate() {
        }

        public void validate() {
            if ("save".equals(this.getOperateKey())) {
                for (ExtendedDataEntity dynamicObject : this.dataEntities) {
                    DynamicObject baseData = dynamicObject.getDataEntity();
                    String agentId = baseData.getString("agentid");
                    String corpId = baseData.getString("corpid");
                    boolean isScan = Boolean.parseBoolean(baseData.getString("isscan"));
                    String sql = "select fid,fcorpid, fagentid from t_bas_wxqyh where fisscan='1'";
                    try (DataSet dataSet = WorkWxConfigSavePlugin.getDefault(sql);){
                        boolean exist = dataSet.hasNext();
                        if (exist) {
                            Row row = dataSet.next();
                            String currentCropId = row.getString(1);
                            String currentAgentId = row.getString(2);
                            if (isScan || !agentId.equals(currentAgentId) || !corpId.equals(currentCropId)) continue;
                            this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"\u5f53\u524d\u5fc5\u987b\u6709\u5e94\u7528\u914d\u7f6e\u7528\u4e8e\u626b\u7801\u767b\u5f55\u3002", (String)"WorkWxConfigSavePlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]));
                            continue;
                        }
                        if (isScan) continue;
                        this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"\u5f53\u524d\u5fc5\u987b\u6709\u5e94\u7528\u914d\u7f6e\u7528\u4e8e\u626b\u7801\u767b\u5f55\u3002", (String)"WorkWxConfigSavePlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
    }
}

