/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.param.formplugin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.mc.tenant.AccountType;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.util.EncryptUtils;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import org.apache.commons.codec.binary.Base64;

public class BaseParameterFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String GROUPSECRET_RESOURCE_OPEN_LINKSPACE = "[groupsecret_resource_open_linkspace]";
    private static final String GROUPSECRET_RESOURCE_OPENIMPORT_R = "[groupsecret_resource_openimport_r]";
    private static final String GROUPSECRET_RESOURCE_XTINTERFACE = "[groupsecret_resource_xtinterface]";
    private static final String GROUPSECRET_RESOURCE_OPENIMPORT_RW = "[groupsecret_resource_openimport_rw]";
    private static final String GROUPSECRET_SSO_AUTH = "[groupsecret_sso_auth]";
    private static final String APP_SECRET = "appSecret";
    private static final String YZJ_PARAMETER_FORM = "yzjParameterForm";
    private static final String BOS_BASE_FORMPLUGIN = "bos-base-formplugin";
    private static final String EID = "eid";
    private static final String IS_ENABLE_ECOSPHERE = "isenableecosphere";
    private static final String IS_ENABLE_TEAM_WORK = "is_enable_team_work";
    private static final String IS_ENABLE_YZJ_PORTAL = "is_enable_yzj_portal";
    private static final String IS_ENABLE_AI_INSIGHT = "is_enable_ai_insight";
    private static final String SYNCMODE = "syncmode";
    private static final Log logger = LogFactory.getLog(BaseParameterFormPlugin.class);
    private static final String BTN_YZJ_KEY = "btn_yzjkey";
    private static final String KEY_YZJ_SPECIAL_VERSION = "isyzjspecialversion";
    private static final String KEY_YZJ_APP_HOST = "syunzhijiaapphost";
    private static final String KEY_YZJ_APP_ID = "syzjappid";
    private static final String KEY_YZJ_APP_SECRET = "syzjappsecret";
    private static final String KEY_YZJ_CONSUMER_KEY = "sconsumerkey";
    private static final String KEY_YZJ_CONSUMER_SECRET = "sconsumersecret";
    private static final String GET_YZJPARAM_BUTTONAP = "get_yzjparam_buttonap";
    private static final List<String> YZJ_SYN_MUST_INPUT_FIELDS = new ArrayList<String>(6);
    private static final List<String> YZJ_SPECIAL_VERSION_MUST_INPUT_FIELDS = new ArrayList<String>(4);
    private static final String[] KEY_CONTROLS = new String[]{"get_yzjparam_buttonap", "btn_yzjkey"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnYzjKey = (Button)this.getControl(BTN_YZJ_KEY);
        btnYzjKey.addUploadListener((UploadListener)this);
        Button yzjParamBtn = (Button)this.getControl(GET_YZJPARAM_BUTTONAP);
        yzjParamBtn.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object syncMode = this.getModel().getValue(SYNCMODE);
        boolean isMustInput = StringUtils.isNotBlank((Object)syncMode) && 1 != Integer.parseInt(syncMode.toString());
        this.updateYzjParamMustInput(isMustInput);
        Object yzjSpecialVersion = this.getModel().getValue(KEY_YZJ_SPECIAL_VERSION);
        isMustInput = StringUtils.isNotBlank((Object)yzjSpecialVersion) && Boolean.parseBoolean(yzjSpecialVersion.toString());
        this.updateTextFieldMustInput(isMustInput, YZJ_SPECIAL_VERSION_MUST_INPUT_FIELDS);
        Object yzjUrl = this.getModel().getValue("yzjurl");
        if (StringUtils.isBlank((Object)yzjUrl) || YzjConfigServiceHelper.isPublicCloud((String)yzjUrl.toString())) {
            this.getModel().setValue("yzjdeploymentmode", (Object)1);
        } else {
            this.getModel().setValue("yzjdeploymentmode", (Object)2);
        }
        Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        if (!BaseParameterFormPlugin.hasPrevilige(AccountType.ThridParty.toString(), account.getAllSourceTypes())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"sso"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"is_sso_force_login"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"sso_labelap"});
        }
        Object orgId = this.getView().getFormShowParameter().getCustomParam("orgid");
        long rootOrgId = ((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId();
        if (orgId != null && !StringUtils.equals((CharSequence)orgId.toString(), (CharSequence)(rootOrgId + ""))) {
            this.getView().setEnable(Boolean.FALSE, KEY_CONTROLS);
        }
    }

    public void upload(UploadEvent evt) {
        String url = (String)evt.getUrls()[0];
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        fileService.download(url, (OutputStream)outStream, "httpclient");
        byte[] fileBytes = outStream.toByteArray();
        try {
            EncryptUtils.restorePrivateKey((byte[])fileBytes);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u201c\u7cfb\u7edf\u96c6\u6210\u5bc6\u94a5\u201d\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4ece\u4e91\u4e4b\u5bb6\u4e0b\u8f7d\u5bc6\u94a5\u6587\u4ef6\u3002", (String)"BaseParameterFormPlugin_0", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String keyStr = Base64.encodeBase64String((byte[])fileBytes);
        this.getModel().setValue("yzjkey", (Object)keyStr);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u6210\u529f\u3002", (String)"BaseParameterFormPlugin_14", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        if (SYNCMODE.equals(proName)) {
            Object newMode = e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((Object)newMode) || 1 == Integer.parseInt(newMode.toString())) {
                this.updateYzjParamMustInput(false);
            } else {
                this.updateYzjParamMustInput(true);
            }
        } else if (KEY_YZJ_SPECIAL_VERSION.equals(proName)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (StringUtils.isBlank((Object)newValue) || !Boolean.parseBoolean(newValue.toString())) {
                this.updateTextFieldMustInput(false, YZJ_SPECIAL_VERSION_MUST_INPUT_FIELDS);
            } else if (StringUtils.isNotBlank((Object)newValue) && Boolean.parseBoolean(newValue.toString())) {
                this.updateTextFieldMustInput(true, YZJ_SPECIAL_VERSION_MUST_INPUT_FIELDS);
            }
        }
        this.setFieldVisible();
    }

    private void updateYzjParamMustInput(boolean isMustInput) {
        this.updateTextFieldMustInput(isMustInput, YZJ_SYN_MUST_INPUT_FIELDS);
        this.updateYzjSecretMustInput(isMustInput);
    }

    private void updateYzjSecretMustInput(boolean isMustInput) {
        boolean secretMustInput = isMustInput;
        if (secretMustInput && (Integer.toString(2).equals(this.getModel().getValue(SYNCMODE)) || StringUtils.isNotBlank((Object)this.getModel().getValue("yzjkey")))) {
            secretMustInput = false;
        }
        ArrayList<String> fields = new ArrayList<String>(1);
        fields.add("yzjsecret");
        this.updateTextFieldMustInput(secretMustInput, fields);
    }

    private void updateTextFieldMustInput(boolean mustInput, List<String> fields) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        IDataEntityType entityType = dataEntity.getDataEntityType();
        DataEntityPropertyCollection proMap = entityType.getProperties();
        for (String field : fields) {
            TextEdit textField = (TextEdit)this.getControl(field);
            if (null == textField) continue;
            textField.setMustInput(mustInput);
            TextProp entityPro = (TextProp)proMap.get((Object)field);
            entityPro.setMustInput(mustInput);
        }
        this.getView().updateView();
        this.getModel().updateCache();
    }

    public static boolean hasPrevilige(String currentType, String[] allTypes) {
        boolean hasPre = false;
        if (StringUtils.isNotEmpty((CharSequence)currentType) && allTypes != null) {
            for (String tempString : allTypes) {
                if (!currentType.equals(tempString)) continue;
                hasPre = true;
                break;
            }
        }
        return hasPre;
    }

    public void click(EventObject evt) {
        if (!(evt instanceof ClickEvent)) {
            return;
        }
        Control c = (Control)evt.getSource();
        String clickKey = c.getKey();
        if (GET_YZJPARAM_BUTTONAP.equals(clickKey)) {
            Object yzjUrl = this.getModel().getValue("yzjurl");
            Object eid = this.getModel().getValue(EID);
            Object syzjappid = this.getModel().getValue(KEY_YZJ_APP_ID);
            if (ObjectUtils.isEmpty((Object)yzjUrl)) {
                this.showFieldTips("yzjurl", ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (String)"BaseParameterFormPlugin_5", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]), false);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4e91\u4e4b\u5bb6\u5730\u5740\u201d\u3002", (String)"BaseParameterFormPlugin_2", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            if (ObjectUtils.isEmpty((Object)eid)) {
                this.showFieldTips(EID, ResManager.loadKDString((String)"\u5de5\u4f5c\u5708\u4e0d\u80fd\u4e3a\u7a7a", (String)"BaseParameterFormPlugin_6", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]), false);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5de5\u4f5c\u5708EID\u201d\u3002", (String)"BaseParameterFormPlugin_1", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            if (ObjectUtils.isEmpty((Object)syzjappid)) {
                syzjappid = "cosmic01";
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("bos_yzjparam_form");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, Object> formData = new HashMap<String, Object>(16);
            formData.put("yzjurl", yzjUrl);
            formData.put(EID, eid);
            formData.put(KEY_YZJ_APP_ID, syzjappid);
            fsp.setCustomParams(formData);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, YZJ_PARAMETER_FORM));
            this.getView().showForm(fsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map values;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (YZJ_PARAMETER_FORM.equals(actionId) && (values = (Map)e.getReturnData()) != null && values.size() > 0) {
            Object secret;
            if (!ObjectUtils.isEmpty(values.get(APP_SECRET))) {
                this.getModel().setValue(KEY_YZJ_APP_SECRET, values.get(APP_SECRET));
            }
            if (!ObjectUtils.isEmpty(values.get(GROUPSECRET_SSO_AUTH))) {
                this.getModel().setValue("team_work_sso_secret", values.get(GROUPSECRET_SSO_AUTH));
            }
            if (!ObjectUtils.isEmpty(values.get(GROUPSECRET_RESOURCE_XTINTERFACE))) {
                this.getModel().setValue("imservicekey", values.get(GROUPSECRET_RESOURCE_XTINTERFACE));
            }
            if (!ObjectUtils.isEmpty(values.get(GROUPSECRET_RESOURCE_OPENIMPORT_R))) {
                this.getModel().setValue("readkey", values.get(GROUPSECRET_RESOURCE_OPENIMPORT_R));
            }
            if (!ObjectUtils.isEmpty(values.get(GROUPSECRET_RESOURCE_OPEN_LINKSPACE))) {
                this.getModel().setValue("syncecospherekey1", values.get(GROUPSECRET_RESOURCE_OPEN_LINKSPACE));
            }
            if (!ObjectUtils.isEmpty(secret = values.get(GROUPSECRET_RESOURCE_OPENIMPORT_RW))) {
                this.getModel().setValue("yzjsecret", secret);
            }
            this.getModel().setValue(KEY_YZJ_APP_HOST, this.getModel().getValue("yzjurl"));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u96c6\u6210\u53c2\u6570\u5df2\u66f4\u65b0\uff0c\u6267\u884c\u4fdd\u5b58\u540e\u751f\u6548\u3002", (String)"BaseParameterFormPlugin_10", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void showFieldTips(String field, String tips, boolean isHidden) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setFieldKey(field);
        LocaleString ls = new LocaleString(tips);
        fieldTip.setTip(ls.getLocaleValue());
        fieldTip.setSuccess(isHidden);
        this.getView().showFieldTip(fieldTip);
    }

    public void beforeBindData(EventObject e) {
        this.setFieldVisible();
    }

    private void setFieldVisible() {
        this.getView().setVisible(Boolean.valueOf(this.getModel().getValue(IS_ENABLE_ECOSPHERE).equals(true)), new String[]{"cosphereparamflex"});
        this.getView().setVisible(Boolean.valueOf(this.getModel().getValue(IS_ENABLE_TEAM_WORK).equals(true)), new String[]{"team_work_sso_secret"});
        this.getView().setVisible(Boolean.valueOf(this.getModel().getValue(IS_ENABLE_YZJ_PORTAL).equals(true)), new String[]{"specialpanelflex"});
        this.getView().setVisible(Boolean.valueOf("2".equals(this.getModel().getValue(SYNCMODE))), new String[]{"syssynparam"});
        this.getView().setVisible(Boolean.valueOf("3".equals(this.getModel().getValue(SYNCMODE))), new String[]{"yzjsyncparam"});
        this.getView().setVisible(Boolean.valueOf(this.getModel().getValue(IS_ENABLE_AI_INSIGHT).equals(true)), new String[]{"ai_insight_form"});
    }

    static {
        YZJ_SYN_MUST_INPUT_FIELDS.add(EID);
        YZJ_SYN_MUST_INPUT_FIELDS.add("yzjurl");
        YZJ_SYN_MUST_INPUT_FIELDS.add("readkey");
        YZJ_SYN_MUST_INPUT_FIELDS.add("imservicekey");
        YZJ_SPECIAL_VERSION_MUST_INPUT_FIELDS.add(KEY_YZJ_APP_HOST);
        YZJ_SPECIAL_VERSION_MUST_INPUT_FIELDS.add(KEY_YZJ_APP_SECRET);
        YZJ_SPECIAL_VERSION_MUST_INPUT_FIELDS.add(KEY_YZJ_CONSUMER_KEY);
        YZJ_SPECIAL_VERSION_MUST_INPUT_FIELDS.add(KEY_YZJ_CONSUMER_SECRET);
    }
}

