/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.param.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Base64;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.param.utils.CaptchaGeneratorUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FieldTip;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DESUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.StringUtils;

public class YzjParameterFormPlugin
extends AbstractFormPlugin {
    private static final String CAPTCHA = "captcha";
    private static final String YZJ_PARAM = "yzj_param";
    private static final String YZJ_PASSWORD = "yzj_password";
    private static final String YZJ_ACCOUNT_NUMBER = "yzj_account_number";
    private static final String EID = "eid";
    private static final String APP_SECRET = "appSecret";
    private static final String ALIAS = "alias";
    private static final String ERROR_CODE = "errorCode";
    private static final Log logger = LogFactory.getLog(YzjParameterFormPlugin.class);
    private static final String GET_YZJPARAM_BTN = "get_yzjparam_btn";
    DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("yzj_data", new DistributeCacheHAPolicy());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button yzjParamBtn = (Button)this.getControl(GET_YZJPARAM_BTN);
        yzjParamBtn.addClickListener((ClickListener)this);
        Image image = (Image)this.getControl("imageap");
        image.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.generatorCaptcha();
    }

    public void click(EventObject evt) {
        if (!(evt instanceof ClickEvent)) {
            return;
        }
        Control c = (Control)evt.getSource();
        String clickKey = c.getKey();
        if (GET_YZJPARAM_BTN.equals(clickKey)) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            Object url = params.get("yzjurl");
            Object accountNo = this.getModel().getValue(YZJ_ACCOUNT_NUMBER);
            Object password = this.getModel().getValue(YZJ_PASSWORD);
            Object verifyCode = this.getModel().getValue("verifycode");
            String verifyCodeCache = (String)this.cache.get(CAPTCHA, RequestContext.get().getCurrUserId() + RequestContext.get().getAccountId());
            if (ObjectUtils.isEmpty((Object)accountNo)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YzjParameterFormPlugin_0", (String)"bos-base-formplugin", (Object[])new Object[0]));
                return;
            }
            if (ObjectUtils.isEmpty((Object)password)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YzjParameterFormPlugin_1", (String)"bos-base-formplugin", (Object[])new Object[0]));
                return;
            }
            if (ObjectUtils.isEmpty((Object)verifyCode)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YzjParameterFormPlugin_2", (String)"bos-base-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isEmpty((String)verifyCodeCache) || !verifyCodeCache.equalsIgnoreCase(verifyCode.toString())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"YzjParameterFormPlugin_3", (String)"bos-base-formplugin", (Object[])new Object[0]));
                if (StringUtils.isEmpty((String)verifyCodeCache)) {
                    this.generatorCaptcha();
                }
                return;
            }
            String times = (String)this.cache.get(YZJ_PARAM, accountNo.toString() + RequestContext.get().getAccountId());
            if (StringUtils.isNotEmpty((String)times) && Integer.parseInt(times) >= 10) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u8fde\u7eed\u8f93\u951910\u6b21\uff0c\u8bf710\u5206\u949f\u540e\u518d\u5c1d\u8bd5\u3002", (String)"YzjParameterFormPlugin_4", (String)"bos-base-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> header = new HashMap<String, String>(8);
            HashMap body = new HashMap(8);
            header.put("Content-Type", "application/x-www-form-urlencoded");
            body.put(EID, params.get(EID));
            body.put("appId", params.get("syzjappid"));
            body.put("exchangeBody", this.getExchangeBody(accountNo.toString(), password.toString(), params.get(EID).toString()));
            this.generatorCaptcha();
            try {
                StringBuilder stringBuilder = new StringBuilder(url.toString());
                stringBuilder.append("/api/support/oksystem");
                String data = HttpClientUtils.post((String)stringBuilder.toString(), header, body);
                HashMap<String, Object> values = new HashMap<String, Object>(8);
                JSONObject result = JSONObject.parseObject((String)data);
                if (null != result && null != result.get((Object)ERROR_CODE)) {
                    if ("100".equals(result.get((Object)ERROR_CODE).toString())) {
                        result = result.getJSONObject("data");
                        JSONArray array = result.getJSONArray("resGroupSecrets");
                        JSONObject obj = new JSONObject();
                        for (int i = 0; i < array.size(); ++i) {
                            obj = array.getJSONObject(i);
                            if (obj.get((Object)ALIAS) == null) continue;
                            values.put(obj.get((Object)ALIAS).toString(), obj.get((Object)"secret"));
                        }
                        obj = result.getJSONObject("sysAppSecret");
                        if (obj != null) {
                            values.put(APP_SECRET, obj.get((Object)APP_SECRET));
                        }
                        this.cache.remove(YZJ_PARAM, accountNo.toString() + RequestContext.get().getAccountId());
                    } else {
                        if ("10000601".equals(result.get((Object)ERROR_CODE).toString())) {
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f51\u5173\u7cfb\u7edf\u7ea7APPID\u672a\u6388\u6743", (String)"YzjParameterFormPlugin_5", (String)"bos-base-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        if ("3001".equals(result.get((Object)ERROR_CODE).toString())) {
                            times = StringUtils.isNotEmpty((String)times) ? String.valueOf(Integer.parseInt(times) + 1) : "1";
                            this.cache.put(YZJ_PARAM, accountNo.toString() + RequestContext.get().getAccountId(), times, 600);
                        }
                        this.getView().showErrorNotification(String.valueOf(result.get((Object)"error")));
                        return;
                    }
                }
                this.getView().returnDataToParent(values);
                this.getView().close();
            }
            catch (Exception e) {
                logger.warn((Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bbf\u95ee\u4e91\u4e4b\u5bb6\u5931\u8d25", (String)"YzjParameterFormPlugin_6", (String)"bos-base-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if ("imageap".equals(clickKey)) {
            this.generatorCaptcha();
        }
    }

    public String getExchangeBody(String accountNo, String password, String eid) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("accountNo", (Object)accountNo);
        jsonObject.put("password", (Object)password);
        Base64.Encoder encoder = Base64.getEncoder();
        String exchangeBody = new String(encoder.encode(DESUtils.encrypt((byte[])jsonObject.toJSONString().getBytes(), (String)eid.concat("$").concat("kingdeeonline"))));
        return exchangeBody;
    }

    private void showFieldTips(String field, String tips, boolean isHidden) {
        FieldTip fieldTip = new FieldTip();
        fieldTip.setFieldKey(field);
        LocaleString ls = new LocaleString(tips);
        fieldTip.setTip(ls.getLocaleValue());
        fieldTip.setSuccess(isHidden);
        this.getView().showFieldTip(fieldTip);
    }

    private void generatorCaptcha() {
        try {
            Map<String, Object> map = CaptchaGeneratorUtils.generatorCaptcha();
            if (!ObjectUtils.isEmpty(map)) {
                Image image = (Image)this.getControl("imageap");
                image.setUrl(map.get("content").toString());
                this.cache.put(CAPTCHA, RequestContext.get().getCurrUserId() + RequestContext.get().getAccountId(), map.get("verifycode").toString(), 60);
            }
        }
        catch (IOException var4) {
            logger.warn("\u9a8c\u8bc1\u7801\u751f\u6210\u5931\u8d25\u3002");
        }
    }
}

