/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.param.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.param.constant.OperationTypeEnum;
import kd.bos.base.param.utils.GrayUserGroupUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.HttpClientUtils;

public class GatedLaunchUtils {
    private static Log log = LogFactory.getLog(GatedLaunchUtils.class);

    public static void updateGrayAppUserInfo(DynamicObject[] dynamicObjects, OperationTypeEnum operationTypeEnum) {
        try {
            Map<String, Object> resultMap = operationTypeEnum == OperationTypeEnum.SAVE ? GatedLaunchUtils.getAddMap(dynamicObjects) : GatedLaunchUtils.getBatchOperationMap(dynamicObjects, operationTypeEnum);
            if (resultMap != null) {
                GatedLaunchUtils.invokeUpgradeGrayStrategy(resultMap);
            }
        }
        catch (Exception e) {
            throw new KDException(e.getMessage());
        }
    }

    private static Map<String, Object> getAddMap(DynamicObject[] dynamicObjects) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            List<Object> ids = Arrays.stream(dynamicObjects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DynamicObject[] gateLaunchObjects = GatedLaunchUtils.loadGateLaunch(ids);
            DynamicObject dynamicObject = gateLaunchObjects[0];
            String appIds = dynamicObject.getString("appids");
            String appGroup = dynamicObject.getString("version");
            String prodNum = dynamicObject.getString("displayprod");
            DynamicObjectCollection userDynamicObjects = (DynamicObjectCollection)dynamicObject.get("user");
            DynamicObjectCollection userGroupDynamicObjects = (DynamicObjectCollection)dynamicObject.get("usergroup");
            HashSet<Object> mergeUsers = new HashSet<Object>();
            if (userDynamicObjects != null && userDynamicObjects.size() != 0) {
                List users = userDynamicObjects.stream().map(o -> String.valueOf(o.getLong("fbasedataid_id"))).collect(Collectors.toList());
                mergeUsers.addAll(users);
            }
            if (userGroupDynamicObjects != null && userGroupDynamicObjects.size() != 0) {
                List<Long> groupIdList = userGroupDynamicObjects.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
                Set<String> groupUser = GrayUserGroupUtils.getMergeUsers(groupIdList);
                mergeUsers.addAll(groupUser);
            }
            String accountid = RequestContext.get().getAccountId();
            resultMap.put("accountId", accountid);
            ArrayList dataMapList = new ArrayList();
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("appIds", appIds);
            dataMap.put("appGroup", appGroup);
            dataMap.put("prodNum", prodNum);
            if (!mergeUsers.isEmpty()) {
                dataMap.put("users", mergeUsers);
            }
            dataMapList.add(dataMap);
            resultMap.put("data", dataMapList);
            return resultMap;
        }
        return null;
    }

    private static Map<String, Object> getBatchOperationMap(DynamicObject[] dynamicObjects, OperationTypeEnum operationType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            DynamicObject[] grayApps = null;
            if (operationType == OperationTypeEnum.DELETE) {
                grayApps = dynamicObjects;
            } else {
                List<Object> ids = Arrays.stream(dynamicObjects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
                grayApps = GatedLaunchUtils.loadGateLaunch(ids);
            }
            if (grayApps != null && grayApps.length > 0) {
                ArrayList dataMapList = new ArrayList(grayApps.length);
                for (DynamicObject grayApp : grayApps) {
                    String appIds = grayApp.getString("appids");
                    String appGroup = grayApp.getString("version");
                    String prodNum = grayApp.getString("displayprod");
                    String accountid = RequestContext.get().getAccountId();
                    resultMap.put("accountId", accountid);
                    HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                    dataMap.put("appIds", appIds);
                    dataMap.put("appGroup", appGroup);
                    dataMap.put("prodNum", prodNum);
                    if (operationType == OperationTypeEnum.ENABLE) {
                        DynamicObjectCollection userObjects = grayApp.getDynamicObjectCollection("user");
                        DynamicObjectCollection userGroupObjects = grayApp.getDynamicObjectCollection("usergroup");
                        HashSet<Object> mergeUsers = new HashSet<Object>();
                        if (userObjects != null && userObjects.size() > 0) {
                            List users = userObjects.stream().map(o -> String.valueOf(o.getLong("fbasedataid_id"))).collect(Collectors.toList());
                            mergeUsers.addAll(users);
                        }
                        if (userGroupObjects != null && userGroupObjects.size() > 0) {
                            List<Long> groupIds = userGroupObjects.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
                            Set<String> groupUsers = GrayUserGroupUtils.getMergeUsers(groupIds);
                            mergeUsers.addAll(groupUsers);
                        }
                        if (!mergeUsers.isEmpty()) {
                            dataMap.put("users", mergeUsers);
                        }
                    }
                    dataMapList.add(dataMap);
                }
                resultMap.put("data", dataMapList);
                return resultMap;
            }
        }
        return null;
    }

    public static DynamicObject[] loadGateLaunch(List<Object> ids) {
        return BusinessDataServiceHelper.load((String)"gated_launch_user_app", (String)GatedLaunchUtils.getSelectedFields(), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
    }

    private static String getSelectedFields() {
        return "id,appids,displayprod,version,user,enable,usergroup";
    }

    public static List<String> listProdNum() {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"gated_launch_user_app", (String)"displayprod", null);
        if (load != null && load.length != 0) {
            return Arrays.stream(load).map(o -> o.getString("displayprod")).collect(Collectors.toList());
        }
        return new ArrayList<String>(0);
    }

    private static Map<String, String> genMCHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(4);
        String token = GatedLaunchUtils.getMCToken();
        headers.put("api", "true");
        headers.put("access_token", token);
        headers.put("accessToken", token);
        return headers;
    }

    private static String getMCToken() {
        String mcUrl = System.getProperty("mc.server.url");
        String api = mcUrl + "/api/upgradeLogin.do";
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("accountId", "");
        String resp = "";
        try {
            resp = HttpClientUtils.postjson((String)api, null, (String)JSON.toJSONString(body));
            JSONObject json = JSON.parseObject((String)resp);
            String state = json.getString("state");
            if (!"success".equals(state)) {
                throw new IOException(String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8fd4\u56de\u9519\u8bef[%s]", (String)"GatedLaunchUtils_0", (String)"bos-base-formplugin", (Object[])new Object[0]), json.getString("errorMsg")));
            }
            JSONObject data = JSON.parseObject((String)json.getString("data"));
            return data.getString("access_token");
        }
        catch (IOException e) {
            log.warn("getMCToken error, resp: {}", (Object)resp, (Object)e);
            return resp;
        }
    }

    private static void invokeUpgradeGrayStrategy(Map<String, Object> body) {
        Map<String, String> headers = GatedLaunchUtils.genMCHeaders();
        String accountId = RequestContext.get().getAccountId();
        body.put("datacenterId", accountId);
        MCApiUtil.getMCAPIInfo((String)"/kapi/app/mc/upgradeGrayStrategy", (boolean)true, headers, body);
    }

    public static Object getGrayAppGroup() throws KDException {
        try {
            String clusterName = Instance.getClusterName();
            String accountId = RequestContext.get().getAccountId();
            HashMap<String, String> body = new HashMap<String, String>(2);
            body.put("clusterNumber", clusterName);
            body.put("datacenterId", accountId);
            return MCApiUtil.getMCAPIInfo((String)"/kapi/app/mc/getGrayAppGroup", (boolean)true, GatedLaunchUtils.genMCHeaders(), body);
        }
        catch (KDException e) {
            log.warn("getGrayAppGroup error:", (Throwable)e);
            throw e;
        }
    }
}

