/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.sql.formplugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.sql.formplugin.KSQLColumnUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class DataBaseSystemTableInfo {
    private static Log log = LogFactory.getLog(DataBaseSystemTableInfo.class);
    private static final String DATA_BASE_TYPE_ORACLE = "0";
    private static final String DATA_BASE_TYPE_POST_GRE_SQL = "1";
    private static final String DATA_BASE_TYPE_MYSQL = "2";
    private static final String DATA_BASE_TYPE_MD = "3";
    private static final String DATA_BASE_TYPE_GS = "4";
    private static final String DATA_BASE_TYPE_GS100 = "5";
    private static final String DATA_BASE_TYPE_SQLSERVER = "6";
    private static final String ORACLE_SYSTEM_TABLE_FILE = "/oracle_system_tables.txt";
    private static final String POST_GRE_SQL_SYSTEM_TABLE_FILE = "/postgresql_system_tables.txt";
    private static final String MYSQL_SYSTEM_TABLE_FILE = "/mysql_system_tables.txt";
    private static final String DM_SYSTEM_TABLE_FILE = "/dm_system_tables.txt";
    private static final String GS100_SYSTEM_TABLE_FILE = "/gs100_system_tables.txt";
    private static final String SQLSERVER_SYSTEM_TABLE_FILE = "/sqlserver_system_tables.txt";
    private static final String TABLE_SENSITIVE_COLUMN_FILE = "/table_sensitive_column.txt";
    private static final Map<String, List<String>> DATA_BASE_SYSTEM_TABLE_MAP = new HashMap<String, List<String>>(5);
    private static final Map<String, String[]> TABLE_COLUMN_MAP = new HashMap<String, String[]>(5);
    private static final String BOS_BASE_FORMPLUGIN = "bos-base-formplugin";

    private DataBaseSystemTableInfo() {
    }

    private static void initTableMapping(String type, String filePath) {
        try (InputStream in = DataBaseSystemTableInfo.class.getResourceAsStream(filePath);
             BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            ArrayList<String> tableNames = new ArrayList<String>(10);
            while ((line = reader.readLine()) != null) {
                tableNames.add(line);
            }
            DATA_BASE_SYSTEM_TABLE_MAP.put(type, tableNames);
        }
        catch (Exception e) {
            log.warn(String.format("\u521d\u59cb\u5316\u6570\u636e\u5e93\u7c7b\u578b\u4e3a:%s,\u6587\u4ef6\u540d\u4e3a:%s\u7684\u6570\u636e\u5e93\u7cfb\u7edf\u8868\u4fe1\u606f\u5931\u8d25...", type, filePath), (Throwable)e);
        }
    }

    public static boolean isSystemTable(String tableName, String type) {
        Map<String, List<String>> systemTableMap;
        List<String> tables;
        boolean isGs100Db;
        boolean bl = isGs100Db = (DATA_BASE_TYPE_GS.equals(type) || DATA_BASE_TYPE_POST_GRE_SQL.equals(type)) && Boolean.parseBoolean("pg_as_gs100");
        if (isGs100Db) {
            type = DATA_BASE_TYPE_GS100;
        }
        if (CollectionUtils.isEmpty(tables = (systemTableMap = DataBaseSystemTableInfo.getDataBaseSystemTableMap()).get(type))) {
            return false;
        }
        for (String table : tables) {
            if (StringUtils.isBlank((CharSequence)table)) continue;
            if (DATA_BASE_TYPE_MD.equals(type) && tableName.startsWith(table)) {
                return true;
            }
            if (!tableName.equals(table) && !table.startsWith(tableName)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, List<String>> getDataBaseSystemTableMap() {
        return Collections.unmodifiableMap(DATA_BASE_SYSTEM_TABLE_MAP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTableCloumnMapping(String filePath) {
        InputStream e = DataBaseSystemTableInfo.class.getResourceAsStream(filePath);
        if (e == null) {
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(e));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                TABLE_COLUMN_MAP.put(line.split(":")[0].trim(), line.split(":")[1].trim().split(","));
            }
        }
        catch (IOException e1) {
            log.warn((Throwable)e1);
        }
        finally {
            try {
                if (e != null) {
                    e.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                log.warn((Throwable)ex);
            }
        }
    }

    public static Map<String, String> useSensitiveColumnList(String sql) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        ArrayList<KSQLColumnUtil.Column> r = new ArrayList<KSQLColumnUtil.Column>(10);
        for (Map.Entry<String, String[]> entry : TABLE_COLUMN_MAP.entrySet()) {
            String[] columns;
            String table = entry.getKey();
            for (String column : columns = entry.getValue()) {
                r.add(new KSQLColumnUtil.Column(table, column));
            }
        }
        List<KSQLColumnUtil.FindColumnResult> check = null;
        try {
            check = KSQLColumnUtil.findColumnsInSelect(sql, r);
        }
        catch (Exception e) {
            log.warn("KSQLColumnUtil findColumnsInSelect error " + e);
            return returnMap;
        }
        try {
            String msg;
            if (check == null || check.size() == 0) {
                return returnMap;
            }
            StringBuilder message = new StringBuilder();
            StringBuilder temp = new StringBuilder();
            List<Set<KSQLColumnUtil.Column>> columnInSelect = check.get(0).getColumnInSelect();
            int columnInSelectlength = columnInSelect.size();
            for (int i = 0; i < columnInSelectlength; ++i) {
                Set<KSQLColumnUtil.Column> set = columnInSelect.get(i);
                if (set.size() == 0) continue;
                temp.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u5217", (String)"DataBaseSystemTableInfo_0", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]), i + 1));
                HashMap<String, String> selectDistincTableMap = new HashMap<String, String>();
                for (KSQLColumnUtil.Column column : set) {
                    selectDistincTableMap.put(column.getTable(), (selectDistincTableMap.get(column.getTable()) == null ? "" : (String)selectDistincTableMap.get(column.getTable())) + column.getColumn() + "\uff0c");
                }
                temp.append("\uff08");
                for (Map.Entry entry : selectDistincTableMap.entrySet()) {
                    msg = String.format(ResManager.loadKDString((String)"\u8868\u201c%1$s\u201d\u4e2d\u7684\u201c%2$s\u201d", (String)"DataBaseSystemTableInfo_1", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]), entry.getKey(), ((String)entry.getValue()).substring(0, ((String)entry.getValue()).length() - 1));
                    temp.append(msg);
                    temp.append("\uff0c");
                }
                temp.delete(temp.length() - 1, temp.length());
                temp.append("\uff09\uff0c");
            }
            if (temp.length() > 0) {
                message.append(ResManager.loadKDString((String)"\u67e5\u8be2\u8fd4\u56de\u90e8\u5206\uff1a", (String)"DataBaseSystemTableInfo_2", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0])).append(temp.subSequence(0, temp.length() - 1)).append(ResManager.loadKDString((String)"\u4e3a\u654f\u611f\u5b57\u6bb5\uff1b", (String)"DataBaseSystemTableInfo_3", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0])).append("\n");
            }
            Set<KSQLColumnUtil.Column> columnInCondition = check.get(0).getColumnInCondition();
            Iterator<KSQLColumnUtil.Column> it = columnInCondition.iterator();
            temp = new StringBuilder();
            HashMap<String, String> whereDistincTableMap = new HashMap<String, String>();
            while (it.hasNext()) {
                KSQLColumnUtil.Column column = it.next();
                whereDistincTableMap.put(column.getTable(), (whereDistincTableMap.get(column.getTable()) == null ? "" : (String)whereDistincTableMap.get(column.getTable())) + column.getColumn() + "\uff0c");
            }
            for (Map.Entry entry : whereDistincTableMap.entrySet()) {
                msg = String.format(ResManager.loadKDString((String)"\u8868\u201c%1$s\u201d\u4e2d\u7684\u201c%2$s\u201d", (String)"DataBaseSystemTableInfo_1", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]), entry.getKey(), ((String)entry.getValue()).substring(0, ((String)entry.getValue()).length() - 1));
                temp.append(msg);
                temp.append("\uff0c");
            }
            if (temp.length() > 0) {
                message.append(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u90e8\u5206\uff1a", (String)"DataBaseSystemTableInfo_4", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0])).append(temp.subSequence(0, temp.length() - 1)).append(ResManager.loadKDString((String)"\u4e3a\u654f\u611f\u5b57\u6bb5\uff1b", (String)"DataBaseSystemTableInfo_3", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (message.length() > 0) {
                returnMap.put("haveSensitiveOrError", message.toString());
            }
            return returnMap;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            returnMap.put("haveSensitiveOrError", e.getMessage());
            return returnMap;
        }
    }

    public static Map<String, String> getTableColumnMap() {
        if (CollectionUtils.isEmpty(TABLE_COLUMN_MAP)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> r = new HashMap<String, String>(10);
        try {
            for (Map.Entry<String, String[]> entry : TABLE_COLUMN_MAP.entrySet()) {
                String[] columns;
                String table = entry.getKey();
                for (String column : columns = entry.getValue()) {
                    r.put(column, column);
                }
            }
        }
        catch (Exception e) {
            log.warn("\u8bfb\u53d6\u8bbe\u7f6e\u7684\u8868\u654f\u611f\u5b57\u6bb5\u5f02\u5e38 " + e);
        }
        return r;
    }

    static {
        DataBaseSystemTableInfo.initTableMapping(DATA_BASE_TYPE_ORACLE, ORACLE_SYSTEM_TABLE_FILE);
        DataBaseSystemTableInfo.initTableMapping(DATA_BASE_TYPE_POST_GRE_SQL, POST_GRE_SQL_SYSTEM_TABLE_FILE);
        DataBaseSystemTableInfo.initTableMapping(DATA_BASE_TYPE_MYSQL, MYSQL_SYSTEM_TABLE_FILE);
        DataBaseSystemTableInfo.initTableMapping(DATA_BASE_TYPE_MD, DM_SYSTEM_TABLE_FILE);
        DataBaseSystemTableInfo.initTableMapping(DATA_BASE_TYPE_GS, POST_GRE_SQL_SYSTEM_TABLE_FILE);
        DataBaseSystemTableInfo.initTableMapping(DATA_BASE_TYPE_GS100, GS100_SYSTEM_TABLE_FILE);
        DataBaseSystemTableInfo.initTableMapping(DATA_BASE_TYPE_SQLSERVER, SQLSERVER_SYSTEM_TABLE_FILE);
        DataBaseSystemTableInfo.initTableCloumnMapping(TABLE_SENSITIVE_COLUMN_FILE);
    }
}

