/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.sql.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.sql.formplugin.ast.Query;
import kd.bos.base.sql.formplugin.ast.SimpleColumn;
import kd.bos.base.sql.formplugin.ast.TableColumnVisitor;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.parser.Lexer;
import kd.bos.ksql.parser.SqlParser;
import kd.bos.ksql.visitor.ASTVisitor;

public class KSQLColumnUtil {
    private KSQLColumnUtil() {
    }

    public static List<FindColumnResult> findColumnsInSelect(String sql, List<Column> columns) throws ParserException {
        Lexer lexer = new Lexer(sql.toLowerCase());
        SqlParser parser = new SqlParser(lexer);
        parser.setThrowExWhenNameTooLong(false);
        List stmtCol = (List)parser.parseStmtList();
        ArrayList<FindColumnResult> result = new ArrayList<FindColumnResult>(stmtCol.size());
        for (Object o : stmtCol) {
            result.add(KSQLColumnUtil.find((SqlStmt)o, columns));
        }
        return result;
    }

    private static FindColumnResult find(SqlStmt stmt, List<Column> columns) {
        TableColumnVisitor visitor = new TableColumnVisitor();
        Query query = (Query)stmt.accept((ASTVisitor)visitor);
        HashMap<String, Column> columnMap = new HashMap<String, Column>(columns.size());
        for (Column column : columns) {
            columnMap.put(column.getTable() + '.' + column.getColumn(), column);
        }
        FindColumnResult r = new FindColumnResult(query.getSelect().size());
        for (int i = 0; i < query.getSelect().size(); ++i) {
            List<SimpleColumn> simpleColumns = query.getSelect().get(i).getSimpleColumn();
            for (SimpleColumn c : simpleColumns) {
                String key = c.getTable() + '.' + c.getColumn();
                if (!columnMap.containsKey(key)) continue;
                r.putColumnInSelect(i, c.getTable(), c.getColumn());
            }
        }
        for (kd.bos.base.sql.formplugin.ast.Column column : query.getCondition()) {
            List<SimpleColumn> simpleColumns = column.getSimpleColumn();
            for (SimpleColumn c : simpleColumns) {
                String key = c.getTable() + '.' + c.getColumn();
                if (!columnMap.containsKey(key)) continue;
                r.putColumnInCondition(c.getTable(), c.getColumn());
            }
        }
        return r;
    }

    public static class Column {
        private final String table;
        private final String column;

        public Column(String table, String column) {
            this.table = table.toLowerCase();
            this.column = column.toLowerCase();
        }

        public String getTable() {
            return this.table;
        }

        public String getColumn() {
            return this.column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Column column1 = (Column)o;
            return Objects.equals(this.table, column1.table) && Objects.equals(this.column, column1.column);
        }

        public int hashCode() {
            return Objects.hash(this.table, this.column);
        }
    }

    public static class FindColumnResult {
        private final List<Set<Column>> columnInSelect = new ArrayList<Set<Column>>();
        private final Set<Column> columnInCondition = new HashSet<Column>();

        private FindColumnResult(int columnSize) {
            for (int i = 0; i < columnSize; ++i) {
                this.columnInSelect.add(i, new HashSet());
            }
        }

        protected void putColumnInCondition(String table, String column) {
            this.columnInCondition.add(new Column(table, column));
        }

        protected void putColumnInSelect(int idx, String table, String column) {
            this.columnInSelect.get(idx).add(new Column(table, column));
        }

        public List<Set<Column>> getColumnInSelect() {
            return this.columnInSelect;
        }

        public Set<Column> getColumnInCondition() {
            return this.columnInCondition;
        }
    }
}

