/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.sql.formplugin;

import java.util.List;
import kd.bos.bundle.Resources;
import kd.bos.ksql.dom.expr.SqlAllColumnExpr;
import kd.bos.ksql.dom.stmt.SqlStmt;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.parser.Lexer;
import kd.bos.ksql.parser.SqlParser;
import kd.bos.ksql.visitor.ASTVisitor;
import kd.bos.ksql.visitor.ASTVisitorBase;

public class KSQLSelectColumnCheckUtil {
    private KSQLSelectColumnCheckUtil() {
    }

    public static void check(String sql) throws ParserException, IllegalArgumentException {
        Lexer lexer = new Lexer(sql.toLowerCase());
        SqlParser parser = new SqlParser(lexer);
        parser.setThrowExWhenNameTooLong(false);
        List stmtCol = (List)parser.parseStmtList();
        ColumnVisitor columnVisitor = new ColumnVisitor();
        for (Object o : stmtCol) {
            ((SqlStmt)o).accept((ASTVisitor)columnVisitor);
        }
        if (columnVisitor.isSelectAll()) {
            throw new IllegalArgumentException(Resources.getString((String)"bos-ksql", (String)"KSqlLimiter_1", (Object[])new Object[0]));
        }
    }

    static class ColumnVisitor
    extends ASTVisitorBase<Object> {
        private boolean selectAll = false;

        ColumnVisitor() {
        }

        public Object visitSqlAllColumnExpr(SqlAllColumnExpr expr) {
            this.selectAll = true;
            return super.visitSqlAllColumnExpr(expr);
        }

        public boolean isSelectAll() {
            return this.selectAll;
        }
    }
}

