/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.sql.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.base.sql.formplugin.BasicFormatterImpl;
import kd.bos.base.sql.formplugin.DDLFormatterImpl;
import kd.bos.base.sql.formplugin.DataBaseSystemTableInfo;
import kd.bos.base.sql.formplugin.SQLParseUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.splittingread.RWContext;
import kd.bos.db.tx.RWTableInfo;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabCloseEvent;
import kd.bos.form.control.events.TabCloseListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.CodeEditListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.ksql.TransUtil;
import kd.bos.ksql.exception.ParserException;
import kd.bos.ksql.formater.FormatOptions;
import kd.bos.ksql.parser.Lexer;
import kd.bos.ksql.parser.SqlParser;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.xdb.QueryTimeout;
import org.jetbrains.annotations.NotNull;

public class SQLQueryAnalyzerPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener,
TabCloseListener,
CodeEditListener {
    private static final int TIME_OUT = 60;
    private static final int TABLE_LIMIT = 200;
    private static final String LINE_FEED = "\r\n";
    private static final Log log = LogFactory.getLog(SQLQueryAnalyzerPlugin.class);
    private static final String PREFIX_DIALECT = "/*dialect*/";
    private static final String SPLIT_FLAG = ";";
    private static final String PAGE_ID = "pageId";
    private static final String ENTER_LINE = "\n";
    private static final String REGEX_TEMPLATE_DATABASE = "\\[.*%s@(\\d{1,3}\\.){3}\\d{1,3}.*\\]";
    private static final String REGEX_TEMPLATE_SERVICE = "'%s'@'(\\d{1,3}\\.){3}\\d{1,3}'";
    private static final String RESULT_GRID = "bd_ksql_result_grid";
    private static final String RESULT_VIEW = "bd_ksql_result_view";
    private static final String RESULT_TAB_KEY = "resulttab";
    private static final String INFOMATION_TEXTAREA = "infomationtextarea";
    private static final String RESULT_AREA = "bd_ksql_result_area";
    private static final String TEXT_DBROUTE = "dbroute";
    private static final String TEXTAREA_SQLAREA = "sqlarea";
    private StringBuilder informationBuilder = new StringBuilder();
    private static final String BOS_BASE_FORMPLUGIN = "bos-base-formplugin";
    private static final String SHOWPAGEID = "showPageId";
    private static final String TEXT_DB_ROUTE = "dbRouteText";
    private static final String SHOW_TAB = "showTab";
    private static final String EXECUTE_RESULT = "executeresult";
    private static final String REMARK = "remark";
    private static final String NUMBER = "number";
    private static final String AUTO_COMPLETE = "autoComplete";
    private static final String TABPAGEAP_INFO = "tabpageap_info";
    private static final String MESSAGE_12 = "SQLQueryAnalyzerPlugin_12";
    private static final String UPDATE_HINTS = "updateHints";
    private static final String ENTRY_ENTITY_HIS = "entryentity_his";
    private static final String ENTRY_DIALECTENABLE = "dialectenable_entry";
    private static final String ENTRY_SQL = "sql_entry";
    private static final String SQL_PLACE_HOLDER = "sqlplaceholder";
    private static final String TABLELISTCACHE = "tablelist_%s";
    private boolean iSSelect = false;
    private boolean iSExplain = false;
    private boolean iSTableIndex = false;
    private boolean iSTableStructure = false;
    private boolean iSTableSelectSql = false;
    private boolean iSInpect = false;
    private static final String DATA_BASE_TYPE_ORACLE = "0";
    private static final String DATA_BASE_TYPE_POST_GRE_SQL = "1";
    private static final String DATA_BASE_TYPE_MYSQL = "2";
    private static final String DATA_BASE_TYPE_MD = "3";
    private static final String DATA_BASE_TYPE_SQLSERVER = "6";
    private static final String DATA_BASE_TYPE_GAUSSDB = "14";
    private static final String DATA_BASE_TYPE_KINGBASE = "15";
    private static final String DATA_BASE_TYPE_VASTBASE = "16";
    private static final String DATA_BASE_TYPE_TDSQL = "17";
    private static final String DATA_BASE_TYPE_GBASE = "18";
    private static final String DATA_BASE_TYPE_TIDB = "19";
    private static final String DATA_BASE_TYPE_YAS = "20";
    public static final String DATA_BASE_TYPE_OCEANBASE_ORACLE = "21";
    public static final String DATA_BASE_TYPE_OCEANBASE_MYSQL = "22";
    private static final int LINE_NUM = 1000;
    private static final int LIMIT_TALBE_SIZE = 50;
    int showTab = 0;
    boolean dialect = true;
    String executetype = "";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY_HIS);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        Tab tab = (Tab)this.getView().getControl(RESULT_TAB_KEY);
        tab.addTabCloseListener((TabCloseListener)this);
        CodeEdit codeEdit = (CodeEdit)this.getControl(TEXTAREA_SQLAREA);
        codeEdit.addCustomHintsListerner((CodeEditListener)this);
        codeEdit.addHintsListener((CodeEditListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"button_ksql_code_child", (CharSequence)operateKey)) {
            this.resetExcute();
            this.iSSelect = true;
            this.showTab = 0;
            this.dialect = false;
            this.executetype = DATA_BASE_TYPE_POST_GRE_SQL;
            this.execute();
        } else if (StringUtils.equals((CharSequence)"button_ksql_new_code_child", (CharSequence)operateKey)) {
            this.iSSelect = true;
            this.dialect = false;
            this.executetype = DATA_BASE_TYPE_POST_GRE_SQL;
            this.showTab = this.getAllCachedPageIds().size();
            this.execute();
        } else if (StringUtils.equals((CharSequence)"button_dialect_sql_code_child", (CharSequence)operateKey)) {
            this.resetExcute();
            this.iSSelect = true;
            this.showTab = 0;
            this.dialect = true;
            this.executetype = DATA_BASE_TYPE_MYSQL;
            this.execute();
        } else if (StringUtils.equals((CharSequence)"button_dialect_sql_new_code_child", (CharSequence)operateKey)) {
            this.iSSelect = true;
            this.dialect = true;
            this.executetype = DATA_BASE_TYPE_MYSQL;
            this.showTab = this.getAllCachedPageIds().size();
            this.execute();
        } else if (StringUtils.equals((CharSequence)"button_explain_sql_code_child", (CharSequence)operateKey)) {
            this.iSExplain = true;
            this.executetype = DATA_BASE_TYPE_MD;
            this.showTab = this.getAllCachedPageIds().size();
            this.execute();
        } else if (StringUtils.equals((CharSequence)"button_table_index_code_child", (CharSequence)operateKey)) {
            this.iSTableIndex = true;
            this.executetype = "4";
            this.showTab = this.getAllCachedPageIds().size();
            this.execute();
        } else if (StringUtils.equals((CharSequence)"button_translate_sql_code_child", (CharSequence)operateKey)) {
            this.showTab = this.getAllCachedPageIds().size();
            this.executetype = "5";
            this.transKSQL();
        } else if (StringUtils.equals((CharSequence)"button_table_definition_code_child", (CharSequence)operateKey)) {
            this.iSTableStructure = true;
            this.executetype = DATA_BASE_TYPE_SQLSERVER;
            this.showTab = this.getAllCachedPageIds().size();
            this.execute();
        } else if (StringUtils.equals((CharSequence)"button_isannotated_code_child", (CharSequence)operateKey)) {
            this.isAnnotated();
        } else if (StringUtils.equals((CharSequence)"button_format_sql_code_child", (CharSequence)operateKey)) {
            this.formateSql();
        } else if (StringUtils.equals((CharSequence)"button_table_select_sql_code_child", (CharSequence)operateKey)) {
            this.iSTableSelectSql = true;
            this.executetype = "7";
            this.showTab = this.getAllCachedPageIds().size();
            this.execute();
        } else if (StringUtils.equals((CharSequence)"button_fireinspect_child", (CharSequence)operateKey)) {
            this.executetype = "7";
            this.iSInpect = true;
            this.dialect = false;
            this.showTab = this.getAllCachedPageIds().size();
            this.execute();
        } else if (StringUtils.equals((CharSequence)"button_all_table_code_child", (CharSequence)formOperate.getOperateKey())) {
            this.executetype = "8";
            this.showTab = this.getAllCachedPageIds().size();
            IDataModel model = this.getModel();
            String dbRouteText = (String)model.getValue(TEXT_DBROUTE);
            this.showAllTable(dbRouteText);
        } else if (StringUtils.equals((CharSequence)"button_table_search_code_child", (CharSequence)operateKey)) {
            FormShowParameter lsp = new FormShowParameter();
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            lsp.setFormId("bd_ksql_searchtable");
            this.getView().showForm(lsp);
            IDataModel model = this.getModel();
            this.showTab = this.getAllCachedPageIds().size();
            String dbRouteText = (String)model.getValue(TEXT_DBROUTE);
            this.getPageCache().put(TEXT_DB_ROUTE, dbRouteText);
            this.getPageCache().put(SHOW_TAB, String.valueOf(this.showTab));
        }
    }

    private void showAllTable(String dbRouteText) {
        String key = String.format(TABLELISTCACHE, dbRouteText);
        boolean forceRefreshNode = this.getPageCache().getBigObject(key) != null;
        List tableList = null;
        if (forceRefreshNode) {
            String tableCache = this.getPageCache().getBigObject(key);
            tableList = SerializationUtils.fromJsonStringToList((String)tableCache, String.class);
            ArrayList<List<Object>> tableNames = new ArrayList<List<Object>>(tableList.size());
            for (String tableName : tableList) {
                ArrayList<String> object = new ArrayList<String>(1);
                object.add(tableName);
                tableNames.add(object);
            }
            this.createResultViewPage(this.showTab, tableNames);
        }
    }

    private void createResultViewPage(int index, List<List<Object>> tableNames) {
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId(RESULT_VIEW);
        HashMap<String, Object> params = new HashMap<String, Object>();
        ++index;
        ArrayList<String> colNames = new ArrayList<String>(3);
        colNames.add(ResManager.loadKDString((String)"\u8868\u540d", (String)"SQLQueryTablePlugin_5", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
        params.put("colNames", colNames);
        params.put("tableNames", tableNames);
        params.put("index", index);
        lsp.setCustomParams(params);
        lsp.getOpenStyle().setTargetKey(RESULT_TAB_KEY);
        lsp.getOpenStyle().setShowType(ShowType.NewTabPage);
        String msg = ResManager.loadKDString((String)"\u663e\u793a\u6240\u6709\u8868\uff08%s\uff09", (String)"SQLQueryAnalyzerPlugin_29", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]);
        lsp.setCaption(String.format(msg, index));
        lsp.setParentFormId(this.getView().getFormShowParameter().getFormId());
        this.getView().getPageCache().put(SHOWPAGEID, lsp.getPageId());
        this.getView().showForm(lsp);
        this.addPageIdIntoCache(lsp.getPageId());
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private Collection<Object> parseStmtList(String sqlText, String executetype) {
        Collection<Object> stmtCol = new ArrayList<Object>(4);
        String noUseKsql = ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4f7f\u7528\u7684KSQL\u8bed\u53e5\u3002", (String)MESSAGE_12, (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)sqlText)) {
            this.showError(this.showTab++, noUseKsql);
            this.getView().showTipNotification(noUseKsql);
            return stmtCol;
        }
        if (sqlText.indexOf(42) > -1 || !DATA_BASE_TYPE_POST_GRE_SQL.equals(executetype)) {
            if (DATA_BASE_TYPE_POST_GRE_SQL.equals(executetype)) {
                sqlText = sqlText.replace("*", SQL_PLACE_HOLDER);
            } else {
                String[] sqls;
                sqlText = sqlText.replace(ENTER_LINE, SPLIT_FLAG);
                for (String sql : sqls = sqlText.split(SPLIT_FLAG)) {
                    stmtCol.add(sql);
                }
                return stmtCol;
            }
        }
        try {
            Lexer lexer = new Lexer(sqlText);
            SqlParser parser = new SqlParser(lexer);
            stmtCol = parser.parseStmtList();
        }
        catch (ParserException e) {
            log.warn("sql \u89e3\u6790\u5931\u8d25: " + e.getMessage(), (Throwable)e);
            this.showError(this.showTab++, e.getMessage());
        }
        if (CollectionUtils.isEmpty(stmtCol)) {
            this.showError(this.showTab++, noUseKsql);
            this.getView().showTipNotification(noUseKsql);
            return stmtCol;
        }
        return stmtCol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        DBInstance dbInstance;
        IDataModel model = this.getModel();
        String dbRouteText = (String)model.getValue(TEXT_DBROUTE);
        DBRoute dbRoute = DBRoute.basedata;
        if (!StringUtils.isEmpty((CharSequence)dbRouteText)) {
            dbRoute = DBRoute.of((String)dbRouteText);
        }
        if ((dbInstance = this.getDbInstance(dbRoute)) == null) {
            return;
        }
        log.info("sql execute dbtype " + dbInstance.getDbtype());
        String sqlText = this.getSelectionSQLText();
        boolean iSHaveValidSql = false;
        if (StringUtils.isNotBlank((CharSequence)sqlText)) {
            Collection<Object> stmtCol = this.parseStmtList(sqlText = this.oneCompleteSql(sqlText), this.executetype);
            if (CollectionUtils.isEmpty(stmtCol)) {
                return;
            }
            for (Object item : stmtCol) {
                String sql = item.toString();
                if (StringUtils.isEmpty((CharSequence)sql)) continue;
                if (sql.indexOf(SQL_PLACE_HOLDER) > -1) {
                    sql = sql.replace(SQL_PLACE_HOLDER, "*");
                }
                sql = sql.trim();
                int rowIndex = this.getModel().createNewEntryRow(ENTRY_ENTITY_HIS);
                model.setValue("executetype", (Object)this.executetype, rowIndex);
                model.setValue(ENTRY_SQL, (Object)sql, rowIndex);
                this.informationBuilder.append(sql).append(ENTER_LINE);
                iSHaveValidSql = true;
                long startTimes = System.currentTimeMillis();
                try {
                    model.setValue(EXECUTE_RESULT, (Object)DATA_BASE_TYPE_POST_GRE_SQL, rowIndex);
                    if (this.iSExplain) {
                        this.expainExecute(dbRoute, sql, dbInstance);
                        continue;
                    }
                    if (this.iSTableStructure) {
                        this.getTableStructure(dbRoute, sql, dbInstance);
                        continue;
                    }
                    if (this.iSTableIndex) {
                        this.getTableIndex(dbRoute, sql, dbInstance);
                        continue;
                    }
                    if (this.iSTableSelectSql) {
                        this.tableGenerateSelectSql(dbRoute, sql, dbInstance);
                        continue;
                    }
                    if (this.iSSelect && (sql.toLowerCase(Locale.ENGLISH).startsWith("select") || sql.toLowerCase(Locale.ENGLISH).startsWith("/*no_sharding*/select"))) {
                        this.isUseDialectExcute(sql);
                        SQLParseUtil.checkSQLFunction(sql);
                        String rex = "(sleep\\(.+\\))";
                        Pattern pattern = Pattern.compile(rex);
                        if (pattern.matcher(sql.toLowerCase()).find()) {
                            this.unSupportSQL(model, rowIndex);
                            continue;
                        }
                        this.selectExecuteQuery(dbRoute, dbInstance, sql);
                        String msg = ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"SQLQueryAnalyzerPlugin_5", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]);
                        this.informationBuilder.append(ENTER_LINE).append(msg).append(ENTER_LINE);
                        continue;
                    }
                    if (this.iSInpect) {
                        this.getInspectResult(dbRoute, sql);
                        continue;
                    }
                    this.unSupportSQL(model, rowIndex);
                }
                catch (Exception e) {
                    log.debug(sql);
                    model.setValue(EXECUTE_RESULT, (Object)DATA_BASE_TYPE_MYSQL, rowIndex);
                    model.setValue(REMARK, (Object)e.getMessage(), rowIndex);
                    this.showError(this.showTab++, e.getMessage());
                    String msg = ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\u3002", (String)"SQLQueryAnalyzerPlugin_6", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]);
                    this.informationBuilder.append(ENTER_LINE).append(msg).append(ENTER_LINE);
                }
                finally {
                    model.setValue(ENTRY_DIALECTENABLE, (Object)this.dialect, rowIndex);
                    double result = (double)(System.currentTimeMillis() - startTimes) / 1000.0;
                    this.informationBuilder.append(result).append("s").append(ENTER_LINE).append(ENTER_LINE);
                }
            }
        }
        if (!iSHaveValidSql) {
            IFormView formView = this.getView();
            this.informationBuilder.append(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4f7f\u7528\u7684KSQL\u8bed\u53e5\u3002", (String)MESSAGE_12, (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
            this.getPageCache().put(SHOWPAGEID, TABPAGEAP_INFO);
            formView.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4f7f\u7528\u7684KSQL\u8bed\u53e5\u3002", (String)MESSAGE_12, (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
        }
        this.getModel().setValue(INFOMATION_TEXTAREA, (Object)this.informationBuilder.toString());
        Tab tab = (Tab)this.getView().getControl(RESULT_TAB_KEY);
        tab.activeTab(this.getPageCache().get(SHOWPAGEID));
    }

    private void unSupportSQL(IDataModel model, int rowIndex) {
        model.setValue(EXECUTE_RESULT, (Object)DATA_BASE_TYPE_MYSQL, rowIndex);
        String remark = ResManager.loadKDString((String)"\u8be5\u8bed\u53e5\u4e0d\u652f\u6301.", (String)"SQLQueryAnalyzerPlugin_0", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]);
        model.setValue(REMARK, (Object)remark, rowIndex);
        this.showError(this.showTab++, remark);
        this.informationBuilder.append(remark).append(ENTER_LINE).append(ENTER_LINE);
        this.getPageCache().put(SHOWPAGEID, TABPAGEAP_INFO);
    }

    private void getInspectResult(DBRoute dbRoute, String sql) {
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("bd_sql_fireinspect_tab");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(TEXT_DBROUTE, dbRoute.getRouteKey());
        params.put("sql", sql);
        lsp.setCustomParams(params);
        lsp.getOpenStyle().setTargetKey(RESULT_TAB_KEY);
        lsp.getOpenStyle().setShowType(ShowType.NewTabPage);
        lsp.setCaption(ResManager.loadKDString((String)"SQL\u63a2\u6d4b\u7ed3\u679c", (String)"SQLQueryAnalyzerPlugin_27", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
        lsp.setParentFormId(this.getView().getFormShowParameter().getFormId());
        this.getPageCache().put(SHOWPAGEID, lsp.getPageId());
        this.getView().showForm(lsp);
        this.addPageIdIntoCache(lsp.getPageId());
    }

    public static JSONArray getDbInstanceList() {
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put("Content-type", "application/json");
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("dataCenterId", RequestContext.get().getAccountId());
        String host = System.getProperty("mc.server.url");
        JSONArray data = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)host)) {
            try {
                JSONObject resp;
                String sHttpResponse = LoginMCService.create().callMcApiService("/kapi/app/mc/GetDbInstanceListService", "application/json", header, params, 30);
                log.debug("getDbInstanceList result: " + sHttpResponse);
                if (StringUtils.isNotBlank((CharSequence)sHttpResponse) && (resp = JSONObject.parseObject((String)sHttpResponse)).getInteger("errorcode") == 100) {
                    data = resp.getJSONArray("data");
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return data;
    }

    public void afterCreateNewData(EventObject e) {
        Lang lang = RequestContext.get().getLang();
        super.afterCreateNewData(e);
        ComboEdit dbCombo = (ComboEdit)this.getView().getControl(TEXT_DBROUTE);
        ArrayList<ComboItem> dbInstenceItem = new ArrayList<ComboItem>(10);
        JSONArray dbInstanceList = SQLQueryAnalyzerPlugin.getDbInstanceList();
        String defDBValue = "sys";
        if (!dbInstanceList.isEmpty()) {
            dbInstanceList = this.filterDuplicationDB(dbInstanceList);
            for (Object instance : dbInstanceList) {
                JSONObject image = (JSONObject)instance;
                String backimage = image.getString(NUMBER);
                String bizAppNum = null;
                bizAppNum = Lang.zh_CN != lang && Lang.zh_TW != lang ? image.getString(NUMBER) : image.getString("name");
                ComboItem item = new ComboItem(new LocaleString(bizAppNum), backimage);
                dbInstenceItem.add(item);
            }
            dbCombo.setComboItems(dbInstenceItem);
            this.getModel().setValue(TEXT_DBROUTE, (Object)defDBValue);
            try {
                DBInstance dbInstance;
                DBRoute dbRoute = DBRoute.basedata;
                if (!StringUtils.isEmpty((CharSequence)defDBValue)) {
                    dbRoute = DBRoute.of((String)defDBValue);
                }
                if ((dbInstance = this.getDbInstance(dbRoute)) != null) {
                    String dbtype = dbInstance.getDbtype();
                    this.getTableList(dbRoute, dbInstance, dbtype, defDBValue);
                }
            }
            catch (Exception e1) {
                log.warn("initialize table list error " + e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private JSONArray filterDuplicationDB(JSONArray dbInstanceList) {
        LinkedHashMap<String, JSONObject> map = new LinkedHashMap<String, JSONObject>();
        for (int i = 0; i < dbInstanceList.size(); ++i) {
            JSONObject jsb = dbInstanceList.getJSONObject(i);
            map.put(jsb.getString(NUMBER), jsb);
        }
        JSONArray dbInstanceListNew = new JSONArray();
        for (JSONObject value : map.values()) {
            dbInstanceListNew.add((Object)value);
        }
        return dbInstanceListNew;
    }

    private String getSelectionSQLText() {
        CodeEdit sqlEditor = (CodeEdit)this.getControl(TEXTAREA_SQLAREA);
        String sqlText = sqlEditor.getSelectionText();
        if (StringUtils.isEmpty((CharSequence)sqlText)) {
            sqlText = this.getAllSQLText();
        }
        return sqlText;
    }

    private String getAllSQLText() {
        CodeEdit sqlEditor = (CodeEdit)this.getControl(TEXTAREA_SQLAREA);
        return sqlEditor.getText();
    }

    private String oneCompleteSql(String oriSQL) {
        if ((oriSQL = oriSQL.trim()).toLowerCase(Locale.ENGLISH).startsWith("/*specialchar*/select") || oriSQL.toLowerCase(Locale.ENGLISH).startsWith("/*specialchar*//*no_sharding*/select")) {
            oriSQL = oriSQL.split("/\\*specialchar\\*/")[1];
            return oriSQL;
        }
        StringBuilder sb = new StringBuilder();
        boolean isStart = false;
        String[] tempSqls = oriSQL.split("\\n");
        for (int j = 0; j < tempSqls.length; ++j) {
            String tmpResult = tempSqls[j].trim();
            if (tmpResult != null) {
                if (tmpResult.indexOf("/*") != -1 && tmpResult.indexOf("*/") != -1) {
                    tmpResult = tmpResult.replaceAll("\\/\\*.*?\\*\\/", "");
                } else if (tmpResult.indexOf("/*") != -1 && tmpResult.indexOf("*/") == -1 && tmpResult.indexOf("--") == -1) {
                    isStart = true;
                } else if (tmpResult.indexOf("/*") != -1 && tmpResult.indexOf("--") != -1 && tmpResult.indexOf("--") < tmpResult.indexOf("/*")) {
                    tmpResult = tmpResult.replaceAll("--.*", "");
                }
                if (isStart && tmpResult.indexOf("*/") != -1) {
                    isStart = false;
                    continue;
                }
                tmpResult = tmpResult.replaceAll("--.*", "").trim();
            }
            if (isStart || tmpResult == null || tmpResult.length() <= 0) continue;
            sb.append(tmpResult).append(" ");
        }
        return sb.toString().trim();
    }

    private DBInstance getDbInstance(DBRoute route) {
        RequestContext requestContext = RequestContext.get();
        String accountId = requestContext.getAccountId();
        String tenantId = requestContext.getTenantId();
        Account correctAccount = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
        return this.getDataBaseInstance(correctAccount, route.getRouteKey());
    }

    private DBInstance getDataBaseInstance(Account account, String routeKey) {
        List dbInstanceList = account.getDBInstanceList();
        DBInstance returnInstance = null;
        if (StringUtils.isEmpty((CharSequence)routeKey) || CollectionUtils.isEmpty((Collection)dbInstanceList)) {
            return returnInstance;
        }
        for (DBInstance instance : dbInstanceList) {
            if (!routeKey.equalsIgnoreCase(instance.getRouteKey())) continue;
            returnInstance = instance;
            if (!DATA_BASE_TYPE_POST_GRE_SQL.equals(instance.getReadOnly())) continue;
            break;
        }
        return returnInstance;
    }

    private void resetExcute() {
        this.informationBuilder = new StringBuilder();
        List<String> pageIds = this.getAllCachedPageIds();
        if (!pageIds.isEmpty()) {
            for (String pageId : pageIds) {
                IFormView formView = SessionManager.getCurrent().getView(pageId);
                if (formView == null) continue;
                formView.close();
                HashMap<String, String> arg = new HashMap<String, String>(1);
                arg.put(PAGE_ID, pageId);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
            }
        }
        this.resetCachedPageIDs();
    }

    private void selectExecuteQuery(DBRoute dbRoute, DBInstance dbInstance, String sql) {
        try {
            if (this.dialect) {
                sql = PREFIX_DIALECT + sql;
            }
            this.checkSqlValidity(dbRoute, sql, dbInstance);
            this.createNewResultPage(this.showTab++, dbRoute, sql, dbInstance.getDbtype(), null, Collections.emptyList());
        }
        catch (Exception ex) {
            throw new KDBizException(this.filterSensitiveInfo(ex, dbInstance));
        }
    }

    private void createNewResultPage(int index, DBRoute dbRoute, String sql, String dbtype, String tableName, List<Object> paramList) {
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId(RESULT_GRID);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("index", ++index);
        params.put("dbRoute", dbRoute.getRouteKey());
        params.put("sql", this.changeToKSqlLimit(sql, dbtype));
        if (!CollectionUtils.isEmpty(paramList)) {
            params.put("params", paramList.toArray());
        }
        if (this.iSTableStructure) {
            params.put("iSTableStructure", this.iSTableStructure);
            params.put("tableName", tableName);
        } else if (this.iSSelect) {
            params.put("iSSelect", this.iSSelect);
        }
        lsp.setCustomParams(params);
        lsp.getOpenStyle().setTargetKey(RESULT_TAB_KEY);
        lsp.getOpenStyle().setShowType(ShowType.NewTabPage);
        if (this.iSExplain) {
            String msg = ResManager.loadKDString((String)"\u6267\u884c\u8ba1\u5212\uff08%s\uff09", (String)"SQLQueryAnalyzerPlugin_20", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]);
            lsp.setCaption(String.format(msg, index));
        } else if (this.iSTableIndex) {
            String msg = ResManager.loadKDString((String)"\u8868\u7d22\u5f15\uff08%s\uff09", (String)"SQLQueryAnalyzerPlugin_21", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]);
            lsp.setCaption(String.format(msg, index));
        } else if (this.iSTableStructure) {
            String msg = ResManager.loadKDString((String)"\u8868\u5b9a\u4e49\uff08%s\uff09", (String)"SQLQueryAnalyzerPlugin_22", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]);
            lsp.setCaption(String.format(msg, index));
        } else {
            String msg = ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\uff08%s\uff09", (String)"SQLQueryAnalyzerPlugin_2", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]);
            lsp.setCaption(String.format(msg, index));
        }
        lsp.setParentFormId(this.getView().getFormShowParameter().getFormId());
        this.getPageCache().put(SHOWPAGEID, lsp.getPageId());
        this.getView().showForm(lsp);
        this.addPageIdIntoCache(lsp.getPageId());
    }

    private void resetCachedPageIDs() {
        this.getPageCache().remove(PAGE_ID);
    }

    private List<String> getAllCachedPageIds() {
        ArrayList<String> list = new ArrayList<String>(10);
        StringBuilder sb = new StringBuilder();
        String pageIdsObject = this.getPageCache().get(PAGE_ID);
        if (pageIdsObject != null) {
            sb.append(pageIdsObject);
            String[] pageIds = sb.toString().split(SPLIT_FLAG);
            for (int i = 0; i < pageIds.length; ++i) {
                if (!StringUtils.isNotEmpty((CharSequence)pageIds[i].trim())) continue;
                list.add(pageIds[i].trim());
            }
        }
        return list;
    }

    private void addPageIdIntoCache(String pageId) {
        StringBuilder sb = new StringBuilder();
        String pageIds = this.getPageCache().get(PAGE_ID);
        if (pageIds != null) {
            sb.append(pageIds);
        }
        sb.append(SPLIT_FLAG);
        sb.append(pageId);
        this.getPageCache().put(PAGE_ID, sb.toString());
    }

    public List<Map<String, Object>> createColumns(List<String> colNames) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(10);
        cols.add(SQLQueryAnalyzerPlugin.genSeqColumn());
        Iterator<String> colIt = colNames.iterator();
        while (colIt.hasNext()) {
            cols.add(this.createColumn(colIt.next()));
        }
        return cols;
    }

    public static Map<String, Object> genSeqColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("dataIndex", "fseq");
        map.put("header", new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"SQLQueryAnalyzerPlugin_4", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0])));
        map.put("isColPageFixed", Boolean.TRUE);
        map.put("type", "numberfield");
        map.put("width", 100);
        return map;
    }

    public Map<String, Object> createColumn(String key) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("header", new LocaleString(key));
        map.put("visible", true);
        map.put("dataIndex", key);
        return map;
    }

    private void checkSqlValidity(DBRoute dbRoute, String sql, DBInstance dbInstance) throws KDBizException {
        try {
            if (this.selectSystemTable(sql, dbInstance.getDbtype())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8bed\u53e5\u4e2d\u5305\u542b\u6570\u636e\u5e93\u7cfb\u7edf\u81ea\u5e26\u7684\u8868\uff0c\u67e5\u8be2\u8bed\u53e5\u7981\u6b62\u6267\u884c\u3002", (String)"SQLQueryAnalyzerPlugin_8", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
            }
            if (this.checkSqlInjection(dbInstance.getDbtype(), sql)) {
                throw new KDBizException(ResManager.loadKDString((String)"sql\u8bed\u53e5\u4e2d\u6709\u6ce8\u5165\u98ce\u9669\uff0c\u53d6\u6d88\u64cd\u4f5c\u3002", (String)"SQLQueryAnalyzerPlugin_24", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
            }
            this.selectDBbySql(dbRoute, sql, dbInstance.getDbtype());
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private String filterSensitiveInfo(Exception e, DBInstance dbInstance) {
        String instance;
        Pattern compile;
        Matcher matcher;
        String message = e.getMessage();
        String user = dbInstance.getDbuser();
        Pattern dbCompile = Pattern.compile(String.format(REGEX_TEMPLATE_DATABASE, user));
        Matcher dbMatcher = dbCompile.matcher(message);
        if (dbMatcher.find()) {
            message = StringUtils.replace((String)message, (String)dbMatcher.group(), (String)"");
        }
        if ((matcher = (compile = Pattern.compile(String.format(REGEX_TEMPLATE_SERVICE, user))).matcher(message)).find()) {
            message = StringUtils.replace((String)message, (String)matcher.group(), (String)"");
        }
        if (message.contains(instance = dbInstance.getDBInsatnce())) {
            message = StringUtils.replace((String)message, (String)(instance + "."), (String)"");
        }
        return ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\u539f\u56e0\u4e3a\uff1a", (String)"SQLQueryAnalyzerPlugin_9", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]) + ENTER_LINE + message;
    }

    private void showError(int index, String errorMessage) {
        FormShowParameter lsp = new FormShowParameter();
        int next = index + 1;
        lsp.setFormId(RESULT_AREA);
        lsp.setCustomParam("resultMessge", (Object)errorMessage);
        lsp.getOpenStyle().setTargetKey(RESULT_TAB_KEY);
        lsp.getOpenStyle().setShowType(ShowType.NewTabPage);
        lsp.setParentFormId(this.getView().getFormShowParameter().getFormId());
        lsp.setCaption(String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7ed3\u679c\uff08%s\uff09", (String)"SQLQueryAnalyzerPlugin_11", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]), next));
        this.getView().showForm(lsp);
        this.getPageCache().put(SHOWPAGEID, lsp.getPageId());
        this.addPageIdIntoCache(lsp.getPageId());
    }

    private boolean selectSystemTable(String sql, String dbType) {
        RWTableInfo tableInfo = RWTableInfo.parseRWTableInfo((String)sql);
        Set tables = tableInfo.getAllTables();
        for (String table : tables) {
            if (StringUtils.isBlank((CharSequence)table) || !DataBaseSystemTableInfo.isSystemTable(table.toLowerCase(Locale.ENGLISH), dbType)) continue;
            return true;
        }
        return false;
    }

    public void transKSQL() {
        IFormView formView = this.getView();
        IDataModel model = this.getModel();
        String ksqlStrs = this.getSelectionSQLText();
        int rowIndex = this.getModel().createNewEntryRow(ENTRY_ENTITY_HIS);
        model.setValue(ENTRY_DIALECTENABLE, (Object)this.dialect, rowIndex);
        model.setValue("executetype", (Object)this.executetype, rowIndex);
        String noUseKsql = ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4f7f\u7528\u7684KSQL\u8bed\u53e5\u3002", (String)MESSAGE_12, (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]);
        if (null == ksqlStrs || "".equals(ksqlStrs)) {
            this.getModel().setValue(INFOMATION_TEXTAREA, (Object)noUseKsql);
            Tab tab = (Tab)this.getView().getControl(RESULT_TAB_KEY);
            tab.activeTab(this.getPageCache().get(SHOWPAGEID));
            model.setValue(EXECUTE_RESULT, (Object)DATA_BASE_TYPE_MYSQL, rowIndex);
            model.setValue(REMARK, (Object)noUseKsql, rowIndex);
            this.getPageCache().put(SHOWPAGEID, TABPAGEAP_INFO);
            formView.showTipNotification(noUseKsql);
            return;
        }
        model.setValue(ENTRY_SQL, (Object)ksqlStrs.trim(), rowIndex);
        boolean isValid = false;
        ksqlStrs = this.oneCompleteSql(ksqlStrs);
        String[] sqls = ksqlStrs.split(SPLIT_FLAG);
        for (int i = 0; i < sqls.length; ++i) {
            String sql = sqls[i];
            if (StringUtils.isEmpty((CharSequence)sql)) continue;
            isValid = true;
        }
        long startTimes = System.currentTimeMillis();
        if (!isValid) {
            this.getPageCache().put(SHOWPAGEID, TABPAGEAP_INFO);
            this.getModel().setValue(INFOMATION_TEXTAREA, (Object)noUseKsql);
            model.setValue(EXECUTE_RESULT, (Object)DATA_BASE_TYPE_MYSQL, rowIndex);
            model.setValue(REMARK, (Object)noUseKsql, rowIndex);
            formView.showTipNotification(noUseKsql);
            Tab tab = (Tab)this.getView().getControl(RESULT_TAB_KEY);
            tab.activeTab(this.getPageCache().get(SHOWPAGEID));
            return;
        }
        ksqlStrs = ksqlStrs.trim();
        this.informationBuilder.append(ksqlStrs).append(ENTER_LINE);
        StringBuilder sqlShow = this.getSqlShow(ksqlStrs, sqls);
        this.showSqlTranslate(this.showTab++, sqlShow.toString());
        if (sqlShow.indexOf(ResManager.loadKDString((String)"\u7ffb\u8bd1\u5931\u8d25", (String)"SQLQueryAnalyzerPlugin_10", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0])) == -1) {
            model.setValue(EXECUTE_RESULT, (Object)DATA_BASE_TYPE_POST_GRE_SQL, rowIndex);
            this.informationBuilder.append(ENTER_LINE).append(ResManager.loadKDString((String)"\u7ffb\u8bd1\u5b8c\u6210", (String)"SQLQueryAnalyzerPlugin_14", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0])).append(ENTER_LINE);
        } else {
            model.setValue(EXECUTE_RESULT, (Object)DATA_BASE_TYPE_MYSQL, rowIndex);
            model.setValue(REMARK, (Object)sqlShow, rowIndex);
            this.informationBuilder.append(ENTER_LINE).append(ResManager.loadKDString((String)"\u7ffb\u8bd1\u5931\u8d25", (String)"SQLQueryAnalyzerPlugin_10", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0])).append(ENTER_LINE);
        }
        double result = (double)(System.currentTimeMillis() - startTimes) / 1000.0;
        this.informationBuilder.append(result).append("s").append(ENTER_LINE);
        this.getModel().setValue(INFOMATION_TEXTAREA, (Object)this.informationBuilder.toString());
    }

    private StringBuilder getSqlShow(String ksqlStrs, String[] sqls) {
        StringBuilder sqlShow = new StringBuilder();
        String retMySql = this.execTransKSQL(ksqlStrs, 6);
        sqlShow.append("\u00b7TO MYSQL:").append(LINE_FEED).append(retMySql).append(LINE_FEED).append(LINE_FEED);
        sqlShow.append("\u00b7TO ORACLE:").append(LINE_FEED);
        for (int i = 0; i < sqls.length; ++i) {
            String sql = this.oneCompleteSql(sqls[i]);
            if (StringUtils.isEmpty((CharSequence)sql)) continue;
            String retOraclesql = this.execTransKSQL(sql, 8);
            sqlShow.append(retOraclesql).append(SPLIT_FLAG).append(LINE_FEED);
        }
        String retsqlserver = this.execTransKSQL(ksqlStrs, 3);
        sqlShow.append(LINE_FEED).append("\u00b7TO SQLSERVER:").append(LINE_FEED).append(retsqlserver).append(LINE_FEED);
        String retPoSQL = this.execTransKSQL(ksqlStrs, 5);
        sqlShow.append(LINE_FEED).append("\u00b7TO POSTGRESSQL:").append(LINE_FEED).append(retPoSQL).append(LINE_FEED);
        String retdmsql = this.execTransKSQL(ksqlStrs, 11);
        sqlShow.append(LINE_FEED).append("\u00b7TO DMSQL:").append(LINE_FEED).append(retdmsql).append(LINE_FEED);
        String retgssql = this.execTransKSQL(ksqlStrs, 12);
        sqlShow.append(LINE_FEED).append("\u00b7TO GSSQL:").append(LINE_FEED).append(retgssql).append(LINE_FEED);
        String retkingsql = this.execTransKSQL(ksqlStrs, 15);
        sqlShow.append(LINE_FEED).append("\u00b7TO KINGSQL:").append(LINE_FEED).append(retkingsql).append(LINE_FEED);
        String rettdsql = this.execTransKSQL(ksqlStrs, Integer.parseInt(DATA_BASE_TYPE_TDSQL));
        sqlShow.append(LINE_FEED).append("\u00b7TO TDSQL:").append(LINE_FEED).append(rettdsql).append(LINE_FEED);
        String rettidb = this.execTransKSQL(ksqlStrs, Integer.parseInt(DATA_BASE_TYPE_TIDB));
        sqlShow.append(LINE_FEED).append("\u00b7TO TiDB:").append(LINE_FEED).append(rettidb).append(LINE_FEED);
        String retvastdb = this.execTransKSQL(ksqlStrs, Integer.parseInt(DATA_BASE_TYPE_VASTBASE));
        sqlShow.append(LINE_FEED).append("\u00b7TO Vastbase:").append(LINE_FEED).append(retvastdb).append(LINE_FEED);
        String retyasdb = this.execTransKSQL(ksqlStrs, Integer.parseInt(DATA_BASE_TYPE_YAS));
        sqlShow.append(LINE_FEED).append("\u00b7TO YashanDB:").append(LINE_FEED).append(retyasdb).append(LINE_FEED);
        String retgbbase = this.execTransKSQL(ksqlStrs, Integer.parseInt(DATA_BASE_TYPE_GBASE));
        sqlShow.append(LINE_FEED).append("\u00b7TO GBase:").append(LINE_FEED).append(retgbbase).append(LINE_FEED);
        String retgaussdb = this.execTransKSQL(ksqlStrs, Integer.parseInt(DATA_BASE_TYPE_GAUSSDB));
        sqlShow.append(LINE_FEED).append("\u00b7TO gaussDB:").append(LINE_FEED).append(retgaussdb).append(LINE_FEED);
        String oceanBaseOracle = this.execTransKSQL(ksqlStrs, Integer.parseInt(DATA_BASE_TYPE_OCEANBASE_ORACLE));
        sqlShow.append(LINE_FEED).append("\u00b7TO OceanBaseOracle:").append(LINE_FEED).append(oceanBaseOracle).append(LINE_FEED);
        return sqlShow;
    }

    public String execTransKSQL(String ksql, int sqlType) {
        String retSql = null;
        try {
            retSql = TransUtil.translate((String)ksql, (int)sqlType, (FormatOptions)new FormatOptions());
        }
        catch (Exception e) {
            return String.format(ResManager.loadKDString((String)"\u7ffb\u8bd1\u5931\u8d25%s", (String)"SQLQueryAnalyzerPlugin_13", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]), e.getMessage());
        }
        return retSql;
    }

    private void showSqlTranslate(int index, String sqlTranslate) {
        FormShowParameter lsp = new FormShowParameter();
        int next = index + 1;
        lsp.setFormId("bd_ksql_result_code_edit");
        lsp.setCustomParam("resultMessgeCodeType", (Object)sqlTranslate);
        lsp.getOpenStyle().setTargetKey(RESULT_TAB_KEY);
        lsp.getOpenStyle().setShowType(ShowType.NewTabPage);
        lsp.setParentFormId(this.getView().getFormShowParameter().getFormId());
        lsp.setCaption(String.format(ResManager.loadKDString((String)"\u7ffb\u8bd1\uff08%s\uff09", (String)"SQLQueryAnalyzerPlugin_15", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]), next));
        this.getView().showForm(lsp);
        this.getPageCache().put(SHOWPAGEID, lsp.getPageId());
        this.addPageIdIntoCache(lsp.getPageId());
    }

    private void expainExecute(DBRoute dbRoute, String sql, DBInstance dbInstance) throws KDBizException {
        this.checkSqlHaveSystemTable(sql, dbInstance);
        try {
            String dbtype = dbInstance.getDbtype();
            if (DATA_BASE_TYPE_ORACLE.equals(dbtype) || DATA_BASE_TYPE_OCEANBASE_ORACLE.equals(dbtype)) {
                this.oracleExpain(dbRoute, sql, dbInstance);
            } else if (DATA_BASE_TYPE_POST_GRE_SQL.equals(dbtype)) {
                this.mySqlExpain(dbRoute, sql, dbInstance);
            } else if (DATA_BASE_TYPE_MYSQL.equals(dbtype)) {
                this.mySqlExpain(dbRoute, sql, dbInstance);
            } else if (DATA_BASE_TYPE_MD.equals(dbtype)) {
                this.dMExpain(dbRoute, sql, dbInstance);
            } else if (DATA_BASE_TYPE_GAUSSDB.equals(dbtype)) {
                this.mySqlExpain(dbRoute, sql, dbInstance);
            } else if (String.valueOf(15).equals(dbtype)) {
                this.mySqlExpain(dbRoute, sql, dbInstance);
            } else if (DATA_BASE_TYPE_TDSQL.equals(dbtype) || DATA_BASE_TYPE_TIDB.equals(dbtype) || DATA_BASE_TYPE_VASTBASE.equals(dbtype) || DATA_BASE_TYPE_YAS.equals(dbtype) || DATA_BASE_TYPE_GBASE.equals(dbtype) || DATA_BASE_TYPE_GAUSSDB.equals(dbtype) || DATA_BASE_TYPE_OCEANBASE_MYSQL.equals(dbtype)) {
                this.mySqlExpain(dbRoute, sql, dbInstance);
            } else {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u5904\u7406\u8be5\u6570\u636e\u5e93\u7c7b\u578b\uff1a%s", (String)"SQLQueryAnalyzerPlugin_16", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]), dbtype));
            }
            this.informationBuilder.append(ENTER_LINE).append(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"SQLQueryAnalyzerPlugin_5", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0])).append(ENTER_LINE);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void dMExpain(DBRoute dbRoute, String sql, DBInstance dbInstance) {
        sql = "EXPLAIN FOR " + sql;
        this.selectExecuteQuery(dbRoute, dbInstance, sql);
    }

    private boolean checkSqlInjection(String dbType, String sql) {
        if (DATA_BASE_TYPE_MYSQL.equals(dbType)) {
            return this.mysqlSqlInjection(sql);
        }
        return false;
    }

    private boolean mysqlSqlInjection(String sql) {
        return (sql = sql.toLowerCase()).contains("updatexml");
    }

    private void oracleExpain(DBRoute dbRoute, String sql, DBInstance dbInstance) {
        sql = "/*dialect*/explain PLAN FOR " + sql;
        try {
            DB.execute((DBRoute)dbRoute, (String)sql);
        }
        catch (Exception ex) {
            throw new KDBizException(this.filterSensitiveInfo(ex, dbInstance));
        }
        this.selectExecuteQuery(dbRoute, dbInstance, "SELECT * FROM table(dbms_xplan.display)");
    }

    private void mySqlExpain(DBRoute dbRoute, String sql, DBInstance dbInstance) {
        sql = "explain " + sql;
        this.selectExecuteQuery(dbRoute, dbInstance, sql);
    }

    private void getTableStructure(DBRoute dbRoute, String tableName, DBInstance dbInstance) throws KDBizException {
        this.checkSqlIsEmpty(tableName);
        String checkSystemTable = "select 1 from " + tableName;
        this.checkSqlHaveSystemTable(checkSystemTable, dbInstance);
        try {
            ArrayList<Object> paramList = new ArrayList<Object>(10);
            String dbtype = dbInstance.getDbtype();
            String sql = this.tableDefinitionSql(tableName, dbInstance.getDBInsatnce(), dbtype, paramList);
            this.selectDBbySql(dbRoute, sql, dbtype);
            this.createNewResultPage(this.showTab++, dbRoute, sql, dbtype, tableName, paramList);
            this.informationBuilder.append(ENTER_LINE).append(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"SQLQueryAnalyzerPlugin_5", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0])).append(ENTER_LINE);
        }
        catch (Exception e) {
            throw new KDBizException(this.filterSensitiveInfo(e, dbInstance));
        }
    }

    private String tableDefinitionSql(String tableName, String dbInsatnce, String dbtype, List<Object> paramList) throws KDBizException {
        String sql = "";
        if (DATA_BASE_TYPE_ORACLE.equals(dbtype) || DATA_BASE_TYPE_VASTBASE.equals(dbtype) || DATA_BASE_TYPE_OCEANBASE_ORACLE.equals(dbtype)) {
            String select = "select t.TABLE_NAME,t.COLUMN_NAME, t.DATA_TYPE, t.DATA_LENGTH,t.DATA_PRECISION,t.NULLABLE,t.CHARACTER_SET_NAME,t.COLUMN_ID,c.COMMENTS ";
            String from = "from user_tab_columns t, user_col_comments c ";
            String where = "where t.table_name = c.table_name and t.column_name = c.column_name and t.table_name = '" + tableName.toUpperCase() + "' ";
            String orderBy = "order by t.COLUMN_ID";
            sql = PREFIX_DIALECT + select + from + where + orderBy;
        } else if (DATA_BASE_TYPE_POST_GRE_SQL.equals(dbtype)) {
            String select = "SELECT a.attnum,a.attname AS field,t.typname AS type,a.attlen AS length,a.atttypmod AS lengthvar,a.attnotnull AS notnull,b.description AS comment ";
            String from = "FROM pg_class c,pg_attribute a LEFT OUTER JOIN pg_description b ON a.attrelid=b.objoid AND a.attnum = b.objsubid,pg_type t ";
            String where = "WHERE c.relname = '" + tableName.toLowerCase() + "' and a.attnum > 0 and a.attrelid = c.oid and a.atttypid = t.oid ";
            String orderBy = "ORDER BY a.attnum";
            sql = PREFIX_DIALECT + select + from + where + orderBy;
        } else if (DATA_BASE_TYPE_MYSQL.equals(dbtype) || DATA_BASE_TYPE_OCEANBASE_MYSQL.equals(dbtype)) {
            String select = "SELECT TABLE_NAME ,COLUMN_NAME ,COLUMN_TYPE ,IS_NULLABLE ,COLUMN_KEY ,COLUMN_DEFAULT ,NUMERIC_PRECISION ,NUMERIC_SCALE ,CHARACTER_SET_NAME ,COLLATION_NAME ,COLUMN_COMMENT,TABLE_SCHEMA ";
            String from = "FROM information_schema.COLUMNS ";
            String where = "WHERE TABLE_SCHEMA='" + dbInsatnce + "' AND TABLE_NAME= '" + tableName + "'";
            sql = PREFIX_DIALECT + select + from + where;
        } else if (DATA_BASE_TYPE_MD.equals(dbtype)) {
            String select = "select t.TABLE_NAME,t.COLUMN_NAME, t.DATA_TYPE, t.DATA_LENGTH,t.DATA_PRECISION,t.NULLABLE,t.CHARACTER_SET_NAME,t.COLUMN_ID,c.COMMENTS ";
            String from = "from user_tab_columns t, user_col_comments c ";
            String where = "where t.table_name = c.table_name and t.column_name = c.column_name and t.table_name = '" + tableName.toUpperCase() + "' ";
            String orderBy = "order by t.COLUMN_ID";
            sql = PREFIX_DIALECT + select + from + where + orderBy;
        } else if (DATA_BASE_TYPE_SQLSERVER.equals(dbtype)) {
            String select = "select TABLE_NAME ,COLUMN_NAME ,TABLE_CATALOG ,TABLE_SCHEMA ,ORDINAL_POSITION ,COLUMN_DEFAULT ,IS_NULLABLE ,DATA_TYPE ,CHARACTER_MAXIMUM_LENGTH ,CHARACTER_OCTET_LENGTH ,NUMERIC_PRECISION ,NUMERIC_PRECISION_RADIX,NUMERIC_SCALE ,DATETIME_PRECISION ,CHARACTER_SET_CATALOG ,CHARACTER_SET_SCHEMA ,CHARACTER_SET_NAME ,COLLATION_CATALOG ,COLLATION_SCHEMA ,COLLATION_NAME,DOMAIN_CATALOG ,DOMAIN_SCHEMA ,DOMAIN_NAME ";
            String from = "from INFORMATION_SCHEMA.COLUMNS ";
            String where = "where table_name = '" + tableName + "'";
            sql = PREFIX_DIALECT + select + from + where;
        } else if (DATA_BASE_TYPE_GAUSSDB.equals(dbtype)) {
            sql = this.getLikePgTableSQL(tableName);
        } else if (String.valueOf(15).equals(dbtype)) {
            sql = this.getLikePgTableSQL(tableName);
        } else if (DATA_BASE_TYPE_TDSQL.equals(dbtype) || DATA_BASE_TYPE_TIDB.equals(dbtype) || DATA_BASE_TYPE_GAUSSDB.equals(dbtype)) {
            String select = "SELECT TABLE_NAME ,COLUMN_NAME ,COLUMN_TYPE ,IS_NULLABLE ,COLUMN_KEY ,COLUMN_DEFAULT ,NUMERIC_PRECISION ,NUMERIC_SCALE ,CHARACTER_SET_NAME ,COLLATION_NAME ,COLUMN_COMMENT,TABLE_SCHEMA ";
            String from = "FROM information_schema.COLUMNS ";
            String where = "WHERE TABLE_SCHEMA='" + dbInsatnce + "' AND TABLE_NAME= '" + tableName + "'";
            sql = PREFIX_DIALECT + select + from + where;
        } else if (DATA_BASE_TYPE_GBASE.equals(dbtype)) {
            paramList.add(tableName);
            String select = "SELECT * FROM COLS WHERE TABLE_NAME = UPPER(?)";
            sql = PREFIX_DIALECT + select;
        } else if (DATA_BASE_TYPE_YAS.equals(dbtype)) {
            String select = "select t.TABLE_NAME,t.COLUMN_NAME, t.DATA_TYPE, t.DATA_LENGTH,t.DATA_PRECISION,t.NULLABLE,t.COLUMN_ID,c.COMMENTS ";
            String from = "from user_tab_columns t, user_col_comments c ";
            String where = "where t.table_name = c.table_name and t.column_name = c.column_name and t.table_name = '" + tableName.toUpperCase() + "' ";
            String orderBy = "order by t.COLUMN_ID";
            sql = PREFIX_DIALECT + select + from + where + orderBy;
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u5904\u7406\u8be5\u6570\u636e\u5e93\u7c7b\u578b\uff1a%s", (String)"SQLQueryAnalyzerPlugin_16", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]), dbtype));
        }
        return sql;
    }

    private String getLikePgTableSQL(String table) {
        String select = "SELECT a.attnum,a.attname AS field,t.typname AS type,a.attlen AS length,a.atttypmod AS lengthvar,a.attnotnull AS notnull,b.description AS comment ";
        String from = "FROM pg_class c,pg_attribute a LEFT OUTER JOIN pg_description b ON a.attrelid=b.objoid AND a.attnum = b.objsubid,pg_type t ";
        String where = "WHERE c.relname = '" + table.toLowerCase() + "' and a.attnum > 0 and a.attrelid = c.oid and a.atttypid = t.oid ";
        String orderBy = "ORDER BY a.attnum";
        return PREFIX_DIALECT + select + from + where + orderBy;
    }

    private void getTableIndex(DBRoute dbRoute, String tableName, DBInstance dbInstance) throws KDBizException {
        this.checkSqlIsEmpty(tableName);
        String checkSystemTable = "select 1 from " + tableName;
        this.checkSqlHaveSystemTable(checkSystemTable, dbInstance);
        try {
            String dbtype = dbInstance.getDbtype();
            String sql = this.getTableIndexSql(dbtype, tableName);
            this.selectDBbySql(dbRoute, sql, dbtype);
            this.createNewResultPage(this.showTab++, dbRoute, sql, dbtype, tableName, Collections.emptyList());
            this.informationBuilder.append(ENTER_LINE).append(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"SQLQueryAnalyzerPlugin_5", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0])).append(ENTER_LINE);
        }
        catch (Exception e) {
            throw new KDBizException(this.filterSensitiveInfo(e, dbInstance));
        }
    }

    private String getTableIndexSql(String dbtype, String tableName) {
        String sql = "";
        if (DATA_BASE_TYPE_ORACLE.equals(dbtype) || DATA_BASE_TYPE_VASTBASE.equals(dbtype) || DATA_BASE_TYPE_YAS.equals(dbtype) || DATA_BASE_TYPE_OCEANBASE_ORACLE.equals(dbtype)) {
            String select = "select a.TABLE_NAME,a.UNIQUENESS,a.index_name,b.COLUMN_NAME,b.COLUMN_POSITION,b.COLUMN_LENGTH,b.DESCEND,a.index_type,a.TABLE_TYPE,a.table_owner,a.last_analyzed ";
            String from = "from user_indexes a ,user_ind_columns b ";
            String where = "where a.table_name=b.table_name and a.index_name = b.index_name and a.table_name = '" + tableName.toUpperCase() + "' order by a.uniqueness desc";
            sql = PREFIX_DIALECT + select + from + where;
        } else if (DATA_BASE_TYPE_POST_GRE_SQL.equals(dbtype) || DATA_BASE_TYPE_GBASE.equals(dbtype) || DATA_BASE_TYPE_GAUSSDB.equals(dbtype)) {
            String select = "select * ";
            String from = "from pg_indexes ";
            String where = "where tablename= '" + tableName.toLowerCase() + "'";
            sql = PREFIX_DIALECT + select + from + where;
        } else if (DATA_BASE_TYPE_MYSQL.equals(dbtype) || DATA_BASE_TYPE_OCEANBASE_MYSQL.equals(dbtype)) {
            sql = "/*dialect*/show index from " + tableName;
        } else if (DATA_BASE_TYPE_MD.equals(dbtype)) {
            String select = "select a.TABLE_NAME,a.UNIQUENESS,a.index_name,b.COLUMN_NAME,b.COLUMN_POSITION,b.COLUMN_LENGTH,b.DESCEND,a.index_type,a.TABLE_TYPE,a.table_owner,a.last_analyzed ";
            String from = "from user_indexes a ,user_ind_columns b ";
            String where = "where a.table_name=b.table_name and a.index_name = b.index_name and a.table_name = '" + tableName.toUpperCase() + "' order by a.uniqueness desc";
            sql = PREFIX_DIALECT + select + from + where;
        } else if (DATA_BASE_TYPE_SQLSERVER.equals(dbtype)) {
            sql = "/*dialect*/exec sp_helpindex " + tableName;
        } else if (DATA_BASE_TYPE_GAUSSDB.equals(dbtype)) {
            sql = this.getLikePgIndexSQL(tableName);
        } else if (DATA_BASE_TYPE_KINGBASE.equals(dbtype)) {
            sql = this.getLikePgIndexSQL(tableName);
        } else if (DATA_BASE_TYPE_TDSQL.equals(dbtype) || DATA_BASE_TYPE_TIDB.equals(dbtype)) {
            sql = "/*dialect*/show index from " + tableName;
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u5904\u7406\u8be5\u6570\u636e\u5e93\u7c7b\u578b\uff1a%s", (String)"SQLQueryAnalyzerPlugin_16", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]), dbtype));
        }
        return sql;
    }

    private String getLikePgIndexSQL(String table) {
        String select = "select * ";
        String from = "from pg_indexes ";
        String where = "where tablename= '" + table.toLowerCase() + "'";
        return PREFIX_DIALECT + select + from + where;
    }

    private void checkSqlIsEmpty(String tableName) throws KDBizException {
        if (tableName.trim().indexOf(" ") != -1) {
            this.informationBuilder.append(ResManager.loadKDString((String)"\u8868\u540d\u4e0d\u6b63\u786e\u3002", (String)"SQLQueryAnalyzerPlugin_17", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0])).append(ENTER_LINE);
            String info = this.informationBuilder.toString();
            this.getModel().setValue(INFOMATION_TEXTAREA, (Object)info);
            this.getPageCache().put(SHOWPAGEID, TABPAGEAP_INFO);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u8868\u540d\u4e0d\u6b63\u786e\u3002", (String)"SQLQueryAnalyzerPlugin_28", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]), tableName));
        }
    }

    private void checkSqlHaveSystemTable(String selectSql, DBInstance dbInstance) throws KDBizException {
        if (this.selectSystemTable(selectSql, dbInstance.getDbtype())) {
            this.informationBuilder.append(ResManager.loadKDString((String)"\u67e5\u8be2\u8bed\u53e5\u4e2d\u5305\u542b\u6570\u636e\u5e93\u7cfb\u7edf\u81ea\u5e26\u7684\u8868\uff0c\u67e5\u8be2\u8bed\u53e5\u7981\u6b62\u6267\u884c\u3002", (String)"SQLQueryAnalyzerPlugin_8", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0])).append(ENTER_LINE);
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8bed\u53e5\u4e2d\u5305\u542b\u6570\u636e\u5e93\u7cfb\u7edf\u81ea\u5e26\u7684\u8868\uff0c\u67e5\u8be2\u8bed\u53e5\u7981\u6b62\u6267\u884c\u3002", (String)"SQLQueryAnalyzerPlugin_8", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void selectDBbySql(DBRoute dbRoute, String sql, String dbtype) throws KDBizException {
        sql = this.changeToKSqlLimit(sql, dbtype);
        try (QueryTimeout q = DB.timeout((int)60);
             RWContext ctx = DB.rw().create("ksql_query_function");){
            DB.query((DBRoute)dbRoute, (String)sql, rs -> rs.next());
        }
        catch (KDException e) {
            log.warn((Throwable)e);
            if (e.getErrorCode() != null && e.getErrorCode().toString().equals("bos.sQLRWTimeOut")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d85\u65f6%s\u79d2\uff0c\u53d6\u6d88\u5f53\u524d\u64cd\u4f5c\u3002", (String)"SQLQueryAnalyzerPlugin_23", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]), 60));
            }
            throw new KDBizException("ErrorCode:" + e.getErrorCode() + ENTER_LINE + e.getMessage());
        }
    }

    public void isAnnotated() {
        IFormView formView = this.getView();
        String noUseKsql = ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4f7f\u7528\u7684KSQL\u8bed\u53e5\u3002", (String)MESSAGE_12, (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]);
        String ksqlStrs = this.getAllSQLText();
        if (null == ksqlStrs || "".equals(ksqlStrs)) {
            this.informationBuilder.append(noUseKsql);
            formView.showTipNotification(noUseKsql);
            this.getModel().setValue(INFOMATION_TEXTAREA, (Object)noUseKsql);
            return;
        }
        CodeEdit sqlCodeEditor = (CodeEdit)this.getControl(TEXTAREA_SQLAREA);
        String selectSql = sqlCodeEditor.getSelectionText();
        StringBuilder newSql = this.getAnnotatedSql(ksqlStrs, selectSql);
        CodeEdit sqlEditor = (CodeEdit)this.getControl(TEXTAREA_SQLAREA);
        sqlEditor.setText(newSql.toString());
    }

    private StringBuilder getAnnotatedSql(String ksqlStrs, String selectSql) {
        String[] sqls = ksqlStrs.split("\\n");
        boolean isAnnotated = false;
        if (this.isAnnotated(sqls[0])) {
            isAnnotated = true;
        }
        StringBuilder newSql = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)selectSql)) {
            if (selectSql.contains("/*") && selectSql.contains("*/")) {
                String newSelectSql = selectSql.replace("/*", "");
                newSelectSql = newSelectSql.replace("*/", "");
                ksqlStrs = ksqlStrs.replace(selectSql, newSelectSql);
            } else {
                String newSelectSql = "/*" + selectSql + "*/";
                ksqlStrs = ksqlStrs.replace(selectSql, newSelectSql);
            }
            newSql.append(ksqlStrs);
        } else {
            int i;
            if (!isAnnotated) {
                for (i = 0; i < sqls.length; ++i) {
                    sqls[i] = sqls[i].length() >= 2 && sqls[i].substring(0, 2).equals("  ") ? "-- " + sqls[i].substring(2) : "-- " + sqls[i];
                }
            } else {
                for (i = 0; i < sqls.length; ++i) {
                    if (!this.isAnnotated(sqls[i])) continue;
                    sqls[i] = this.deleteAnnotation(sqls[i]);
                }
            }
            for (i = 0; i < sqls.length; ++i) {
                if (i == sqls.length - 1) {
                    newSql.append(sqls[i]);
                    continue;
                }
                newSql.append(sqls[i]).append(ENTER_LINE);
            }
        }
        return newSql;
    }

    String deleteAnnotation(String str) {
        if (str == null) {
            return str;
        }
        if (this.isNeed2Replace(str)) {
            if (str.indexOf("-- ") > -1) {
                return str.replaceFirst("-- ", "  ");
            }
            return str.replaceFirst("--", "  ");
        }
        return str.replaceFirst("--", "");
    }

    boolean isNeed2Replace(String str) {
        return str.length() > 2;
    }

    boolean isAnnotated(String str) {
        if (str == null) {
            return false;
        }
        return str.trim().startsWith("--");
    }

    public void formateSql() {
        String noUseKsql = ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4f7f\u7528\u7684KSQL\u8bed\u53e5\u3002", (String)MESSAGE_12, (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]);
        IFormView formView = this.getView();
        String sqlStrs = this.getAllSQLText();
        if (sqlStrs == null || sqlStrs.length() == 0) {
            this.informationBuilder.append(noUseKsql);
            formView.showTipNotification(noUseKsql);
            this.getModel().setValue(INFOMATION_TEXTAREA, (Object)noUseKsql);
            return;
        }
        if ((sqlStrs = this.oneCompleteSql(sqlStrs)).length() == 0) {
            this.informationBuilder.append(noUseKsql);
            formView.showTipNotification(noUseKsql);
            return;
        }
        StringBuilder newSql = new StringBuilder();
        String[] sqls = sqlStrs.split(SPLIT_FLAG);
        for (int i = 0; i < sqls.length; ++i) {
            if (StringUtils.isBlank((CharSequence)sqls[i])) continue;
            try {
                String sqlLine = sqls[i].trim();
                newSql.append(this.getSqlFormatter(sqlLine)).append(";\n");
                continue;
            }
            catch (Exception e) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u683c\u5f0f\u5316\u5931\u8d25\u3002", (String)"SQLQueryAnalyzerPlugin_19", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
        }
        CodeEdit sqlEditor = (CodeEdit)this.getControl(TEXTAREA_SQLAREA);
        sqlEditor.setText(newSql.toString());
    }

    protected String getSqlFormatter(String sql) {
        if (sql.toLowerCase(Locale.ENGLISH).startsWith("create") || sql.toLowerCase(Locale.ENGLISH).startsWith("alter")) {
            return new DDLFormatterImpl().format(sql);
        }
        if (sql.toLowerCase(Locale.ENGLISH).startsWith("select") || sql.toLowerCase(Locale.ENGLISH).startsWith("insert") || sql.toLowerCase(Locale.ENGLISH).startsWith("delete") || sql.toLowerCase(Locale.ENGLISH).startsWith("update")) {
            return new BasicFormatterImpl().format(sql);
        }
        return sql;
    }

    public void tableGenerateSelectSql(DBRoute dbRoute, String tableName, DBInstance dbInstance) throws KDBizException {
        this.checkSqlIsEmpty(tableName);
        String checkSystemTable = "select 1 from " + tableName;
        this.checkSqlHaveSystemTable(checkSystemTable, dbInstance);
        try {
            String dbtype = dbInstance.getDbtype();
            ArrayList<Object> paramList = new ArrayList<Object>(10);
            String sql = this.tableDefinitionSql(tableName, dbInstance.getDBInsatnce(), dbtype, paramList);
            List ids = CollectionUtils.isEmpty(paramList) ? (List)DB.query((DBRoute)dbRoute, (String)sql, SQLQueryAnalyzerPlugin::getQueryTableColumnResult) : (List)DB.query((DBRoute)dbRoute, (String)sql, (Object[])paramList.toArray(), SQLQueryAnalyzerPlugin::getQueryTableColumnResult);
            StringBuilder fields = new StringBuilder();
            for (String field : ids) {
                fields.append(field).append(",");
            }
            if (fields.length() <= 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8868%s\u672a\u67e5\u8be2\u5230\u3002", (String)"SQLQueryAnalyzerPlugin_25", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]), tableName));
            }
            String sqlStrs = this.getAllSQLText();
            CodeEdit sqlEditor = (CodeEdit)this.getControl(TEXTAREA_SQLAREA);
            StringBuilder selectSql = new StringBuilder();
            selectSql.append(sqlStrs);
            selectSql.append(ENTER_LINE);
            selectSql.append("select ").append(fields.subSequence(0, fields.length() - 1)).append(" \nfrom ").append(tableName).append(SPLIT_FLAG);
            sqlEditor.setText(selectSql.toString());
        }
        catch (Exception e) {
            throw new KDBizException(this.filterSensitiveInfo(e, dbInstance));
        }
    }

    @NotNull
    private static List<String> getQueryTableColumnResult(ResultSet resultSet) throws SQLException {
        ArrayList<String> fids = new ArrayList<String>(resultSet.getFetchSize());
        while (resultSet.next()) {
            fids.add(resultSet.getString(2));
        }
        return fids;
    }

    void isUseDialectExcute(String sql) {
        if (sql.indexOf("*") > -1) {
            this.dialect = true;
        }
    }

    public void tabClose(TabCloseEvent arg0) {
        List tabKeys = arg0.getTabKeys();
        ArrayList tabListClose = new ArrayList(10);
        for (String tabKey : tabKeys) {
            IFormView formView = SessionManager.getCurrent().getViewNoPlugin(tabKey);
            formView.close();
            HashMap<String, String> arg = new HashMap<String, String>();
            arg.put(PAGE_ID, tabKey);
            tabListClose.add(arg);
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("closeWindow", tabListClose);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (TEXT_DBROUTE.equalsIgnoreCase(name)) {
            DBInstance dbInstance;
            IDataModel model = this.getModel();
            String dbRouteText = (String)model.getValue(TEXT_DBROUTE);
            DBRoute dbRoute = DBRoute.basedata;
            if (!StringUtils.isEmpty((CharSequence)dbRouteText)) {
                dbRoute = DBRoute.of((String)dbRouteText);
            }
            if ((dbInstance = this.getDbInstance(dbRoute)) != null) {
                String dbtype = dbInstance.getDbtype();
                this.getTableList(dbRoute, dbInstance, dbtype, dbRouteText);
            }
        }
    }

    private void getTableList(DBRoute dbRoute, DBInstance dbInstance, String dbtype, String dbRouteText) {
        String key = String.format(TABLELISTCACHE, dbRouteText);
        boolean forceRefreshNode = this.getPageCache().getBigObject(key) != null;
        List tableList = null;
        if (forceRefreshNode) {
            String tableCache = this.getPageCache().getBigObject(key);
            tableList = SerializationUtils.fromJsonStringToList((String)tableCache, String.class);
        } else {
            try {
                ArrayList<Object> params = new ArrayList<Object>(1);
                String sql = this.getTableListSql(dbtype, dbInstance.getDBInsatnce(), params);
                log.info("\u83b7\u53d6\u6570\u636e\u5e93\u8868\u5217\u8868sql: " + sql);
                tableList = !CollectionUtils.isEmpty(params) ? (List)DB.query((DBRoute)dbRoute, (String)sql, (Object[])params.toArray(), resultSet -> {
                    ArrayList<String> fids = new ArrayList<String>(resultSet.getFetchSize());
                    while (resultSet.next()) {
                        String table = resultSet.getString(1);
                        if (!StringUtils.isNotBlank((CharSequence)table) || table.toLowerCase(Locale.ENGLISH).indexOf("t_") != 0) continue;
                        fids.add(resultSet.getString(1));
                    }
                    return fids;
                }) : (List)DB.query((DBRoute)dbRoute, (String)sql, resultSet -> {
                    ArrayList<String> fids = new ArrayList<String>(resultSet.getFetchSize());
                    while (resultSet.next()) {
                        String table = resultSet.getString(1);
                        if (!StringUtils.isNotBlank((CharSequence)table) || table.toLowerCase(Locale.ENGLISH).indexOf("t_") != 0) continue;
                        fids.add(resultSet.getString(1));
                    }
                    return fids;
                });
                if (!CollectionUtils.isEmpty((Collection)tableList)) {
                    this.getPageCache().putBigObject(key, SerializationUtils.toJsonString((Object)tableList));
                    this.getPageCache().put(TEXT_DB_ROUTE, dbRouteText);
                }
            }
            catch (Exception e) {
                log.warn("getTableList error " + e);
            }
        }
        if (tableList == null || tableList.isEmpty()) {
            return;
        }
        List<Map<String, Object>> fids = this.getTableNameFilter(tableList);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> configMap = new HashMap<String, Object>(4);
        configMap.put("k", TEXTAREA_SQLAREA);
        configMap.put("realTimeGetHint", true);
        configMap.put(AUTO_COMPLETE, true);
        configMap.put("keyWords", this.setBlacklist());
        clientViewProxy.addAction("u", configMap);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
        dataMap.put("code", fids.toArray());
        dataMap.put(AUTO_COMPLETE, true);
        dataMap.put("prefix", this.setHints().toArray());
        clientViewProxy.invokeControlMethod(TEXTAREA_SQLAREA, "setHints", new Object[]{dataMap});
    }

    private List<Map<String, Object>> getTableNameFilter(List<String> tableList) {
        ArrayList<Map<String, Object>> fids = new ArrayList<Map<String, Object>>(tableList.size());
        for (String tableName : tableList) {
            HashMap<String, String> fidsMap = new HashMap<String, String>(1);
            if (!StringUtils.isNotBlank((CharSequence)tableName) || tableName.toLowerCase(Locale.ENGLISH).indexOf("t_") != 0 || fids.size() >= 200) break;
            fidsMap.put("name", tableName);
            fids.add(fidsMap);
        }
        return fids;
    }

    private String getTableListSql(String dbtype, String dbInstance, List<Object> params) {
        String sql = "";
        String select = "";
        switch (dbtype) {
            case "0": 
            case "16": 
            case "18": 
            case "21": {
                sql = "SELECT TABLE_NAME FROM KSQL_USERTABLES";
                break;
            }
            case "1": 
            case "14": 
            case "15": {
                select = "select tablename from pg_tables order by tablename ";
                sql = PREFIX_DIALECT + select;
                break;
            }
            case "2": 
            case "17": 
            case "19": 
            case "22": {
                params.add(dbInstance);
                select = "select table_name from information_schema.tables where table_schema= ?";
                sql = PREFIX_DIALECT + select;
                break;
            }
            case "3": 
            case "6": {
                select = "select table_name from information_schema.tables ";
                sql = PREFIX_DIALECT + select;
                break;
            }
            case "20": {
                select = "SELECT TABLE_NAME FROM ALL_TABLES ";
                sql = PREFIX_DIALECT + select;
                break;
            }
        }
        return sql;
    }

    private Map<String, Object> setBlacklist() {
        ArrayList<String> blacklist = new ArrayList<String>(5);
        blacklist.add("DROP");
        blacklist.add("DELETE");
        blacklist.add("UPDATE");
        blacklist.add("INSERT");
        blacklist.add("CREATE");
        HashMap<String, Object> blacklistMap = new HashMap<String, Object>(1);
        blacklistMap.put("blacklist", blacklist);
        return blacklistMap;
    }

    private List<String> setHints() {
        ArrayList<String> hintsList = new ArrayList<String>(2);
        hintsList.add("t_");
        hintsList.add("tk_");
        return hintsList;
    }

    public void customHints(Map<String, Object> word) {
        DBInstance dbInstance;
        IDataModel model = this.getModel();
        String dbRouteText = (String)model.getValue(TEXT_DBROUTE);
        DBRoute dbRoute = DBRoute.basedata;
        if (!StringUtils.isEmpty((CharSequence)dbRouteText)) {
            dbRoute = DBRoute.of((String)dbRouteText);
        }
        if ((dbInstance = this.getDbInstance(dbRoute)) == null) {
            return;
        }
        String dbtype = dbInstance.getDbtype();
        List tableNames = (List)word.get("word");
        if (CollectionUtils.isEmpty((Collection)tableNames)) {
            return;
        }
        List<Map<String, Object>> idsList = this.getTableColumns(tableNames, dbRoute, dbInstance, dbtype);
        if (CollectionUtils.isEmpty(idsList)) {
            return;
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> configMap = new HashMap<String, String>(1);
        configMap.put("k", TEXTAREA_SQLAREA);
        clientViewProxy.addAction("u", configMap);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
        dataMap.put("code", idsList);
        dataMap.put(AUTO_COMPLETE, true);
        clientViewProxy.invokeControlMethod(TEXTAREA_SQLAREA, UPDATE_HINTS, new Object[]{dataMap});
    }

    public void getHints(Map<String, Object> word) {
        boolean forceRefreshNode;
        if (CollectionUtils.isEmpty(word)) {
            return;
        }
        String tableName = word.get("userInput").toString();
        if (tableName.indexOf("t_") < 0) {
            return;
        }
        String dbRouteText = this.getPageCache().get(TEXT_DB_ROUTE);
        String key = String.format(TABLELISTCACHE, dbRouteText);
        boolean bl = forceRefreshNode = this.getPageCache().getBigObject(key) != null;
        if (!forceRefreshNode) {
            return;
        }
        String tableCache = this.getPageCache().getBigObject(key);
        List tableList = SerializationUtils.fromJsonStringToList((String)tableCache, String.class);
        if (CollectionUtils.isEmpty((Collection)tableList)) {
            return;
        }
        List shardsList = tableList.stream().filter(f -> f.toLowerCase(Locale.ENGLISH).contains(tableName.toLowerCase(Locale.ENGLISH).replaceAll("t_", ""))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(shardsList)) {
            return;
        }
        shardsList.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() > o2.length()) {
                    return 1;
                }
                if (o1.length() == o2.length()) {
                    return 0;
                }
                if (o1.length() < o2.length()) {
                    return -1;
                }
                return 0;
            }
        });
        if (shardsList.size() > 50) {
            shardsList = shardsList.subList(0, 50);
        }
        ArrayList fids = new ArrayList(shardsList.size());
        for (String name : shardsList) {
            HashMap<String, String> fidsMap = new HashMap<String, String>(1);
            fidsMap.put("name", name);
            fids.add(fidsMap);
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> configMap = new HashMap<String, String>(2);
        configMap.put("key", TEXTAREA_SQLAREA);
        configMap.put("methodname", UPDATE_HINTS);
        clientViewProxy.addAction("u", configMap);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(3);
        dataMap.put("dynamicHints", fids.toArray());
        dataMap.put(AUTO_COMPLETE, true);
        dataMap.put("userInput", tableName);
        clientViewProxy.invokeControlMethod(TEXTAREA_SQLAREA, UPDATE_HINTS, new Object[]{dataMap});
    }

    private List<Map<String, Object>> getTableColumns(List<Object> tableNames, DBRoute dbRoute, DBInstance dbInstance, String dbtype) {
        ArrayList<Map<String, Object>> idsList = new ArrayList<Map<String, Object>>(8);
        ArrayList<String> names = new ArrayList<String>(8);
        for (Object objects : tableNames) {
            List tables = (List)objects;
            for (Object name : tables) {
                names.add(name.toString());
            }
        }
        if (CollectionUtils.isEmpty(names)) {
            return idsList;
        }
        for (String tableName : names) {
            try {
                if (StringUtils.isBlank((CharSequence)tableName)) continue;
                HashMap<String, Object> nameMap = new HashMap<String, Object>(8);
                nameMap.put("name", tableName);
                idsList.add(nameMap);
                List<Map<String, Object>> columnsList = this.getDateBaseTableColumns(dbRoute, tableName, dbInstance, dbtype);
                if (CollectionUtils.isEmpty(columnsList)) continue;
                nameMap.put("child", columnsList);
                idsList.add(nameMap);
            }
            catch (Exception e) {
                log.warn("sql customHints " + e.getMessage(), (Throwable)e);
            }
        }
        return idsList;
    }

    private List<Map<String, Object>> getDateBaseTableColumns(DBRoute dbRoute, String tableName, DBInstance dbInstance, String dbtype) throws KDBizException {
        ArrayList<Map<String, Object>> childList = new ArrayList<Map<String, Object>>();
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        String sql = this.tableDefinitionSql(tableName, dbInstance.getDBInsatnce(), dbtype, paramList);
        if (CollectionUtils.isEmpty(paramList)) {
            DB.query((DBRoute)dbRoute, (String)sql, resultSet -> {
                ArrayList fids = new ArrayList(resultSet.getFetchSize());
                while (resultSet.next()) {
                    HashMap<String, String> columnsMap = new HashMap<String, String>(1);
                    columnsMap.put("name", resultSet.getString(2));
                    childList.add(columnsMap);
                }
                return fids;
            });
        } else {
            DB.query((DBRoute)dbRoute, (String)sql, (Object[])paramList.toArray(), resultSet -> {
                ArrayList fids = new ArrayList(resultSet.getFetchSize());
                while (resultSet.next()) {
                    HashMap<String, String> columnsMap = new HashMap<String, String>(1);
                    columnsMap.put("name", resultSet.getString(2));
                    childList.add(columnsMap);
                }
                return fids;
            });
        }
        return childList;
    }

    private String changeToKSqlLimit(String sql, String dbtype) {
        block4: {
            if (!this.executetype.equals(DATA_BASE_TYPE_POST_GRE_SQL)) {
                return sql;
            }
            try {
                if (!sql.contains("count(1)") && !sql.contains("count(*)")) {
                    sql = TransUtil.changeToKSqlLimit((String)sql, (int)1000);
                }
            }
            catch (Exception e1) {
                log.warn("ksql add limit error " + e1.getMessage(), (Throwable)e1);
                if (sql.indexOf(42) <= -1) break block4;
                sql = this.changeToSqlLimit(sql, dbtype, this.executetype);
            }
        }
        log.debug("selectDBbySql sql " + sql + " dbtype: " + dbtype);
        return sql;
    }

    private String changeToSqlLimit(String sql, String dbtype, String executetype) {
        if (StringUtils.isBlank((CharSequence)sql) || sql.indexOf(42) <= -1 || StringUtils.isBlank((CharSequence)dbtype) || !executetype.equals(DATA_BASE_TYPE_POST_GRE_SQL)) {
            return sql;
        }
        try {
            sql = this.oneCompleteSql(sql);
            sql = sql.replace("*", SQL_PLACE_HOLDER);
            sql = TransUtil.changeToKSqlLimit((String)sql, (int)1000);
            sql = this.execTransKSQL(sql, Integer.parseInt(this.changeDBType(dbtype)));
            sql = sql.replace(SQL_PLACE_HOLDER, "*");
            sql = PREFIX_DIALECT + sql;
            return sql;
        }
        catch (Exception e) {
            log.warn("sql add limit error " + e.getMessage(), (Throwable)e);
            return sql;
        }
    }

    private String changeDBType(String dbtype) {
        String kSqlDbType = "5";
        switch (dbtype) {
            case "0": {
                kSqlDbType = DATA_BASE_TYPE_MYSQL;
                break;
            }
            case "1": {
                kSqlDbType = "5";
                break;
            }
            case "2": 
            case "7": {
                kSqlDbType = DATA_BASE_TYPE_SQLSERVER;
                break;
            }
            case "3": {
                kSqlDbType = "11";
                break;
            }
            case "4": {
                kSqlDbType = "12";
                break;
            }
            case "5": {
                kSqlDbType = "13";
                break;
            }
            case "6": {
                kSqlDbType = DATA_BASE_TYPE_MD;
                break;
            }
            default: {
                kSqlDbType = dbtype;
            }
        }
        return kSqlDbType;
    }
}

