/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.sql.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabCloseEvent;
import kd.bos.form.control.events.TabCloseListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.form.FormView;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class SQLQueryAnalyzerTopPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener,
TabCloseListener {
    private static final Log log = LogFactory.getLog(SQLQueryAnalyzerTopPlugin.class);
    private static final String BOS_BASE_FORMPLUGIN = "bos-base-formplugin";
    private static final String SHOWPAGEID = "showPageId";
    private static final String PAGE_ID = "pageId";
    private static final String SPLIT_FLAG = ";";
    private static final String totalTabNum = "totalTabNum";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        Tab tab = (Tab)this.getView().getControl("sqlwindowtabap");
        tab.addTabCloseListener((TabCloseListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)"newsqlwindow", (CharSequence)evt.getItemKey())) {
            SessionManager current = SessionManager.getCurrent();
            int i = 0;
            StringBuilder sb = new StringBuilder();
            for (String pageId : this.getAllCachedPageIds()) {
                if (!current.existView(pageId)) continue;
                sb.append(pageId);
                sb.append(SPLIT_FLAG);
                ++i;
            }
            this.getPageCache().put(PAGE_ID, sb.toString());
            if (i >= 10) {
                this.getView().showMessage(ResManager.loadKDString((String)"sql\u67e5\u8be2\u7a97\u53e3\u4e0d\u80fd\u8d85\u8fc710\u4e2a", (String)"SQLQueryAnalyzerTopPlugin_0", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            String totalNum = this.getPageCache().get(totalTabNum);
            FormShowParameter lsp = new FormShowParameter();
            lsp.setFormId("bd_ksql_query_view");
            lsp.getOpenStyle().setTargetKey("sqlwindowtabap");
            lsp.getOpenStyle().setShowType(ShowType.NewTabPage);
            lsp.setParentFormId(this.getView().getFormShowParameter().getFormId());
            lsp.setCaption(String.format(ResManager.loadKDString((String)"sql\u67e5\u8be2\u7a97\u53e3\uff08%s\uff09", (String)"SQLQueryAnalyzerTopPlugin_1", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]), totalNum));
            this.getView().showForm(lsp);
            this.getPageCache().put(SHOWPAGEID, lsp.getPageId());
            this.AddPageIdIntoCache(lsp.getPageId());
        } else if (StringUtils.equals((CharSequence)"button_execute_ksql", (CharSequence)evt.getItemKey()) || StringUtils.equals((CharSequence)"button_execute_ksql_new", (CharSequence)evt.getItemKey()) || StringUtils.equals((CharSequence)"button_explain_sql", (CharSequence)evt.getItemKey()) || StringUtils.equals((CharSequence)"button_table_index", (CharSequence)evt.getItemKey()) || StringUtils.equals((CharSequence)"button_translate_sql", (CharSequence)evt.getItemKey()) || StringUtils.equals((CharSequence)"button_table_definition", (CharSequence)evt.getItemKey()) || StringUtils.equals((CharSequence)"button_format_sql", (CharSequence)evt.getItemKey()) || StringUtils.equals((CharSequence)"button_isannotated", (CharSequence)evt.getItemKey()) || StringUtils.equals((CharSequence)"button_fireinspect", (CharSequence)evt.getItemKey()) || StringUtils.equals((CharSequence)"button_table_search", (CharSequence)evt.getItemKey()) || StringUtils.equals((CharSequence)"button_all_table", (CharSequence)evt.getItemKey())) {
            this.extracted(evt.getOperationKey());
        }
    }

    private void extracted(String operationKey) {
        Tab tab = (Tab)this.getView().getControl("sqlwindowtabap");
        String currentTab = tab.getCurrentTab();
        SessionManager current = SessionManager.getCurrent();
        if (!current.existView(currentTab)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u65e0sql\u67e5\u8be2\u7a97\u53e3\uff0c\u8bf7\u65b0\u589e\u3002", (String)"SQLQueryAnalyzerTopPlugin_4", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        IFormView view = this.getView();
        String subAppID = view.getServiceAppId(currentTab);
        String requestParams = String.format("[{\"key\":\"%s\",\"methodName\":\"itemClick\",\"args\":[\"%s\",\"%s\"],\"postData\":[{},[]]}]", "toolbarap", "button_dialect_sql", operationKey + "_child");
        Object resultObject = DispatchServiceHelper.invokeBOSService((String)subAppID, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{currentTab, requestParams});
        if (resultObject == null) {
            log.warn("\u8c03\u7528" + operationKey + "_child\uff0c\u65e0\u8fd4\u56de\u503c");
            return;
        }
        String result = resultObject.toString();
        List list = (List)SerializationUtils.fromJsonString((String)result, List.class);
        HashMap<String, Object> arg = new HashMap<String, Object>(2);
        arg.put(PAGE_ID, currentTab);
        arg.put("actions", list);
        ((FormView)this.getView()).getClientProxy().addAction("sendDynamicFormAction", arg);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("bd_ksql_query_view");
        lsp.getOpenStyle().setTargetKey("sqlwindowtabap");
        lsp.getOpenStyle().setShowType(ShowType.NewTabPage);
        lsp.setParentFormId(this.getView().getFormShowParameter().getFormId());
        lsp.setCaption(ResManager.loadKDString((String)"sql\u67e5\u8be2\u7a97\u53e3(1)", (String)"SQLQueryAnalyzerTopPlugin_2", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
        this.getView().showForm(lsp);
        this.getPageCache().put(SHOWPAGEID, lsp.getPageId());
        this.AddPageIdIntoCache(lsp.getPageId());
    }

    private void AddPageIdIntoCache(String pageId) {
        StringBuilder sb = new StringBuilder();
        String pageIds = this.getPageCache().get(PAGE_ID);
        if (pageIds != null) {
            sb.append(pageIds);
        }
        sb.append(SPLIT_FLAG);
        sb.append(pageId);
        this.getPageCache().put(PAGE_ID, sb.toString());
        String totalNum = this.getPageCache().get(totalTabNum);
        if (totalNum != null && totalNum.length() > 0) {
            this.getPageCache().put(totalTabNum, Integer.parseInt(totalNum) + 1 + "");
        } else {
            this.getPageCache().put(totalTabNum, "2");
        }
    }

    private void deletePageIdIntoCache(String pageId) {
        ArrayList<String> list = new ArrayList<String>(10);
        StringBuilder sb = new StringBuilder();
        String pageIdsObject = this.getPageCache().get(PAGE_ID);
        if (pageIdsObject != null) {
            sb.append(pageIdsObject);
            String[] pageIds = sb.toString().split(SPLIT_FLAG);
            for (int i = 0; i < pageIds.length; ++i) {
                if (!StringUtils.isNotEmpty((CharSequence)pageIds[i].trim()) || pageIds[i].trim().equals(pageId)) continue;
                list.add(pageIds[i].trim());
            }
            StringBuilder sb2 = new StringBuilder();
            for (String pageId2 : list) {
                sb2.append(pageId2);
                sb2.append(SPLIT_FLAG);
            }
            this.getPageCache().put(PAGE_ID, sb2.toString());
        }
    }

    private List<String> getAllCachedPageIds() {
        ArrayList<String> list = new ArrayList<String>(10);
        StringBuilder sb = new StringBuilder();
        String pageIdsObject = this.getPageCache().get(PAGE_ID);
        if (pageIdsObject != null) {
            sb.append(pageIdsObject);
            String[] pageIds = sb.toString().split(SPLIT_FLAG);
            for (int i = 0; i < pageIds.length; ++i) {
                if (!StringUtils.isNotEmpty((CharSequence)pageIds[i].trim())) continue;
                list.add(pageIds[i].trim());
            }
        }
        return list;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        boolean isSuperAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
        if (!isSuperAdmin) {
            String tenantId = RequestContext.get().getTenantId();
            String isVisible = System.getProperty(tenantId + "_queryAnalyzer");
            boolean adminUser = PermissionServiceHelper.isAdminUser((long)userId);
            if (isVisible != null && !StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)isVisible) || !adminUser) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u8be5\u529f\u80fd\u3002", (String)"SQLQueryAnalyzerTopPlugin_3", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    public void tabClose(TabCloseEvent evt) {
        List tabKeys = evt.getTabKeys();
        ArrayList tabListClose = new ArrayList(10);
        for (String tabKey : tabKeys) {
            IFormView formView = SessionManager.getCurrent().getViewNoPlugin(tabKey);
            formView.close();
            HashMap<String, String> arg = new HashMap<String, String>();
            arg.put(PAGE_ID, tabKey);
            tabListClose.add(arg);
            this.deletePageIdIntoCache(tabKey);
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("closeWindow", tabListClose);
    }
}

