/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.sql.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.ksql.TransUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class SQLQueryTablePlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(SQLQueryTablePlugin.class);
    private static final String BOS_BASE_FORM_PLUGIN = "bos-base-formplugin";
    private static final String RESULT_TAB_KEY = "resulttab";
    private static final String RESULT_VIEW = "bd_ksql_result_view";
    private static final String SHOW_PAGE_ID = "showPageId";
    private static final String BD_KSQL_SEARCH_TABLE = "bd_ksql_searchtable";
    private static final String PAGE_ID = "pageId";
    private static final String SHOW_TAB = "showTab";
    private static final String TABLE_NAME = "tablename";
    private static final int LINE_NUM = 1000;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"operatepanel"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)BD_KSQL_SEARCH_TABLE, (CharSequence)operateKey)) {
            if (this.getModel().getValue(TABLE_NAME) == null || this.getModel().getValue(TABLE_NAME) == "") {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5b9e\u4f53\u540d\u79f0\u3002", (String)"SQLQueryTablePlugin_0", (String)BOS_BASE_FORM_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String tableName = (String)this.getModel().getValue(TABLE_NAME);
            List<List<Object>> list = this.getTableEntity(tableName);
            if (CollectionUtils.isEmpty(list)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u5bf9\u5e94\u5b9e\u4f53\u3002", (String)"SQLQueryTablePlugin_1", (String)BOS_BASE_FORM_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String showTab = this.getView().getParentView().getPageCache().get(SHOW_TAB);
            this.createResultViewPage(Integer.parseInt(showTab), list);
            FormShowParameter lsp = new FormShowParameter();
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            lsp.setFormId(BD_KSQL_SEARCH_TABLE);
            this.getView().close();
        }
    }

    private void createResultViewPage(int index, List<List<Object>> tableNames) {
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId(RESULT_VIEW);
        HashMap<String, Object> params = new HashMap<String, Object>();
        ++index;
        ArrayList<String> colNames = new ArrayList<String>(3);
        colNames.add(ResManager.loadKDString((String)"\u5b9e\u4f53", (String)"SQLQueryTablePlugin_3", (String)BOS_BASE_FORM_PLUGIN, (Object[])new Object[0]));
        colNames.add(ResManager.loadKDString((String)"\u540d\u79f0", (String)"SQLQueryTablePlugin_4", (String)BOS_BASE_FORM_PLUGIN, (Object[])new Object[0]));
        colNames.add(ResManager.loadKDString((String)"\u8868\u540d", (String)"SQLQueryTablePlugin_5", (String)BOS_BASE_FORM_PLUGIN, (Object[])new Object[0]));
        params.put("colNames", colNames);
        params.put("tableNames", tableNames);
        params.put("index", index);
        lsp.setCustomParams(params);
        lsp.getOpenStyle().setTargetKey(RESULT_TAB_KEY);
        lsp.getOpenStyle().setShowType(ShowType.NewTabPage);
        String msg = ResManager.loadKDString((String)"\u5b9e\u4f53\u8868\u641c\u7d22\uff08%s\uff09", (String)"SQLQueryTablePlugin_2", (String)BOS_BASE_FORM_PLUGIN, (Object[])new Object[0]);
        lsp.setCaption(String.format(msg, index));
        lsp.setParentFormId(this.getView().getParentView().getFormShowParameter().getFormId());
        this.getView().getParentView().getPageCache().put(SHOW_PAGE_ID, lsp.getPageId());
        this.getView().getParentView().showForm(lsp);
        this.addPageIdIntoCache(lsp.getPageId());
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private List<List<Object>> getTableEntity(String entityName) {
        List<List<Object>> list = new ArrayList<List<Object>>(8);
        try {
            String lang = RequestContext.get().getLang().toString();
            String sql = "select d1.fid, d1.fname, d2.ftablename from t_meta_mainentityinfo_l d1,t_meta_mainentityinfo d2 where d1.fname like ? and d1.fid = d2.fid and d1.flocaleid = ? ";
            if (!this.isContainChinese(entityName)) {
                sql = "select d1.fid, d1.fname, d2.ftablename from t_meta_mainentityinfo_l d1,t_meta_mainentityinfo d2 where d1.fid like ? and d1.fid = d2.fid and d1.flocaleid = ? ";
            }
            Object[] params = new Object[]{"%" + entityName + "%", lang};
            sql = this.changeToKSqlLimit(sql);
            list = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, resultSet -> {
                ArrayList objectList = new ArrayList(8);
                while (resultSet.next()) {
                    ArrayList<String> objects = new ArrayList<String>(3);
                    String fid = resultSet.getString(1);
                    String fname = resultSet.getString(2);
                    String ftablename = resultSet.getString(3);
                    objects.add(fid);
                    objects.add(fname);
                    objects.add(ftablename);
                    objectList.add(objects);
                }
                return objectList;
            });
            return list;
        }
        catch (Exception e) {
            log.warn("getTableEntity error " + e.getMessage(), (Throwable)e);
            return list;
        }
    }

    private String changeToKSqlLimit(String sql) {
        try {
            sql = TransUtil.changeToKSqlLimit((String)sql, (int)1000);
        }
        catch (Exception e1) {
            log.warn("sql add limit error " + e1.getMessage(), (Throwable)e1);
        }
        log.debug("selectDBbySql sql " + sql);
        return sql;
    }

    private boolean isContainChinese(String str) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        return m.find();
    }

    private void addPageIdIntoCache(String pageId) {
        StringBuilder sb = new StringBuilder();
        String pageIds = this.getView().getParentView().getPageCache().get(PAGE_ID);
        if (pageIds != null) {
            sb.append(pageIds);
        }
        sb.append(";");
        sb.append(pageId);
        this.getView().getParentView().getPageCache().put(PAGE_ID, sb.toString());
    }
}

