/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.sql.formplugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.base.sql.formplugin.Column;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SQLResultExportPlugin
extends AbstractFormPlugin {
    private static final String BOS_BASE_FORMPLUGIN = "bos-base-formplugin";
    private static final String SHOW_PAGE_ID = "showPageId";
    private static final String TAB_INFO = "tabpageap_info";
    private static final String TAB_HISTORY = "tabpageap_his_entry";
    private static final Log logger = LogFactory.getLog(SQLResultExportPlugin.class);
    private static final String BUTTON_EXPORT = "button_export";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        if (BUTTON_EXPORT.equals(evt.getItemKey())) {
            String showPageId;
            Tab resulttab;
            String currentResultTabId;
            Tab tab = (Tab)this.getView().getControl("sqlwindowtabap");
            String currentTabId = tab.getCurrentTab();
            IFormView currentTab = this.getView().getView(currentTabId);
            IFormView currentResultTab = currentTab.getView(currentResultTabId = (resulttab = (Tab)currentTab.getControl("resulttab")).getCurrentTab());
            if (Objects.isNull(currentResultTab) && (Objects.isNull(currentResultTab = currentTab.getView(showPageId = currentTab.getPageCache().get(SHOW_PAGE_ID))) || TAB_INFO.equals(currentResultTabId) || TAB_HISTORY.equals(currentResultTabId))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u7ed3\u679c\u9875\u7b7e\u3002", (String)"SQLResultExportPlugin_0", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            String resultPageId = currentResultTab.getPageId();
            String dataListStr = currentResultTab.getPageCache().getBigObject("datalist_" + resultPageId);
            String columnListStr = currentResultTab.getPageCache().getBigObject("columnlist_" + resultPageId);
            if (StringUtils.isEmpty((CharSequence)dataListStr) || StringUtils.isEmpty((CharSequence)columnListStr)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u7b7e\u7ed3\u679c\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u3002", (String)"SQLResultExportPlugin_1", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            if (dataListStr.length() <= 2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u7b7e\u65e0\u7ed3\u679c\u3002", (String)"SQLResultExportPlugin_3", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
            } else {
                List dataList = SerializationUtils.fromJsonStringToList((String)dataListStr, ArrayList.class);
                List columnList = SerializationUtils.fromJsonStringToList((String)columnListStr, Column.class);
                XSSFWorkbook workbook = this.excel(dataList, columnList);
                String entityName = currentResultTab.getFormShowParameter().getCaption();
                String path = this.upload(entityName, workbook);
                this.getView().openUrl(RequestContext.get().getClientFullContextPath() + "attachment/download.do?path=" + path);
            }
        }
    }

    private XSSFWorkbook excel(List<List<Object>> excel, List<Column> columnList) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        sheet.setDefaultColumnWidth(30);
        ArrayList excelList = new ArrayList(8);
        ArrayList<String> selectFieldList = new ArrayList<String>(8);
        selectFieldList.add(0, "#");
        for (int i = 0; i < columnList.size(); ++i) {
            selectFieldList.add(columnList.get(i).getName());
        }
        excelList.add(selectFieldList);
        ArrayList<String> dataList = null;
        for (int i = 0; i < excel.size(); ++i) {
            dataList = new ArrayList<String>(8);
            for (int j = 0; j < excel.get(i).size() - 1; ++j) {
                dataList.add(excel.get(i).get(j + 1).toString());
            }
            excelList.add(i + 1, dataList);
        }
        XSSFCellStyle billStyle = workbook.createCellStyle();
        XSSFFont billFont = workbook.createFont();
        billFont.setFontName(ResManager.loadKDString((String)"\u9ed1\u4f53", (String)"SQLResultExportPlugin_2", (String)BOS_BASE_FORMPLUGIN, (Object[])new Object[0]));
        billFont.setFontHeight(15.0);
        billStyle.setFont((Font)billFont);
        for (int i = 0; i < excelList.size(); ++i) {
            XSSFRow nrow = sheet.createRow(i);
            for (int u = 0; u < ((List)excelList.get(i)).size(); ++u) {
                XSSFCell ncell = nrow.createCell(u);
                ncell.setCellStyle((CellStyle)billStyle);
                ncell.setCellValue((String)((List)excelList.get(i)).get(u));
            }
        }
        return workbook;
    }

    private String upload(String entityName, XSSFWorkbook workbook) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String fileName = entityName + sdf.format(new Date()) + ".xlsx";
        String pathName = "/exportexcel/" + fileName;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outputStream);
            ByteArrayInputStream inputStream = this.parse(outputStream);
            FileService fs = FileServiceFactory.getAttachmentFileService();
            return fs.upload(new FileItem(fileName, pathName, (InputStream)inputStream));
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private ByteArrayInputStream parse(OutputStream out) {
        ByteArrayOutputStream baos = (ByteArrayOutputStream)out;
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

