/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.sql.formplugin;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.base.sql.formplugin.Column;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class SQLResultGrid
extends AbstractFormPlugin {
    private static final int TIME_OUT = 60;
    private static final String FSEQ_NAME = "fseqName";
    private static final String TABLE_KEY_ENTRYENTITY = "entryentity";
    private static final int PAGE_ROW = 50;
    public static final String COLUMN_LIST = "columnList";
    public static final String DATA_LIST = "dataList";
    public static final String INDEX = "index";
    public static final String DBROUTE = "dbRoute";
    public static final String SQL = "sql";
    public static final String PARAMS = "params";
    public static final String IS_TABLE_STRUCTURE = "iSTableStructure";
    public static final String TABLE_NAME = "tableName";
    public static final String IS_SELECT = "iSSelect";
    private static final String DATA_INDEX = "dataIndex";
    private static final String HEADER = "header";
    private static final String SQL_SECRET = "******";
    private static final Log log = LogFactory.getLog(SQLResultGrid.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleBusinessLogic();
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void handleBusinessLogic() {
        Object dbRouteObject = this.getView().getFormShowParameter().getCustomParams().get(DBROUTE);
        Object sqlObject = this.getView().getFormShowParameter().getCustomParams().get(SQL);
        Object paramsObj = this.getView().getFormShowParameter().getCustomParams().get(PARAMS);
        if (dbRouteObject != null && sqlObject instanceof String) {
            List<List<Object>> dataList;
            ArrayList<Column> columnList;
            block4: {
                String dbRouteText = (String)dbRouteObject;
                String sql = (String)sqlObject;
                DBRoute dbRoute = DBRoute.basedata;
                if (!StringUtils.isEmpty((CharSequence)dbRouteText)) {
                    dbRoute = DBRoute.of((String)dbRouteText);
                }
                columnList = new ArrayList<Column>(16);
                dataList = this.getData(dbRoute, sql, columnList, paramsObj);
                this.getFieldDisplayName(dataList, columnList, sql);
                String pageId = this.getView().getPageId();
                try {
                    this.getPageCache().putBigObject("columnlist_" + pageId, SerializationUtils.toJsonString(columnList));
                    this.getPageCache().putBigObject("datalist_" + pageId, SerializationUtils.toJsonString(dataList));
                }
                catch (KDException e) {
                    log.error("SQLResultGrid handleBusinessLogic error:", (Throwable)e);
                    if (null == e.getErrorCode() || !BosErrorCode.redisCacheOverMaxSize.getCode().equals(e.getErrorCode().getCode())) break block4;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8fc7\u591a\uff0c\u8bf7\u6dfb\u52a0\u6570\u636e\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"SQLResultGrid_1", (String)"bos-base-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            this.createGrid(this.getCoulumnList(columnList), TABLE_KEY_ENTRYENTITY);
            this.setGridData(this.getCoulumnList(columnList), dataList);
        }
    }

    private List<List<Object>> getFieldDisplayName(List<List<Object>> dataList, List<Column> columnList, String sql) {
        block5: {
            Object iSSelect;
            block4: {
                Object iSTableStructure = this.getView().getFormShowParameter().getCustomParams().get(IS_TABLE_STRUCTURE);
                Object tableNameObj = this.getView().getFormShowParameter().getCustomParams().get(TABLE_NAME);
                iSSelect = this.getView().getFormShowParameter().getCustomParams().get(IS_SELECT);
                if (iSTableStructure == null || tableNameObj == null) break block4;
                String tableName = (String)tableNameObj;
                ArrayList<String> tableNameList = new ArrayList<String>(1);
                tableNameList.add(tableName.toLowerCase(Locale.ENGLISH));
                Map<String, String> tableFieldDisplayNameMap = this.getFieldDisplayName(tableNameList);
                for (List<Object> objectList : dataList) {
                    boolean isDisplayName = false;
                    for (int i = 0; i < objectList.size(); ++i) {
                        String displayName;
                        String objName;
                        Object obj = objectList.get(i);
                        if (!(obj instanceof String) || i >= 4 || StringUtils.isBlank((CharSequence)(objName = (String)obj)) || isDisplayName || !StringUtils.isNotEmpty((CharSequence)(displayName = tableFieldDisplayNameMap.get(objName.toLowerCase(Locale.ENGLISH))))) continue;
                        objectList.set(this.getCommentIndex(columnList), displayName);
                        isDisplayName = true;
                    }
                }
                break block5;
            }
            if (iSSelect == null) break block5;
            List<String> tableNameList = this.getTableName(sql);
            Map<String, String> tableFieldDisplayNameMap = this.getFieldDisplayName(tableNameList);
            if (CollectionUtils.isEmpty(columnList)) {
                return dataList;
            }
            for (Column column : columnList) {
                String displayName;
                String name = column.getName();
                if (StringUtils.isBlank((CharSequence)name) || !StringUtils.isNotEmpty((CharSequence)(displayName = tableFieldDisplayNameMap.get(name.toLowerCase(Locale.ENGLISH))))) continue;
                name = name + "(" + displayName + ")";
                column.setName(name);
            }
        }
        return dataList;
    }

    private int getCommentIndex(List<Column> columnList) {
        if (CollectionUtils.isEmpty(columnList)) {
            return 8;
        }
        int index = 0;
        for (Column column : columnList) {
            if (StringUtils.isNotBlank((CharSequence)column.getName()) && column.getName().toLowerCase(Locale.ENGLISH).contains("comment")) {
                return index + 2;
            }
            ++index;
        }
        return 8;
    }

    private List<String> getTableName(String sql) {
        String[] names;
        ArrayList<String> tableNameList = new ArrayList<String>(4);
        if (StringUtils.isBlank((CharSequence)sql)) {
            return tableNameList;
        }
        for (String name : names = sql.split(" ")) {
            if (!name.toLowerCase(Locale.ENGLISH).startsWith("t_")) continue;
            name = name.replace(")", "");
            tableNameList.add(name.toLowerCase(Locale.ENGLISH));
        }
        return tableNameList;
    }

    private Map<String, String> getFieldDisplayName(List<String> tableNameList) {
        HashMap<String, String> fieldMap = new HashMap<String, String>(8);
        if (CollectionUtils.isEmpty(tableNameList)) {
            return fieldMap;
        }
        ArrayList numberList = new ArrayList(8);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid from t_meta_mainentityinfo where ", new Object[0]);
        sqlBuilder.appendIn("ftablename", tableNameList.toArray());
        DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sqlBuilder, resultSet -> {
            while (resultSet.next()) {
                numberList.add(resultSet.getString("fid"));
            }
            return null;
        });
        if (CollectionUtils.isEmpty(numberList)) {
            return fieldMap;
        }
        for (String number : numberList) {
            try {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)number);
                if (dt == null) continue;
                DataEntityPropertyCollection properties = dt.getProperties();
                for (IDataEntityProperty iDataEntityProperty : properties) {
                    if (iDataEntityProperty == null || StringUtils.isBlank((CharSequence)iDataEntityProperty.getName()) || StringUtils.isBlank((CharSequence)iDataEntityProperty.getAlias())) continue;
                    String displayName = "-";
                    if (iDataEntityProperty.getDisplayName() != null) {
                        displayName = iDataEntityProperty.getDisplayName().getLocaleValue_zh_CN();
                        Locale locale = RequestContext.get().getLang().getLocale();
                        String lang = locale.getLanguage() + "_" + locale.getCountry();
                        if ("en_US".equals(lang)) {
                            displayName = iDataEntityProperty.getDisplayName().getLocaleValue_en();
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)displayName)) {
                        displayName = "-";
                    }
                    if (StringUtils.isNotBlank((CharSequence)iDataEntityProperty.getName())) {
                        if (displayName.equals("-") && fieldMap.containsKey(iDataEntityProperty.getName().toLowerCase(Locale.ENGLISH))) continue;
                        fieldMap.put(iDataEntityProperty.getName().toLowerCase(Locale.ENGLISH), displayName);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)iDataEntityProperty.getAlias()) || displayName.equals("-") && fieldMap.containsKey(iDataEntityProperty.getAlias().toLowerCase(Locale.ENGLISH))) continue;
                    fieldMap.put(iDataEntityProperty.getAlias().toLowerCase(Locale.ENGLISH), displayName);
                }
            }
            catch (Exception e) {
                log.warn("\u8bfb\u53d6\u8868\u5b57\u6bb5\u5907\u6ce8\u5f02\u5e38: " + e.getMessage(), (Throwable)e);
            }
        }
        return fieldMap;
    }

    /*
     * Exception decompiling
     */
    private List<List<Object>> getData(DBRoute dbRoute, String sql, List<Column> columnList, Object paramsObj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private static List<List<Object>> getQueryResultList(List<Column> columnList, Map<String, String> tableColumnMap, ResultSet rs) throws SQLException {
        int i;
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        ResultSetMetaData meta = rs.getMetaData();
        int columnNumber = meta.getColumnCount();
        for (i = 1; i <= columnNumber; ++i) {
            Column column = new Column();
            column.setName(meta.getColumnName(i));
            column.setcType(meta.getColumnType(i));
            columnList.add(column);
        }
        i = 0;
        while (rs.next()) {
            ArrayList<Object> row = new ArrayList<Object>();
            int index = ++i;
            if (i > 1000) break;
            row.add(index);
            row.add(index);
            for (int n = 1; n <= columnNumber; ++n) {
                if (tableColumnMap.containsKey(meta.getColumnName(n).toLowerCase(Locale.ENGLISH))) {
                    row.add(SQL_SECRET);
                    continue;
                }
                row.add(rs.getObject(n) == null ? "" : rs.getObject(n).toString());
            }
            data.add(row);
        }
        return data;
    }

    private List<String> getCoulumnList(List<Column> columnList) {
        ArrayList<String> reutrnList = null;
        if (columnList != null) {
            reutrnList = new ArrayList<String>(10);
            for (Column column : columnList) {
                if (column.getName().indexOf(".") != -1) {
                    reutrnList.add(column.getName().replace(".", "\u00b7"));
                    continue;
                }
                reutrnList.add(column.getName());
            }
        }
        return reutrnList;
    }

    private void setGridData(List<String> colNames, List<List<Object>> rs) {
        HashMap<String, Object> data = new HashMap<String, Object>(10);
        data.put("dataindex", this.getDataIndex(colNames));
        data.put("rows", rs);
        data.put("datacount", rs.size());
        data.put("isSelectedAll", Boolean.FALSE);
        data.put("isSplitPage", Boolean.FALSE);
        data.put("pagerows", 50);
        data.put("pageindex", 1);
        int pageCount = this.getPageCount(50, rs.size());
        data.put("pagecount", pageCount);
        data.put("realPageCount", pageCount);
        data.put("rowcount", 50);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setEntryProperty(TABLE_KEY_ENTRYENTITY, "data", data);
    }

    private int getPageCount(int pageRow, int total) {
        int pageCount = 0;
        pageCount = total / pageRow;
        if (total / pageRow > pageCount) {
            ++pageCount;
        }
        if (pageCount < 0) {
            pageCount = 0;
        }
        return pageCount;
    }

    private Map<String, Integer> getDataIndex(List<String> colNames) {
        LinkedHashMap<String, Integer> dataIndex = new LinkedHashMap<String, Integer>(8);
        dataIndex.put("rk", 0);
        dataIndex.put(FSEQ_NAME, 1);
        for (int i = 0; i < colNames.size(); ++i) {
            String key = colNames.get(i);
            if (dataIndex.containsKey(key)) {
                key = key + "_" + i;
            }
            dataIndex.put(key, i + 2);
        }
        return dataIndex;
    }

    private void createGrid(List<String> colNames, String gridKey) {
        HashMap<String, Object> meta = new HashMap<String, Object>(8);
        meta.put("key", gridKey);
        meta.put("methodname", "createGridColumns");
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("rk", "rk");
        args.put("seq", FSEQ_NAME);
        args.put("columns", this.createColumns(colNames));
        meta.put("args", new Map[]{args});
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("InvokeControlMethod", meta);
    }

    public List<Map<String, Object>> createColumns(List<String> colNames) {
        LinkedHashMap<String, Integer> dataIndex = new LinkedHashMap<String, Integer>(8);
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(8);
        cols.add(SQLResultGrid.genRKColumn());
        cols.add(SQLResultGrid.genSeqColumn());
        for (int i = 0; i < colNames.size(); ++i) {
            String dataIndexKey = colNames.get(i);
            String viewKey = colNames.get(i);
            if (dataIndex.containsKey(dataIndexKey)) {
                dataIndexKey = dataIndexKey + "_" + i;
            }
            dataIndex.put(dataIndexKey, i + 2);
            cols.add(this.createColumn(dataIndexKey, viewKey));
        }
        return cols;
    }

    public static Map<String, Object> genSeqColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put(DATA_INDEX, FSEQ_NAME);
        map.put(HEADER, new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"SQLResultGrid_0", (String)"bos-base-formplugin", (Object[])new Object[0])));
        map.put("isColPageFixed", Boolean.TRUE);
        map.put("type", "numberfield");
        map.put("width", 100);
        return map;
    }

    public static Map<String, Object> genRKColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put(DATA_INDEX, "rk");
        map.put(HEADER, new LocaleString("rk"));
        map.put("visible", Boolean.FALSE);
        map.put("width", "50");
        return map;
    }

    public Map<String, Object> createColumn(String dataIndexKey, String viewKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("visible", true);
        map.put(DATA_INDEX, dataIndexKey);
        map.put(HEADER, new LocaleString(viewKey));
        return map;
    }

    private static /* synthetic */ List lambda$getData$2(List columnList, Map tableColumnMap, ResultSet rs) throws Exception {
        return SQLResultGrid.getQueryResultList(columnList, tableColumnMap, rs);
    }

    private static /* synthetic */ List lambda$getData$1(List columnList, Map tableColumnMap, ResultSet rs) throws Exception {
        return SQLResultGrid.getQueryResultList(columnList, tableColumnMap, rs);
    }
}

