/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.sql.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.sql.formplugin.Column;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SQLResultView
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(SQLResultView.class);
    private static final String FSEQ_NAME = "fseqName";
    private static final String TABLE_KEY_ENTRYENTITY = "entryentity";
    private static final int PAGE_ROW = 50;
    private static final String DATAINDEX = "dataIndex";
    private static final String HEADER = "header";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleBusinessLogic();
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void handleBusinessLogic() {
        block6: {
            Object tableNamesObject = this.getView().getFormShowParameter().getCustomParams().get("tableNames");
            Object colNamesObject = this.getView().getFormShowParameter().getCustomParams().get("colNames");
            if (tableNamesObject != null && colNamesObject != null) {
                List tableNames = (List)tableNamesObject;
                List colNames = (List)colNamesObject;
                ArrayList<List<Object>> rs = new ArrayList<List<Object>>(8);
                int indexNum = 0;
                for (List objects : tableNames) {
                    ArrayList<Integer> names = new ArrayList<Integer>(8);
                    names.add(indexNum);
                    names.add(indexNum);
                    for (Object object : objects) {
                        names.add((Integer)object);
                    }
                    rs.add((List<Object>)names);
                    ++indexNum;
                }
                this.createGrid(colNames, TABLE_KEY_ENTRYENTITY);
                this.setGridData(colNames, rs);
                String pageId = this.getView().getPageId();
                ArrayList<Column> columnList = new ArrayList<Column>(16);
                for (String colName : colNames) {
                    Column column = new Column();
                    column.setName(colName);
                    columnList.add(column);
                }
                try {
                    this.getPageCache().putBigObject("columnlist_" + pageId, SerializationUtils.toJsonString(columnList));
                    this.getPageCache().putBigObject("datalist_" + pageId, SerializationUtils.toJsonString(rs));
                }
                catch (KDException e) {
                    log.error("SQLResultView handleBusinessLogic error:", (Throwable)e);
                    if (null == e.getErrorCode() || !BosErrorCode.redisCacheOverMaxSize.getCode().equals(e.getErrorCode().getCode())) break block6;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8fc7\u591a\uff0c\u8bf7\u6dfb\u52a0\u6570\u636e\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"SQLResultView_0", (String)"bos-base-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }

    private void setGridData(List<String> colNames, List<List<Object>> rs) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("dataindex", this.getDataIndex(colNames));
        data.put("rows", rs);
        data.put("datacount", rs.size());
        data.put("isSelectedAll", Boolean.FALSE);
        data.put("isSplitPage", Boolean.FALSE);
        data.put("pagerows", 50);
        data.put("pageindex", 1);
        int pageCount = this.getPageCount(50, rs.size());
        data.put("pagecount", pageCount);
        data.put("realPageCount", pageCount);
        data.put("rowcount", 50);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setEntryProperty(TABLE_KEY_ENTRYENTITY, "data", data);
    }

    private int getPageCount(int pageRow, int total) {
        int pageCount = 0;
        pageCount = total / pageRow;
        if (total / pageRow > pageCount) {
            ++pageCount;
        }
        if (pageCount < 0) {
            pageCount = 0;
        }
        return pageCount;
    }

    private Map<String, Integer> getDataIndex(List<String> colNames) {
        LinkedHashMap<String, Integer> dataIndex = new LinkedHashMap<String, Integer>(16);
        dataIndex.put("rk", 0);
        dataIndex.put(FSEQ_NAME, 1);
        for (int i = 0; i < colNames.size(); ++i) {
            String key = colNames.get(i);
            if (dataIndex.containsKey(key)) {
                key = key + "_" + i;
            }
            dataIndex.put(key, i + 2);
        }
        return dataIndex;
    }

    private void createGrid(List<String> colNames, String gridKey) {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("key", gridKey);
        meta.put("methodname", "createGridColumns");
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("rk", "rk");
        args.put("seq", FSEQ_NAME);
        args.put("columns", this.createColumns(colNames));
        meta.put("args", new Map[]{args});
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("InvokeControlMethod", meta);
    }

    private List<Map<String, Object>> createColumns(List<String> colNames) {
        LinkedHashMap<String, Integer> dataIndex = new LinkedHashMap<String, Integer>(16);
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(10);
        cols.add(this.genRKColumn());
        cols.add(this.genSeqColumn());
        for (int i = 0; i < colNames.size(); ++i) {
            String dataIndexKey = colNames.get(i);
            String viewKey = colNames.get(i);
            if (dataIndex.containsKey(dataIndexKey)) {
                dataIndexKey = dataIndexKey + "_" + i;
            }
            dataIndex.put(dataIndexKey, i + 2);
            cols.add(this.createColumn(dataIndexKey, viewKey));
        }
        return cols;
    }

    private Map<String, Object> genSeqColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put(DATAINDEX, FSEQ_NAME);
        map.put(HEADER, new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"SQLResultGrid_0", (String)"bos-base-formplugin", (Object[])new Object[0])));
        map.put("isColPageFixed", Boolean.TRUE);
        map.put("type", "numberfield");
        map.put("width", 100);
        return map;
    }

    private Map<String, Object> genRKColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put(DATAINDEX, "rk");
        map.put(HEADER, new LocaleString("rk"));
        map.put("visible", Boolean.FALSE);
        map.put("width", "50");
        return map;
    }

    private Map<String, Object> createColumn(String dataIndexKey, String viewKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("visible", true);
        map.put(DATAINDEX, dataIndexKey);
        map.put(HEADER, new LocaleString(viewKey));
        return map;
    }
}

