/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPools;

public abstract class AbstractBaseDataClearTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(AbstractBaseDataClearTask.class);
    protected static final String STORAGE_DAYS_KEY = "storageDays";
    protected static final int STORAGE_DAYS_DEFAULT = 30;
    protected static final int BATCH_COUNT = 1000;
    private int storageDays;
    private List<BaseDataClearParam> baseDataClearParamList = new ArrayList<BaseDataClearParam>();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("\u3010\u57fa\u7840\u6570\u636e\u6e05\u7406\u4efb\u52a1\u3011\u81ea\u5b9a\u4e49\u53c2\u6570\uff1a" + map);
        Object storageDaysParam = map.get(STORAGE_DAYS_KEY);
        if (StringUtils.isNotBlank((Object)storageDaysParam)) {
            this.storageDays = Integer.parseInt(storageDaysParam.toString());
        }
        if (this.storageDays <= 0) {
            this.storageDays = 30;
        }
        this.addBaseDataClearParam(this.baseDataClearParamList);
        if (CollectionUtils.isEmpty(this.baseDataClearParamList)) {
            logger.warn("\u3010\u57fa\u7840\u6570\u636e\u6e05\u7406\u4efb\u52a1\u3011\u6e05\u7406\u57fa\u7840\u8d44\u6599\u6570\u636e\u5931\u8d25\uff1a\u57fa\u7840\u8d44\u6599\u6e05\u7406\u5bf9\u8c61\u7684\u53c2\u6570\u4e3a\u7a7a\u3002");
            return;
        }
        for (BaseDataClearParam param : this.baseDataClearParamList) {
            if (param == null) {
                logger.warn("\u3010\u57fa\u7840\u6570\u636e\u6e05\u7406\u4efb\u52a1\u3011\u6e05\u7406\u57fa\u7840\u8d44\u6599\u6570\u636e\u5931\u8d25\uff1a\u57fa\u7840\u8d44\u6599\u6e05\u7406\u5bf9\u8c61\u4e3a\u7a7a\u3002");
                continue;
            }
            ThreadPools.executeOnce((String)("AbstractBaseDataClearTask" + param.getEntityName()), () -> this.clear(param));
        }
    }

    private void clear(BaseDataClearParam param) {
        String entityName = param.getEntityName();
        if (StringUtils.isBlank((CharSequence)entityName)) {
            logger.warn("\u3010\u57fa\u7840\u6570\u636e\u6e05\u7406\u4efb\u52a1\u3011\u6e05\u7406\u57fa\u7840\u8d44\u6599\u6570\u636e\u5931\u8d25\uff1a\u5b9e\u4f53\u6807\u8bc6\u7684\u53c2\u6570\u201centityName\u201d\u4e3a\u7a7a\u3002");
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (dataEntityType == null) {
            logger.warn(String.format("\u3010\u57fa\u7840\u6570\u636e\u6e05\u7406\u4efb\u52a1\u3011\u6e05\u7406\u57fa\u7840\u8d44\u6599\u6570\u636e\u5931\u8d25\uff1a\u5b9e\u4f53\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", entityName));
            return;
        }
        String pkPropertyName = param.getPkPropertyName();
        if (StringUtils.isBlank((CharSequence)pkPropertyName)) {
            pkPropertyName = "id";
        }
        if (dataEntityType.getProperty(pkPropertyName) == null) {
            logger.warn("\u3010\u57fa\u7840\u6570\u636e\u6e05\u7406\u4efb\u52a1\u3011\u6e05\u7406\u57fa\u7840\u8d44\u6599\u6570\u636e\u5931\u8d25\uff1a\u4e3b\u952e\u5c5e\u6027\u540d\u7684\u53c2\u6570\u201cdatePropertyName\u201d\u4e0d\u5b58\u5728\u3002");
            return;
        }
        String datePropertyName = param.getDatePropertyName();
        if (StringUtils.isBlank((CharSequence)datePropertyName) && dataEntityType.getProperty("createtime") != null) {
            datePropertyName = "createtime";
        }
        if (StringUtils.isBlank((CharSequence)datePropertyName)) {
            logger.warn("\u3010\u57fa\u7840\u6570\u636e\u6e05\u7406\u4efb\u52a1\u3011\u6e05\u7406\u57fa\u7840\u8d44\u6599\u6570\u636e\u5931\u8d25\uff1a\u65e5\u671f\u5c5e\u6027\u540d\u7684\u53c2\u6570\u201cdatePropertyName\u201d\u4e3a\u7a7a\u3002");
            return;
        }
        if (dataEntityType.getProperty(datePropertyName) == null) {
            logger.warn("\u3010\u57fa\u7840\u6570\u636e\u6e05\u7406\u4efb\u52a1\u3011\u6e05\u7406\u57fa\u7840\u8d44\u6599\u6570\u636e\u5931\u8d25\uff1a\u65e5\u671f\u5c5e\u6027\u540d\u7684\u53c2\u6570\u201cdatePropertyName\u201d\u4e0d\u5b58\u5728\u3002");
            return;
        }
        int count = 0;
        QFilter storageDayFilter = new QFilter(datePropertyName, "<", (Object)Utils.getDate((int)(-this.storageDays)));
        QFilter[] filters = new QFilter[]{storageDayFilter};
        while (true) {
            DataSet ds = QueryServiceHelper.queryDataSet((String)("AbstractBaseDataClearTask" + entityName), (String)entityName, (String)pkPropertyName, (QFilter[])filters, (String)"", (int)1000);
            Throwable throwable = null;
            try {
                if (!ds.hasNext()) break;
                ArrayList<Object> deleteIds = new ArrayList<Object>(1000);
                for (Row row : ds) {
                    deleteIds.add(row.get(pkPropertyName));
                }
                int currentCount = deleteIds.size();
                DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])deleteIds.toArray(new Object[currentCount]));
                count += currentCount;
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
                continue;
            }
            break;
        }
        logger.info(dataEntityType.getName() + "\u3010\u57fa\u7840\u6570\u636e\u6e05\u7406\u4efb\u52a1\u3011\u57fa\u7840\u8d44\u6599\u6570\u636e\u6e05\u7406\u6570\u91cf\uff1a" + count);
    }

    protected abstract void addBaseDataClearParam(List<BaseDataClearParam> var1);

    protected static class BaseDataClearParam {
        private String entityName;
        private String pkPropertyName = "id";
        private String datePropertyName = "createtime";

        public BaseDataClearParam(String entityName) {
            this.entityName = entityName;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public String getPkPropertyName() {
            return this.pkPropertyName;
        }

        public void setPkPropertyName(String pkPropertyName) {
            this.pkPropertyName = pkPropertyName;
        }

        public String getDatePropertyName() {
            return this.datePropertyName;
        }

        public void setDatePropertyName(String datePropertyName) {
            this.datePropertyName = datePropertyName;
        }
    }
}

