/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.log.consumer;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.model.ExtHandleMsg;
import kd.bos.bd.log.model.User;
import kd.bos.bd.log.service.BDLogSaveService;
import kd.bos.bd.log.service.UserService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;

public class BDLogConsumer
implements MessageConsumer {
    private static Log logger = LogFactory.getLog(BDLogConsumer.class);

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        BDLogInfo bdLogInfo = null;
        if (!(body instanceof BDLogInfo)) {
            logger.error("BDLogConsumer.onMessage, \u4f20\u5165\u53c2\u6570\u7c7b\u578b\u4e0d\u662f\u65e5\u5fd7\u4fe1\u606f!");
            acker.discard(messageId);
            return;
        }
        bdLogInfo = (BDLogInfo)body;
        String logType = bdLogInfo.getLogType();
        EnumBDLogType anEnum = EnumBDLogType.getEnum(logType);
        if (EnumBDLogType.UNKNOW == anEnum) {
            logger.error("BDLogConsumer.onMessage, \u65e5\u5fd7\u7c7b\u578b\u4e0d\u5b58\u5728\u6216\u975e\u6cd5!");
            acker.discard(messageId);
            return;
        }
        String logTypeDesc = anEnum.getDescri();
        List list = bdLogInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            logger.error("BDLogConsumer.onMessage, [{}], \u65e5\u5fd7\u8bb0\u5f55\u4e3a\u7a7a!", (Object)logTypeDesc);
            acker.discard(messageId);
            return;
        }
        boolean needExt = bdLogInfo.isNeedExt();
        try {
            DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)logType);
            if (null == logObj) {
                logger.error("BDLogConsumer.onMessage, [{}], \u8868\u5355:{} \u4e0d\u5b58\u5728", (Object)logTypeDesc, (Object)logType);
                acker.discard(messageId);
                return;
            }
        }
        catch (Exception e) {
            logger.error("BDLogConsumer.onMessage, [{}], \u8868\u5355:{} \u5143\u6570\u636e\u4e0d\u5b58\u5728", new Object[]{logTypeDesc, logType, e});
            acker.discard(messageId);
            return;
        }
        try {
            this.fulLogInfo(list);
            boolean ack = BDLogSaveService.saveToDB(new ExtHandleMsg(needExt, logType, list.size()), list);
            if (ack) {
                acker.ack(messageId);
                return;
            }
            acker.discard(messageId);
            return;
        }
        catch (Exception e) {
            logger.error("BDLogConsumer.onMessage, [{}], \u6d88\u606f\u65e5\u5fd7\u5199\u5165 DB \u5f02\u5e38!", (Object)logTypeDesc, (Object)e);
            acker.discard(messageId);
            return;
        }
    }

    private void fulLogInfo(List<Map<String, Object>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<String, Object> map = list.get(0);
        String cloudId = (String)map.get("cloud_id");
        String cloudName = this.getCloudName(cloudId);
        String appId = (String)map.get("app_id");
        String appName = this.getAppName(appId);
        String formIdentity = (String)map.get("form_identity");
        String formName = this.getFormName(formIdentity);
        Long userId = (Long)map.get("oper_id");
        User User2 = this.getUser(userId);
        Long orgId = (Long)map.get("oper_org_id");
        String orgName = this.getOrgName(orgId);
        list.stream().forEach(x -> {
            x.put("cloud_name", cloudName);
            x.put("app_name", appName);
            x.put("form_name", formName);
            x.put("oper_name", User2.getFtruename());
            x.put("oper_number", User2.getFnumber());
            x.put("oper_username", User2.getFusername());
            x.put("oper_org_name", orgName);
            x.put("create_time", TimeServiceHelper.now());
            x.put("modify_time", TimeServiceHelper.now());
        });
    }

    private String getCloudName(String cloudId) {
        try {
            if (StringUtils.isEmpty((String)cloudId)) {
                return ResManager.loadKDString((String)"\u7a7a\u670d\u52a1\u4e91", (String)"EMPTY_CLOUD", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
            }
            DynamicObject app = BusinessDataServiceHelper.loadSingleFromCache((Object)cloudId, (String)"bos_devportal_bizcloud", (String)"id,name");
            if (null == app) {
                return ResManager.loadKDString((String)"\u670d\u52a1\u4e91\u540d\u4e0d\u5b58\u5728", (String)"CLOUD_NAME_NOTEXIST", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
            }
            return app.getLocaleString("name").getLocaleValue();
        }
        catch (Exception e) {
            logger.error("BDLogConsumer.getCloudName, \u83b7\u53d6\u5e94\u7528\u540d \u5f02\u5e38!", (Throwable)e);
            return "";
        }
    }

    private String getAppName(String appId) {
        try {
            if (StringUtils.isEmpty((String)appId)) {
                return ResManager.loadKDString((String)"\u7a7a\u5e94\u7528", (String)"EMPTY_APP", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
            }
            DynamicObject app = BusinessDataServiceHelper.loadSingleFromCache((Object)appId, (String)"bos_devportal_bizapp", (String)"id,name");
            if (null == app) {
                return ResManager.loadKDString((String)"\u5e94\u7528\u540d\u4e0d\u5b58\u5728", (String)"APP_NAME_NOTEXIST", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
            }
            return app.getLocaleString("name").getLocaleValue();
        }
        catch (Exception e) {
            logger.error("BDLogConsumer.getAppName, \u83b7\u53d6\u5e94\u7528\u540d \u5f02\u5e38!", (Throwable)e);
            return "";
        }
    }

    private String getFormName(String formIdentity) {
        try {
            if (StringUtils.isEmpty((String)formIdentity)) {
                return ResManager.loadKDString((String)"\u7a7a\u8868\u5355", (String)"EMPTY_FORM", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
            }
            DynamicObject app = BusinessDataServiceHelper.loadSingleFromCache((Object)formIdentity, (String)"bos_objecttype", (String)"id,name");
            if (null == app) {
                return ResManager.loadKDString((String)"\u8868\u5355\u540d\u4e0d\u5b58\u5728", (String)"FORM_NAME_NOTEXIST", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
            }
            return app.getLocaleString("name").getLocaleValue();
        }
        catch (Exception e) {
            logger.error("BDLogConsumer.getFormName, \u83b7\u53d6\u8868\u5355\u540d \u5f02\u5e38!", (Throwable)e);
            return "";
        }
    }

    private User getUser(Long userId) {
        User User2 = null;
        try {
            if (0L != userId) {
                List<User> UserList = UserService.getUserInfoByIds(Collections.singletonList(String.valueOf(userId)));
                if (CollectionUtils.isEmpty(UserList)) {
                    String ftruename = ResManager.loadKDString((String)"\u7a7a\u7528\u6237", (String)"EMPTY_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
                    String fnumber = ResManager.loadKDString((String)"\u7a7a\u7528\u6237", (String)"EMPTY_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
                    String fphone = ResManager.loadKDString((String)"\u7a7a\u7528\u6237", (String)"EMPTY_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
                    String femail = ResManager.loadKDString((String)"\u7a7a\u7528\u6237", (String)"EMPTY_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
                    String fusername = ResManager.loadKDString((String)"\u7a7a\u7528\u6237", (String)"EMPTY_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
                    User2 = new User(userId, ftruename, fnumber, fphone, femail, fusername);
                    return User2;
                }
                return UserList.get(0);
            }
            if (0L == userId) {
                String ftruename = ResManager.loadKDString((String)"\u672a\u77e5\u7528\u6237", (String)"UNKNOW_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
                String fnumber = ResManager.loadKDString((String)"\u672a\u77e5\u7528\u6237", (String)"UNKNOW_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
                String fphone = ResManager.loadKDString((String)"\u672a\u77e5\u7528\u6237", (String)"UNKNOW_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
                String femail = ResManager.loadKDString((String)"\u672a\u77e5\u7528\u6237", (String)"UNKNOW_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
                String fusername = ResManager.loadKDString((String)"\u672a\u77e5\u7528\u6237", (String)"UNKNOW_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
                User2 = new User(userId, ftruename, fnumber, fphone, femail, fusername);
                return User2;
            }
            if (-1L == userId) {
                String ftruename = ResManager.loadKDString((String)"\u533f\u540d\u7528\u6237", (String)"ANONYMOUS_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
                String fnumber = ResManager.loadKDString((String)"\u533f\u540d\u7528\u6237", (String)"ANONYMOUS_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
                String fphone = ResManager.loadKDString((String)"\u533f\u540d\u7528\u6237", (String)"ANONYMOUS_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
                String femail = ResManager.loadKDString((String)"\u533f\u540d\u7528\u6237", (String)"ANONYMOUS_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
                String fusername = ResManager.loadKDString((String)"\u533f\u540d\u7528\u6237", (String)"ANONYMOUS_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
                User2 = new User(userId, ftruename, fnumber, fphone, femail, fusername);
                return User2;
            }
            String ftruename = ResManager.loadKDString((String)"\u7a7a\u7528\u6237", (String)"EMPTY_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
            String fnumber = ResManager.loadKDString((String)"\u7a7a\u7528\u6237", (String)"EMPTY_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
            String fphone = ResManager.loadKDString((String)"\u7a7a\u7528\u6237", (String)"EMPTY_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
            String femail = ResManager.loadKDString((String)"\u7a7a\u7528\u6237", (String)"EMPTY_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
            String fusername = ResManager.loadKDString((String)"\u7a7a\u7528\u6237", (String)"EMPTY_USER", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
            User2 = new User(userId, ftruename, fnumber, fphone, femail, fusername);
            return User2;
        }
        catch (Exception e) {
            logger.error("BDLogConsumer.getUser, \u83b7\u53d6\u7528\u6237 \u5f02\u5e38!", (Throwable)e);
            return User2;
        }
    }

    private String getOrgName(Long orgId) {
        try {
            if (0L != orgId) {
                DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"id,name");
                if (null == org) {
                    return ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u4e0d\u5b58\u5728", (String)"ORG_NAME_NOTEXIST", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
                }
                return org.getLocaleString("name").getLocaleValue();
            }
            if (0L == orgId) {
                return ResManager.loadKDString((String)"\u672a\u77e5\u7ec4\u7ec7", (String)"UNKNOW_ORG", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
            }
            if (-1L == orgId) {
                return ResManager.loadKDString((String)"\u533f\u540d\u7ec4\u7ec7", (String)"ANONYMOUS_ORG", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u7a7a\u7ec4\u7ec7", (String)"EMPTY_ORG", (String)"bos-mservice-bdlog", (Object[])new Object[0]);
        }
        catch (Exception e) {
            logger.error("BDLogConsumer.getOrgName, \u83b7\u53d6\u7ec4\u7ec7\u540d \u5f02\u5e38!", (Throwable)e);
            return "";
        }
    }
}

