/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.log.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.rabbitmq.BDConnection;
import kd.bos.bd.log.rabbitmq.BDPublisherCallbackChannel;
import kd.bos.bd.log.rabbitmq.BDRabbitmqUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.rabbit.ChannelFactory;
import kd.bos.rabbitmq.RabbitmqFactory;
import kd.bos.threads.ThreadPools;

@Deprecated
public class BDCachingConnectionFactory {
    private static final Log logger = LogFactory.getLog(BDCachingConnectionFactory.class);
    private final LinkedList<BDPublisherCallbackChannel> cachedChannels = new LinkedList();
    private final Object connectionMonitor = new Object();
    private volatile ExecutorService channelsExecutor;
    private int channelCacheSize = 10;
    private static final BDCachingConnectionFactory instance = new BDCachingConnectionFactory();

    private BDCachingConnectionFactory() {
    }

    public static BDCachingConnectionFactory getInstance() {
        return instance;
    }

    public BDConnection createConnection() {
        return new BDChannelCachingConnection(RabbitmqFactory.getConnection((String)ChannelFactory.getRegionServerKey((String)EnumBDLogType.BD.getRegion())));
    }

    public BDPublisherCallbackChannel getChannel(BDChannelCachingConnection connection) throws IOException {
        BDPublisherCallbackChannel channel = null;
        if (connection.isOpen()) {
            channel = this.findOpenChannel(this.cachedChannels);
            logger.info(Thread.currentThread().getName() + ":\u83b7\u53d6\u7f13\u5b58\u4e2d\u7684channel");
        }
        if (channel == null) {
            channel = new BDPublisherCallbackChannel(connection.getDelegate().createChannel(), this.getChannelsExecutor());
            this.cachedChannels.addLast(channel);
            logger.info(Thread.currentThread().getName() + ":\u521b\u5efa\u65b0\u7684channel");
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecutorService getChannelsExecutor() {
        if (this.channelsExecutor == null) {
            Object object = this.connectionMonitor;
            synchronized (object) {
                if (this.channelsExecutor == null) {
                    this.channelsExecutor = ThreadPools.newCachedExecutorService((String)EnumBDLogType.BD.getPoolName());
                }
            }
        }
        return this.channelsExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BDPublisherCallbackChannel findOpenChannel(LinkedList<BDPublisherCallbackChannel> channelList) {
        BDPublisherCallbackChannel channel = null;
        LinkedList<BDPublisherCallbackChannel> linkedList = channelList;
        synchronized (linkedList) {
            while (!channelList.isEmpty() && !(channel = channelList.removeFirst()).isOpen()) {
                this.cleanUpClosedChannel(channel);
                channel = null;
            }
            return channel;
        }
    }

    private void cleanUpClosedChannel(BDPublisherCallbackChannel channel) {
        try {
            Channel target = channel.getTargetChannel();
            if (target != null) {
                target.close();
            }
        }
        catch (Exception e) {
            logger.info("BDCachingConnectionFactory.cleanUpClosedChannel error", (Object)e.getMessage());
        }
    }

    public void closeChannel(BDPublisherCallbackChannel channel) throws IOException, TimeoutException {
        if (!BDRabbitmqUtils.isPhysicalCloseRequired()) {
            this.logicalClose(channel);
        } else {
            this.physicalClose(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logicalClose(BDPublisherCallbackChannel channel) throws IOException, TimeoutException {
        if (channel != null) {
            if (channel.getTargetChannel() != null && !channel.getTargetChannel().isOpen()) {
                Object object = channel.getTargetMonitor();
                synchronized (object) {
                    channel.getTargetChannel().close();
                    if (this.cachedChannels.contains(channel)) {
                        this.cachedChannels.remove(channel);
                    }
                }
            }
            this.returnToCache(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnToCache(BDPublisherCallbackChannel channel) {
        if (channel != null) {
            LinkedList<BDPublisherCallbackChannel> linkedList = this.cachedChannels;
            synchronized (linkedList) {
                boolean alreadyCached = this.cachedChannels.contains(channel);
                if (this.cachedChannels.size() >= this.channelCacheSize && !alreadyCached) {
                    this.physicalClose(channel);
                } else if (!alreadyCached) {
                    this.cachedChannels.addLast(channel);
                }
            }
        }
    }

    private void physicalClose(BDPublisherCallbackChannel channel) {
        if (channel != null && channel.getTargetChannel() != null) {
            try {
                channel.getTargetChannel().close();
            }
            catch (Exception e) {
                logger.info("BDCachingConnectionFactory.physicalClose error", (Object)e.getMessage());
            }
        }
    }

    private class BDChannelCachingConnection
    implements BDConnection {
        private volatile Connection target;

        public BDChannelCachingConnection(Connection target) {
            this.target = target;
        }

        @Override
        public BDPublisherCallbackChannel createChannel() throws IOException {
            return BDCachingConnectionFactory.this.getChannel(this);
        }

        @Override
        public void close() {
            if (this.target != null) {
                try {
                    this.target.close();
                }
                catch (Exception e) {
                    logger.info("BDPublisherCallbackChannel.close error", (Object)e.getMessage());
                }
            }
        }

        @Override
        public boolean isOpen() {
            return this.target != null && this.target.isOpen();
        }

        @Override
        public Connection getDelegate() {
            return this.target;
        }
    }
}

