/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.log.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.rabbitmq.ExtConnection;
import kd.bos.bd.log.rabbitmq.ExtPublisherCallbackChannel;
import kd.bos.bd.log.rabbitmq.ExtRabbitmqUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.rabbit.ChannelFactory;
import kd.bos.rabbitmq.RabbitmqFactory;
import kd.bos.threads.ThreadPools;

@Deprecated
public class ExtCachingConnectionFactory {
    private static final Log logger = LogFactory.getLog(ExtCachingConnectionFactory.class);
    private final LinkedList<ExtPublisherCallbackChannel> cachedChannels = new LinkedList();
    private final Object connectionMonitor = new Object();
    private volatile ExecutorService channelsExecutor;
    private int channelCacheSize = 10;
    private static final ExtCachingConnectionFactory instance = new ExtCachingConnectionFactory();

    private ExtCachingConnectionFactory() {
    }

    public static ExtCachingConnectionFactory getInstance() {
        return instance;
    }

    public ExtConnection createConnection(String logType) {
        EnumBDLogType anEnum = EnumBDLogType.getEnum(logType);
        return new ExtChannelCachingConnection(RabbitmqFactory.getConnection((String)ChannelFactory.getRegionServerKey((String)anEnum.getRegion())));
    }

    public ExtPublisherCallbackChannel getChannel(ExtChannelCachingConnection connection, String logType) throws IOException {
        ExtPublisherCallbackChannel channel = null;
        if (connection.isOpen()) {
            channel = this.findOpenChannel(this.cachedChannels);
            logger.info(Thread.currentThread().getName() + ":\u83b7\u53d6\u7f13\u5b58\u4e2d\u7684channel");
        }
        if (channel == null) {
            channel = new ExtPublisherCallbackChannel(connection.getDelegate().createChannel(), this.getChannelsExecutor(logType));
            this.cachedChannels.addLast(channel);
            logger.info(Thread.currentThread().getName() + ":\u521b\u5efa\u65b0\u7684channel");
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecutorService getChannelsExecutor(String logType) {
        if (this.channelsExecutor == null) {
            Object object = this.connectionMonitor;
            synchronized (object) {
                if (this.channelsExecutor == null) {
                    this.channelsExecutor = ThreadPools.newCachedExecutorService((String)EnumBDLogType.getPoolNameByType(logType));
                }
            }
        }
        return this.channelsExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtPublisherCallbackChannel findOpenChannel(LinkedList<ExtPublisherCallbackChannel> channelList) {
        ExtPublisherCallbackChannel channel = null;
        LinkedList<ExtPublisherCallbackChannel> linkedList = channelList;
        synchronized (linkedList) {
            while (!channelList.isEmpty() && !(channel = channelList.removeFirst()).isOpen()) {
                this.cleanUpClosedChannel(channel);
                channel = null;
            }
            return channel;
        }
    }

    private void cleanUpClosedChannel(ExtPublisherCallbackChannel channel) {
        try {
            Channel target = channel.getTargetChannel();
            if (target != null) {
                target.close();
            }
        }
        catch (Exception e) {
            logger.info("ExtCachingConnectionFactory.cleanUpClosedChannel error", (Object)e.getMessage());
        }
    }

    public void closeChannel(ExtPublisherCallbackChannel channel) throws IOException, TimeoutException {
        if (!ExtRabbitmqUtils.isPhysicalCloseRequired()) {
            this.logicalClose(channel);
        } else {
            this.physicalClose(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logicalClose(ExtPublisherCallbackChannel channel) throws IOException, TimeoutException {
        if (channel != null) {
            if (channel.getTargetChannel() != null && !channel.getTargetChannel().isOpen()) {
                Object object = channel.getTargetMonitor();
                synchronized (object) {
                    channel.getTargetChannel().close();
                    if (this.cachedChannels.contains(channel)) {
                        this.cachedChannels.remove(channel);
                    }
                }
            }
            this.returnToCache(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnToCache(ExtPublisherCallbackChannel channel) {
        if (channel != null) {
            LinkedList<ExtPublisherCallbackChannel> linkedList = this.cachedChannels;
            synchronized (linkedList) {
                boolean alreadyCached = this.cachedChannels.contains(channel);
                if (this.cachedChannels.size() >= this.channelCacheSize && !alreadyCached) {
                    this.physicalClose(channel);
                } else if (!alreadyCached) {
                    this.cachedChannels.addLast(channel);
                }
            }
        }
    }

    private void physicalClose(ExtPublisherCallbackChannel channel) {
        if (channel != null && channel.getTargetChannel() != null) {
            try {
                channel.getTargetChannel().close();
            }
            catch (Exception e) {
                logger.info("ExtCachingConnectionFactory.physicalClose error", (Object)e.getMessage());
            }
        }
    }

    private class ExtChannelCachingConnection
    implements ExtConnection {
        private volatile Connection target;

        public ExtChannelCachingConnection(Connection target) {
            this.target = target;
        }

        @Override
        public ExtPublisherCallbackChannel createChannel(String logType) throws IOException {
            return ExtCachingConnectionFactory.this.getChannel(this, logType);
        }

        @Override
        public void close() {
            if (this.target != null) {
                try {
                    this.target.close();
                }
                catch (Exception e) {
                    logger.info("ExtCachingConnectionFactory.ExtChannelCachingConnection.close error", (Object)e.getMessage());
                }
            }
        }

        @Override
        public boolean isOpen() {
            return this.target != null && this.target.isOpen();
        }

        @Override
        public Connection getDelegate() {
            return this.target;
        }
    }
}

