/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.log.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BasicProperties;
import java.io.IOException;
import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeoutException;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.helper.ConstantsHelper;
import kd.bos.bd.log.rabbitmq.ExtCachingConnectionFactory;
import kd.bos.bd.log.rabbitmq.ExtConnection;
import kd.bos.bd.log.rabbitmq.ExtPublisherCallbackChannel;
import kd.bos.bd.log.rabbitmq.ExtRabbitmqUtils;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageSerde;
import kd.bos.mq.support.QueueManager;
import kd.bos.trace.util.TraceIdUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.RandomUtils;

@Deprecated
public class ExtMQPublishService
implements ExtPublisherCallbackChannel.Listener {
    private static final Log logger = LogFactory.getLog(ExtMQPublishService.class);
    private static final ExtMQPublishService instance = new ExtMQPublishService();
    private final SortedMap<Long, Message> confirmMap = new ConcurrentSkipListMap<Long, Message>();
    private static final ExtCachingConnectionFactory connectionFactory = ExtCachingConnectionFactory.getInstance();

    private ExtMQPublishService() {
    }

    public static ExtMQPublishService getInstance() {
        return instance;
    }

    private void addListener(ExtPublisherCallbackChannel channel) throws IOException {
        channel.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Object message, String logType) throws IOException {
        ExtPublisherCallbackChannel channel = null;
        try {
            ExtConnection connection = connectionFactory.createConnection(logType);
            channel = connection.createChannel(logType);
            this.addListener(channel);
            AMQP.BasicProperties properties = new AMQP.BasicProperties.Builder().deliveryMode(Integer.valueOf(2)).contentEncoding("UTF-8").build();
            long seq = channel.getNextPublishSeqNo();
            Message msg = this.toMessage(message);
            byte[] bytes = MessageSerde.get().encode(msg);
            this.confirmMap.put(seq, msg);
            EnumBDLogType enumBDLogType = EnumBDLogType.getEnum(logType);
            String QUEUE_NAME = QueueManager.getRealQueueName((String)enumBDLogType.getRegion(), (String)enumBDLogType.getQueueName());
            channel.basicPublish("", QUEUE_NAME, true, properties, bytes);
        }
        catch (Throwable throwable) {
            ExtRabbitmqUtils.closeChannel(channel);
            throw throwable;
        }
        ExtRabbitmqUtils.closeChannel(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendForResult(Object message, String logType) throws IOException, TimeoutException, InterruptedException {
        boolean bl;
        ExtPublisherCallbackChannel channel = null;
        try {
            ExtConnection connection = connectionFactory.createConnection(logType);
            channel = connection.createChannel(logType);
            channel.confirmSelect();
            AMQP.BasicProperties properties = new AMQP.BasicProperties.Builder().deliveryMode(Integer.valueOf(2)).contentEncoding("UTF-8").build();
            Message msg = this.toMessage(message);
            byte[] bytes = MessageSerde.get().encode(msg);
            EnumBDLogType enumBDLogType = EnumBDLogType.getEnum(logType);
            String QUEUE_NAME = QueueManager.getRealQueueName((String)enumBDLogType.getRegion(), (String)enumBDLogType.getQueueName());
            channel.basicPublish("", QUEUE_NAME, true, properties, bytes);
            bl = channel.waitForConfirms();
        }
        catch (Throwable throwable) {
            ExtRabbitmqUtils.closeChannel(channel);
            throw throwable;
        }
        ExtRabbitmqUtils.closeChannel(channel);
        return bl;
    }

    private Message toMessage(Object body) {
        Message message = new Message();
        message.setBody(body);
        message.setInnerId(RandomUtils.nextLong());
        message.setMessageTime();
        message.setConsumeSynchronizeTag(null);
        RequestContext rc = RequestContextCreator.createForMQ();
        if (rc.getAccountId() == null || rc.getTenantId() == null) {
            try {
                List logInfoList = JSON.parseArray((String)JSON.toJSONString((Object)body), BDLogInfo.class);
                if (CollectionUtils.isNotEmpty((Collection)logInfoList)) {
                    BDLogInfo logInfo = (BDLogInfo)logInfoList.get(0);
                    rc = RequestContext.get();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        message.setRequestContext(rc);
        return message;
    }

    @Override
    public void handleConfirm(boolean ack, long l, boolean multi) {
        HashMap<Long, Message> cache = new HashMap<Long, Message>();
        if (!multi) {
            Message message = (Message)this.confirmMap.remove(l);
            cache.put(l, message);
        } else {
            SortedMap<Long, Message> messages = this.confirmMap.headMap(l + 1L);
            cache.putAll(messages);
            Iterator iterator = messages.entrySet().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
        if (!ack) {
            logger.info("{}\u6a21\u62df\u6570\u636e\u63d2\u5165\u6570\u636e\u5e93======================{}", (Object)ConstantsHelper.getBDLogPrefixExt(), (Object)((Object)cache).toString());
            if (!cache.isEmpty()) {
                try {
                    long[] ids = ID.genLongIds((int)cache.size());
                    int i = 0;
                    for (Map.Entry entry : cache.entrySet()) {
                        if (entry.getValue() == null) continue;
                        Message message = (Message)entry.getValue();
                        boolean b = this.createTraceAndRequestContext(message);
                        if (b) {
                            Object[] param = new Object[]{ids[i++], JSON.toJSONString((Object)((Message)entry.getValue()).getBody()), 0, new Date(System.currentTimeMillis())};
                            this.addMessageToDb(param);
                            continue;
                        }
                        logger.error("{}\u53d1\u9001MQ\u5931\u8d25\u6d88\u606f\uff0c\u6ca1\u6709\u4e0a\u4e0b\u6587\uff0c\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\u8868", (Object)ConstantsHelper.getBDLogPrefixExt());
                    }
                }
                catch (Exception e) {
                    logger.error("{}\u53d1\u9001\u5931\u8d25\u65e5\u5fd7\u5199\u5165\u6570\u636e\u5e93\u5931\u8d25:", (Object)ConstantsHelper.getBDLogPrefixExt(), (Object)e);
                }
            }
        }
    }

    @Override
    public void handleReturn(int var1, String var2, String var3, String var4, BasicProperties var5, byte[] var6) throws IOException {
        logger.info("{}\u6570\u636e\u8fdb\u5165\u4ea4\u6362\u673a----handleReturn", (Object)ConstantsHelper.getBDLogPrefixExt());
    }

    private void addMessageToDb(Object[] params) {
        String sql = "INSERT INTO t_perm_log_diff_failmsg (FID,FMESSAGE,FRETRYTIMES,FCREATETIME) VALUES(?,?,?,?)";
        DB.execute((DBRoute)DBRoute.log, (String)sql, (Object[])params);
    }

    private boolean createTraceAndRequestContext(Message message) {
        RequestContext rc = message.getRequestContext();
        if (rc == null) {
            return false;
        }
        String traceId = TraceIdUtil.createTraceIdString();
        rc.setTraceId(traceId);
        RequestContextCreator.restoreForMQ((RequestContext)rc);
        return true;
    }
}

