/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.log.service;

import com.alibaba.fastjson.JSON;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.bd.log.model.ExtHandleMsg;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.util.StringUtils;

public class ExtHandlePublishService {
    private static Log log = LogFactory.getLog(ExtHandlePublishService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void needExtHandle(ExtHandleMsg extHandleMsg) {
        boolean needExt = extHandleMsg.isNeedExt();
        if (!needExt) {
            return;
        }
        String logType = extHandleMsg.getLogType();
        Integer num = extHandleMsg.getNum();
        if (StringUtils.isEmpty((String)logType) || null == num || num.equals(0)) {
            log.info("ExtHandlePublishService.needExtHandle, param invalid, extHandleMsg\uff1a{}", (Object)JSON.toJSONString((Object)extHandleMsg));
            return;
        }
        EnumBDLogType enumBDLogType = EnumBDLogType.getEnum(logType);
        if (null == enumBDLogType || EnumBDLogType.UNKNOW == enumBDLogType) {
            log.info("ExtHandlePublishService.needExtHandle, unknow logtype, logType\uff1a{}", (Object)logType);
            return;
        }
        String region = enumBDLogType.getRegion();
        String queueName = enumBDLogType.getQueueName();
        if (StringUtils.isEmpty((String)region) || StringUtils.isEmpty((String)queueName)) {
            log.info("ExtHandlePublishService.needExtHandle, extHandleRegion or extHandleQueueName is empty, logType\uff1a{}", (Object)logType);
            return;
        }
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher(region, queueName);){
            pub.publish((Object)extHandleMsg);
        }
    }
}

