/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.log.service.impl;

import java.util.Collection;
import java.util.List;
import kd.bos.bd.log.api.IBDLogService;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.enums.EnumBDLogType;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.TimeServiceHelper;

public class BDLogServiceImpl
implements IBDLogService {
    private static Log logger = LogFactory.getLog(BDLogServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLog(BDLogInfo bdLogInfo) {
        if (null == bdLogInfo) {
            return;
        }
        String logType = bdLogInfo.getLogType();
        EnumBDLogType anEnum = EnumBDLogType.getEnum(logType);
        if (EnumBDLogType.UNKNOW == anEnum) {
            logger.info("BDLogService.addLog, \u65e5\u5fd7\u7c7b\u578b\u4e0d\u5b58\u5728\u6216\u975e\u6cd5!");
            return;
        }
        String logTypeDesc = anEnum.getDescri();
        List list = bdLogInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            logger.info("BDLogService.addLog, [{}], \u65e5\u5fd7\u8bb0\u5f55\u4e3a\u7a7a!", (Object)logTypeDesc);
            return;
        }
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher(EnumBDLogType.BD.getRegion(), EnumBDLogType.BD.getQueueName());){
            list.stream().forEach(map -> {
                map.put("oper_id", null == map.get("oper_id") ? Long.valueOf(RequestContext.get().getCurrUserId()) : map.get("oper_id"));
                map.put("oper_org_id", null == map.get("oper_org_id") ? Long.valueOf(RequestContext.get().getOrgId()) : map.get("oper_org_id"));
                map.put("oper_time", null == map.get("oper_time") ? TimeServiceHelper.now() : map.get("oper_time"));
                map.put("client_type", null == map.get("client_type") ? RequestContext.get().getClient() : map.get("client_type"));
                map.put("client_ip", null == map.get("client_ip") ? RequestContext.get().getLoginIP() : map.get("client_ip"));
                map.put("client_name", null == map.get("client_name") ? RequestContext.get().getClient() : map.get("client_name"));
            });
            pub.publish((Object)bdLogInfo);
        }
    }
}

