/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.log.timetask;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bd.log.api.model.BDLogInfo;
import kd.bos.bd.log.rabbitmq.BDMQPublishService;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;

public class BDLogFailMsgResendTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(BDLogFailMsgResendTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        StringBuilder sql = new StringBuilder("select fid, fmessage, fretrytimes, fnextretrytime, fcreatetime from ");
        sql.append("t_bdlog_failmsg");
        sql.append(" where fretrytimes <3");
        try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.log, (String)sql.toString());){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long id = row.getLong(0);
                String message = row.getString(1);
                List appLogInfoList = JSON.parseArray((String)message, BDLogInfo.class);
                int retryTime = row.getInteger(2);
                Long nextTime = row.getLong(3);
                if (nextTime != null && nextTime != 0L && Long.parseLong(String.valueOf(nextTime)) > System.currentTimeMillis()) continue;
                boolean result = BDMQPublishService.getInstance().sendForResult(appLogInfoList);
                if (result) {
                    this.clearRecord(id);
                    continue;
                }
                this.updateRecord(id, retryTime);
            }
        }
        catch (Exception e) {
            log.error("BDLogFailMsgResendTask.execute, rabbitmq \u6743\u9650\u64cd\u4f5c\u65e5\u5fd7\u91cd\u8bd5\u6295\u9012\u4efb\u52a1, \u8fd0\u884c\u5f02\u5e38 ", (Throwable)e);
        }
    }

    private void clearRecord(long id) {
        try {
            StringBuilder sql = new StringBuilder("delete from ");
            sql.append("t_bdlog_failmsg");
            sql.append(" where fid=");
            sql.append(id);
            DB.execute((DBRoute)DBRoute.log, (String)sql.toString());
        }
        catch (Exception e) {
            log.error("BDLogFailMsgResendTask.clearRecord, rabbitmq \u6743\u9650\u64cd\u4f5c\u65e5\u5fd7\u91cd\u8bd5\u6295\u9012\u4efb\u52a1\uff0c\u6e05\u9664\u53d1\u9001\u6210\u529f\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
        }
    }

    private void updateRecord(long id, int retryTime) {
        long nextRetryTime = System.currentTimeMillis();
        if (0 == retryTime) {
            nextRetryTime += 300000L;
        } else if (1 == retryTime) {
            nextRetryTime += 600000L;
        } else if (2 == retryTime) {
            nextRetryTime += 900000L;
        }
        StringBuilder sql = new StringBuilder("update ");
        sql.append("t_bdlog_failmsg");
        sql.append(" set fretrytimes=").append(retryTime + 1).append(",");
        sql.append(" fnextretrytime=").append(nextRetryTime).append(",");
        sql.append(" where fid = ").append(id);
        try {
            DB.execute((DBRoute)DBRoute.log, (String)sql.toString());
        }
        catch (Exception e) {
            log.error("BDLogFailMsgResendTask.updateRecord, rabbitmq \u6743\u9650\u64cd\u4f5c\u65e5\u5fd7\u91cd\u8bd5\u6295\u9012\u4efb\u52a1\uff0c\u66f4\u65b0\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }
}

