/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.yzj.config;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.common.BaseAppParameterServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.util.EncryptUtils;
import kd.bos.yzj.config.YzjTokenHelper;
import kd.bos.yzj.model.YzjConfig;
import org.apache.commons.codec.binary.Base64;

public class YzjConfigServiceHelper {
    private static Log logger = LogFactory.getLog(YzjConfigServiceHelper.class);
    public static final String PARAM_SYNC_MODE = "syncmode";
    public static final String PARAM_YZJ_URL = "yzjurl";
    public static final String PARAM_YZJ_SECRET = "yzjsecret";
    private static final String PARAM_IS_AUTO_SYNC = "isautosync";
    private static final String PARAM_IS_AUTO_CLEAR_SYNC_TASK = "isautoclearsynctask";
    private static final String PARAM_KEEP_SYNC_TASK_COUNT = "keepsynctaskcount";
    private static final String PARAM_ORG_DISABLE_LIMIT = "orgdisablelimit";
    private static final String PARAM_USER_DISABLE_LIMIT = "userdisablelimit";
    private static final String PARAM_YZJ_SYNC_ORG_IGNORE_OP = "yzjsyncorgignoreop";
    private static final String PARAM_YZJ_SYNC_USER_IGNORE_OP = "yzjsyncuserignoreop";
    private static final String PARAM_YZJ_SYNC_USER_IGNORE_PRO = "yzjsyncuserignorepro";
    public static final String EID = "Eid";
    public static final String PARAM_EID = "eid";
    private static final String KEY_DATA = "KeyData";
    private static final String YZJ_PUBLIC_DOMAIN_NAME = "w.yunzhijia.c";
    public static final String YZJ_DEPLOYMENT_MODE = "yzjdeploymentmode";
    public static final String YZJ_KEY = "yzjkey";
    public static final String YZJ_READ_KEY = "readkey";
    public static final String YZJ_IM_SERVICE_KEY = "imservicekey";
    public static final String SPLIT_COMMA = ",";
    private static final String DISABLEUSER = "disableuser";
    private static final String SYNC_ORG_SORT_NUMBER_TO_YZJ = "syncorgsortnumbertoyzj";
    private static final String SYNC_ORG_SORT_NUMBER_FROM_YZJ = "syncorgsortnumberfromyzj";

    public static boolean isEnable() {
        YzjConfig config = YzjConfigServiceHelper.getParameterConfig();
        boolean isEnable = config.isEnable();
        logger.info("\u4e91\u4e4b\u5bb6\u662f\u5426\u5df2\u542f\u7528:" + isEnable);
        return isEnable;
    }

    public static boolean isPublicCloud() {
        YzjConfig config = YzjConfigServiceHelper.getParameterConfig();
        return config.isPublicCloud();
    }

    public static boolean isPublicCloud(String yzjUrl) {
        boolean isPublicCloud = false;
        if (StringUtils.isNotBlank((CharSequence)yzjUrl) && yzjUrl.contains(YZJ_PUBLIC_DOMAIN_NAME)) {
            isPublicCloud = true;
        }
        logger.info("\u4e91\u4e4b\u5bb6\u662f\u5426\u5df2\u542f\u7528\u516c\u6709\u4e91:" + isPublicCloud);
        return isPublicCloud;
    }

    public static String getYZJUrl() {
        YzjConfig config = YzjConfigServiceHelper.getParameterConfig();
        String yzjUrl = config.getUrl();
        logger.info("\u4e91\u4e4b\u5bb6URL:" + yzjUrl);
        if (StringUtils.isBlank((CharSequence)yzjUrl)) {
            return "";
        }
        return yzjUrl.trim();
    }

    public static YzjConfig getParameterConfig() {
        YzjConfig config = new YzjConfig();
        Map<String, Object> paramMap = BaseAppParameterServiceHelper.getParameterFromCache();
        if (paramMap == null) {
            config.setSuccess(false);
            config.setMsg(ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6\u7684\u201c\u7cfb\u7edf\u53c2\u6570\u201d\u5931\u8d25\uff0c\u8bf7\u4fee\u6539\u3002", (String)"YzjConfigServiceHelper_0", (String)"bos-yunzhijia", (Object[])new Object[0]));
        } else {
            config.setSuccess(true);
            Object deploymentModeParam = paramMap.get(YZJ_DEPLOYMENT_MODE);
            if (StringUtils.isNotBlank((Object)deploymentModeParam)) {
                int deploymentMode = Integer.parseInt(deploymentModeParam.toString());
                config.setDeploymentMode(deploymentMode);
                config.setPublicCloud(1 == deploymentMode);
            }
            config.setEid(YzjConfigServiceHelper.parseConfigValue2StringType(PARAM_EID, paramMap, config.getEid()));
            config.setKeyStr(YzjConfigServiceHelper.parseConfigValue2StringType(YZJ_KEY, paramMap, config.getKeyStr()));
            config.setReadKey(YzjConfigServiceHelper.parseConfigValue2StringType(YZJ_READ_KEY, paramMap, config.getReadKey()));
            config.setImServiceKey(YzjConfigServiceHelper.parseConfigValue2StringType(YZJ_IM_SERVICE_KEY, paramMap, config.getImServiceKey()));
            config.setUrl(YzjConfigServiceHelper.parseConfigValue2StringType(PARAM_YZJ_URL, paramMap, ""));
            config.setYzjSecret(YzjConfigServiceHelper.parseConfigValue2StringType(PARAM_YZJ_SECRET, paramMap, ""));
            config.setSyncMode(YzjConfigServiceHelper.parseConfigValue2IntType(PARAM_SYNC_MODE, paramMap, config.getSyncMode()));
            config.setEnable(config.getSyncMode() != 1);
            config.setSyncOrgSortNumberToYzj(YzjConfigServiceHelper.parseConfigValue2BooleanType(SYNC_ORG_SORT_NUMBER_TO_YZJ, paramMap, Boolean.FALSE));
            config.setSyncOrgSortNumberFromYzj(YzjConfigServiceHelper.parseConfigValue2BooleanType(SYNC_ORG_SORT_NUMBER_FROM_YZJ, paramMap, Boolean.FALSE));
            config.setDisableuser(YzjConfigServiceHelper.parseConfigValue2BooleanType(DISABLEUSER, paramMap, Boolean.TRUE));
            config.setAutoSync(YzjConfigServiceHelper.parseConfigValue2BooleanType(PARAM_IS_AUTO_SYNC, paramMap, config.isAutoSync()));
            config.setAutoClearSyncTask(YzjConfigServiceHelper.parseConfigValue2BooleanType(PARAM_IS_AUTO_CLEAR_SYNC_TASK, paramMap, config.isAutoClearSyncTask()));
            config.setKeepSyncTaskCount(YzjConfigServiceHelper.parseConfigValue2IntType(PARAM_KEEP_SYNC_TASK_COUNT, paramMap, config.getKeepSyncTaskCount()));
            config.setOrgDisableLimit(YzjConfigServiceHelper.parseConfigValue2IntType(PARAM_ORG_DISABLE_LIMIT, paramMap, config.getOrgDisableLimit()));
            config.setUserDisableLimit(YzjConfigServiceHelper.parseConfigValue2IntType(PARAM_USER_DISABLE_LIMIT, paramMap, config.getUserDisableLimit()));
            config.getOrgIgnoreOperations().addAll(YzjConfigServiceHelper.parseConfigValue2CollectionType(PARAM_YZJ_SYNC_ORG_IGNORE_OP, paramMap));
            config.getUserIgnoreOperations().addAll(YzjConfigServiceHelper.parseConfigValue2CollectionType(PARAM_YZJ_SYNC_USER_IGNORE_OP, paramMap));
            config.getUserIgnoreProperties().addAll(YzjConfigServiceHelper.parseConfigValue2CollectionType(PARAM_YZJ_SYNC_USER_IGNORE_PRO, paramMap));
        }
        logger.info("\u4e91\u4e4b\u5bb6\u53c2\u6570[getParameterConfig]\uff1a" + config.getSystemParam());
        return config;
    }

    private static String parseConfigValue2StringType(String key, Map<String, Object> paramMap, String defaultValue) {
        Object config = paramMap.get(key);
        if (StringUtils.isBlank((Object)config)) {
            return defaultValue;
        }
        return config.toString();
    }

    private static boolean parseConfigValue2BooleanType(String key, Map<String, Object> paramMap, boolean defaultValue) {
        Object config = paramMap.get(key);
        if (StringUtils.isBlank((Object)config)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(config.toString());
    }

    private static int parseConfigValue2IntType(String key, Map<String, Object> paramMap, int defaultValue) {
        Object config = paramMap.get(key);
        if (StringUtils.isBlank((Object)config)) {
            return defaultValue;
        }
        return Integer.parseInt(config.toString());
    }

    private static List<String> parseConfigValue2CollectionType(String key, Map<String, Object> paramMap) {
        Object config = paramMap.get(key);
        if (StringUtils.isBlank((Object)config)) {
            return new ArrayList<String>(0);
        }
        String[] values = StringUtils.split((String)config.toString(), (String)SPLIT_COMMA);
        ArrayList<String> result = new ArrayList<String>(values.length);
        for (String value : values) {
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            result.add(value);
        }
        return result;
    }

    public static YzjConfig getConfig() {
        YzjConfig config = YzjConfigServiceHelper.getParameterConfig();
        if (!config.isSuccess() || !config.isEnable()) {
            return config;
        }
        String tenantId = RequestContext.get().getTenantId();
        config.setTenantId(tenantId);
        if (StringUtils.isBlank((CharSequence)config.getEid())) {
            YzjConfigServiceHelper.getConfigFromMc(config);
        }
        YzjConfigServiceHelper.getYzjSecret(config);
        YzjConfigServiceHelper.getTokenByYzjSecret(config);
        logger.info("\u4e91\u4e4b\u5bb6\u53c2\u6570[getConfig]\uff1a" + config.getSystemParam());
        return config;
    }

    private static void getYzjSecret(YzjConfig config) {
        if (StringUtils.isNotBlank((CharSequence)config.getYzjSecret()) || YzjConfigServiceHelper.useReadKey(config)) {
            return;
        }
        String oldBase64Key = config.getKeyStr();
        if (StringUtils.isBlank((CharSequence)oldBase64Key)) {
            String msg = 2 == config.getSyncMode() ? ResManager.loadKDString((String)"\u8bf7\u5728\u201c\u7cfb\u7edf\u53c2\u6570\u201d\u914d\u7f6e\u4e91\u4e4b\u5bb6\u7684\u201c\u53ea\u8bfb\u5bc6\u94a5\u201d\u3002", (String)"YzjConfigServiceHelper_4", (String)"bos-yunzhijia", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u5728\u201c\u7cfb\u7edf\u53c2\u6570\u201d\u914d\u7f6e\u4e91\u4e4b\u5bb6\u7684\u201c\u7cfb\u7edf\u96c6\u6210\u5bc6\u94a5\u201d\u3002", (String)"YzjConfigServiceHelper_1", (String)"bos-yunzhijia", (Object[])new Object[0]);
            logger.info(msg);
            config.setMsg(msg);
            config.setSuccess(false);
        } else {
            byte[] keyByte = Base64.decodeBase64((byte[])oldBase64Key.getBytes(StandardCharsets.UTF_8));
            try {
                config.setKey(EncryptUtils.restorePrivateKey((byte[])keyByte));
                config.setKeyStr(oldBase64Key);
                config.setSuccess(true);
            }
            catch (Exception e) {
                String msg = ResManager.loadKDString((String)"\u5bc6\u94a5\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u201c\u7cfb\u7edf\u53c2\u6570\u914d\u201d\u7f6e\u7684\u4e91\u4e4b\u5bb6\u201c\u7cfb\u7edf\u96c6\u6210\u5bc6\u94a5\u201d\u662f\u5426\u6b63\u786e\u3002", (String)"YzjConfigServiceHelper_2", (String)"bos-yunzhijia", (Object[])new Object[0]);
                logger.info(msg + e.getMessage());
                config.setMsg(msg);
                config.setSuccess(false);
            }
        }
    }

    private static boolean useReadKey(YzjConfig config) {
        if (2 == config.getSyncMode() && StringUtils.isNotBlank((CharSequence)config.getReadKey())) {
            config.setYzjSecret(config.getReadKey());
            return true;
        }
        return false;
    }

    private static void getTokenByYzjSecret(YzjConfig config) {
        String yzjSecret = config.getYzjSecret();
        if (StringUtils.isBlank((CharSequence)yzjSecret)) {
            return;
        }
        boolean useReadKey = YzjConfigServiceHelper.useReadKey(config);
        config.setToken(YzjTokenHelper.getToken(config, "resGroupSecret"));
        config.setYzjSecret(yzjSecret);
        if (useReadKey && StringUtils.isBlank((CharSequence)config.getToken())) {
            config.setSuccess(true);
            config.setMsg("");
            config.setToken(YzjTokenHelper.getToken(config, "resGroupSecret"));
        }
        if (StringUtils.isBlank((CharSequence)config.getToken())) {
            String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6\u7684AccessToken\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u201c\u7cfb\u7edf\u53c2\u6570\u914d\u201d\u7f6e\u7684\u4e91\u4e4b\u5bb6\u201c\u7cfb\u7edf\u96c6\u6210\u5bc6\u94a5\u201d\u662f\u5426\u6b63\u786e\u3002", (String)"YzjConfigServiceHelper_3", (String)"bos-yunzhijia", (Object[])new Object[0]);
            config.setMsg(msg);
            config.setSuccess(false);
        } else {
            config.setApiUseToken(true);
        }
    }

    private static void getConfigFromMc(YzjConfig config) {
        config.setPublicCloud(YzjConfigServiceHelper.isPublicCloud(config.getUrl()));
        Map mpEidKey = null;
        String cacheKey = CacheKeyUtil.getAcctId();
        String cacheType = CacheLoginData.getType4YzjEKey((String)cacheKey);
        mpEidKey = CacheLoginData.getCache((String)cacheType);
        if (mpEidKey == null) {
            return;
        }
        config.setEid((String)mpEidKey.get(EID));
        config.setKeyStr((String)mpEidKey.get(KEY_DATA));
    }
}

