/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.yzj.config;

import java.io.IOException;
import java.security.Key;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.EncryptUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import kd.bos.yzj.model.YzjConfig;
import kd.bos.yzj.model.YzjData;
import kd.bos.yzj.util.YzjUtils;

public class YzjTokenHelper {
    public static final String SCOPE_APP = "app";
    public static final String SCOPE_TEAM = "team";
    public static final String SCOPE_RES_GROUP_SECRET = "resGroupSecret";
    public static final String SCOPE_TICKET = "ticket";
    private static final String API_YZJ_SHARE_GETTICET = "/imsdk/getTicket.do?";
    public static final String API_GET_ACCESSTOKEN = "/gateway/oauth2/token/getAccessToken";
    private static final String KEY_APPID = "appId";
    private static final String KEY_EID = "eid";
    private static final String KEY_SECRET = "secret";
    private static final String KEY_TIMESTAMP = "timestamp";
    private static final String KEY_SCOPE = "scope";
    private static final String KEY_ACCESSTOKEN = "accessToken";
    private static final String KEY_DATA = "data";
    private static final String SYSTEM_TYPE = "bos-yunzhijia";
    private static Log logger = LogFactory.getLog(YzjTokenHelper.class);

    public static String getToken(String scope) {
        return YzjTokenHelper.getToken(scope, "");
    }

    public static String getToken(YzjConfig yzjConfig, String scope) {
        return YzjTokenHelper.getTokenWithAppId(yzjConfig, scope, "");
    }

    public static String getToken(String scope, String appId) {
        return YzjTokenHelper.getTokenWithAppId(YzjConfigServiceHelper.getConfig(), scope, appId);
    }

    public static String getTokenWithAppId(YzjConfig yzjConfig, String scope, String appId) {
        String token = "";
        if (yzjConfig == null) {
            logger.error("\u4e91\u4e4b\u5bb6\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            return token;
        }
        if (StringUtils.isBlank((CharSequence)scope)) {
            yzjConfig.setSuccess(false);
            String msg = ResManager.loadKDString((String)"\u6388\u6743\u7ea7\u522bscope\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YzjTokenHelper_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            yzjConfig.setMsg(msg);
            logger.info(msg);
            return token;
        }
        switch (scope) {
            case "app": {
                token = YzjTokenHelper.getAppToken(yzjConfig, appId);
                break;
            }
            case "team": {
                token = YzjTokenHelper.getTeamToken(yzjConfig, appId);
                break;
            }
            case "resGroupSecret": {
                token = YzjTokenHelper.getGroupToken(yzjConfig);
                break;
            }
            case "ticket": {
                token = YzjTokenHelper.getTicketToken(yzjConfig);
                break;
            }
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            if (yzjConfig.isSuccess()) {
                yzjConfig.setSuccess(false);
                String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6token\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u4e91\u4e4b\u5bb6\u7684\u7cfb\u7edf\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"YzjTokenHelper_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                yzjConfig.setMsg(msg);
                logger.info(msg);
            }
        } else {
            yzjConfig.setToken(token);
        }
        return token;
    }

    private static String getAppToken(YzjConfig yzjConfig, String appId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(KEY_APPID, appId);
        params.put(KEY_SECRET, yzjConfig.getYzjSecret());
        params.put(KEY_TIMESTAMP, Calendar.getInstance().getTimeInMillis());
        params.put(KEY_SCOPE, SCOPE_RES_GROUP_SECRET);
        return YzjTokenHelper.post(yzjConfig, params);
    }

    private static String getTeamToken(YzjConfig yzjConfig, String appId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(KEY_APPID, appId);
        params.put(KEY_EID, yzjConfig.getEid());
        params.put(KEY_SECRET, yzjConfig.getYzjSecret());
        params.put(KEY_TIMESTAMP, Calendar.getInstance().getTimeInMillis());
        params.put(KEY_SCOPE, SCOPE_RES_GROUP_SECRET);
        return YzjTokenHelper.post(yzjConfig, params);
    }

    private static String getGroupToken(YzjConfig yzjConfig) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(KEY_EID, yzjConfig.getEid());
        params.put(KEY_SECRET, yzjConfig.getYzjSecret());
        params.put(KEY_TIMESTAMP, Calendar.getInstance().getTimeInMillis());
        params.put(KEY_SCOPE, SCOPE_RES_GROUP_SECRET);
        return YzjTokenHelper.post(yzjConfig, params);
    }

    private static String post(YzjConfig yzjConfig, Map<String, Object> params) {
        if (StringUtils.isBlank((CharSequence)yzjConfig.getYzjSecret())) {
            yzjConfig.setSuccess(false);
            String msg = ResManager.loadKDString((String)"\u6388\u6743\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YzjTokenHelper_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            yzjConfig.setMsg(msg);
            logger.info(msg);
            return "";
        }
        YzjData yzjData = new YzjData();
        yzjData.setParams(params);
        yzjData.setApi(API_GET_ACCESSTOKEN);
        YzjUtils.postToken(yzjConfig, yzjData);
        if (!yzjData.isSuccess()) {
            return "";
        }
        String token = "";
        try {
            Map resMap = (Map)JSONUtils.cast((String)yzjData.getResponse(), HashMap.class);
            if (!Boolean.parseBoolean(resMap.get("success").toString())) {
                String msg = resMap.get("error").toString();
                logger.info(msg);
                yzjConfig.setMsg(YzjTokenHelper.getMessage(msg));
                yzjConfig.setSuccess(false);
                return "";
            }
            Map dataMap = (Map)resMap.get(KEY_DATA);
            if (dataMap != null && StringUtils.isNotBlank(dataMap.get(KEY_ACCESSTOKEN))) {
                token = (String)dataMap.get(KEY_ACCESSTOKEN);
            }
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u89e3\u6790\u4e91\u4e4b\u5bb6token\u5931\u8d25\u3002", (String)"YzjTokenHelper_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            logger.info(msg + e.getMessage());
            yzjConfig.setMsg(YzjTokenHelper.getMessage(msg));
            yzjConfig.setSuccess(false);
            return "";
        }
        return token;
    }

    private static String getTicketToken(YzjConfig yzjConfig) {
        String sKey = YzjTokenHelper.getYzjTicketKey(yzjConfig);
        String token = "";
        if (StringUtils.isBlank((CharSequence)sKey)) {
            return token;
        }
        String eid = yzjConfig.getEid();
        String yzjHost = yzjConfig.getUrl();
        String sgetticket = yzjHost + API_YZJ_SHARE_GETTICET + "eid=" + eid + "&data=" + sKey;
        String ticket = "";
        try {
            ticket = HttpClientUtils.get((String)sgetticket);
            if (StringUtils.isBlank((CharSequence)ticket)) {
                yzjConfig.setMsg(ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6token\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u4e91\u4e4b\u5bb6\u7684\u7cfb\u7edf\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"YzjTokenHelper_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                yzjConfig.setSuccess(false);
                return token;
            }
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u83b7\u53d6\u4e91\u4e4b\u5bb6token\u5931\u8d25\u3002", (String)"YzjTokenHelper_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            logger.info(msg + e.getMessage());
            yzjConfig.setMsg(YzjTokenHelper.getMessage(msg));
            yzjConfig.setSuccess(false);
            return "";
        }
        try {
            Map mpTicket = (Map)JSONUtils.cast((String)ticket, HashMap.class);
            token = (String)mpTicket.get(KEY_DATA);
        }
        catch (IOException e) {
            String msg = ResManager.loadKDString((String)"\u89e3\u6790\u4e91\u4e4b\u5bb6token\u5931\u8d25\u3002", (String)"YzjTokenHelper_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            logger.info(msg + e.getMessage());
            yzjConfig.setMsg(YzjTokenHelper.getMessage(msg));
            yzjConfig.setSuccess(false);
            return "";
        }
        return token;
    }

    private static String getYzjTicketKey(YzjConfig yzjConfig) {
        RequestContext requestContext = RequestContext.get();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("privatevalue", requestContext.getUserOpenId());
        params.put("flag", "0");
        params.put("bizNo", "NEXTCLOUDERP");
        String sKey = "";
        Key privateKey = yzjConfig.getKey();
        try {
            sKey = EncryptUtils.encryptWithEncodeBase64UTF8((String)JSONUtils.toString(params), (Key)privateKey);
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u52a0\u5bc6\u4e91\u4e4b\u5bb6\u53c2\u6570\u5931\u8d25\u3002", (String)"YzjTokenHelper_5", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            logger.info(msg + e.getMessage());
            yzjConfig.setMsg(YzjTokenHelper.getMessage(msg));
            yzjConfig.setSuccess(false);
            return "";
        }
        return sKey;
    }

    private static String getMessage(String msg) {
        return String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u786e\u4fdd\u5728\u4e91\u4e4b\u5bb6\u7ba1\u7406\u4e2d\u5fc3\u52fe\u9009\u5f00\u542f\u4e86\u76f8\u5e94\u7684\u6388\u6743\uff0c\u5e76\u4e14\u5728\u82cd\u7a79\u7cfb\u7edf\u53c2\u6570\u7ef4\u62a4\u4e86\u6b63\u786e\u7684\u914d\u7f6e\u4fe1\u606f\u3002", (String)"YzjTokenHelper_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), msg);
    }
}

