/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.yzj.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.yzj.interfaces.IYzjService;
import kd.bos.yzj.model.YzjApiRes;
import kd.bos.yzj.model.YzjConfig;
import kd.bos.yzj.model.YzjData;
import kd.bos.yzj.model.user.YzjUsersResponseModel;
import kd.bos.yzj.util.YzjUtils;

public class YzjService
implements IYzjService {
    private static Log logger = LogFactory.getLog(YzjService.class);
    private static final String SYSTEM_TYPE = "bos-yunzhijia";
    protected YzjConfig config;
    private String fullNameSeq;

    public YzjService(YzjConfig config) {
        this.config = config;
    }

    @Override
    public YzjConfig getConfig() {
        return this.config;
    }

    @Override
    public void post(YzjData yzjData) {
        YzjUtils.post(this.config, yzjData);
    }

    @Override
    public void getData(YzjData yzjData) {
        if (!this.config.isEnable()) {
            logger.warn("\u7cfb\u7edf\u672a\u542f\u7528\u4e91\u4e4b\u5bb6");
            return;
        }
        this.post(yzjData);
        if (!yzjData.isSuccess()) {
            logger.info("\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u5931\u8d25\uff1a" + yzjData.getMsg());
            return;
        }
        String response = yzjData.getResponse();
        if (StringUtils.isBlank((CharSequence)response)) {
            yzjData.setSuccess(false);
            yzjData.setMsg(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"YzjService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        Map dataMap = null;
        try {
            dataMap = (Map)JSONUtils.cast((String)response, HashMap.class, (boolean)true);
        }
        catch (IOException e) {
            yzjData.setSuccess(false);
            yzjData.setMsg(ResManager.loadKDString((String)"\u89e3\u6790\u4e91\u4e4b\u5bb6\u8fd4\u56de\u7684\u6d88\u606f\u5931\u8d25\u3002", (String)"YzjService_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            logger.info("\u89e3\u6790\u4e91\u4e4b\u5bb6\u8fd4\u56de\u7684\u6d88\u606f\u5931\u8d25\uff1a" + response + " \u5f02\u5e38\uff1a" + e.getMessage());
            return;
        }
        if (dataMap == null) {
            yzjData.setSuccess(false);
            yzjData.setMsg(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"YzjService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        this.handleApiSuccessResponse(yzjData, dataMap);
    }

    private void handleApiSuccessResponse(YzjData yzjData, Map<String, Object> dataMap) {
        Object success = dataMap.get("success");
        if (StringUtils.isNotBlank((Object)success) && !((Boolean)success).booleanValue()) {
            String error = String.valueOf(dataMap.get("error"));
            error = String.format(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u63a5\u53e3\u201c%1$s\u201d\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\u201c%2$s\u201d\u3002", (String)"YzjService_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), yzjData.getApi(), error);
            yzjData.setMsg(error);
            yzjData.setSuccess(false);
            logger.info(error);
            return;
        }
        Object errorCode = dataMap.get("errorCode");
        if (StringUtils.isBlank((Object)errorCode) || (Integer)errorCode != 100) {
            logger.info(String.format("\u4e91\u4e4b\u5bb6\u63a5\u53e3\u201c%s\u201d\u8fd4\u56de\u7684\u201c\u9519\u8bef\u7801\uff08errorCode\uff09\u201d\u4e3a\u201c%s\u201d\u3002", yzjData.getApi(), errorCode));
            yzjData.setSuccess(false);
            return;
        }
        Object data = dataMap.get("data");
        if (data == null) {
            logger.info(String.format("\u4e91\u4e4b\u5bb6\u63a5\u53e3\u201c%s\u201d\u8fd4\u56de\u7684\u201cdata\u201d\u4e3a\u201cnull\u201d\u3002", yzjData.getApi()));
            yzjData.setSuccess(false);
            return;
        }
        List dataList = (List)data;
        yzjData.setDataList(dataList);
        yzjData.setSuccess(true);
        logger.info(yzjData.getApi() + "\u4e91\u4e4b\u5bb6\u63a5\u53e3\u5355\u6b21\u8fd4\u56de\u6570\u636e\u6570\u91cf\uff1a" + dataList.size());
    }

    @Override
    public void getBatchData(YzjData yzjData) {
        List<Map<String, Object>> dataList;
        block4: {
            YzjData eachYzjData;
            if (!this.config.isEnable()) {
                logger.warn("\u7cfb\u7edf\u672a\u542f\u7528\u4e91\u4e4b\u5bb6");
                return;
            }
            if (yzjData == null || StringUtils.isBlank((CharSequence)yzjData.getApi())) {
                return;
            }
            yzjData.setSuccess(true);
            int begin = 0;
            int count = 1000;
            while (true) {
                HashMap<String, Integer> param = new HashMap<String, Integer>();
                param.put("begin", begin);
                param.put("count", count);
                eachYzjData = new YzjData();
                eachYzjData.setApi(yzjData.getApi());
                eachYzjData.setParams(param);
                eachYzjData.setGetAll(true);
                this.getData(eachYzjData);
                if (!eachYzjData.isSuccess()) break;
                List<Map<String, Object>> eachDataList = eachYzjData.getDataList();
                if (eachDataList != null && !eachDataList.isEmpty()) {
                    yzjData.getDataList().addAll(eachDataList);
                    begin += count;
                    continue;
                }
                break block4;
                break;
            }
            yzjData.setSuccess(false);
            yzjData.setMsg(eachYzjData.getMsg());
            yzjData.setDataList(new ArrayList<Map<String, Object>>());
        }
        int total = (dataList = yzjData.getDataList()) == null ? 0 : dataList.size();
        logger.info(yzjData.getApi() + "\u4e91\u4e4b\u5bb6\u63a5\u53e3\u6279\u91cf\u83b7\u53d6\u7684\u603b\u6570\uff1a" + total);
    }

    @Override
    public void parseResponse(String yzjResponse, List<YzjApiRes> resList) {
        if (StringUtils.isBlank((CharSequence)yzjResponse) || CollectionUtils.isEmpty(resList)) {
            return;
        }
        List<Map<String, Object>> resultDataList = this.getYzjResponseData(yzjResponse, resList);
        if (CollectionUtils.isEmpty(resultDataList)) {
            return;
        }
        for (Map<String, Object> resultMap : resultDataList) {
            Object msg = resultMap.get("msg");
            if (StringUtils.isBlank((Object)msg)) continue;
            for (YzjApiRes yzjApiRes : resList) {
                if (!yzjApiRes.getMsgId().equals(resultMap.get("msgId"))) continue;
                yzjApiRes.setSuccess(false);
                yzjApiRes.setMsg(msg.toString());
            }
        }
    }

    private List<Map<String, Object>> getYzjResponseData(String yzjResponse, List<YzjApiRes> resList) {
        try {
            YzjUsersResponseModel yzjmdl = (YzjUsersResponseModel)JSONUtils.cast((String)yzjResponse, YzjUsersResponseModel.class, (boolean)true);
            if (!yzjmdl.isSuccess()) {
                for (YzjApiRes yzjApiRes : resList) {
                    yzjApiRes.setSuccess(false);
                    yzjApiRes.setMsg(yzjmdl.getError());
                }
                return Collections.emptyList();
            }
            ArrayList<Map<String, Object>> resultDataList = yzjmdl.getData();
            if (CollectionUtils.isEmpty(resultDataList)) {
                return Collections.emptyList();
            }
            return resultDataList;
        }
        catch (Exception e) {
            logger.info("\u89e3\u6790\u4e91\u4e4b\u5bb6\u8fd4\u56de\u7ed3\u679c\u5931\u8d25\uff1a" + yzjResponse + e.getMessage());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u89e3\u6790\u4e91\u4e4b\u5bb6\u8fd4\u56de\u7ed3\u679c\u5931\u8d25\uff1a%2$s", (String)"YzjService_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), yzjResponse, e.getMessage()));
        }
    }

    protected String getFullNameSep() {
        if (this.fullNameSeq == null) {
            this.fullNameSeq = OrgUnitServiceHelper.getOrgSeparation().getFullNameSep();
        }
        return this.fullNameSeq;
    }
}

