/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.yzj.impl.attendance;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.yzj.config.YzjTokenHelper;
import kd.bos.yzj.impl.YzjService;
import kd.bos.yzj.interfaces.IYzjAttendanceService;
import kd.bos.yzj.model.YzjConfig;
import kd.bos.yzj.model.YzjData;
import kd.bos.yzj.model.attendance.YzjClockInResponseModel;

public class YzjAttendancePubCloudService
extends YzjService
implements IYzjAttendanceService {
    private static Log logger = LogFactory.getLog(YzjAttendancePubCloudService.class);
    private static final String SYSTEM_TYPE = "bos-yunzhijia";
    private static final String LOG_MSG_PREFIX = "@.........";
    private DateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public YzjAttendancePubCloudService(YzjConfig config) {
        super(config);
    }

    @Override
    public List<Map<String, Object>> getClockInList(String openIds, Date startDate, Date endDate) {
        return this.getClockInList(openIds, startDate, endDate, 1, 200, null);
    }

    @Override
    public List<Map<String, Object>> getClockInList(String openIds, Date startDate, Date endDate, int start, int limit, String deptIds) {
        if (2 != this.config.getSyncMode()) {
            logger.warn("\u7cfb\u7edf\u672a\u542f\u7528\u82cd\u7a79\u4ece\u4e91\u4e4b\u5bb6\u540c\u6b65\u7ec4\u7ec7\u4eba\u5458\u6a21\u5f0f");
            return Collections.EMPTY_LIST;
        }
        if (StringUtils.isEmpty((CharSequence)openIds)) {
            return Collections.EMPTY_LIST;
        }
        HashMap<String, Object> mpUsers = new HashMap<String, Object>();
        mpUsers.put("eid", this.config.getEid());
        try {
            this.config.setYzjSecret("");
            YzjTokenHelper.getToken(this.config, "resGroupSecret");
            mpUsers.put("accessToken", this.config.getToken());
        }
        catch (Exception e) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6token \u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"YzjAttendancePubCloudService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), e.getMessage());
            logger.error(String.format("%s%s", LOG_MSG_PREFIX, errorMsg), (Throwable)e);
            throw new RuntimeException(e);
        }
        mpUsers.put("workDateFrom", this.DATETIME_FORMAT.format(startDate));
        mpUsers.put("workDateTo", this.DATETIME_FORMAT.format(endDate));
        mpUsers.put("deptIds", deptIds);
        mpUsers.put("openIds", openIds);
        mpUsers.put("start", start);
        mpUsers.put("limit", limit);
        String sHttpResponse = this.genResponse("/gateway/attendance-data/v1/clockIn/list?accessToken=" + mpUsers.get("accessToken"), mpUsers);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return Collections.EMPTY_LIST;
        }
        try {
            Map mpGetCloclIn = (Map)JSONUtils.cast((String)sHttpResponse, HashMap.class, (boolean)true);
            if (mpGetCloclIn == null || StringUtils.isBlank(mpGetCloclIn.get("data"))) {
                String msg = ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u79fb\u52a8\u7b7e\u5230\u660e\u7ec6\u67e5\u8be2\u5931\u8d25: \u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"YzjAttendancePubCloudService_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                logger.error(String.format("%s%s", LOG_MSG_PREFIX, msg));
                return Collections.EMPTY_LIST;
            }
            YzjClockInResponseModel yzjmdl = (YzjClockInResponseModel)JSONUtils.cast((String)sHttpResponse, YzjClockInResponseModel.class, (boolean)true);
            if (!yzjmdl.isSuccess()) {
                return Collections.EMPTY_LIST;
            }
            logger.info(String.format("%s%s", LOG_MSG_PREFIX, "\u4e91\u4e4b\u5bb6\u79fb\u52a8\u7b7e\u5230\u660e\u7ec6\u67e5\u8be2\u6210\u529f\u3002"));
            return yzjmdl.getData();
        }
        catch (Exception e) {
            String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u5f02\u5e38\u4fe1\u606f\uff1a%2$s \u4e91\u4e4b\u5bb6\u8fd4\u56de\u4fe1\u606f\uff1a%3$s", (String)"YzjAttendancePubCloudService_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), LOG_MSG_PREFIX, e.getMessage(), sHttpResponse);
            logger.error(errorMsg, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String genResponse(String api, Object param) {
        YzjData yzjData = new YzjData();
        yzjData.setApi(api);
        yzjData.setParams(param);
        this.post(yzjData);
        String response = yzjData.getResponse();
        if (!yzjData.isSuccess() || StringUtils.isBlank((CharSequence)response)) {
            return "";
        }
        return response;
    }
}

