/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.yzj.impl.org;

import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.yzj.impl.YzjApiEnum;
import kd.bos.yzj.impl.YzjService;
import kd.bos.yzj.interfaces.IYzjOrgService;
import kd.bos.yzj.model.YzjConfig;
import kd.bos.yzj.model.YzjData;
import kd.bos.yzj.model.org.YzjOrgParam;
import kd.bos.yzj.model.org.YzjOrgResponse;
import kd.bos.yzj.model.org.YzjOrgsResponseModel;

public class YzjOrgPubCloudService
extends YzjService
implements IYzjOrgService {
    private static Log logger = LogFactory.getLog(YzjOrgPubCloudService.class);
    private static final String KEY_DEPARTMENTS = "departments";
    private static final String KEY_YZJ_ORG_ID = "yzjorgid";
    private static final String KEY_FULL_NAME = "fullname";
    private static final String KEY_ORG_ID = "orgId";
    private static final String SYSTEM_TYPE = "bos-yunzhijia";

    public YzjOrgPubCloudService(YzjConfig config) {
        super(config);
    }

    private List<Map<String, String>> getYzjOrgatTime(String sDateTime) {
        List<Map<String, String>> lstOrgs = new ArrayList<Map<String, String>>();
        if (StringUtils.isEmpty((CharSequence)sDateTime)) {
            return lstOrgs;
        }
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("time", sDateTime);
        String sHttpResponse = this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_ORG_GETATTIME.name()), para, null);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return lstOrgs;
        }
        try {
            Map mpOrg = (Map)JSONUtils.cast((String)sHttpResponse, HashMap.class);
            if (mpOrg != null && StringUtils.isNotBlank(mpOrg.get("data"))) {
                lstOrgs = (List)mpOrg.get("data");
            }
        }
        catch (Exception e) {
            this.writeErrorLog(sHttpResponse, e);
        }
        return lstOrgs;
    }

    @Override
    @Deprecated
    public void add(List<YzjOrgParam> orgModelList) {
        if (3 != this.config.getSyncMode()) {
            return;
        }
        if (orgModelList == null || orgModelList.isEmpty()) {
            return;
        }
        int count = orgModelList.size();
        ArrayList<String> lstFullPathOrgs = new ArrayList<String>(count);
        ArrayList<String> lstOrgsWeights = new ArrayList<String>(count);
        String rooOrgName = this.getRootOrgName();
        int rootOrgLen = rooOrgName.length();
        for (YzjOrgParam org : orgModelList) {
            if (!this.changeFullnameToDepartment(rootOrgLen, org)) continue;
            lstFullPathOrgs.add(org.getDepartment());
            lstOrgsWeights.add(org.getSortCode());
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar nowTime = Calendar.getInstance();
        nowTime.add(12, -1);
        String sGetOrgTime = dateFormat.format(nowTime.getTime());
        HashMap<String, ArrayList<String>> dep = new HashMap<String, ArrayList<String>>();
        dep.put(KEY_DEPARTMENTS, lstFullPathOrgs);
        dep.put("weights", lstOrgsWeights);
        String sHttpResponse = this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_ORG_ADD.name()), dep, orgModelList);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return;
        }
        try {
            YzjOrgsResponseModel yzjmdl = (YzjOrgsResponseModel)JSONUtils.cast((String)sHttpResponse, YzjOrgsResponseModel.class);
            if (yzjmdl == null) {
                return;
            }
            if (yzjmdl.getData().size() > 0) {
                for (YzjOrgResponse orgRes : yzjmdl.getData()) {
                    String sOrgFullPath = orgRes.getMsgId();
                    for (YzjOrgParam org : orgModelList) {
                        if (!sOrgFullPath.equalsIgnoreCase(org.getDepartment())) continue;
                        org.setSuccess(false);
                        org.setMsg(orgRes.getMsg());
                    }
                }
            } else {
                List<Map<String, String>> lstAddedOrgs = this.getYzjOrgatTime(sGetOrgTime);
                ArrayList<String> successList = new ArrayList<String>();
                if (!CollectionUtils.isEmpty(lstAddedOrgs)) {
                    for (Map map : lstAddedOrgs) {
                        String sNewOrgPath = (String)map.get("department");
                        String sNewOrgGUID = (String)map.get("id");
                        String schangeType = (String)map.get("changeType");
                        if (!schangeType.equalsIgnoreCase("1")) continue;
                        for (YzjOrgParam org : orgModelList) {
                            if (!sNewOrgPath.equalsIgnoreCase(org.getDepartment())) continue;
                            org.setSuccess(true);
                            org.setYzjOrgId(sNewOrgGUID);
                            successList.add(sNewOrgPath);
                        }
                    }
                }
                for (YzjOrgParam yzjOrgParam : orgModelList) {
                    if (successList.contains(yzjOrgParam.getDepartment())) continue;
                    yzjOrgParam.setSuccess(false);
                    yzjOrgParam.setMsg(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u65b0\u589e\u7ec4\u7ec7\u5931\u8d25\u3002", (String)"YzjOrgPubCloudService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
            }
        }
        catch (Exception e) {
            this.writeErrorLog(sHttpResponse, e);
        }
    }

    private boolean changeFullnameToDepartment(int rootOrgLen, YzjOrgParam org) {
        String fullname = org.getFullname();
        if (StringUtils.isBlank((CharSequence)fullname)) {
            org.setSuccess(false);
            org.setMsg(ResManager.loadKDString((String)"\u7ec4\u7ec7\u957f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YzjOrgPubCloudService_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (rootOrgLen == fullname.length()) {
            org.setDepartment("\\\\");
            return true;
        }
        if (fullname.indexOf(this.getFullNameSep()) == -1 || fullname.length() < rootOrgLen) {
            org.setDepartment(fullname);
        } else {
            String noRootFullname = fullname.substring(++rootOrgLen);
            String department = noRootFullname.replace(this.getFullNameSep(), "\\");
            org.setDepartment(department);
        }
        return true;
    }

    private boolean changeOldFullnameToDepartment(int rootOrgLen, YzjOrgParam org) {
        String fullname = org.getOldFullname();
        if (StringUtils.isBlank((CharSequence)fullname)) {
            org.setSuccess(false);
            org.setMsg(ResManager.loadKDString((String)"\u539f\u7ec4\u7ec7\u957f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YzjOrgPubCloudService_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (rootOrgLen == fullname.length()) {
            org.setOldDepartment("\\\\");
            return true;
        }
        String noRootFullname = fullname.substring(++rootOrgLen);
        String department = noRootFullname.replaceAll(this.getFullNameSep(), "\\");
        org.setOldDepartment(department);
        return true;
    }

    @Override
    @Deprecated
    public void delete(List<YzjOrgParam> orgModelList) {
        if (3 != this.config.getSyncMode()) {
            return;
        }
        if (CollectionUtils.isEmpty(orgModelList)) {
            return;
        }
        ArrayList<String> lstFullPathOrgs = new ArrayList<String>(orgModelList.size());
        String rooOrgName = this.getRootOrgName();
        int rootOrgLen = rooOrgName.length();
        for (YzjOrgParam org : orgModelList) {
            if (!this.changeFullnameToDepartment(rootOrgLen, org)) continue;
            lstFullPathOrgs.add(org.getDepartment());
        }
        HashMap<String, ArrayList<String>> dep = new HashMap<String, ArrayList<String>>();
        dep.put(KEY_DEPARTMENTS, lstFullPathOrgs);
        String sHttpResponse = this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_ORG_DEL.name()), dep, orgModelList);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return;
        }
        try {
            YzjOrgsResponseModel yzjmdl = (YzjOrgsResponseModel)JSONUtils.cast((String)sHttpResponse, YzjOrgsResponseModel.class);
            if (yzjmdl == null) {
                return;
            }
            if (!yzjmdl.isSuccess()) {
                for (YzjOrgParam org : orgModelList) {
                    org.setSuccess(false);
                    org.setMsg(yzjmdl.getError());
                }
                return;
            }
            ArrayList<YzjOrgResponse> dataList = yzjmdl.getData();
            if (CollectionUtils.isEmpty(dataList)) {
                return;
            }
            for (YzjOrgResponse orgRes : dataList) {
                String sOrgFullPath = orgRes.getMsgId();
                for (YzjOrgParam org : orgModelList) {
                    if (!sOrgFullPath.equalsIgnoreCase(org.getDepartment())) continue;
                    org.setSuccess(false);
                    org.setMsg(orgRes.getMsg());
                }
            }
        }
        catch (Exception e) {
            this.writeErrorLog(sHttpResponse, e);
        }
    }

    @Override
    public void deleteById(List<YzjOrgParam> orgModelList) {
        if (3 != this.config.getSyncMode()) {
            return;
        }
        if (CollectionUtils.isEmpty(orgModelList)) {
            return;
        }
        ArrayList<String> yzjOrgIds = new ArrayList<String>(orgModelList.size());
        for (YzjOrgParam org : orgModelList) {
            yzjOrgIds.add(org.getYzjOrgId());
        }
        HashMap<String, ArrayList<String>> dep = new HashMap<String, ArrayList<String>>(1);
        dep.put(KEY_DEPARTMENTS, yzjOrgIds);
        String sHttpResponse = this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_ORG_DELETEBYID.name()), dep, orgModelList);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return;
        }
        try {
            YzjOrgsResponseModel yzjmdl = (YzjOrgsResponseModel)JSONUtils.cast((String)sHttpResponse, YzjOrgsResponseModel.class);
            if (yzjmdl == null) {
                return;
            }
            if (yzjmdl.isSuccess()) {
                this.setErrorProperties(orgModelList, yzjmdl);
                return;
            }
            for (YzjOrgParam org : orgModelList) {
                org.setSuccess(false);
                org.setMsg(yzjmdl.getError());
            }
        }
        catch (Exception e) {
            this.writeErrorLog(sHttpResponse, e);
        }
    }

    @Override
    public void update(List<YzjOrgParam> orgModelList) {
        if (3 != this.config.getSyncMode()) {
            return;
        }
        if (CollectionUtils.isEmpty(orgModelList)) {
            return;
        }
        ArrayList lstPathOrgs = new ArrayList(orgModelList.size());
        String rooOrgName = this.getRootOrgName();
        int rootOrgLen = rooOrgName.length();
        for (YzjOrgParam org : orgModelList) {
            if (!this.changeFullnameToDepartment(rootOrgLen, org) || !this.changeOldFullnameToDepartment(rootOrgLen, org)) continue;
            LinkedHashMap<String, String> mpOrg = new LinkedHashMap<String, String>(2);
            mpOrg.put("department", org.getOldDepartment());
            mpOrg.put("todepartment", org.getDepartment());
            lstPathOrgs.add(mpOrg);
        }
        HashMap dep = new HashMap(1);
        dep.put(KEY_DEPARTMENTS, lstPathOrgs);
        String sHttpResponse = this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_ORG_UPDATE.name()), dep, orgModelList);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return;
        }
        try {
            YzjOrgsResponseModel yzjmdl = (YzjOrgsResponseModel)JSONUtils.cast((String)sHttpResponse, YzjOrgsResponseModel.class);
            if (yzjmdl == null) {
                return;
            }
            ArrayList<YzjOrgResponse> dataList = yzjmdl.getData();
            if (CollectionUtils.isEmpty(dataList)) {
                return;
            }
            for (YzjOrgResponse orgRes : yzjmdl.getData()) {
                String sOrgFullPath = orgRes.getMsgId();
                for (YzjOrgParam org : orgModelList) {
                    if (!sOrgFullPath.equalsIgnoreCase(org.getOldDepartment())) continue;
                    org.setSuccess(false);
                    org.setMsg(orgRes.getMsg());
                }
            }
        }
        catch (Exception e) {
            this.writeErrorLog(sHttpResponse, e);
        }
    }

    @Override
    public void move(List<YzjOrgParam> lstOrgs) {
        if (3 != this.config.getSyncMode()) {
            return;
        }
        if (lstOrgs == null || lstOrgs.size() == 0) {
            return;
        }
        if (!this.checkMoveOrg(lstOrgs, false)) {
            return;
        }
        for (YzjOrgParam org : lstOrgs) {
            this.doMoveYzjOrgs(org);
        }
    }

    @Override
    public void moveUniqueness(List<YzjOrgParam> lstOrgs) {
        if (!this.config.isEnable()) {
            logger.warn("\u7cfb\u7edf\u672a\u542f\u7528\u4e91\u4e4b\u5bb6");
            return;
        }
        if (lstOrgs == null || lstOrgs.size() == 0) {
            return;
        }
        if (!this.checkMoveOrg(lstOrgs, true)) {
            return;
        }
        for (YzjOrgParam org : lstOrgs) {
            this.doMoveYzjOrgs(org);
        }
    }

    @Deprecated
    private boolean checkMoveOrg(List<YzjOrgParam> lstOrgs, boolean isCheckExists) {
        int count = lstOrgs.size();
        ArrayList<String> yzjOrgIds = new ArrayList<String>(count);
        HashMap<String, String> yzjOrgMap = new HashMap<String, String>(count);
        for (YzjOrgParam org : lstOrgs) {
            String orgId = org.getYzjOrgId();
            String moveToOrgId = org.getMoveToYzjOrgId();
            if (StringUtils.isEmpty((CharSequence)orgId)) {
                org.setSuccess(false);
                org.setMsg(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684\u4e91\u4e4b\u5bb6ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YzjOrgPubCloudService_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)moveToOrgId)) {
                org.setSuccess(false);
                org.setMsg(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u7684\u4e91\u4e4b\u5bb6ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YzjOrgPubCloudService_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            yzjOrgIds.add(orgId);
            yzjOrgIds.add(moveToOrgId);
            yzjOrgMap.put(orgId, moveToOrgId);
        }
        if (!isCheckExists) {
            return true;
        }
        String selectFields = "id,yzjorgid,org.name name,fullname";
        QFilter[] filters = new QFilter[]{new QFilter(KEY_YZJ_ORG_ID, "in", yzjOrgIds)};
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (col == null || col.size() == 0) {
            return true;
        }
        int nameCount = col.size();
        HashMap<String, String> nameMap = new HashMap<String, String>(nameCount);
        HashMap<String, String> fullNameMap = new HashMap<String, String>(nameCount);
        for (Object org : col) {
            nameMap.put(org.getString(KEY_YZJ_ORG_ID), org.getString("name"));
            fullNameMap.put(org.getString(KEY_YZJ_ORG_ID), org.getString(KEY_FULL_NAME));
        }
        ArrayList<String> newFullNames = new ArrayList<String>(yzjOrgMap.size());
        for (Map.Entry entry : yzjOrgMap.entrySet()) {
            String name = (String)nameMap.get(entry.getKey());
            String parentFullName = (String)fullNameMap.get(entry.getValue());
            if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)parentFullName)) continue;
            String newFullName = parentFullName + "_" + name;
            newFullNames.add(newFullName);
        }
        filters = new QFilter[]{new QFilter(KEY_FULL_NAME, "in", newFullNames)};
        col = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (col == null || col.size() == 0) {
            return true;
        }
        HashMap<String, String> existsFullNameMap = new HashMap<String, String>(col.size());
        for (DynamicObject org : col) {
            existsFullNameMap.put(org.getString(KEY_YZJ_ORG_ID), org.getString(KEY_FULL_NAME));
        }
        for (YzjOrgParam orgModel : lstOrgs) {
            if (!existsFullNameMap.containsKey(orgModel.getYzjOrgId())) continue;
            orgModel.setSuccess(false);
            orgModel.setMsg(ResManager.loadKDString((String)"\u90e8\u95e8\u79fb\u52a8\u5931\u8d25\uff1a\u76ee\u6807\u90e8\u95e8\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u3002", (String)"YzjOrgPubCloudService_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        return false;
    }

    private boolean doMoveYzjOrgs(YzjOrgParam org) {
        HashMap<String, String> dep = new HashMap<String, String>(2);
        dep.put(KEY_ORG_ID, org.getYzjOrgId());
        dep.put("moveToOrgId", org.getMoveToYzjOrgId());
        ArrayList<YzjOrgParam> orgModelList = new ArrayList<YzjOrgParam>();
        orgModelList.add(org);
        String sHttpResponse = this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_ORG_MOVE.name()), dep, orgModelList);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return false;
        }
        try {
            Map yzjRes = (Map)JSONUtils.cast((String)sHttpResponse, Map.class);
            if (yzjRes != null && yzjRes.get("success") != null && "false".equals(yzjRes.get("success").toString().toLowerCase(Locale.ENGLISH))) {
                org.setSuccess(false);
                org.setMsg(String.valueOf(yzjRes.get("error")));
                return false;
            }
        }
        catch (Exception e) {
            this.writeErrorLog(sHttpResponse, e);
        }
        return true;
    }

    @Override
    @Deprecated
    public void updateNameById(List<YzjOrgParam> orgModelList) {
        if (this.isStopExecute(orgModelList)) {
            return;
        }
        ArrayList lstPathOrgs = new ArrayList(orgModelList.size());
        for (YzjOrgParam org : orgModelList) {
            LinkedHashMap<String, String> mpOrg = new LinkedHashMap<String, String>(2);
            mpOrg.put(KEY_ORG_ID, org.getYzjOrgId());
            mpOrg.put("todepartment", org.getName());
            lstPathOrgs.add(mpOrg);
        }
        HashMap dep = new HashMap(1);
        dep.put(KEY_DEPARTMENTS, lstPathOrgs);
        String sHttpResponse = this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_ORG_UPDATE_NAME_BY_ID.name()), dep, orgModelList);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return;
        }
        try {
            this.handleErrorData(orgModelList, sHttpResponse);
        }
        catch (Exception e) {
            this.writeErrorLog(sHttpResponse, e);
        }
    }

    private void handleErrorData(List<YzjOrgParam> orgModelList, String sHttpResponse) throws IOException {
        YzjOrgsResponseModel yzjmdl = (YzjOrgsResponseModel)JSONUtils.cast((String)sHttpResponse, YzjOrgsResponseModel.class);
        if (yzjmdl == null || yzjmdl.getData() == null) {
            return;
        }
        this.setErrorProperties(orgModelList, yzjmdl);
    }

    private void setErrorProperties(List<YzjOrgParam> orgModelList, YzjOrgsResponseModel yzjmdl) {
        ArrayList<YzjOrgResponse> dataList = yzjmdl.getData();
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        for (YzjOrgResponse orgRes : dataList) {
            String sOrgFullPath = orgRes.getMsgId();
            for (YzjOrgParam org : orgModelList) {
                if (!sOrgFullPath.equalsIgnoreCase(org.getYzjOrgId())) continue;
                org.setSuccess(false);
                org.setMsg(orgRes.getMsg());
            }
        }
    }

    private boolean isStopExecute(List<YzjOrgParam> orgModelList) {
        if (3 != this.config.getSyncMode()) {
            return true;
        }
        return CollectionUtils.isEmpty(orgModelList);
    }

    @Override
    public void updateWeightById(List<YzjOrgParam> orgModelList) {
        if (this.isStopExecute(orgModelList)) {
            return;
        }
        ArrayList lstPathOrgs = new ArrayList(orgModelList.size());
        for (YzjOrgParam org : orgModelList) {
            LinkedHashMap<String, String> mpOrg = new LinkedHashMap<String, String>();
            mpOrg.put(KEY_ORG_ID, org.getYzjOrgId());
            mpOrg.put("weights", org.getSortCode());
            lstPathOrgs.add(mpOrg);
        }
        HashMap dep = new HashMap(1);
        dep.put(KEY_DEPARTMENTS, lstPathOrgs);
        String sHttpResponse = this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_ORG_UPDATE_WEIGTH.name()), dep, orgModelList);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return;
        }
        try {
            this.handleErrorData(orgModelList, sHttpResponse);
        }
        catch (Exception e) {
            logger.info("\u66f4\u65b0\u4e91\u4e4b\u5bb6\u7ec4\u7ec7\u6743\u91cd\u5931\u8d25\uff1a" + sHttpResponse + e.getMessage());
        }
    }

    private String genResponse(String api, Object param, List<YzjOrgParam> orgModelList) {
        YzjData yzjData = new YzjData();
        yzjData.setApi(api);
        yzjData.setParams(param);
        this.post(yzjData);
        String response = yzjData.getResponse();
        if (!yzjData.isSuccess()) {
            if (orgModelList != null) {
                for (YzjOrgParam org : orgModelList) {
                    org.setSuccess(false);
                    org.setMsg(yzjData.getMsg());
                }
            }
            return "";
        }
        if (StringUtils.isBlank((CharSequence)response)) {
            if (orgModelList != null) {
                for (YzjOrgParam org : orgModelList) {
                    org.setSuccess(false);
                    org.setMsg(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"YzjOrgPubCloudService_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
            }
            return "";
        }
        return response;
    }

    @Override
    public YzjData getAll() {
        YzjData yzjData = new YzjData();
        yzjData.setApi(this.getApi(this.config, YzjApiEnum.YZJ_ORG_GETALL.name()));
        yzjData.setGetAll(true);
        this.getData(yzjData);
        return yzjData;
    }

    @Override
    public List<Map<String, Object>> getByFullname(int type, List<YzjOrgParam> orgList) {
        String rootOrgName = this.getRootOrgName();
        int rootOrgLen = rootOrgName.length();
        for (YzjOrgParam orgModel : orgList) {
            this.changeFullnameToDepartment(rootOrgLen, orgModel);
        }
        return this.get(type, orgList);
    }

    @Override
    public List<Map<String, Object>> get(int type, List<YzjOrgParam> orgList) {
        if (orgList == null || orgList.isEmpty()) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<String> paramList = new ArrayList<String>(orgList.size());
        String rootOrgName = this.getRootOrgName();
        int rootOrgLen = rootOrgName.length();
        for (YzjOrgParam orgModel : orgList) {
            String key = "";
            if (type == 0) {
                key = orgModel.getYzjOrgId();
            } else {
                this.changeFullnameToDepartment(rootOrgLen, orgModel);
                key = orgModel.getDepartment();
            }
            if (!StringUtils.isNotBlank((CharSequence)key)) continue;
            paramList.add(key);
        }
        if (paramList.isEmpty()) {
            return new ArrayList<Map<String, Object>>(0);
        }
        HashMap<String, Serializable> param = new HashMap<String, Serializable>(1);
        param.put("type", Integer.valueOf(type));
        param.put("array", paramList);
        YzjData yzjData = new YzjData();
        yzjData.setApi(this.getApi(this.config, YzjApiEnum.YZJ_ORG_GET.name()));
        yzjData.setParams(param);
        this.getData(yzjData);
        if (yzjData.isSuccess()) {
            return yzjData.getDataList();
        }
        return new ArrayList<Map<String, Object>>(0);
    }

    @Override
    public String transferOrgFullnameToYzjFormat(String fullname, String rootOrgName) {
        if (StringUtils.isBlank((CharSequence)fullname)) {
            return fullname;
        }
        if (StringUtils.isBlank((CharSequence)rootOrgName)) {
            rootOrgName = this.getRootOrgName();
        }
        if (StringUtils.isBlank((CharSequence)rootOrgName)) {
            return fullname;
        }
        if (fullname.equals(rootOrgName)) {
            return "\\\\";
        }
        if ((fullname = fullname.replaceFirst(rootOrgName + this.getFullNameSep(), "")).indexOf(this.getFullNameSep()) > 0) {
            fullname = fullname.replace(this.getFullNameSep(), "\\");
        }
        return fullname;
    }

    @Override
    public String getRootOrgName() {
        QFilter orgFilter = new QFilter("id", "=", (Object)OrgUnitServiceHelper.getRootOrgId());
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,name", (QFilter[])filters);
        if (org == null) {
            return "";
        }
        return org.getString("name");
    }

    private void writeErrorLog(String httpResponse, Exception e) {
        logger.info("\u4e91\u4e4b\u5bb6\u540c\u6b65\u6570\u636e\u5931\u8d25\uff1a" + httpResponse + e.getMessage());
    }
}

