/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.yzj.impl.user;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.yzj.impl.YzjApiEnum;
import kd.bos.yzj.impl.YzjService;
import kd.bos.yzj.interfaces.IYzjUserService;
import kd.bos.yzj.model.YzjApiRes;
import kd.bos.yzj.model.YzjConfig;
import kd.bos.yzj.model.YzjData;
import kd.bos.yzj.model.user.YzjEmailParam;
import kd.bos.yzj.model.user.YzjPhoneParam;
import kd.bos.yzj.model.user.YzjUserAccount;
import kd.bos.yzj.model.user.YzjUserModel;
import kd.bos.yzj.model.user.YzjUsersResponseModel;
import kd.bos.yzj.util.YzjUtils;

public class YzjUserPubCloudService
extends YzjService
implements IYzjUserService {
    private static Log logger = LogFactory.getLog(YzjUserPubCloudService.class);
    private static final String SYSTEM_TYPE = "bos-yunzhijia";
    private static final String PARAM_PERSONS = "persons";
    private static final String KEY_JOB_TITLE = "jobTitle";
    private static final String KEY_DEPARTMENT = "department";
    private static final String KEY_EMAIL = "email";
    private static final String KEY_PHONE = "phone";
    private static final String KEY_OPEN_ID = "openId";
    private static final String KEY_LEADER_OPEN_ID = "leaderOpenId";
    private static final String KEY_ORG_ID = "orgId";
    private static final String KEY_COMMIT_ID = "commitId";
    private static final String KEY_MSG_ID = "msgId";

    public YzjUserPubCloudService(YzjConfig config) {
        super(config);
    }

    @Override
    public Map<String, Object> getUser(int type, String userkey) {
        if (StringUtils.isBlank((CharSequence)userkey)) {
            return new HashMap<String, Object>(0);
        }
        ArrayList<YzjUserModel> userList = new ArrayList<YzjUserModel>(1);
        YzjUserModel userModel = new YzjUserModel();
        if (type == 0) {
            userModel.setPhone(userkey);
        } else {
            userModel.setOpenId(userkey);
        }
        userList.add(userModel);
        List<Map<String, Object>> yzjUserList = this.getUsers(type, userList);
        if (yzjUserList == null || yzjUserList.isEmpty()) {
            return new HashMap<String, Object>(0);
        }
        return yzjUserList.get(0);
    }

    @Override
    public List<Map<String, Object>> getUsers(int type, List<YzjUserModel> userList) {
        if (!this.config.isEnable()) {
            logger.warn("\u7cfb\u7edf\u672a\u542f\u7528\u4e91\u4e4b\u5bb6");
            return Collections.emptyList();
        }
        if (type != 0 && type != 1) {
            logger.error("\u4e91\u4e4b\u5bb6\u67e5\u8be2\u4eba\u5458\u7684\u7c7b\u578btype\u53ea\u80fd\u662f0\uff1a\u624b\u673a\u53f7\u7801\uff0c1\uff1aopenId");
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(userList)) {
            return Collections.emptyList();
        }
        String sHttpResponse = this.getUserInfoFromYzj(type, userList);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return Collections.emptyList();
        }
        try {
            Map mpGetUser = (Map)JSONUtils.cast((String)sHttpResponse, HashMap.class, (boolean)true);
            if (mpGetUser == null || StringUtils.isBlank(mpGetUser.get("data"))) {
                String msg = ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u4eba\u5458\u67e5\u8be2\u5931\u8d25: \u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"YzjUserPubCloudService_8", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                for (YzjUserModel userModel : userList) {
                    userModel.setOperSuccess(false);
                    userModel.setOperMsg(msg);
                }
                return Collections.emptyList();
            }
            YzjUsersResponseModel yzjmdl = (YzjUsersResponseModel)JSONUtils.cast((String)sHttpResponse, YzjUsersResponseModel.class, (boolean)true);
            if (!yzjmdl.isSuccess()) {
                for (YzjUserModel userModel : userList) {
                    userModel.setOperSuccess(false);
                    userModel.setOperMsg(yzjmdl.getError());
                }
                return Collections.emptyList();
            }
            logger.info("@.........\u4e91\u4e4b\u5bb6\u4eba\u5458\u67e5\u8be2\u6210\u529f\u3002");
            ArrayList<Map<String, Object>> dataList = yzjmdl.getData();
            this.formatToCosmicPhone(dataList);
            return dataList;
        }
        catch (Exception e) {
            throw new KDBizException(this.getExceptionMessage(e.getMessage(), sHttpResponse));
        }
    }

    private String getUserInfoFromYzj(int type, List<YzjUserModel> userList) {
        ArrayList<String> lstUsers = new ArrayList<String>(userList.size());
        for (YzjUserModel userModel : userList) {
            if (type == 0) {
                String phone = userModel.getPhone();
                if (!StringUtils.isNotBlank((CharSequence)phone)) continue;
                lstUsers.add(YzjUtils.formatToYzjPhone(phone));
                continue;
            }
            String openId = userModel.getOpenId();
            if (!StringUtils.isNotBlank((CharSequence)openId)) continue;
            lstUsers.add(openId);
        }
        HashMap<String, Object> mpUsers = new HashMap<String, Object>(3);
        mpUsers.put("eid", this.config.getEid());
        mpUsers.put("type", type);
        mpUsers.put("array", lstUsers);
        return this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_USER_GET.name()), mpUsers, userList);
    }

    @Override
    public void getUser(int type, List<YzjUserModel> userList) {
        List<Map<String, Object>> resultList = this.getUsers(type, userList);
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        block0: for (Map<String, Object> userMap : resultList) {
            String openId = String.valueOf(userMap.get(KEY_OPEN_ID));
            String phone = YzjUtils.formatToCosmicPhone(String.valueOf(userMap.get(KEY_PHONE)));
            String email = String.valueOf(userMap.get(KEY_EMAIL));
            for (YzjUserModel userModel : userList) {
                if (!(StringUtils.isNotBlank((CharSequence)openId) && openId.equalsIgnoreCase(userModel.getOpenId()) || StringUtils.isNotBlank((CharSequence)phone) && phone.equalsIgnoreCase(YzjUtils.formatToCosmicPhone(userModel.getPhone()))) && (!StringUtils.isNotBlank((CharSequence)email) || !email.equalsIgnoreCase(userModel.getEmail()))) continue;
                userModel.setOperSuccess(true);
                userModel.setOpenId(openId);
                userModel.setName(String.valueOf(userMap.get("name")));
                userModel.setPhotoUrl(String.valueOf(userMap.get("photoUrl")));
                userModel.setPhone(phone);
                userModel.setEmail(email);
                userModel.setDepartment(String.valueOf(userMap.get(KEY_DEPARTMENT)));
                userModel.setJobNo(String.valueOf(userMap.get("jobNo")));
                userModel.setJobTitle(String.valueOf(userMap.get(KEY_JOB_TITLE)));
                String gender = String.valueOf(userMap.get("gender"));
                userModel.setGender("0".equals(gender) ? "" : gender);
                String status = String.valueOf(userMap.get("status"));
                userModel.setStatus("1".equals(status) ? status : "0");
                userModel.setOrgUserType(Integer.parseInt(String.valueOf(userMap.get("orgUserType"))));
                continue block0;
            }
        }
    }

    @Override
    public void add(List<YzjUserModel> userList) {
        if (3 != this.config.getSyncMode()) {
            return;
        }
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        this.formatParameter(userList, null, false);
        HashMap<String, List<YzjUserModel>> mpUsers = new HashMap<String, List<YzjUserModel>>();
        mpUsers.put(PARAM_PERSONS, userList);
        String sHttpResponse = this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_USER_ADD.name()), mpUsers, userList);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return;
        }
        try {
            YzjUsersResponseModel yzjmdl = (YzjUsersResponseModel)JSONUtils.cast((String)sHttpResponse, YzjUsersResponseModel.class);
            logger.info("@.........\u4e91\u4e4b\u5bb6\u4eba\u5458\u521b\u5efa\u6210\u529f\u3002");
            if (null == yzjmdl) {
                return;
            }
            boolean bUpdateUserPartJobs = false;
            if (yzjmdl.isSuccess()) {
                ArrayList<Map<String, Object>> dataList = yzjmdl.getData();
                bUpdateUserPartJobs = this.isUpdateUserPartJobs(userList, dataList);
            } else {
                String msg = yzjmdl.getError();
                for (YzjUserModel erpUser : userList) {
                    erpUser.setOperSuccess(false);
                    erpUser.setOperMsg(msg);
                }
            }
            logger.info("@.........\u662f\u5426\u540c\u6b65\u66f4\u65b0\u4eba\u5458\u7684\u517c\u804c\u90e8\u95e8\u5206\u6790\u5b8c\u6210\u3002");
            if (bUpdateUserPartJobs) {
                this.updateUserPartJob(userList);
            }
        }
        catch (Exception e) {
            throw new KDBizException(this.getExceptionMessage(e.getMessage(), sHttpResponse));
        }
    }

    private void formatParameter(List<YzjUserModel> userList, List<YzjUserModel> userJobNoList, boolean defaultOperSuccess) {
        for (YzjUserModel user : userList) {
            if (defaultOperSuccess) {
                user.setOperSuccess(true);
            }
            user.setPhone(YzjUtils.formatToYzjPhone(user.getPhone()));
            YzjUserAccount account = user.getAccount();
            if (account != null && account.getMobile() != null) {
                account.setMobile(YzjUtils.formatToYzjPhone(account.getMobile()));
            }
            if ("0".equals(user.getJobNo())) {
                user.setJobNo("");
            } else if (userJobNoList != null) {
                userJobNoList.add(user);
            }
            if (user.getBirthday() != null) continue;
            user.setBirthday("");
        }
    }

    private boolean isUpdateUserPartJobs(List<YzjUserModel> userList, ArrayList<Map<String, Object>> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return false;
        }
        boolean bUpdateUserPartJobs = false;
        for (Map<String, Object> mpYzjUser : dataList) {
            String phone = String.valueOf(mpYzjUser.get(KEY_PHONE));
            String openId = mpYzjUser.get(KEY_OPEN_ID).toString();
            String email = String.valueOf(mpYzjUser.get(KEY_EMAIL));
            String msgId = mpYzjUser.get(KEY_MSG_ID).toString();
            String msg = mpYzjUser.get("msg").toString();
            String msgCode = String.valueOf(mpYzjUser.get("msgCode"));
            boolean bSuccess = true;
            if (!openId.equalsIgnoreCase(msgId) || StringUtils.isNotBlank((CharSequence)phone) && YzjUtils.formatToYzjPhone(phone).equalsIgnoreCase(msgId) || StringUtils.isNotBlank((CharSequence)email) && email.equals(msgId)) {
                bSuccess = false;
            } else if ("100029".equals(msgCode)) {
                bSuccess = false;
            }
            phone = YzjUtils.formatToCosmicPhone(phone);
            for (YzjUserModel erpUser : userList) {
                boolean isSameUser;
                if (!erpUser.isOperSuccess() || !(isSameUser = StringUtils.isNotBlank((CharSequence)phone) && phone.equalsIgnoreCase(YzjUtils.formatToCosmicPhone(erpUser.getPhone())) || StringUtils.isNotBlank((CharSequence)email) && email.equalsIgnoreCase(erpUser.getEmail()))) continue;
                if (!bSuccess) {
                    erpUser.setOperSuccess(false);
                    erpUser.setOperMsg(msg);
                    erpUser.setPhone(phone);
                    continue;
                }
                erpUser.setOperSuccess(true);
                erpUser.setOpenId(openId);
                erpUser.setPhone(phone);
                erpUser.setEmail(email);
                bUpdateUserPartJobs = true;
            }
        }
        return bUpdateUserPartJobs;
    }

    private void updateUserPartJob(List<YzjUserModel> lstUsers) {
        int count = lstUsers.size();
        ArrayList lstAddedPartJobs = new ArrayList(count);
        String sAddUUID = UUID.randomUUID().toString();
        ArrayList<String> openIds = new ArrayList<String>(count);
        HashMap<String, YzjUserModel> userMap = new HashMap<String, YzjUserModel>(count);
        for (YzjUserModel erpUser : lstUsers) {
            String openId = erpUser.getOpenId();
            userMap.put(openId, erpUser);
            if (!erpUser.isOperSuccess()) continue;
            openIds.add(openId);
            List<Map<String, String>> partJob = erpUser.getPartJob();
            if (CollectionUtils.isEmpty(partJob)) continue;
            for (Map<String, String> mpJob : partJob) {
                String orgId = mpJob.get(KEY_ORG_ID);
                if (StringUtils.isBlank((CharSequence)orgId)) continue;
                HashMap<String, String> userAddJobs = new HashMap<String, String>(4);
                userAddJobs.put(KEY_COMMIT_ID, sAddUUID);
                userAddJobs.put(KEY_OPEN_ID, erpUser.getOpenId());
                userAddJobs.put(KEY_ORG_ID, orgId);
                userAddJobs.put(KEY_JOB_TITLE, mpJob.get(KEY_JOB_TITLE));
                lstAddedPartJobs.add(userAddJobs);
            }
        }
        if (CollectionUtils.isEmpty(openIds)) {
            return;
        }
        try {
            ArrayList<Map<String, String>> lstDelPartJobs = new ArrayList<Map<String, String>>(count);
            this.getDelPartJobs(openIds, lstDelPartJobs);
            if (!lstDelPartJobs.isEmpty()) {
                this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_USER_DELPARTJOB.name()), lstDelPartJobs, lstUsers);
            }
            this.updateOrgById(lstUsers);
            if (!lstAddedPartJobs.isEmpty()) {
                this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_USER_ADDPARTJOB.name()), lstAddedPartJobs, lstUsers);
            }
            Map<String, List<String>> allSuperiorMap = this.getAllSuperiorMap();
            this.compareSuperior(allSuperiorMap, userMap);
            this.deleteSuperior(lstUsers);
            this.addSuperior(lstUsers);
        }
        catch (Exception e) {
            logger.error("@.........\u4e91\u4e4b\u5bb6\u4eba\u5458\u4fee\u6539\u517c\u804c\u90e8\u95e8\u5931\u8d25:" + e.getMessage());
        }
    }

    private Map<String, List<String>> getAllSuperiorMap() {
        YzjData allSuperior = this.getAllSuperior();
        List<Map<String, Object>> dataList = allSuperior.getDataList();
        if (CollectionUtils.isEmpty(dataList)) {
            return new HashMap<String, List<String>>(0);
        }
        HashMap<String, List<String>> superiorMap = new HashMap<String, List<String>>(dataList.size());
        for (Map<String, Object> yzjDataMap : dataList) {
            String openId = String.valueOf(yzjDataMap.get(KEY_OPEN_ID));
            String leaderOpenId = String.valueOf(yzjDataMap.get(KEY_LEADER_OPEN_ID));
            ArrayList<String> leaderOpenIds = (ArrayList<String>)superiorMap.get(openId);
            if (leaderOpenIds == null) {
                leaderOpenIds = new ArrayList<String>();
                superiorMap.put(openId, leaderOpenIds);
            }
            leaderOpenIds.add(leaderOpenId);
        }
        return superiorMap;
    }

    private void compareSuperior(Map<String, List<String>> allSuperiorMap, Map<String, YzjUserModel> userMap) {
        for (Map.Entry<String, YzjUserModel> userModelEntry : userMap.entrySet()) {
            String openId = userModelEntry.getKey();
            List<String> yzjSuperiorOpenIds = allSuperiorMap.get(openId);
            if (CollectionUtils.isEmpty(yzjSuperiorOpenIds)) continue;
            YzjUserModel userModel = userModelEntry.getValue();
            List<String> addSuperiorList = userModel.getAddSuperiorList();
            if (CollectionUtils.isEmpty(addSuperiorList)) {
                userModel.setDeleteSuperiorList(yzjSuperiorOpenIds);
                continue;
            }
            ArrayList<String> deleteYzjSuperiorOpenIds = new ArrayList<String>(yzjSuperiorOpenIds);
            deleteYzjSuperiorOpenIds.removeAll(addSuperiorList);
            userModel.setDeleteSuperiorList(deleteYzjSuperiorOpenIds);
            addSuperiorList.removeAll(yzjSuperiorOpenIds);
        }
    }

    private void getDelPartJobs(List<String> openIds, List<Map<String, String>> lstDelPartJobs) {
        String selectFields = "id,useropenid,entryentity.dpt.fyzjorgid fyzjorgid,entryentity.ispartjob ispartjob,entryentity.superior.useropenid leaderopenid";
        QFilter idFilter = new QFilter("useropenid", "in", openIds);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObjectCollection userCol = QueryServiceHelper.query((String)"bos_user", (String)selectFields, (QFilter[])filters);
        if (userCol == null || userCol.size() == 0) {
            return;
        }
        for (DynamicObject user : userCol) {
            String openId = user.getString("useropenid");
            if (!user.getBoolean("ispartjob")) continue;
            HashMap<String, String> userDelJobs = new HashMap<String, String>();
            String yzjOrgId = user.getString("fyzjorgid");
            userDelJobs.put(KEY_COMMIT_ID, yzjOrgId);
            userDelJobs.put(KEY_OPEN_ID, openId);
            userDelJobs.put(KEY_ORG_ID, yzjOrgId);
            lstDelPartJobs.add(userDelJobs);
        }
    }

    @Override
    public void update(List<YzjUserModel> userList) {
        if (3 != this.config.getSyncMode()) {
            return;
        }
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        ArrayList<YzjUserModel> userJobNoList = new ArrayList<YzjUserModel>(userList.size());
        this.formatParameter(userList, userJobNoList, true);
        this.updateJobNoByOpenIds(userJobNoList);
        ArrayList<YzjUserModel> userUpdateList = new ArrayList<YzjUserModel>(userList.size());
        for (YzjUserModel user : userList) {
            if (!user.isOperSuccess()) continue;
            userUpdateList.add(user);
        }
        if (userUpdateList.isEmpty()) {
            return;
        }
        HashMap<String, ArrayList<YzjUserModel>> mpUsers = new HashMap<String, ArrayList<YzjUserModel>>(1);
        mpUsers.put(PARAM_PERSONS, userUpdateList);
        String sHttpResponse = this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_USER_UPDATE_INFO.name()), mpUsers, userUpdateList);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return;
        }
        try {
            YzjUsersResponseModel yzjmdl = (YzjUsersResponseModel)JSONUtils.cast((String)sHttpResponse, YzjUsersResponseModel.class);
            if (yzjmdl == null) {
                logger.info("@.........\u4e91\u4e4b\u5bb6\u4eba\u5458\u4fee\u6539\u6210\u529f\u3002");
                return;
            }
            boolean bUpdateDept = false;
            if (yzjmdl.isSuccess()) {
                bUpdateDept = this.isUpdateDept(userUpdateList, yzjmdl);
            } else {
                String msg = yzjmdl.getError();
                for (YzjUserModel erpUser : userUpdateList) {
                    erpUser.setOperSuccess(false);
                    erpUser.setOperMsg(msg);
                }
            }
            logger.info("@.........\u662f\u5426\u66f4\u65b0\u4eba\u5458\u7684\u90e8\u95e8\u548c\u517c\u804c\u804c\u4f4d\u5206\u6790\u5b8c\u6210\u3002");
            if (bUpdateDept) {
                this.updateUserPartJob(userUpdateList);
            } else {
                this.updateOrgById(userUpdateList);
            }
            logger.info("@.........\u4e91\u4e4b\u5bb6\u4eba\u5458\u4fee\u6539\u6210\u529f\u3002");
        }
        catch (Exception e) {
            throw new KDBizException(this.getExceptionMessage(e.getMessage(), sHttpResponse));
        }
    }

    private boolean isUpdateDept(List<YzjUserModel> userList, YzjUsersResponseModel yzjmdl) {
        ArrayList<Map<String, Object>> dataList = yzjmdl.getData();
        if (CollectionUtils.isEmpty(dataList)) {
            return false;
        }
        boolean bUpdateDept = false;
        for (Map<String, Object> mpYzjUser : yzjmdl.getData()) {
            String openId = mpYzjUser.get(KEY_OPEN_ID).toString();
            String msgId = mpYzjUser.get(KEY_MSG_ID).toString();
            String msg = mpYzjUser.get("msg").toString();
            boolean bSuccess = openId.equalsIgnoreCase(msgId);
            for (YzjUserModel erpUser : userList) {
                if (StringUtils.isBlank((CharSequence)openId) || !openId.equals(erpUser.getOpenId())) continue;
                if (!bSuccess) {
                    erpUser.setOperSuccess(false);
                    erpUser.setOperMsg(msg);
                    continue;
                }
                erpUser.setOperSuccess(true);
                erpUser.setOpenId(openId);
                bUpdateDept = true;
            }
        }
        return bUpdateDept;
    }

    @Override
    public void delete(List<YzjUserModel> userList) {
        if (3 != this.config.getSyncMode()) {
            return;
        }
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        ArrayList<String> openIds = new ArrayList<String>(userList.size());
        for (YzjUserModel userModel : userList) {
            openIds.add(userModel.getOpenId());
        }
        HashMap<String, ArrayList<String>> mpUsers = new HashMap<String, ArrayList<String>>();
        mpUsers.put("openIds", openIds);
        String sHttpResponse = this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_USER_DEL.name()), mpUsers, userList);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return;
        }
        try {
            YzjUsersResponseModel yzjmdl = (YzjUsersResponseModel)JSONUtils.cast((String)sHttpResponse, YzjUsersResponseModel.class);
            if (yzjmdl != null && !yzjmdl.isSuccess()) {
                for (YzjUserModel userModel : userList) {
                    userModel.setOperMsg(yzjmdl.getError());
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(this.getExceptionMessage(e.getMessage(), sHttpResponse));
        }
    }

    @Override
    public boolean updatePhone(List<Map<String, String>> lstUsers) {
        this.validateParam(lstUsers);
        ArrayList<YzjPhoneParam> params = new ArrayList<YzjPhoneParam>(lstUsers.size());
        YzjPhoneParam phoneParam = null;
        for (Map<String, String> mp : lstUsers) {
            phoneParam = new YzjPhoneParam(mp.get(KEY_OPEN_ID), mp.get(KEY_PHONE));
            params.add(phoneParam);
        }
        List<YzjApiRes> resList = this.batchUpdatePhone(params);
        for (YzjApiRes res : resList) {
            if (res.isSuccess()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addOrgAdmin(List<YzjUserModel> userList) {
        if (3 != this.config.getSyncMode()) {
            return;
        }
        if (CollectionUtils.isEmpty(userList) || userList.size() > 1000) {
            return;
        }
        ArrayList adminList = new ArrayList(userList.size());
        for (YzjUserModel user : userList) {
            HashMap<String, Object> mpUsers = new HashMap<String, Object>(4);
            mpUsers.put(KEY_DEPARTMENT, user.getDepartment());
            mpUsers.put(KEY_OPEN_ID, user.getOpenId());
            mpUsers.put("weights", user.getWeights());
            mpUsers.put(KEY_COMMIT_ID, user.getDepartmentID());
            adminList.add(mpUsers);
        }
        String sHttpResponse = this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_USER_SET_ORG_ADMINS.name()), adminList, userList);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return;
        }
        try {
            YzjUsersResponseModel yzjmdl = (YzjUsersResponseModel)JSONUtils.cast((String)sHttpResponse, YzjUsersResponseModel.class);
            if (null == yzjmdl || CollectionUtils.isEmpty(yzjmdl.getData())) {
                logger.info("@.........YzjUsersResponseModel\u4e3anull\u6216\u8005data\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u4e91\u4e4b\u5bb6\u6279\u91cf\u8bbe\u7f6e\u90e8\u95e8\u8d1f\u8d23\u4eba\u6210\u529f\u3002");
                return;
            }
            for (Map<String, Object> resultMap : yzjmdl.getData()) {
                for (YzjUserModel user : userList) {
                    if (!String.valueOf(user.getDepartmentID()).equalsIgnoreCase(String.valueOf(resultMap.get(KEY_COMMIT_ID)))) continue;
                    user.setOperSuccess(false);
                    user.setOperMsg(String.valueOf(resultMap.get("errorMsg")));
                }
            }
            logger.info("@.........\u4e91\u4e4b\u5bb6\u6279\u91cf\u8bbe\u7f6e\u90e8\u95e8\u8d1f\u8d23\u4eba\u6210\u529f\u3002");
        }
        catch (Exception e) {
            throw new KDBizException(this.getExceptionMessage(e.getMessage(), sHttpResponse));
        }
    }

    @Override
    public void deleteOrgAdmin(List<YzjUserModel> userList) {
        if (3 != this.config.getSyncMode()) {
            return;
        }
        if (CollectionUtils.isEmpty(userList) || userList.size() > 1000) {
            return;
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(2);
        params.put("deleteAll", Boolean.FALSE);
        ArrayList adminList = new ArrayList(userList.size());
        for (YzjUserModel user : userList) {
            HashMap<String, Object> mpUsers = new HashMap<String, Object>();
            mpUsers.put(KEY_DEPARTMENT, user.getDepartment());
            mpUsers.put(KEY_OPEN_ID, user.getOpenId());
            mpUsers.put(KEY_COMMIT_ID, user.getDepartmentID());
            adminList.add(mpUsers);
        }
        params.put("list", adminList);
        String sHttpResponse = this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_USER_DEL_ORG_ADMINS.name()), params, userList);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return;
        }
        try {
            YzjUsersResponseModel yzjmdl = (YzjUsersResponseModel)JSONUtils.cast((String)sHttpResponse, YzjUsersResponseModel.class);
            if (null == yzjmdl || CollectionUtils.isEmpty(yzjmdl.getData())) {
                logger.info("@.........yzjmdl\u4e3anull\u6216\u8005data\u4e3a\u7a7a\uff0c\u4e91\u4e4b\u5bb6\u6279\u91cf\u5220\u9664\u90e8\u95e8\u8d1f\u8d23\u4eba\u6210\u529f\u3002");
                return;
            }
            for (Map<String, Object> resultMap : yzjmdl.getData()) {
                for (YzjUserModel user : userList) {
                    if (!String.valueOf(user.getDepartmentID()).equalsIgnoreCase(String.valueOf(resultMap.get(KEY_COMMIT_ID)))) continue;
                    user.setOperSuccess(false);
                    user.setOperMsg(String.valueOf(resultMap.get("error")));
                }
            }
            logger.info("@.........\u4e91\u4e4b\u5bb6\u6279\u91cf\u5220\u9664\u90e8\u95e8\u8d1f\u8d23\u4eba\u6210\u529f\u3002");
        }
        catch (Exception e) {
            throw new KDBizException(this.getExceptionMessage(e.getMessage(), sHttpResponse));
        }
    }

    @Override
    public void updateStatus(List<YzjUserModel> userModelList) {
    }

    @Override
    public void updateOrgById(List<YzjUserModel> userModelList) {
        if (3 != this.config.getSyncMode()) {
            return;
        }
        if (CollectionUtils.isEmpty(userModelList)) {
            logger.warn("\u4eba\u5458\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        HashMap paramMap = new HashMap();
        ArrayList userMapList = new ArrayList(userModelList.size());
        for (YzjUserModel user : userModelList) {
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put(KEY_OPEN_ID, user.getOpenId());
            userMap.put(KEY_ORG_ID, user.getYzjOrgId());
            userMapList.add(userMap);
        }
        paramMap.put(PARAM_PERSONS, userMapList);
        String sHttpResponse = this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_USER_UPDATE_DEPT_BY_DEPTID.name()), paramMap, userModelList);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return;
        }
        try {
            YzjUsersResponseModel yzjmdl = (YzjUsersResponseModel)JSONUtils.cast((String)sHttpResponse, YzjUsersResponseModel.class);
            if (null == yzjmdl || CollectionUtils.isEmpty(yzjmdl.getData())) {
                logger.info("@.........YzjUsersResponseModel\u4e3anull\u6216\u8005data\u4e3a\u7a7a\uff0c\u4e91\u4e4b\u5bb6\u901a\u8fc7\u7ec4\u7ec7id\u66f4\u65b0\u4eba\u5458\u7ec4\u7ec7\u6210\u529f.");
                return;
            }
            for (Map<String, Object> resultMap : yzjmdl.getData()) {
                if (StringUtils.isBlank((Object)resultMap.get("msg"))) continue;
                for (YzjUserModel user : userModelList) {
                    if (!String.valueOf(user.getOpenId()).equalsIgnoreCase(String.valueOf(resultMap.get(KEY_MSG_ID)))) continue;
                    user.setOperSuccess(false);
                    user.setOperMsg(String.valueOf(resultMap.get("msg")));
                }
            }
            logger.info("@.........\u4e91\u4e4b\u5bb6\u901a\u8fc7\u7ec4\u7ec7id\u66f4\u65b0\u4eba\u5458\u7ec4\u7ec7\u6210\u529f.");
        }
        catch (Exception e) {
            logger.info("@.........\u4e91\u4e4b\u5bb6\u901a\u8fc7\u7ec4\u7ec7id\u66f4\u65b0\u4eba\u5458\u7ec4\u7ec7\u8d25:" + sHttpResponse + e.getMessage());
        }
    }

    private String genResponse(String api, Object param, List<YzjUserModel> userList) {
        YzjData yzjData = new YzjData();
        yzjData.setApi(api);
        yzjData.setParams(param);
        this.post(yzjData);
        String response = yzjData.getResponse();
        if (!yzjData.isSuccess()) {
            if (userList != null) {
                for (YzjUserModel user : userList) {
                    user.setOperSuccess(false);
                    user.setOperMsg(yzjData.getMsg());
                }
            }
            return "";
        }
        if (StringUtils.isBlank((CharSequence)response)) {
            if (userList != null) {
                for (YzjUserModel user : userList) {
                    user.setOperSuccess(false);
                    user.setOperMsg(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"YzjUserPubCloudService_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
            }
            return "";
        }
        return response;
    }

    @Override
    public YzjData getAll() {
        YzjData yzjData = new YzjData();
        yzjData.setApi(this.getApi(this.config, YzjApiEnum.YZJ_USER_GETALL.name()));
        this.getBatchData(yzjData);
        this.formatToCosmicPhone(yzjData.getDataList());
        return yzjData;
    }

    private void formatToCosmicPhone(List<Map<String, Object>> dataList) {
        for (Map<String, Object> dataMap : dataList) {
            Object phone = dataMap.get(KEY_PHONE);
            if (StringUtils.isBlank((Object)phone)) continue;
            dataMap.put(KEY_PHONE, YzjUtils.formatToCosmicPhone(phone.toString()));
        }
    }

    @Override
    public YzjData getAllCharge() {
        YzjData yzjData = new YzjData();
        yzjData.setApi(this.getApi(this.config, YzjApiEnum.YZJ_ORG_GETADMIN.name()));
        this.getBatchData(yzjData);
        return yzjData;
    }

    @Override
    public YzjData getAllPartJob() {
        YzjData yzjData = new YzjData();
        yzjData.setApi(this.getApi(this.config, YzjApiEnum.YZJ_USER_GETPARTJOB.name()));
        this.getBatchData(yzjData);
        return yzjData;
    }

    @Override
    public YzjData getAllSuperior() {
        YzjData yzjData = new YzjData();
        if (!this.config.isEnable()) {
            logger.warn("\u7cfb\u7edf\u672a\u542f\u7528\u4e91\u4e4b\u5bb6");
            return yzjData;
        }
        yzjData.setApi(this.getApi(this.config, YzjApiEnum.YZJ_USER_QUERYRELATIONS.name()));
        this.getBatchData(yzjData);
        return yzjData;
    }

    @Override
    public void addSuperior(List<YzjUserModel> userList) {
        this.modifySuperior(userList, true);
    }

    @Override
    public void deleteSuperior(List<YzjUserModel> userList) {
        this.modifySuperior(userList, false);
    }

    private void modifySuperior(List<YzjUserModel> userList, boolean isAdd) {
        if (3 != this.config.getSyncMode()) {
            return;
        }
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        ArrayList userMapList = new ArrayList(userList.size());
        HashMap<String, String> commitOpenIdMap = new HashMap<String, String>(userList.size());
        for (YzjUserModel user : userList) {
            List<String> superiorList;
            String openId = user.getOpenId();
            if (StringUtils.isBlank((CharSequence)openId)) continue;
            List<String> list = superiorList = isAdd ? user.getAddSuperiorList() : user.getDeleteSuperiorList();
            if (CollectionUtils.isEmpty(superiorList)) continue;
            for (String leaderOpenId : superiorList) {
                HashMap<String, String> userMap = new HashMap<String, String>(8);
                String commitId = openId + "_" + leaderOpenId;
                userMap.put(KEY_COMMIT_ID, commitId);
                userMap.put(KEY_OPEN_ID, openId);
                userMap.put(KEY_LEADER_OPEN_ID, leaderOpenId);
                userMap.put("relationType", "LEADER");
                userMapList.add(userMap);
                commitOpenIdMap.put(commitId, openId);
            }
        }
        if (userMapList.isEmpty()) {
            return;
        }
        String api = isAdd ? YzjApiEnum.YZJ_USER_ADDRELATIONS.name() : YzjApiEnum.YZJ_USER_DELETERELATIONS.name();
        String sHttpResponse = this.genResponse(this.getApi(this.config, api), userMapList, userList);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return;
        }
        try {
            YzjUsersResponseModel yzjmdl = (YzjUsersResponseModel)JSONUtils.cast((String)sHttpResponse, YzjUsersResponseModel.class);
            if (yzjmdl == null) {
                return;
            }
            if (yzjmdl.isSuccess()) {
                logger.info(api + "@.........\u4e91\u4e4b\u5bb6\u4fee\u6539\u4eba\u5458\u76f4\u63a5\u4e0a\u7ea7\u6210\u529f \u3002");
                return;
            }
            String msg = yzjmdl.getError();
            Map<String, String> errorMsgMap = this.getErrorMsgByCommitId(yzjmdl, commitOpenIdMap);
            for (YzjUserModel erpUser : userList) {
                erpUser.setOperSuccess(false);
                String errorMsg = errorMsgMap.get(erpUser.getOpenId());
                if (StringUtils.isBlank((CharSequence)errorMsg)) {
                    errorMsg = msg;
                }
                erpUser.setOperMsg(String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u76f4\u63a5\u4e0a\u7ea7\u65f6\uff0c%s", (String)"YzjUserPubCloudService_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), errorMsg));
            }
            logger.info(api + "@.........\u4e91\u4e4b\u5bb6\u4fee\u6539\u4eba\u5458\u76f4\u63a5\u4e0a\u7ea7\u5931\u8d25 \u3002");
        }
        catch (Exception e) {
            logger.info(this.getExceptionMessage(e.getMessage(), sHttpResponse));
        }
    }

    private Map<String, String> getErrorMsgByCommitId(YzjUsersResponseModel yzjmdl, Map<String, String> commitOpenIdMap) {
        HashMap<String, String> errorMsgMap = new HashMap<String, String>(commitOpenIdMap.size());
        ArrayList<Map<String, Object>> dataList = yzjmdl.getData();
        if (dataList == null) {
            return errorMsgMap;
        }
        for (Map<String, Object> dataMap : dataList) {
            String openId;
            Object errorMsg = dataMap.get("errorMsg");
            if (StringUtils.isBlank((Object)errorMsg)) {
                errorMsg = dataMap.get("error");
            }
            if (StringUtils.isBlank((Object)errorMsg) || (openId = commitOpenIdMap.get(dataMap.get(KEY_COMMIT_ID))) == null) continue;
            errorMsgMap.put(openId, errorMsg.toString());
        }
        return errorMsgMap;
    }

    @Override
    public List<YzjApiRes> batchUpdatePhone(List<YzjPhoneParam> params) {
        this.validateParam(params);
        ArrayList<YzjApiRes> resList = new ArrayList<YzjApiRes>(params.size());
        HashMap personsMap = new HashMap(1);
        ArrayList personList = new ArrayList(params.size());
        HashMap<String, String> paramMap = null;
        YzjApiRes res = null;
        for (YzjPhoneParam phoneParam : params) {
            paramMap = new HashMap<String, String>(2);
            paramMap.put(KEY_OPEN_ID, phoneParam.getOpenId());
            paramMap.put(KEY_PHONE, YzjUtils.formatToYzjPhone(phoneParam.getPhone()));
            personList.add(paramMap);
            res = new YzjApiRes();
            res.setSuccess(true);
            res.setMsgId(phoneParam.getOpenId());
            resList.add(res);
        }
        if (3 != this.config.getSyncMode()) {
            return resList;
        }
        personsMap.put(PARAM_PERSONS, personList);
        this.parseResponse(this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_USER_UPDATEMOBILE.name()), personsMap, null), resList);
        return resList;
    }

    @Override
    public List<YzjApiRes> batchUpdateEmail(List<YzjEmailParam> params) {
        this.validateParam(params);
        ArrayList<YzjApiRes> resList = new ArrayList<YzjApiRes>(params.size());
        HashMap personsMap = new HashMap(1);
        ArrayList personList = new ArrayList(params.size());
        HashMap<String, String> paramMap = null;
        YzjApiRes res = null;
        for (YzjEmailParam emailParam : params) {
            paramMap = new HashMap<String, String>(2);
            paramMap.put(KEY_OPEN_ID, emailParam.getOpenId());
            paramMap.put(KEY_EMAIL, emailParam.getEmail());
            personList.add(paramMap);
            res = new YzjApiRes();
            res.setSuccess(true);
            res.setMsgId(emailParam.getOpenId());
            resList.add(res);
        }
        if (3 != this.config.getSyncMode()) {
            return resList;
        }
        personsMap.put(PARAM_PERSONS, personList);
        this.parseResponse(this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_USER_UPDATEEMAIL.name()), personsMap, null), resList);
        return resList;
    }

    @Override
    public void updateJobNoByOpenIds(List<YzjUserModel> userList) {
        if (3 != this.config.getSyncMode()) {
            return;
        }
        if (CollectionUtils.isEmpty(userList)) {
            return;
        }
        int count = userList.size();
        ArrayList<YzjUserModel> yzjUserList = new ArrayList<YzjUserModel>(count);
        for (YzjUserModel yzjUserModel : userList) {
            YzjUserModel queryUserModel = new YzjUserModel();
            queryUserModel.setOpenId(yzjUserModel.getOpenId());
            yzjUserList.add(queryUserModel);
        }
        this.getUser(1, yzjUserList);
        HashMap<String, String> openIdJobNoMap = new HashMap<String, String>(count);
        for (YzjUserModel userModel : yzjUserList) {
            openIdJobNoMap.put(userModel.getOpenId(), userModel.getJobNo());
        }
        ArrayList arrayList = new ArrayList(count);
        HashMap<String, YzjUserModel> userMap = new HashMap<String, YzjUserModel>(count);
        for (YzjUserModel user : userList) {
            String openId = user.getOpenId();
            if (StringUtils.isBlank((CharSequence)openId)) {
                user.setOperMsg(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u516c\u5f00\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u3002", (String)"YzjUserPubCloudService_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                user.setOperSuccess(false);
                continue;
            }
            String jobNo = user.getJobNo();
            if (StringUtils.isBlank((CharSequence)jobNo)) {
                user.setOperMsg(ResManager.loadKDString((String)"\u201c\u5de5\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u3002", (String)"YzjUserPubCloudService_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                user.setOperSuccess(false);
                continue;
            }
            if (jobNo.equals(openIdJobNoMap.get(openId))) {
                user.setOperSuccess(true);
                continue;
            }
            HashMap<String, String> param = new HashMap<String, String>(3);
            param.put(KEY_COMMIT_ID, openId);
            param.put(KEY_OPEN_ID, openId);
            param.put("jobNo", jobNo);
            arrayList.add(param);
            userMap.put(openId, user);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        HashMap mpUsers = new HashMap(1);
        mpUsers.put(PARAM_PERSONS, arrayList);
        String sHttpResponse = this.genResponse(this.getApi(this.config, YzjApiEnum.YZJ_USER_UPDATE_JOBNO_BY_OPENIDS.name()), mpUsers, userList);
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return;
        }
        try {
            YzjUsersResponseModel yzjmdl = (YzjUsersResponseModel)JSONUtils.cast((String)sHttpResponse, YzjUsersResponseModel.class);
            if (yzjmdl == null) {
                logger.info("@.........\u4e91\u4e4b\u5bb6\u4eba\u5458\u4fee\u6539\u5de5\u53f7\u5931\u8d25\u3002");
                return;
            }
            if (yzjmdl.isSuccess()) {
                ArrayList<Map<String, Object>> dataList = yzjmdl.getData();
                if (CollectionUtils.isEmpty(dataList)) {
                    return;
                }
                for (Map map : dataList) {
                    Object msg;
                    Object msgCode;
                    Object commitId = map.get(KEY_COMMIT_ID);
                    YzjUserModel user = (YzjUserModel)userMap.get(commitId);
                    if (user == null || "209".equals(String.valueOf(msgCode = map.get("msgCode"))) || !StringUtils.isNotBlank(msg = map.get("msg"))) continue;
                    user.setOperSuccess(false);
                    user.setOperMsg(msg.toString());
                }
            } else {
                String msg = yzjmdl.getError();
                for (YzjUserModel yzjUserModel : userList) {
                    yzjUserModel.setOperSuccess(false);
                    yzjUserModel.setOperMsg(msg);
                }
            }
            logger.info("@.........\u4e91\u4e4b\u5bb6\u4eba\u5458\u4fee\u6539\u5de5\u53f7\u6210\u529f\u3002");
        }
        catch (Exception e) {
            throw new KDBizException(this.getExceptionMessage(e.getMessage(), sHttpResponse));
        }
    }

    private String getExceptionMessage(String exceptionMsg, String httpRespMsg) {
        return String.format(ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f\uff1a%1$s\uff0c\u4e91\u4e4b\u5bb6\u8fd4\u56de\u4fe1\u606f\uff1a%2$s\u3002", (String)"YzjUserPubCloudService_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), exceptionMsg, httpRespMsg);
    }

    private void validateParam(Collection<?> params) {
        if (CollectionUtils.isEmpty(params)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YzjUserPubCloudService_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }
}

