/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.yzj.service;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import kd.bos.yzj.impl.attendance.YzjAttendancePubCloudService;
import kd.bos.yzj.impl.org.YzjOrgPriCloudService;
import kd.bos.yzj.impl.org.YzjOrgPubCloudService;
import kd.bos.yzj.impl.partner.YzjPartnerPriCloudService;
import kd.bos.yzj.impl.partner.YzjPartnerPubCloudService;
import kd.bos.yzj.impl.user.YzjUserPriCloudService;
import kd.bos.yzj.impl.user.YzjUserPubCloudService;
import kd.bos.yzj.interfaces.IYzjAttendanceService;
import kd.bos.yzj.interfaces.IYzjOrgService;
import kd.bos.yzj.interfaces.IYzjPartnerService;
import kd.bos.yzj.interfaces.IYzjUserService;
import kd.bos.yzj.model.YzjConfig;

public class YzjServiceFactory {
    public static IYzjOrgService getOrgService() {
        return YzjServiceFactory.getOrgService(YzjConfigServiceHelper.getConfig());
    }

    public static IYzjOrgService getOrgService(YzjConfig config) {
        if (config == null) {
            throw new KDBizException(YzjServiceFactory.getNoConfigErrorMessage());
        }
        if (config.isPublicCloud()) {
            return new YzjOrgPubCloudService(config);
        }
        return new YzjOrgPriCloudService(config);
    }

    public static IYzjUserService getUserService() {
        return YzjServiceFactory.getUserService(YzjConfigServiceHelper.getConfig());
    }

    public static IYzjUserService getUserService(YzjConfig config) {
        if (config == null) {
            throw new KDBizException(YzjServiceFactory.getNoConfigErrorMessage());
        }
        if (config.isPublicCloud()) {
            return new YzjUserPubCloudService(config);
        }
        return new YzjUserPriCloudService(config);
    }

    public static IYzjAttendanceService getClockInService() {
        return YzjServiceFactory.getClockInService(YzjConfigServiceHelper.getConfig());
    }

    public static IYzjAttendanceService getClockInService(YzjConfig config) {
        if (config == null) {
            throw new KDBizException(YzjServiceFactory.getNoConfigErrorMessage());
        }
        return new YzjAttendancePubCloudService(config);
    }

    public static IYzjPartnerService getPartnerService() {
        return YzjServiceFactory.getPartnerService(YzjConfigServiceHelper.getConfig());
    }

    public static IYzjPartnerService getPartnerService(YzjConfig config) {
        if (config == null) {
            throw new KDBizException(YzjServiceFactory.getNoConfigErrorMessage());
        }
        if (config.isPublicCloud()) {
            return new YzjPartnerPubCloudService(config);
        }
        return new YzjPartnerPriCloudService(config);
    }

    private static String getNoConfigErrorMessage() {
        return ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u914d\u7f6e\u4fe1\u606f\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YzjServiceFactory_0", (String)"bos-yunzhijia", (Object[])new Object[0]);
    }
}

