/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.yzj.util;

import java.io.IOException;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.bos.util.EncryptUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.bos.yzj.model.YzjConfig;
import kd.bos.yzj.model.YzjData;
import kd.bos.yzj.model.user.YzjUserModel;
import kd.bos.yzj.model.user.YzjUsersResponseModel;

public class YzjUtils {
    private static Log logger = LogFactory.getLog(YzjUtils.class);
    private static final int DEFAULT_CONNECTIONTIMEOUT = 60000;
    private static final int DEFAULT_READTIMEOUT = 180000;
    private static final int DEFAULT_CONNECTIONTIMEOUT_SINGLETON = 10000;
    private static final int DEFAULT_READTIMEOUT_SINGLETON = 30000;
    public static final String GLOBAL_PHONE_START = "+";
    public static final String GLOBAL_PHONE_SPLIT = "-";
    public static final String ERROR_CODE = "errorCode";
    public static final String ERROR = "error";
    private static final String API_GET_ALL = "getall";
    private static final String PRIVATE_SYMBOL = "***";

    public static void post(YzjConfig yzjConfig, YzjData yzjData) {
        if (yzjData == null) {
            return;
        }
        HashMap paramMap = yzjData.getParams();
        if (paramMap == null) {
            paramMap = new HashMap();
        }
        String api = yzjData.getApi();
        String paramJson = "";
        Map<String, Object> body = null;
        try {
            paramJson = JSONUtils.toString(paramMap);
            String paramLog = YzjUtils.filterPrivateMsg(paramMap);
            logger.info(String.format("\u8c03\u7528\u4e91\u4e4b\u5bb6\u63a5\u53e3[%s]\uff0c\u53c2\u6570\uff1a%s", api, paramLog));
            body = YzjUtils.getHttpRequestBody(yzjConfig, paramJson);
        }
        catch (Exception e) {
            yzjData.setSuccess(false);
            yzjData.setMsg(ResManager.loadKDString((String)"\u52a0\u5bc6\u53d1\u9001\u6d88\u606f\u5230\u4e91\u4e4b\u5bb6\u7684\u53c2\u6570\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5bc6\u94a5\u662f\u5426\u6b63\u786e\u3002", (String)"YzjUtils_0", (String)"bos-yunzhijia", (Object[])new Object[0]));
            logger.info("\u52a0\u5bc6\u53d1\u9001\u6d88\u606f\u5230\u4e91\u4e4b\u5bb6\u7684\u53c2\u6570\u5931\u8d25\uff1a" + api + " \u53c2\u6570\uff1a" + yzjData + " \u5f02\u5e38\uff1a" + e.getMessage());
            return;
        }
        YzjUtils.post(yzjConfig, yzjData, body);
    }

    private static String filterPrivateMsg(Object paramMap) throws IOException {
        try {
            if (!(paramMap instanceof Map)) {
                return JSONUtils.toString((Object)paramMap);
            }
            Object person = ((Map)paramMap).get("persons");
            if (!(person instanceof List)) {
                return JSONUtils.toString((Object)paramMap);
            }
            List personList = (List)person;
            HashMap logMap = new HashMap(((Map)paramMap).size());
            ArrayList users = new ArrayList(personList.size());
            for (Object userObj : personList) {
                if (!(userObj instanceof YzjUserModel)) {
                    return YzjUtils.filterPhoneAndEmail(paramMap, personList);
                }
                YzjUserModel user = (YzjUserModel)userObj;
                HashMap<String, String> userMap = new HashMap<String, String>(2);
                userMap.put("openId", user.getOpenId());
                userMap.put("name", user.getName());
                users.add(userMap);
            }
            logMap.put("persons", users);
            return JSONUtils.toString(logMap);
        }
        catch (Exception e) {
            logger.error("YzjUtils.filterPrivateMsg ERROR", (Throwable)e);
            return JSONUtils.toString((Object)paramMap);
        }
    }

    private static String filterPhoneAndEmail(Object paramMap, List<?> personList) throws IOException {
        for (Object userObj : personList) {
            if (!(userObj instanceof Map)) {
                return JSONUtils.toString((Object)paramMap);
            }
            Map user = (Map)userObj;
            user.remove("phone");
            user.remove("email");
        }
        return JSONUtils.toString((Object)paramMap);
    }

    private static String filterPrivateMsgForRes(String response) {
        try {
            Map resMap = (Map)JSONUtils.cast((String)response, Map.class);
            Object dataMsg = resMap.get("data");
            if ("".equals(dataMsg)) {
                return response;
            }
            YzjUsersResponseModel responseModel = (YzjUsersResponseModel)JSONUtils.cast((String)response, YzjUsersResponseModel.class);
            ArrayList<Map<String, Object>> dataList = responseModel.getData();
            if (CollectionUtils.isEmpty(dataList)) {
                return response;
            }
            for (Map map : dataList) {
                Optional.ofNullable(map.get("photoUrl")).ifPresent(photoUrl -> data.put("photoUrl", PRIVATE_SYMBOL));
                Optional.ofNullable(map.get("phone")).ifPresent(phone -> data.put("phone", PRIVATE_SYMBOL));
                Optional.ofNullable(map.get("email")).ifPresent(email -> data.put("email", PRIVATE_SYMBOL));
                Object contact = map.get("contact");
                Optional.ofNullable(contact).ifPresent(contactObj -> {
                    String contactStr;
                    try {
                        List contactList = (List)JSONUtils.cast((String)contactObj.toString(), List.class);
                        for (Map contactMap : contactList) {
                            contactMap.put("value", PRIVATE_SYMBOL);
                        }
                        contactStr = JSONUtils.toString((Object)contactList);
                    }
                    catch (IOException e) {
                        logger.error("YzjUtils.filterPrivateMsgForRes.contactStr ERROR", (Object)e.getMessage());
                        contactStr = contactObj.toString();
                    }
                    data.put("contact", contactStr);
                });
            }
            response = JSONUtils.toString((Object)responseModel);
        }
        catch (IOException e) {
            logger.error("YzjUtils.filterPrivateMsgForRes.responseModel ERROR", (Object)e.getMessage());
            return response;
        }
        return response;
    }

    public static void postToken(YzjConfig yzjConfig, YzjData yzjData) {
        if (yzjData == null) {
            return;
        }
        HashMap paramMap = yzjData.getParams();
        if (paramMap == null) {
            paramMap = new HashMap();
        }
        logger.info(String.format("\u8c03\u7528\u4e91\u4e4b\u5bb6\u63a5\u53e3[%s]\uff0c\u53c2\u6570\uff1a%s", yzjData.getApi(), ((Map)paramMap).get("scope")));
        YzjUtils.post(yzjConfig, yzjData, paramMap);
    }

    private static void post(YzjConfig yzjConfig, YzjData yzjData, Map<String, Object> body) {
        String api = yzjData.getApi();
        boolean isPostToken = "/gateway/oauth2/token/getAccessToken".equals(api);
        Map<String, String> header = YzjUtils.getHttpRequestHeader();
        boolean isSuccess = false;
        String response = "";
        String url = yzjConfig.getUrl() + api;
        if (yzjConfig.isApiUseToken()) {
            url = url + "?accessToken=" + yzjConfig.getToken();
        }
        int tryCount = yzjConfig.getRetryCount();
        long startTime = System.currentTimeMillis();
        String originalResponse = null;
        for (int i = 1; i <= tryCount; ++i) {
            try {
                response = yzjData.isGetAll() ? HttpClientUtils.post((String)url, header, body, (int)60000, (int)180000) : HttpClientUtils.post((String)url, header, body, (int)10000, (int)30000);
                originalResponse = response;
                if (isPostToken) {
                    logger.info(String.format("\u8c03\u7528\u4e91\u4e4b\u5bb6\u63a5\u53e3[%s]\u6210\u529f\u3002", api));
                } else {
                    String responseLog = YzjUtils.filterPrivateMsgForRes(response);
                    logger.info(String.format("\u8c03\u7528\u4e91\u4e4b\u5bb6\u63a5\u53e3[%s]\uff0c\u539f\u59cb\u7ed3\u679c\uff1a%s", api, responseLog));
                }
                response = YzjUtils.nullDataToEmptyList(response);
                if (!StringUtils.isNotBlank((CharSequence)response)) continue;
                isSuccess = true;
                break;
            }
            catch (Exception e) {
                logger.info("\u7b2c" + i + "\u6b21\u5c1d\u8bd5\u53d1\u9001\u6d88\u606f\u5230\u4e91\u4e4b\u5bb6\u5931\u8d25\uff1a" + api + " \u53c2\u6570\uff1a" + yzjData + " \u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        long spendTime = System.currentTimeMillis() - startTime;
        logger.debug(String.format("\u8c03\u7528\u4e91\u4e4b\u5bb6\u901a\u4fe1\u63a5\u53e3\u8017\u65f6[%s]\uff1a%s(ms)", api, spendTime));
        yzjData.setSuccess(isSuccess);
        if (!isSuccess) {
            yzjData.setMsg(ResManager.loadKDString((String)"\u4e0e\u4e91\u4e4b\u5bb6\u901a\u4fe1\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"YzjUtils_1", (String)"bos-yunzhijia", (Object[])new Object[0]));
        }
        YzjUtils.recordApiOperationLog(yzjData, originalResponse, isPostToken);
        if (!isPostToken) {
            logger.debug(String.format("\u8c03\u7528\u4e91\u4e4b\u5bb6\u63a5\u53e3[%s]\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a%s", api, response));
        }
        yzjData.setResponse(response);
    }

    private static void recordApiOperationLog(YzjData yzjData, String response, boolean isPostToken) {
        if (yzjData.getApi().toLowerCase(Locale.ENGLISH).endsWith(API_GET_ALL)) {
            return;
        }
        ThreadPools.executeOnce((String)"kd.bos.yzj.util.YzjUtils.recordApiOperationLog", () -> {
            try {
                OpLogAppInfo appLogInfo = new OpLogAppInfo();
                appLogInfo.setBizAppID("83bfebc8000037ac");
                appLogInfo.setBizObjID("bos_yzj_synctask");
                String api = yzjData.getApi();
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4e91\u4e4b\u5bb6\u540c\u6b65", "YzjUtils_6", "bos-yunzhijia");
                appLogInfo.setOpName(api, opName);
                if (!isPostToken) {
                    String params = yzjData.getParams() == null ? "" : SerializationUtils.toJsonString((Object)yzjData.getParams());
                    StringBuilder detail = new StringBuilder();
                    detail.append("request: ");
                    detail.append(params);
                    detail.append("\r\nresponse: ");
                    detail.append(response);
                    appLogInfo.setModifyContent(detail.toString());
                    appLogInfo.setModifyContentTag(detail.toString());
                }
                MultiLangEnumBridge opDesc = yzjData.isSuccess() ? new MultiLangEnumBridge("\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff1a%s", "YzjUtils_4", "bos-yunzhijia") : new MultiLangEnumBridge("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a%s", "YzjUtils_5", "bos-yunzhijia");
                appLogInfo.setOpDesc(opDesc, new String[]{api});
                LogServiceHelper.addLog((AppLogInfo)appLogInfo);
            }
            catch (Exception e) {
                logger.error("\u8bb0\u5f55\u4e91\u4e4b\u5bb6\u63a5\u53e3\u8c03\u7528\u64cd\u4f5c\u65e5\u5fd7\u51fa\u73b0\u5f02\u5e38.", (Throwable)e);
            }
        });
    }

    private static Map<String, String> getHttpRequestHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
        return header;
    }

    private static Map<String, Object> getHttpRequestBody(YzjConfig yzjConfig, String sJSON) throws Exception {
        HashMap<String, Object> mpBody = new HashMap<String, Object>(4);
        mpBody.put("eid", yzjConfig.getEid());
        mpBody.put("nonce", UUID.randomUUID().toString());
        if (yzjConfig.isApiUseToken()) {
            mpBody.put("data", sJSON);
        } else {
            mpBody.put("data", EncryptUtils.encryptWithEncodeBase64UTF8((String)sJSON, (Key)yzjConfig.getKey()));
        }
        return mpBody;
    }

    private static String nullDataToEmptyList(String sHttpResponse) {
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            logger.error("\u4e91\u4e4b\u5bb6\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a\u3002");
            return sHttpResponse;
        }
        try {
            Map resMap = (Map)JSONUtils.cast((String)sHttpResponse, HashMap.class, (boolean)true);
            if (resMap != null) {
                if (StringUtils.isBlank(resMap.get("data"))) {
                    resMap.put("data", new ArrayList());
                    String errorCode = String.valueOf(resMap.get(ERROR_CODE));
                    String error = String.valueOf(resMap.get(ERROR));
                    if (StringUtils.isNotBlank((CharSequence)errorCode) || StringUtils.isNotBlank((CharSequence)error)) {
                        if ("103".equals(errorCode) || "103".equals(error)) {
                            resMap.put(ERROR, ResManager.loadKDString((String)"\u975e\u6cd5eid\uff0c\u672a\u5728mcloud\u6ce8\u518c\uff0c\u8bf7\u5728\u82cd\u7a79\u7684\u7cfb\u7edf\u53c2\u6570\u586b\u5199\u6b63\u786e\u7684\u5de5\u4f5c\u5708EID\u3002", (String)"YzjUtils_2", (String)"bos-yunzhijia", (Object[])new Object[0]));
                        } else if ("104".equals(errorCode) || "104".equals(error)) {
                            resMap.put(ERROR, ResManager.loadKDString((String)"\u6570\u636e\u89e3\u5bc6\u51fa\u9519\uff0c\u8bf7\u5728\u82cd\u7a79\u7684\u7cfb\u7edf\u53c2\u6570\u586b\u5199\u6b63\u786e\u7684\u5de5\u4f5c\u5708EID\u548c\u7cfb\u7edf\u96c6\u6210\u5bc6\u94a5\u3002", (String)"YzjUtils_3", (String)"bos-yunzhijia", (Object[])new Object[0]));
                        }
                    }
                }
                return JSONUtils.toString((Object)resMap);
            }
        }
        catch (IOException e) {
            logger.info(e.getMessage());
        }
        return sHttpResponse;
    }

    public static String formatToYzjPhone(String phone) {
        if (StringUtils.isBlank((CharSequence)phone)) {
            return "";
        }
        if (phone.indexOf(GLOBAL_PHONE_SPLIT) == -1) {
            return phone;
        }
        if (phone.startsWith(GLOBAL_PHONE_START)) {
            return phone;
        }
        return GLOBAL_PHONE_START + phone;
    }

    public static String formatToCosmicPhone(String phone) {
        if (StringUtils.isBlank((CharSequence)phone)) {
            return "";
        }
        if (phone.indexOf(GLOBAL_PHONE_SPLIT) == -1) {
            return phone;
        }
        if (phone.startsWith(GLOBAL_PHONE_START)) {
            return StringUtils.substringAfter((String)phone, (String)GLOBAL_PHONE_START);
        }
        return phone;
    }
}

