/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class BaseDataUtils {
    private static final String ERROR_FORMAT = "Error:%s";
    private static final String BD_COUNTRY = "bd_country";
    private static final String ID_NAME = "id,name";
    private static final String ID_ASC = "id asc";
    private static final String ENABLE = "enable";
    private static final String PARENT_ID = "parentid";
    private static final String IS_LEAF = "isleaf";
    private static final String PARENT = "parent";
    private static final String BD_ADMINDIVISION = "bd_admindivision";
    private static final String ID_NAME_PARENT_ISLEAF = "id,name,parent,isleaf";

    public static String getUserDefaultOrgID(String userID) {
        SqlParameter userParam = new SqlParameter(":fid", 12, (Object)userID);
        String sql = "select userentry.fdptid as fid from t_sec_userentry userentry where userentry.fid=?";
        return (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new SqlParameter[]{userParam}, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) {
                String fid = null;
                try {
                    if (rs.next()) {
                        fid = rs.getString("fid");
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(BaseDataUtils.ERROR_FORMAT, e.getMessage())});
                }
                return fid;
            }
        });
    }

    public static boolean checkUniqueness(String fieldName, String fieldValue, String tableName) {
        boolean uniqueness = false;
        SqlParameter param = new SqlParameter(":" + fieldName, 12, (Object)fieldValue);
        String sql = "select " + fieldName + " as fieldName from " + tableName + " where " + fieldName + "=?";
        String executeScalar = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new SqlParameter[]{param}, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) {
                String fieldName = null;
                try {
                    if (rs.next()) {
                        fieldName = rs.getString("fieldName");
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(BaseDataUtils.ERROR_FORMAT, e.getMessage())});
                }
                return fieldName;
            }
        });
        if (executeScalar != null) {
            uniqueness = true;
        }
        return uniqueness;
    }

    public static Map<String, String> getProvinceData(String province_id) {
        SqlParameter provinceParam = new SqlParameter(":fid", 12, (Object)province_id);
        String sql = "select province.fnumber as fnumber,province.fname as fname from T_BD_province province where province.fid=?";
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new SqlParameter[]{provinceParam}, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) {
                HashMap<String, String> map = null;
                try {
                    if (rs.next()) {
                        map = new HashMap<String, String>();
                        String fnumber = rs.getString("fnumber");
                        map.put("provincenum", fnumber);
                        String fname = rs.getString("fname");
                        map.put("provincename", fname);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(BaseDataUtils.ERROR_FORMAT, e.getMessage())});
                }
                return map;
            }
        });
    }

    public static boolean validatorCurrency(String number, String name) {
        SqlParameter fnumber = new SqlParameter(":fnumber", 12, (Object)number);
        SqlParameter fname = new SqlParameter(":fname", 12, (Object)name);
        String sql = "select count(1) from T_BD_Currency c ,T_BD_Currency_l l where c.fid=l.fid and c.fnumber = ? and  l.fname = ?";
        String count = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new SqlParameter[]{fnumber, fname}, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) {
                String value = "0";
                try {
                    if (rs.next()) {
                        value = rs.getString(1);
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(BaseDataUtils.ERROR_FORMAT, e.getMessage())});
                }
                return value;
            }
        });
        return Integer.parseInt(count) >= 1;
    }

    public static boolean checkAccountBooksTypeIsExist(final String fieldName, String fieldValue, String tableName) {
        boolean isExist = false;
        SqlParameter param = new SqlParameter(":" + fieldName, 12, (Object)fieldValue);
        String sql = "select " + fieldName + " as fieldName from " + tableName + " where " + fieldName + "=?";
        String executeScalar = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new SqlParameter[]{param}, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) {
                try {
                    if (rs.next()) {
                        String fieldName2 = rs.getString("fieldName");
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(BaseDataUtils.ERROR_FORMAT, e.getMessage())});
                }
                return fieldName;
            }
        });
        if (executeScalar != null) {
            isExist = true;
        }
        return isExist;
    }

    public static String getOrgName(String fid) {
        SqlParameter userParam = new SqlParameter(":fid", 12, (Object)fid);
        String sql = "select org.fname as fname from t_org_org org where org.fid=?";
        String orgName = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new SqlParameter[]{userParam}, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) {
                String fid = null;
                try {
                    if (rs.next()) {
                        fid = rs.getString("fname");
                    }
                }
                catch (SQLException e) {
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(BaseDataUtils.ERROR_FORMAT, e.getMessage())});
                }
                return fid;
            }
        });
        return orgName;
    }

    public static List<Map<String, String>> getCountryTreeData() {
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObjects = orm.query(BD_COUNTRY, ID_NAME, null, ID_ASC);
        return BaseDataUtils.getCountryTreeData((List<DynamicObject>)dynamicObjects);
    }

    public static List<Map<String, String>> getCountryTreeDataWithEnabled() {
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)"1");
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObjects = orm.query(BD_COUNTRY, ID_NAME, new QFilter[]{enableFilter}, ID_ASC);
        return BaseDataUtils.getCountryTreeData((List<DynamicObject>)dynamicObjects);
    }

    public static List<Map<String, String>> getCountryTreeDataByCountryId(Collection<Object> countryIds) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("id", "in", countryIds);
        DynamicObjectCollection dynamicObjects = orm.query(BD_COUNTRY, ID_NAME, filter.toArray(), ID_ASC);
        return BaseDataUtils.getCountryTreeData((List<DynamicObject>)dynamicObjects);
    }

    public static List<Map<String, String>> getCountryTreeDataByCountryIdWithEnabled(Collection<Object> countryIds) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("id", "in", countryIds);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filter, enableFilter};
        DynamicObjectCollection dynamicObjects = orm.query(BD_COUNTRY, ID_NAME, filters, ID_ASC);
        return BaseDataUtils.getCountryTreeData((List<DynamicObject>)dynamicObjects);
    }

    private static List<Map<String, String>> getCountryTreeData(List<DynamicObject> countries) {
        ArrayList<Map<String, String>> countryTreeData = new ArrayList<Map<String, String>>(countries.size());
        Set ids = (Set)DB.query((DBRoute)DBRoute.basedata, (String)"select distinct fcountryid from t_bd_admindivision", null, rs -> {
            HashSet<String> idSet = new HashSet<String>(300);
            while (rs.next()) {
                idSet.add(rs.getString(1));
            }
            return idSet;
        });
        for (DynamicObject dynamicObject : countries) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dynamicObject.get("id").toString());
            map.put("name", dynamicObject.get("name").toString());
            map.put(PARENT_ID, "8609760E-EF83-4775-A9FF-CCDEC7C0B689");
            if (ids.contains(dynamicObject.get("id").toString())) {
                map.put(IS_LEAF, "false");
            }
            countryTreeData.add(map);
        }
        return countryTreeData;
    }

    public static List<Map<String, String>> getAdminDivisionTreeData(String parentid) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter(PARENT, "=", (Object)Long.valueOf(parentid));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dynamicObjects = orm.query(BD_ADMINDIVISION, "id,name,parent,isleaf,country", filters, ID_ASC);
        ArrayList<Map<String, String>> adminDivisionTreeData = new ArrayList<Map<String, String>>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dynamicObject.get("id").toString());
            map.put("name", dynamicObject.get("name").toString());
            parentid = dynamicObject.get(PARENT).toString();
            String countryid = dynamicObject.get(PARENT).toString();
            if ("0".equals(parentid) && !"0".equals(countryid)) {
                parentid = countryid;
            }
            map.put(PARENT_ID, parentid);
            map.put(IS_LEAF, dynamicObject.get(IS_LEAF).toString());
            adminDivisionTreeData.add(map);
        }
        return adminDivisionTreeData;
    }

    public static List<Map<String, String>> getAdminDivisionTreeDataWithEnabled(String parentid) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter(PARENT, "=", (Object)Long.valueOf(parentid));
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filter, enableFilter};
        DynamicObjectCollection dynamicObjects = orm.query(BD_ADMINDIVISION, "id,name,parent,isleaf,country", filters, ID_ASC);
        ArrayList<Map<String, String>> adminDivisionTreeData = new ArrayList<Map<String, String>>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dynamicObject.get("id").toString());
            map.put("name", dynamicObject.get("name").toString());
            parentid = dynamicObject.get(PARENT).toString();
            String countryid = dynamicObject.get(PARENT).toString();
            if ("0".equals(parentid) && !"0".equals(countryid)) {
                parentid = countryid;
            }
            map.put(PARENT_ID, parentid);
            map.put(IS_LEAF, dynamicObject.get(IS_LEAF).toString());
            adminDivisionTreeData.add(map);
        }
        return adminDivisionTreeData;
    }

    public static List<Map<String, String>> getAdminDivisionTreeDataByCountryid(String countryid) {
        ORM orm = ORM.create();
        QFilter countryFilter = new QFilter("country", "=", (Object)Long.valueOf(countryid));
        QFilter levelFilter = new QFilter("level", "=", (Object)1);
        QFilter[] filters = new QFilter[]{countryFilter, levelFilter};
        DynamicObjectCollection dynamicObjects = orm.query(BD_ADMINDIVISION, ID_NAME_PARENT_ISLEAF, filters, ID_ASC);
        ArrayList<Map<String, String>> adminDivisionTreeData = new ArrayList<Map<String, String>>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dynamicObject.get("id").toString());
            map.put("name", dynamicObject.get("name").toString());
            map.put(IS_LEAF, dynamicObject.get(IS_LEAF).toString());
            String parentid = dynamicObject.get(PARENT).toString();
            if ("0".equals(parentid) && !"0".equals(countryid)) {
                parentid = countryid;
            }
            map.put(PARENT_ID, parentid);
            adminDivisionTreeData.add(map);
        }
        return adminDivisionTreeData;
    }

    public static List<Map<String, String>> getAdminDivisionTreeDataByCountryidWithEnabled(String countryid) {
        ORM orm = ORM.create();
        QFilter countryFilter = new QFilter("country", "=", (Object)Long.valueOf(countryid));
        QFilter levelFilter = new QFilter("level", "=", (Object)1);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)"1");
        QFilter[] filters = new QFilter[]{countryFilter, levelFilter, enableFilter};
        DynamicObjectCollection dynamicObjects = orm.query(BD_ADMINDIVISION, ID_NAME_PARENT_ISLEAF, filters, ID_ASC);
        ArrayList<Map<String, String>> adminDivisionTreeData = new ArrayList<Map<String, String>>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dynamicObject.get("id").toString());
            map.put("name", dynamicObject.get("name").toString());
            map.put(IS_LEAF, dynamicObject.get(IS_LEAF).toString());
            String parentid = dynamicObject.get(PARENT).toString();
            if ("0".equals(parentid) && !"0".equals(countryid)) {
                parentid = countryid;
            }
            map.put(PARENT_ID, parentid);
            adminDivisionTreeData.add(map);
        }
        return adminDivisionTreeData;
    }

    public static List<Map<String, String>> getAddressCategoryTreeData(String parentid) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter(PARENT, "=", (Object)Long.valueOf(parentid));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dynamicObjects = orm.query("bd_addresscategory", ID_NAME_PARENT_ISLEAF, filters, ID_ASC);
        ArrayList<Map<String, String>> addressCategoryTreeData = new ArrayList<Map<String, String>>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dynamicObject.get("id").toString());
            map.put("name", dynamicObject.get("name").toString());
            map.put(PARENT_ID, dynamicObject.get(PARENT).toString());
            map.put(IS_LEAF, dynamicObject.get(IS_LEAF).toString());
            addressCategoryTreeData.add(map);
        }
        return addressCategoryTreeData;
    }

    public static List<Map<String, String>> getCityTypeTreeData(String parentid) {
        ORM orm = ORM.create();
        QFilter filter = null;
        filter = "".equals(parentid) ? QFilter.isNull((String)PARENT) : new QFilter(PARENT, "=", (Object)Long.valueOf(parentid));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dynamicObjects = orm.query("bd_citytype", ID_NAME_PARENT_ISLEAF, filters, ID_ASC);
        ArrayList<Map<String, String>> cityTypeTreeData = new ArrayList<Map<String, String>>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dynamicObject.get("id").toString());
            map.put("name", dynamicObject.get("name").toString());
            map.put(PARENT_ID, dynamicObject.get(PARENT).toString());
            map.put(IS_LEAF, dynamicObject.get(IS_LEAF).toString());
            cityTypeTreeData.add(map);
        }
        return cityTypeTreeData;
    }

    public static Boolean checkAdminDivisionIsCity(String id) {
        ORM orm = ORM.create();
        QFilter filter1 = new QFilter("id", "=", (Object)Long.valueOf(id));
        QFilter filter2 = new QFilter("iscity", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{filter1, filter2};
        DynamicObjectCollection dynamicObjects = orm.query(BD_ADMINDIVISION, "id,iscity", filters, ID_ASC);
        if (dynamicObjects.size() == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Integer saveCity(Map<String, String> map) {
        String cityTypeId = map.get("cityTypeId");
        String adminDivisionId = map.get("adminDivisionId");
        ORM orm = ORM.create();
        DynamicObject newDynamicObject = orm.newDynamicObject("bd_citynew");
        newDynamicObject.set("group", (Object)cityTypeId);
        newDynamicObject.set("admindivision", (Object)adminDivisionId);
        Integer id = (Integer)orm.insert(newDynamicObject);
        return id;
    }
}

