/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.org.event.AbstractOrgChangeEventServicePlugin;
import kd.bos.org.model.OrgChangeCheckDetail;
import kd.bos.org.model.OrgChangeCheckReport;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AssistantUpdateWithOrgChangePlugin
extends AbstractOrgChangeEventServicePlugin {
    private static final String BOS_MSERVICE_BD = "bos-mservice-bd";
    private static final String OPERATION_PARAMS = "base_orgchange_resetroot";
    private static final String PARAMS_SUBSCRIPTION_ID = "subscription_id";
    private static final String PARAMS_NEW_ROOT_ORG = "newrootid";
    private static final String PARAMS_OLD_ROOT_ORG = "oldrootid";
    private static final String PARAMS_VIEW = "synviews";
    private static final String PARAMS_VIEW_ID = "viewid";
    private static final String PARAM_CHANGE_RECORD_ID = "changerecordid";
    private static final String CTRL_VIEW = "ctrlview";
    private static final String CREATE_ORG = "createorg";
    private static final String CREATE_ORG_ID = "createorg.id";
    private static final String GROUP = "group";
    private static final String GROUP_ID = "group.id";
    private static final String GROUP_CONTROL = "isgroupcontrol";
    private static final String NUMBER = "number";
    private static final String ENTITY_ASSISTANT_GROUP = "bos_assistantdatagroup";
    private static final String ENTITY_ASSISTANT_DETAIL = "bos_assistantdata_detail";

    protected OrgChangeCheckReport handleEventAndReturnCheckReport(KDBizEvent evt) {
        OrgChangeCheckReport orgChangeCheckReport = new OrgChangeCheckReport();
        String variableStr = evt.getVariables();
        JSONObject variables = (JSONObject)SerializationUtils.fromJsonString((String)variableStr, JSONObject.class);
        Object subscriptionId = variables.get((Object)PARAMS_SUBSCRIPTION_ID);
        if (Objects.nonNull(subscriptionId)) {
            orgChangeCheckReport.setEventId(Long.valueOf(subscriptionId.toString()));
        }
        JSONObject operationParams = variables.getJSONObject(OPERATION_PARAMS);
        String changeRecordId = operationParams.getString(PARAM_CHANGE_RECORD_ID);
        orgChangeCheckReport.setChangeRecordId(Long.valueOf(changeRecordId));
        JSONArray viewArray = operationParams.getJSONArray(PARAMS_VIEW);
        if (CollectionUtils.isEmpty((Collection)viewArray)) {
            orgChangeCheckReport.setCheckResult(ResManager.loadKDString((String)"\u901a\u8fc7", (String)"AssistantUpdateWithOrgChangePlugin_3", (String)BOS_MSERVICE_BD, (Object[])new Object[0]));
            orgChangeCheckReport.setCheckStatus("P");
            return orgChangeCheckReport;
        }
        HashMap viewOrgMap = new HashMap(viewArray.size());
        for (Object viewMap : viewArray) {
            JSONObject viewObj = (JSONObject)viewMap;
            String newRootId = viewObj.getString(PARAMS_NEW_ROOT_ORG);
            String oldRootId = viewObj.getString(PARAMS_OLD_ROOT_ORG);
            HashMap<String, Long> orgMap = new HashMap<String, Long>(2);
            orgMap.put(PARAMS_NEW_ROOT_ORG, Long.valueOf(newRootId));
            orgMap.put(PARAMS_OLD_ROOT_ORG, Long.valueOf(oldRootId));
            String viewId = viewObj.getString(PARAMS_VIEW_ID);
            viewOrgMap.put(Long.valueOf(viewId), orgMap);
        }
        QFilter groupFilter = new QFilter(CTRL_VIEW, "in", viewOrgMap.keySet());
        groupFilter.and(GROUP_CONTROL, "=", (Object)Boolean.TRUE);
        String groupSelectField = "createorg.id,ctrlview";
        Map groups = BusinessDataServiceHelper.loadFromCache((String)ENTITY_ASSISTANT_GROUP, (String)groupSelectField, (QFilter[])new QFilter[]{groupFilter});
        if (CollectionUtils.isEmpty((Map)groups)) {
            orgChangeCheckReport.setCheckResult(ResManager.loadKDString((String)"\u901a\u8fc7", (String)"AssistantUpdateWithOrgChangePlugin_3", (String)BOS_MSERVICE_BD, (Object[])new Object[0]));
            orgChangeCheckReport.setCheckStatus("P");
            return orgChangeCheckReport;
        }
        QFilter assistantFilter = new QFilter(GROUP_ID, "in", groups.keySet());
        String assistantSelectFields = "createorg.id,ctrlview,group.id";
        Map assistants = BusinessDataServiceHelper.loadFromCache((String)ENTITY_ASSISTANT_DETAIL, (String)assistantSelectFields, (QFilter[])new QFilter[]{assistantFilter});
        HashMap<Object, Set> groupAssistantMap = new HashMap<Object, Set>(groups.size());
        for (Object assistant : assistants.values()) {
            groupAssistantMap.computeIfAbsent(assistant.get(GROUP_ID), k -> new HashSet()).add((Long)assistant.getPkValue());
        }
        ArrayList<OrgChangeCheckDetail> checkDetails = new ArrayList<OrgChangeCheckDetail>(assistants.size());
        for (Map.Entry entry : groups.entrySet()) {
            Object groupId = entry.getKey();
            DynamicObject group = (DynamicObject)entry.getValue();
            DynamicObject ctrlView = group.getDynamicObject(CTRL_VIEW);
            Map orgMap = (Map)viewOrgMap.get(ctrlView.getLong("id"));
            Long oldOrgId = (Long)orgMap.get(PARAMS_OLD_ROOT_ORG);
            Long newOrgId = (Long)orgMap.get(PARAMS_NEW_ROOT_ORG);
            Long groupCreateOrgId = group.getLong(CREATE_ORG_ID);
            if (oldOrgId.equals(groupCreateOrgId)) {
                group.set(CREATE_ORG, (Object)newOrgId);
                OrgChangeCheckDetail assistantCheckDetail = new OrgChangeCheckDetail();
                assistantCheckDetail.setEntity(group.getDataEntityType().getName());
                assistantCheckDetail.setBdNumber(group.getString(NUMBER));
                assistantCheckDetail.setReason(ResManager.loadKDString((String)"\u96c6\u56e2\u7ba1\u63a7\u7684\u6570\u636e\u53ea\u80fd\u7531\u6839\u7ec4\u7ec7\u7ef4\u62a4", (String)"AssistantUpdateWithOrgChangePlugin_4", (String)BOS_MSERVICE_BD, (Object[])new Object[0]));
                assistantCheckDetail.setSolution(ResManager.loadKDString((String)"\u5c06\u7c7b\u522b\u53ca\u5176\u6240\u6709\u660e\u7ec6\u7ba1\u7406\u6743\u8f6c\u8ba9\u7ed9\u65b0\u6839\u7ec4\u7ec7", (String)"AssistantUpdateWithOrgChangePlugin_5", (String)BOS_MSERVICE_BD, (Object[])new Object[0]));
                checkDetails.add(assistantCheckDetail);
            }
            if (CollectionUtils.isEmpty(groupAssistantMap) || !groupAssistantMap.containsKey(groupId)) continue;
            for (Long assistantId : (Set)groupAssistantMap.get(groupId)) {
                DynamicObject assistant = (DynamicObject)assistants.get(assistantId);
                Long assistantCreateOrgId = assistant.getLong(CREATE_ORG_ID);
                if (!oldOrgId.equals(assistantCreateOrgId)) continue;
                assistant.set(CREATE_ORG, (Object)newOrgId);
            }
        }
        try {
            SaveServiceHelper.save((DynamicObject[])groups.values().toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])assistants.values().toArray(new DynamicObject[0]));
            orgChangeCheckReport.setCheckResult(ResManager.loadKDString((String)"\u5b58\u5728\u96c6\u56e2\u7ba1\u63a7\u7684\u7c7b\u522b", (String)"AssistantUpdateWithOrgChangePlugin_1", (String)BOS_MSERVICE_BD, (Object[])new Object[0]));
            orgChangeCheckReport.setCheckStatus("W");
            orgChangeCheckReport.setDetails(checkDetails);
        }
        catch (Exception e) {
            orgChangeCheckReport.setCheckStatus("W");
            orgChangeCheckReport.setCheckResult(ResManager.loadKDString((String)"\u5b58\u5728\u96c6\u56e2\u7ba1\u63a7\u7684\u7c7b\u522b\uff0c\u66f4\u65b0\u7c7b\u522b\u521b\u5efa\u7ec4\u7ec7\u4e3a\u65b0\u6839\u7ec4\u7ec7\u5931\u8d25", (String)"AssistantUpdateWithOrgChangePlugin_2", (String)BOS_MSERVICE_BD, (Object[])new Object[0]));
        }
        return orgChangeCheckReport;
    }
}

