/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.service.internal.BaseDataCtrlAdapter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public abstract class AbstractBaseDataService {
    private static final Log LOGGER = LogFactory.getLog(AbstractBaseDataService.class);
    public static final String BASEDATAEXCSUFFIX = "Exc";
    private static final String ORG_ID = "org.id";
    protected static final String FIELD_ISCTRLUNIT = "isctrlunit";
    private static final String ENTITY_ORG_STRUCTURE = "bos_org_structure";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void saveBaseDataUseRange(String entityID, List<Long> dataIds, List<Long> useOrgIds) {
        if (CollectionUtils.isEmpty(dataIds) || CollectionUtils.isEmpty(useOrgIds)) {
            return;
        }
        HashSet<Long> useOrgSet = new HashSet<Long>(useOrgIds);
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityID);
        String baseDataTableName = dt.getAlias();
        String baseDataUseRangeTableName = baseDataTableName + "_U";
        String bsaeDataExcTableName = baseDataTableName + BASEDATAEXCSUFFIX;
        String insertUseRangeSQL = " insert into " + baseDataUseRangeTableName + "(FUseOrgID, FDataID) values(?, ?)";
        String dbRouteKey = dt.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        try (TXHandle h = TX.requiresNew();){
            Object row2;
            int dataSize = dataIds.size();
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(useOrgSet.size() * dataSize);
            HashSet savedDataIds = new HashSet(dataSize);
            HashSet excedDataIds = new HashSet(dataSize);
            HashSet<Long> needSaveDataIds = new HashSet<Long>(dataSize);
            SqlBuilder useRangeQuery = new SqlBuilder();
            useRangeQuery.append(" select fdataid,fuseorgid from ", new Object[0]);
            useRangeQuery.append(baseDataUseRangeTableName, new Object[0]);
            useRangeQuery.append("  where ", new Object[0]);
            useRangeQuery.appendIn("fuseorgid", new ArrayList<Long>(useOrgSet));
            useRangeQuery.append("  and ", new Object[0]);
            useRangeQuery.appendIn("fdataid", new ArrayList<Long>(dataIds));
            HashMap allUseRange = new HashMap(useOrgSet.size());
            try (DataSet ds = DB.queryDataSet((String)AbstractBaseDataService.class.getName(), (DBRoute)dbRoute, (SqlBuilder)useRangeQuery);){
                for (Object row2 : ds) {
                    if (row2.getLong("fdataid") == null) continue;
                    Long useOrgId = row2.getLong("fuseorgid");
                    ArrayList<Long> tempDataIds = (ArrayList<Long>)allUseRange.get(useOrgId);
                    if (null == tempDataIds) {
                        tempDataIds = new ArrayList<Long>(16);
                    }
                    Long dataid = row2.getLong("fdataid");
                    tempDataIds.add(dataid);
                    allUseRange.put(useOrgId, tempDataIds);
                }
            }
            SqlBuilder excQuery = new SqlBuilder();
            excQuery.append(" select fdataid,fuseorgid from ", new Object[0]);
            excQuery.append(bsaeDataExcTableName, new Object[0]);
            excQuery.append("  where ", new Object[0]);
            excQuery.appendIn("fuseorgid", new ArrayList<Long>(useOrgSet));
            excQuery.append("  and ", new Object[0]);
            excQuery.appendIn("fdataid", new ArrayList<Long>(dataIds));
            HashMap allExcData = new HashMap(useOrgSet.size());
            DataSet ds = DB.queryDataSet((String)AbstractBaseDataService.class.getName(), (DBRoute)dbRoute, (SqlBuilder)excQuery);
            row2 = null;
            try {
                Iterator iter = ds.iterator();
                while (iter.hasNext()) {
                    Row row3 = (Row)iter.next();
                    if (row3.getLong("fdataid") == null) continue;
                    Long useOrgId = row3.getLong("fuseorgid");
                    ArrayList<Long> tempDataIds = (ArrayList<Long>)allExcData.get(useOrgId);
                    if (null == tempDataIds) {
                        tempDataIds = new ArrayList<Long>(16);
                    }
                    Long dataid = row3.getLong("fdataid");
                    tempDataIds.add(dataid);
                    allExcData.put(useOrgId, tempDataIds);
                }
            }
            catch (Throwable iter) {
                row2 = iter;
                throw iter;
            }
            finally {
                if (ds != null) {
                    if (row2 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable iter) {
                            ((Throwable)row2).addSuppressed(iter);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            for (Long useOrgID : useOrgSet) {
                needSaveDataIds.addAll(dataIds);
                List tempDataIds = (List)allUseRange.get(useOrgID);
                if (null != tempDataIds) {
                    savedDataIds.addAll(tempDataIds);
                }
                needSaveDataIds.removeAll(savedDataIds);
                tempDataIds = (List)allExcData.get(useOrgID);
                if (null != tempDataIds) {
                    excedDataIds.addAll(tempDataIds);
                }
                needSaveDataIds.removeAll(excedDataIds);
                for (Long dataId : needSaveDataIds) {
                    Object[] params = new Object[]{useOrgID, dataId};
                    paramsList.add(params);
                    if (paramsList.size() != 10000) continue;
                    DB.executeBatch((DBRoute)dbRoute, (String)insertUseRangeSQL, paramsList);
                    paramsList.clear();
                }
                savedDataIds.clear();
                needSaveDataIds.clear();
                excedDataIds.clear();
            }
            if (!paramsList.isEmpty()) {
                DB.executeBatch((DBRoute)dbRoute, (String)insertUseRangeSQL, paramsList);
            }
            HashMap cacachMap = new HashMap(useOrgIds.size());
            useOrgIds.forEach(orgId -> cacachMap.putIfAbsent(orgId, Boolean.TRUE));
            BaseDataCtrlCache.updateIsHasBaseDataUseRangeBatch((String)entityID, cacachMap);
        }
    }

    public void saveBaseDataUseRange(DynamicObject[] dataArr, List<Long> useOrgList) {
        if (dataArr == null || dataArr.length == 0 || CollectionUtils.isEmpty(useOrgList)) {
            return;
        }
        DynamicObject dataInfo = dataArr[0];
        String entityID = dataInfo.getDataEntityType().getName();
        ArrayList<Long> dataIds = new ArrayList<Long>(dataArr.length);
        for (DynamicObject data : dataArr) {
            dataIds.add((Long)data.getPkValue());
        }
        this.saveBaseDataUseRange(entityID, dataIds, useOrgList);
    }

    void saveBaseDataUseRange(DynamicObject dataInfo, List<Long> useOrgList) {
        DynamicObject[] dataArr = new DynamicObject[]{dataInfo};
        this.saveBaseDataUseRange(dataArr, useOrgList);
    }

    void saveBaseDataUseReg(String entityID, List<Long> dataIds, Long createOrgID, Long adminOrgID, List<Long> useOrgIds, String ctrlStrategy, boolean isAssign) {
        Long assignOrgId = 0L;
        this.saveBaseDataUseReg(entityID, dataIds, createOrgID, adminOrgID, useOrgIds, ctrlStrategy, isAssign, assignOrgId);
    }

    protected void saveBaseDataUseReg(String entityID, List<Long> dataIds, Long createOrgID, Long adminOrgID, List<Long> useOrgIds, String ctrlStrategy, boolean isAssign, Long assignOrgID) {
        if (CollectionUtils.isEmpty(dataIds) || CollectionUtils.isEmpty(useOrgIds)) {
            return;
        }
        HashSet<Long> useOrgSet = new HashSet<Long>(useOrgIds);
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityID);
        String baseDataTableName = dt.getAlias();
        String baseDataUseRegTableName = baseDataTableName + "UseReg";
        String insertSql = " insert into " + baseDataUseRegTableName + "(FUseOrgID, FDataID, FCreateOrgID, FAdminOrgID, FCtrlStrategy,FIsAssign, FAssignOrgID) values(?, ?, ?, ?, ?, ?, ?) ";
        String dbRouteKey = dt.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        try (TXHandle h = TX.beginRequired();){
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(useOrgSet.size());
            HashSet savedDataIds = new HashSet(dataIds.size());
            HashSet<Long> needSaveDataIds = new HashSet<Long>(dataIds.size());
            ArrayList<Object[]> fixUseregParmList = new ArrayList<Object[]>();
            StringBuilder fixUseregSql = new StringBuilder();
            String isAssignStr = "'1'";
            isAssignStr = isAssign ? "1" : "0";
            HashMap<Long, List<Long>> allUseReg = new HashMap<Long, List<Long>>(useOrgSet.size());
            HashMap<String, Map<String, Long>> allUseRegMap = new HashMap<String, Map<String, Long>>(useOrgSet.size());
            this.getUseReg(entityID, new HashSet<Long>(dataIds), useOrgSet, allUseReg, allUseRegMap);
            fixUseregSql.append("update ").append(baseDataUseRegTableName).append(" set ");
            fixUseregSql.append(" fcreateorgid = ?,fadminorgid = ?,fassignorgid = ?,fisassign = ?");
            fixUseregSql.append(" where fuseorgid = ? and fdataid = ? ");
            for (Long useOrgID : useOrgSet) {
                if (null != allUseReg.get(useOrgID)) {
                    savedDataIds.addAll((Collection)allUseReg.get(useOrgID));
                }
                needSaveDataIds.addAll(dataIds);
                for (Long dataId : needSaveDataIds) {
                    Map tempMap = (Map)allUseRegMap.get(useOrgID + "" + dataId);
                    if (null == tempMap) continue;
                    Long tmpUseOrgId = (Long)tempMap.get("useOrgId");
                    Long tmpDataId = (Long)tempMap.get("dataId");
                    Long tmpCreateOrgID = (Long)tempMap.get("createOrgID");
                    Long tmpAdminOrgID = (Long)tempMap.get("adminOrgID");
                    Long tmpAssignOrgID = (Long)tempMap.get("assignOrgID");
                    if (!useOrgID.equals(tmpUseOrgId) || !dataId.equals(tmpDataId) || createOrgID.equals(tmpCreateOrgID) && adminOrgID.equals(tmpAdminOrgID) && assignOrgID.equals(tmpAssignOrgID)) continue;
                    Object[] fixUseregParm = new Object[]{createOrgID, adminOrgID, assignOrgID, isAssignStr, useOrgID, dataId};
                    fixUseregParmList.add(fixUseregParm);
                }
                needSaveDataIds.removeAll(savedDataIds);
                for (Long dataId : needSaveDataIds) {
                    Object[] params = new Object[]{useOrgID, dataId, createOrgID, adminOrgID, ctrlStrategy, isAssignStr, assignOrgID};
                    paramsList.add(params);
                    if (paramsList.size() != 10000) continue;
                    DB.executeBatch((DBRoute)dbRoute, (String)insertSql, paramsList);
                    paramsList.clear();
                }
                savedDataIds.clear();
                needSaveDataIds.clear();
            }
            if (!paramsList.isEmpty()) {
                DB.executeBatch((DBRoute)dbRoute, (String)insertSql, paramsList);
            }
            if (!fixUseregParmList.isEmpty()) {
                DB.executeBatch((DBRoute)dbRoute, (String)fixUseregSql.toString(), fixUseregParmList);
            }
        }
    }

    protected void getUseReg(String entityID, Set<Long> dataIds, Set<Long> orgIds, Map<Long, List<Long>> allUseReg, Map<String, Map<String, Long>> allUseRegMap) {
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityID);
        String baseDataTableName = dt.getAlias();
        String baseDataUseRegTableName = baseDataTableName + "UseReg";
        String dbRouteKey = dt.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        SqlBuilder useRegQuery = new SqlBuilder();
        useRegQuery.append(" select fdataid,fuseorgid,fcreateorgid,fadminorgid,fassignorgid from ", new Object[0]);
        useRegQuery.append(baseDataUseRegTableName, new Object[0]);
        useRegQuery.append("  where ", new Object[0]);
        useRegQuery.appendIn("fuseorgid", new ArrayList<Long>(orgIds));
        useRegQuery.append("  and ", new Object[0]);
        useRegQuery.appendIn("fdataid", new ArrayList<Long>(dataIds));
        try (DataSet ds = DB.queryDataSet((String)AbstractBaseDataService.class.getName(), (DBRoute)dbRoute, (SqlBuilder)useRegQuery);){
            int savedCount = 0;
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                if (++savedCount > 100000) {
                    LOGGER.error("\u5206\u914d\u5931\u8d25\uff0c\u91cd\u590d\u5206\u914d\u7684\u8bb0\u5f55\u592a\u591a\uff0c\u8bf7\u9009\u62e9\u5c11\u91cf\u7ec4\u7ec7\uff0c\u6216\u8005\u51cf\u5c11\u5206\u914d\u7684\u6570\u636e\u3002");
                    throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff0c\u91cd\u590d\u5206\u914d\u7684\u8bb0\u5f55\u592a\u591a\uff0c\u8bf7\u9009\u62e9\u5c11\u91cf\u7ec4\u7ec7\uff0c\u6216\u8005\u51cf\u5c11\u5206\u914d\u7684\u6570\u636e\u3002", (String)"AbstractBaseDataService_2", (String)"bos-mservice-bd", (Object[])new Object[0])), new Object[0]);
                }
                Row row = (Row)iter.next();
                Long dataId = row.getLong("fdataid");
                if (dataId == null) continue;
                Long createorgid = row.getLong("fcreateorgid");
                Long adminorgid = row.getLong("fadminorgid");
                Long assignorgid = row.getLong("fassignorgid");
                Long useOrgId = row.getLong("fuseorgid");
                List<Long> tempDataIds = allUseReg.get(useOrgId);
                if (null == tempDataIds) {
                    tempDataIds = new ArrayList<Long>(16);
                }
                tempDataIds.add(dataId);
                allUseReg.put(useOrgId, tempDataIds);
                HashMap<String, Long> tempMap = new HashMap<String, Long>(5);
                tempMap.put("useOrgId", useOrgId);
                tempMap.put("dataId", dataId);
                tempMap.put("createOrgID", createorgid);
                tempMap.put("adminOrgID", adminorgid);
                tempMap.put("assignOrgID", assignorgid);
                allUseRegMap.put(useOrgId + "" + dataId, tempMap);
            }
        }
    }

    protected void saveBaseDataUseReg(DynamicObject[] dataArr, Long createOrgID, Long adminOrgID, List<Long> useOrgList, String ctrlStrategy) {
        if (dataArr == null || dataArr.length == 0 || null == useOrgList) {
            return;
        }
        HashSet<Long> useOrgSet = new HashSet<Long>(useOrgList);
        DynamicObject dataInfo = dataArr[0];
        String baseDataTableName = dataInfo.getDataEntityType().getAlias();
        String baseDataUseRegTableName = baseDataTableName + "UseReg";
        String insertSql = " insert into " + baseDataUseRegTableName + "(FUseOrgID, FDataID, FCreateOrgID, FAdminOrgID, FCtrlStrategy,FIsAssign) values(?, ?, ?, ?, ?,'0') ";
        String dbRouteKey = dataInfo.getDataEntityType().getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        try (TXHandle h = TX.beginRequired();){
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(useOrgSet.size());
            HashSet<Long> dataIds = new HashSet<Long>(dataArr.length);
            for (DynamicObject dynamicObject : dataArr) {
                dataIds.add((Long)dynamicObject.getPkValue());
            }
            SqlBuilder useRegQuery = new SqlBuilder();
            useRegQuery.append(" select fdataid,fuseorgid from ", new Object[0]);
            useRegQuery.append(baseDataUseRegTableName, new Object[0]);
            useRegQuery.append("  where ", new Object[0]);
            useRegQuery.appendIn("fuseorgid", new ArrayList<Long>(useOrgSet));
            useRegQuery.append("  and ", new Object[0]);
            useRegQuery.appendIn("fdataid", new ArrayList(dataIds));
            HashMap allUseReg = new HashMap(useOrgSet.size());
            Throwable throwable = null;
            try (DataSet ds = DB.queryDataSet((String)AbstractBaseDataService.class.getName(), (DBRoute)dbRoute, (SqlBuilder)useRegQuery);){
                int savedCount = 0;
                Iterator iter = ds.iterator();
                while (iter.hasNext()) {
                    if (++savedCount > 100000) {
                        LOGGER.error("\u5206\u914d\u5931\u8d25\uff0c\u91cd\u590d\u5206\u914d\u7684\u8bb0\u5f55\u592a\u591a\uff0c\u8bf7\u9009\u62e9\u5c11\u91cf\u7ec4\u7ec7\uff0c\u6216\u8005\u51cf\u5c11\u5206\u914d\u7684\u6570\u636e\u3002");
                        throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff0c\u91cd\u590d\u5206\u914d\u7684\u8bb0\u5f55\u592a\u591a\uff0c\u8bf7\u9009\u62e9\u5c11\u91cf\u7ec4\u7ec7\uff0c\u6216\u8005\u51cf\u5c11\u5206\u914d\u7684\u6570\u636e\u3002", (String)"AbstractBaseDataService_2", (String)"bos-mservice-bd", (Object[])new Object[0])), new Object[0]);
                    }
                    Row row = (Row)iter.next();
                    if (row.getLong("fdataid") == null) continue;
                    Long useOrgId = row.getLong("fuseorgid");
                    ArrayList<Long> tempDataIds = (ArrayList<Long>)allUseReg.get(useOrgId);
                    if (null == tempDataIds) {
                        tempDataIds = new ArrayList<Long>(16);
                    }
                    Long dataid = row.getLong("fdataid");
                    tempDataIds.add(dataid);
                    allUseReg.put(useOrgId, tempDataIds);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            HashSet savedDataIds = new HashSet(dataArr.length);
            HashSet<Long> hashSet = new HashSet<Long>(dataArr.length);
            for (Long useOrgID : useOrgSet) {
                if (null != allUseReg.get(useOrgID)) {
                    savedDataIds.addAll((Collection)allUseReg.get(useOrgID));
                }
                hashSet.addAll(dataIds);
                hashSet.removeAll(savedDataIds);
                for (Long dataId : hashSet) {
                    Object[] params = new Object[]{useOrgID, dataId, createOrgID, adminOrgID, ctrlStrategy};
                    paramsList.add(params);
                    if (paramsList.size() != 10000) continue;
                    DB.executeBatch((DBRoute)dbRoute, (String)insertSql, paramsList);
                    paramsList.clear();
                }
                savedDataIds.clear();
                hashSet.clear();
            }
            if (!paramsList.isEmpty()) {
                DB.executeBatch((DBRoute)dbRoute, (String)insertSql, paramsList);
            }
        }
    }

    Map<String, DynamicObject> getCtrlViews(Set<String> entityIds) {
        if (CollectionUtils.isEmpty(entityIds)) {
            return Collections.emptyMap();
        }
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(16);
        HashSet<String> copyEntityIds = new HashSet<String>(entityIds);
        QFilter[] baseDataFilters = new QFilter[]{new QFilter("basedata", "in", entityIds)};
        Map baseDataViews = BusinessDataServiceHelper.loadFromCache((String)"bd_basedataview", (String)"ctrlview.treetype, basedata", (QFilter[])baseDataFilters);
        if (null != baseDataViews && baseDataViews.size() > 0) {
            for (DynamicObject dataView : baseDataViews.values()) {
                DynamicObject entity = dataView.getDynamicObject("basedata");
                DynamicObject view = dataView.getDynamicObject("ctrlview");
                if (null == entity || null == view) continue;
                String entityId = entity.getPkValue().toString();
                result.put(entityId, view);
                copyEntityIds.remove(entityId);
            }
        }
        if (CollectionUtils.isEmpty(copyEntityIds)) {
            return result;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("basedataid", "in", copyEntityIds)};
        Map defaultCtrlStrategies = BusinessDataServiceHelper.loadFromCache((String)"bd_bddefctrlstrtgy", (String)"ctrlview.treetype, basedataid", (QFilter[])qFilters);
        if (null != defaultCtrlStrategies && defaultCtrlStrategies.size() > 0) {
            for (DynamicObject defaultCtrlStrategy : defaultCtrlStrategies.values()) {
                DynamicObject entity = defaultCtrlStrategy.getDynamicObject("basedataid");
                DynamicObject view = defaultCtrlStrategy.getDynamicObject("ctrlview");
                if (null == entity || null == view) continue;
                String entityId = entity.getPkValue().toString();
                result.put(entityId, view);
            }
        }
        return result;
    }

    public Long getBaseDataCreateOrgId(DynamicObject baseData) {
        return this.getBaseDataCreateOrgId(baseData, 0L);
    }

    public Long getBaseDataCreateOrgId(DynamicObject baseData, Long defaultValue) {
        Object org = baseData.get("createorg");
        if (Objects.isNull(org)) {
            return defaultValue;
        }
        if (org instanceof DynamicObject) {
            DynamicObject createOrg = (DynamicObject)org;
            return null == createOrg.getPkValue() ? createOrg.getLong("id") : ((Long)createOrg.getPkValue()).longValue();
        }
        if (org instanceof Long) {
            return (Long)baseData.get("createorg");
        }
        return defaultValue;
    }

    public List<Long> getDirectSubordinateOrgList(Long orgViewId, Long parentOrgId) {
        return BaseDataCtrlAdapter.getDirectSubordinateOrgList(orgViewId, parentOrgId);
    }

    public Long getSupCtrlUintOrg(String entityID, Long orgId) {
        Long supCtrlUint = 0L;
        Map<String, DynamicObject> ctrlViewMap = this.getCtrlViews(new HashSet<String>(Collections.singleton(entityID)));
        DynamicObject ctrlview = ctrlViewMap.get(entityID);
        if (null == ctrlViewMap || null == ctrlview) {
            return supCtrlUint;
        }
        String viewNumber = ctrlview.getString("number");
        Long viewId = ctrlview.getLong("id");
        List supOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)viewNumber, (long)orgId);
        HashSet supOrgIdSet = new HashSet();
        supOrgIdSet.addAll(supOrgIds);
        QFilter viewFilter = new QFilter("view.id", "=", (Object)viewId);
        QFilter orgFilter = new QFilter(ORG_ID, "in", supOrgIdSet);
        QFilter ctrlUnitFilter = new QFilter(FIELD_ISCTRLUNIT, "=", (Object)Boolean.TRUE);
        QFilter[] qfilters = new QFilter[]{viewFilter, orgFilter, ctrlUnitFilter};
        DynamicObject[] viewOrgs = BusinessDataServiceHelper.load((String)ENTITY_ORG_STRUCTURE, (String)"id,org.id,isctrlunit,longnumber", (QFilter[])qfilters, (String)"longnumber desc");
        if (viewOrgs != null && viewOrgs.length > 0) {
            supCtrlUint = viewOrgs[0].getLong(ORG_ID);
        }
        return supCtrlUint;
    }

    public void savePrivateBaseDataUseRange(String entityID, List<Object[]> privateParams) {
        this.saveBaseDataUseRange(entityID, privateParams);
    }

    public void saveBaseDataUseRange(String entityID, List<Object[]> saveParams) {
        if (CollectionUtils.isEmpty(saveParams)) {
            return;
        }
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityID);
        String baseDataTableName = dt.getAlias();
        String baseDataUseRangeTableName = baseDataTableName + "_U";
        String insertUseRangeSQL = " insert into " + baseDataUseRangeTableName + "(FDataID, FUseOrgID) values(?, ?)";
        String dbRouteKey = dt.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        try (TXHandle h = TX.requiresNew();){
            Iterator<Object[]> useOrgId;
            int dataSize = saveParams.size();
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(dataSize);
            HashSet<Iterator<Object[]>> useOrgSet = new HashSet<Iterator<Object[]>>(dataSize);
            HashSet<Object> dataIds = new HashSet<Object>(dataSize);
            for (Object[] saveParam : saveParams) {
                Object dataId = saveParam[0];
                useOrgId = saveParam[1];
                dataIds.add(dataId);
                useOrgSet.add(useOrgId);
            }
            SqlBuilder useRangeQuery = new SqlBuilder();
            useRangeQuery.append(" select fdataid,fuseorgid from ", new Object[0]);
            useRangeQuery.append(baseDataUseRangeTableName, new Object[0]);
            useRangeQuery.append("  where ", new Object[0]);
            useRangeQuery.appendIn("fuseorgid", new ArrayList(useOrgSet));
            useRangeQuery.append("  and ", new Object[0]);
            useRangeQuery.appendIn("fdataid", new ArrayList(dataIds));
            HashMap<String, String> savedUseRange = new HashMap<String, String>(useOrgSet.size());
            DataSet ds = DB.queryDataSet((String)AbstractBaseDataService.class.getName(), (DBRoute)dbRoute, (SqlBuilder)useRangeQuery);
            useOrgId = null;
            try {
                int savedCount = 0;
                Iterator iter = ds.iterator();
                while (iter.hasNext()) {
                    if (++savedCount > 100000) {
                        LOGGER.error("\u5206\u914d\u5931\u8d25\uff0c\u91cd\u590d\u5206\u914d\u7684\u8bb0\u5f55\u592a\u591a\uff0c\u8bf7\u9009\u62e9\u5c11\u91cf\u7ec4\u7ec7\uff0c\u6216\u8005\u51cf\u5c11\u5206\u914d\u7684\u6570\u636e\u3002");
                        throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff0c\u91cd\u590d\u5206\u914d\u7684\u8bb0\u5f55\u592a\u591a\uff0c\u8bf7\u9009\u62e9\u5c11\u91cf\u7ec4\u7ec7\uff0c\u6216\u8005\u51cf\u5c11\u5206\u914d\u7684\u6570\u636e\u3002", (String)"AbstractBaseDataService_2", (String)"bos-mservice-bd", (Object[])new Object[0])), new Object[0]);
                    }
                    Row row = (Row)iter.next();
                    Long dataId = row.getLong("fdataid");
                    if (dataId == null) continue;
                    Long useOrgId2 = row.getLong("fuseorgid");
                    savedUseRange.put(dataId + "" + useOrgId2, "1");
                }
            }
            catch (Throwable savedCount) {
                useOrgId = savedCount;
                throw savedCount;
            }
            finally {
                if (ds != null) {
                    if (useOrgId != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable savedCount) {
                            ((Throwable)((Object)useOrgId)).addSuppressed(savedCount);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            List<Object[]> saveParamsRmDuplicated = this.removeDuplicated(saveParams);
            for (Object[] saveParam : saveParamsRmDuplicated) {
                Object dataId = saveParam[0];
                Object useOrgId3 = saveParam[1];
                if (null == savedUseRange.get(dataId + "" + useOrgId3)) {
                    paramsList.add(saveParam);
                }
                if (paramsList.size() != 10000) continue;
                DB.executeBatch((DBRoute)dbRoute, (String)insertUseRangeSQL, paramsList);
                paramsList.clear();
            }
            if (!paramsList.isEmpty()) {
                DB.executeBatch((DBRoute)dbRoute, (String)insertUseRangeSQL, paramsList);
            }
            HashMap cacachMap = new HashMap(saveParams.size());
            saveParams.forEach(param -> cacachMap.putIfAbsent(Long.valueOf(param[1].toString()), Boolean.TRUE));
            BaseDataCtrlCache.updateIsHasBaseDataUseRangeBatch((String)entityID, cacachMap);
        }
    }

    private List<Object[]> removeDuplicated(List<Object[]> saveParams) {
        ArrayList<Object[]> saveParamsRmDuplicated = new ArrayList<Object[]>(saveParams.size());
        HashMap<String, String> map = new HashMap<String, String>(saveParams.size());
        for (Object[] saveParam : saveParams) {
            Object dataId = saveParam[0];
            Object useOrgId = saveParam[1];
            if (null != map.get(String.valueOf(dataId) + String.valueOf(useOrgId))) continue;
            saveParamsRmDuplicated.add(saveParam);
            map.put(String.valueOf(dataId) + String.valueOf(useOrgId), "1");
        }
        return saveParamsRmDuplicated;
    }
}

