/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.basedata.common.BaseDataCtrlLog;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.log.LogServiceHelper;

public class BDCtrlLogServiceHelper {
    private static Log logger = LogFactory.getLog(BDCtrlLogServiceHelper.class);

    public static void saveLog(String appNumber, String bizObjID, String opName, Long orgId, String opDescription) {
        try {
            ArrayList<BaseDataCtrlLog> bdCtrlLogs = new ArrayList<BaseDataCtrlLog>(1);
            BaseDataCtrlLog bdCtrlLog = new BaseDataCtrlLog(appNumber, bizObjID, opName, orgId, opDescription);
            bdCtrlLogs.add(bdCtrlLog);
            BDCtrlLogServiceHelper.saveLogBatch(bdCtrlLogs);
        }
        catch (Exception e) {
            logger.error(" save logger error:", (Throwable)e);
        }
    }

    public static void saveLogBatch(List<BaseDataCtrlLog> bdCtrlLogs) {
        try {
            if (CollectionUtils.isEmpty(bdCtrlLogs)) {
                return;
            }
            ArrayList<OpLogAppInfo> appLogInfoList = new ArrayList<OpLogAppInfo>(bdCtrlLogs.size());
            OpLogAppInfo appLogInfo = null;
            Long userId = RequestContext.get().getCurrUserId();
            Date opTime = new Date();
            String clientType = RequestContext.get().getClient();
            String clientIP = RequestContext.get().getLoginIP();
            String clientName = RequestContext.get().getClient();
            String accountId = RequestContext.get().getAccountId();
            String tenantId = RequestContext.get().getTenantId();
            String language = RequestContext.get().getLang().name();
            for (BaseDataCtrlLog bdCtrlLog : bdCtrlLogs) {
                String appNumber = bdCtrlLog.getAppNumber();
                String bizObjID = bdCtrlLog.getBizObjID();
                String opName = bdCtrlLog.getOpName();
                String opDescription = bdCtrlLog.getOpDescription();
                Long orgId = bdCtrlLog.getOrgId();
                appLogInfo = new OpLogAppInfo();
                appLogInfo.setUserID(userId);
                appLogInfo.setBizAppID(BizAppServiceHelp.getAppIdByAppNumber((String)appNumber));
                appLogInfo.setBizObjID(bizObjID);
                appLogInfo.setOrgID(orgId);
                appLogInfo.setOpTime(opTime);
                appLogInfo.setClientType(clientType);
                appLogInfo.setClientIP(clientIP);
                appLogInfo.setClientName(clientName);
                appLogInfo.setOpName(opName);
                if (StringUtils.isNotBlank((CharSequence)opDescription) && opDescription.length() > 258) {
                    opDescription = opDescription.substring(0, 256) + "...";
                }
                appLogInfo.setOpDescription(opDescription);
                appLogInfo.setAccountId(accountId);
                appLogInfo.setTenantId(tenantId);
                appLogInfo.setLanguage(language);
                if (null != bdCtrlLog.getOpKey() && null != bdCtrlLog.getOpShowName()) {
                    appLogInfo.setOpName(bdCtrlLog.getOpKey(), bdCtrlLog.getOpShowName());
                } else if (null != bdCtrlLog.getOpKey() && null != bdCtrlLog.getOpNameBridge()) {
                    appLogInfo.setOpName(bdCtrlLog.getOpKey(), bdCtrlLog.getOpNameBridge());
                }
                if (null != bdCtrlLog.getMultiLangDesc()) {
                    appLogInfo.setOpDesc(bdCtrlLog.getMultiLangDesc(), bdCtrlLog.getArgs());
                }
                appLogInfo.setKeyWord(bdCtrlLog.getKeyWord());
                appLogInfoList.add(appLogInfo);
            }
            LogServiceHelper.addBatchLog(appLogInfoList);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }
}

