/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.basedata.service.AbstractBaseDataService;
import kd.bos.basedata.service.BaseDataServiceImpl;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class BaseDataAuditService
extends AbstractBaseDataService {
    private static final Log LOGGER = LogFactory.getLog(BaseDataServiceImpl.class);

    public void baseDataAuditHandler(DynamicObject[] baseDataArr) {
        if (baseDataArr == null || baseDataArr.length == 0) {
            return;
        }
        String entity = baseDataArr[0].getDataEntityType().getName();
        if (BaseDataCommonService.isNewModel((String)entity)) {
            try {
                new kd.bos.bd.service.BaseDataAuditService().baseDataAuditHandler(baseDataArr);
                return;
            }
            catch (Exception e) {
                LOGGER.error("\u5ba1\u6838\u6570\u636e\u751f\u6210\u4f4d\u56fe\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                throw new KDBizException("fail to generate bitmap data on audit operation...");
            }
        }
        HashSet<String> needValidateCtrlViewEntityIds = new HashSet<String>(baseDataArr.length);
        HashMap<String, List> dataMap = new HashMap<String, List>(16);
        for (DynamicObject data : baseDataArr) {
            String ctrlStrategy = data.getString("ctrlstrategy");
            Long createOrgID = this.getBaseDataCreateOrgId(data);
            String key = ctrlStrategy + "_" + createOrgID;
            List dataSet = dataMap.computeIfAbsent(key, k -> new ArrayList());
            dataSet.add(data);
            if (!"1".equals(ctrlStrategy) && !"2".equals(ctrlStrategy) && !"6".equals(ctrlStrategy)) continue;
            needValidateCtrlViewEntityIds.add(data.getDataEntityType().getName());
        }
        Map<String, DynamicObject> ctrlViews = this.getCtrlViews(needValidateCtrlViewEntityIds);
        if (this.notExistCtrlView(ctrlViews, needValidateCtrlViewEntityIds)) {
            return;
        }
        HashSet<Long> clearOrgSet = new HashSet<Long>();
        for (Map.Entry entry : dataMap.entrySet()) {
            DynamicObject dataInfo = (DynamicObject)((List)entry.getValue()).get(0);
            String entityId = dataInfo.getDataEntityType().getName();
            String ctrlStrategy = dataInfo.getString("ctrlstrategy");
            if ("3".equals(ctrlStrategy) || "4".equals(ctrlStrategy) || "7".equals(ctrlStrategy) || "1".equals(ctrlStrategy) || "2".equals(ctrlStrategy)) continue;
            if ("6".equals(ctrlStrategy)) {
                DynamicObject[] dataInfos = ((List)entry.getValue()).toArray(new DynamicObject[0]);
                DynamicObject createOrg = dataInfo.getDynamicObject("createorg");
                this.handleCuShareStrategy(clearOrgSet, dataInfos, createOrg, ctrlViews.get(entityId));
                continue;
            }
            if (!"5".equals(ctrlStrategy)) continue;
            BaseDataCtrlCacheMrg.clearCacheWithPrefix((String)BaseDataCtrlCacheMrg.getType4BaseDataFilter(), (String)entityId);
        }
    }

    private boolean notExistCtrlView(Map<String, DynamicObject> ctrlViews, Set<String> needValidateCtrlViewEntityIds) {
        if (CollectionUtils.isEmpty(needValidateCtrlViewEntityIds)) {
            return false;
        }
        for (String entityId : needValidateCtrlViewEntityIds) {
            if (null != ctrlViews.get(entityId)) continue;
            LOGGER.warn("\u672c\u6b21\u5ba1\u6838\u7684\u57fa\u7840\u8d44\u6599\u4e2d\uff0c\u90e8\u5206\u6570\u636e\u4e0d\u5b58\u5728\u63a7\u5236\u89c6\u56fe\uff0c\u4e0d\u8fdb\u884c\u5ba1\u6838\u64cd\u4f5c\u3002\u57fa\u7840\u8d44\u6599\u7c7b\u578b\uff1a" + entityId);
            return true;
        }
        return false;
    }

    private void handleCuShareStrategy(Set<Long> clearOrgSet, DynamicObject[] dataInfos, DynamicObject createOrg, DynamicObject ctrlView) {
        try {
            ArrayList<Long> useOrgList = new ArrayList<Long>(1);
            useOrgList.add((Long)createOrg.getPkValue());
            List allSubordinateOrg = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)((Long)ctrlView.getPkValue()), useOrgList, (boolean)true);
            List<Long> orgList = this.getCuOrgIds((Long)ctrlView.getPkValue(), allSubordinateOrg);
            clearOrgSet.addAll(orgList);
            this.saveBaseDataUseRange(dataInfos, orgList);
        }
        catch (Exception e) {
            LOGGER.error("BaseDataServiceHelper.baseDataAddnewHandler" + e.getMessage(), (Throwable)e);
        }
    }

    private List<Long> getCuOrgIds(Long viewId, List<Long> orgIds) {
        QFilter f1 = new QFilter("org", "in", orgIds);
        QFilter f2 = new QFilter("view.id", "=", (Object)viewId);
        QFilter f3 = new QFilter("isctrlunit", "=", (Object)Boolean.TRUE);
        QFilter f4 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] qFilters = null;
        qFilters = new QFilter[]{f1, f2, f3, f4};
        ArrayList<Long> cuOrgIds = new ArrayList<Long>(16);
        ORM ormOV = ORM.create();
        try (DataSet ds = ormOV.queryDataSet(BaseDataServiceImpl.class.getName(), "bos_org_structure", "org.id", qFilters);){
            for (Row row : ds) {
                Long orgId = row.getLong("org.id");
                if (orgId == null) continue;
                cuOrgIds.add(orgId);
            }
        }
        return cuOrgIds;
    }
}

