/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.service;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.basedata.query.BasedataGroupManager;
import kd.bos.basedata.service.AbstractBaseDataService;
import kd.bos.basedata.service.BaseDataAuditService;
import kd.bos.basedata.service.BaseDataQueryService;
import kd.bos.basedata.service.CancelAssignService;
import kd.bos.basedata.service.internal.BaseDataAddAdapter;
import kd.bos.basedata.service.internal.BaseDataAssignAdapter;
import kd.bos.basedata.service.internal.BaseDataCtrlAdapter;
import kd.bos.basedata.service.internal.BaseDataDeleteAdapter;
import kd.bos.basedata.service.internal.BaseDataDrmAdapter;
import kd.bos.basedata.service.internal.BaseDataOrgRelationAdapter;
import kd.bos.basedata.service.internal.BaseDataOrgUseRangAdapter;
import kd.bos.basedata.service.internal.ChangeCtrlStrategyAdapter;
import kd.bos.basedata.service.internal.IndividualizeAdapter;
import kd.bos.bd.service.AssignService;
import kd.bos.bd.service.BaseDataAutoUpgradeService;
import kd.bos.bd.service.BaseDataRepairService;
import kd.bos.bd.service.ChangeCtrlStrategyService;
import kd.bos.bd.service.ChangeManageRightService;
import kd.bos.bd.service.IndividualizeService;
import kd.bos.bd.service.internal.BaseDataSupplementService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.AssignQueryResponse;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.entity.basedata.CancelAssignResult;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.BaseEntity;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IBaseDataService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkService;

@SdkService(name="BaseDataServiceImpl")
public class BaseDataServiceImpl
extends AbstractBaseDataService
implements IBaseDataService {
    private static Log logger = LogFactory.getLog(BaseDataServiceImpl.class);
    public static final String DEFAULTCTRLSTRATEGY_ENTITYID = "bd_bddefctrlstrtgy";
    public static final String BDCTRLSTRTGY_ENTITYID = "bd_bdctrlstrtgy";
    public static final String ORG_ENTITYID = "bos_org";
    public static final String ORGBIZ_ENTITYID = "bos_org_biz";
    public static final String MANAGESTRATEGY_CREATEORG = "2";
    public static final String MANAGESTRATEGY_CU = "1";
    public static final String CTRLTYPE_ASSIGN = "D";
    public static final String CTRLTYPE_SHARE = "S";
    public static final String CTRLSTRATEGY_CU_ASSIGN = "1";
    public static final String CTRLSTRATEGY_CU_FREE_ASSIGN = "2";
    public static final String CTRLSTRATEGY_OU_ASSIGN = "3";
    public static final String CTRLSTRATEGY_OU_FREE_ASSIGN = "4";
    public static final String CTRLSTRATEGY_GLOBAL_SHARE = "5";
    public static final String CTRLSTRATEGY_CU_SHARE = "6";
    public static final String CTRLSTRATEGY_PRIVATE = "7";
    public static final String BASEDATAUSEREGSUFFIX = "UseReg";
    public static final String BASEDATAEXCSUFFIX = "Exc";
    public static final String BASEDATAUSERANGESUFFIX = "_U";
    public static final String ENTITYID_EXCHANGERATE = "bd_exrate_tree";
    public static final String ENTITYID_WORKCALENDAR = "bd_workcalendar";
    public static final String ENTITYID_ENTITYOPORGVIEW = "bd_entityoporgview";
    public static final String ENTITYID_ENTITYMETA = "bos_entitymeta";
    public static final String ENTITYID_BASEDATAVIEW = "bd_basedataview";
    public static final String BOS_USER_ENTITYID = "bos_user";
    public static final String EXRATE_CONVERT_MODE_DIRECT = "1";
    public static final String EXRATE_CONVERT_MODE_INDIRECT = "2";
    public static final String BD_ACCOUNTINGSYS = "bd_accountingsys";
    public static final String BD_ACCOUNTINGSYS_BASE = "bd_accountingsys_base";
    public static final String BD_ACCOUNTINGSYSVIEWSCH = "bd_accountingsysviewsch";
    public static final String DATA_STATUS = "status";
    public static final String DATA_STATUS_A = "A";
    public static final String DATA_STATUS_B = "B";
    public static final String DATA_STATUS_C = "C";
    private static final String ORG_ENTITY = "bos_org";
    public static final String ENTITYID_ORG_STRUCTURE = "bos_org_structure";
    private static final String QUERY_PERM = "47150e89000000ac";
    private static final List<String> noneCustomEntityList = new ArrayList<String>(10);
    private static final String BD_MATERIAL = "bd_material";
    private static final String ENABLE = "enable";
    private static final String CREATEORG = "createorg";
    private static final String CREATEORGID = "createorg.id";
    private static final String NUMBER = "number";
    private static final String FUSEORGID = "fuseorgid";
    private static final String USEORG = "useorg";
    private static final String BD_CTRLASSISTDATATYPE = "bd_ctrlassistdatatype";

    public static BigDecimal getExchangeRate(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        BigDecimal exchangeRate = null;
        exchangeRate = BaseDataServiceImpl.getExchangeRate(exchangeTableID, sourceCurrencyID, targetCurrencyID, "1", date);
        if (exchangeRate != null) {
            return exchangeRate;
        }
        exchangeRate = BaseDataServiceImpl.getExchangeRate(exchangeTableID, targetCurrencyID, sourceCurrencyID, "2", date);
        return exchangeRate;
    }

    public static BigDecimal getExchangeRate(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, String convertMode, Date date) {
        BigDecimal exchangeRate = null;
        ORM orm = ORM.create();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter exchangeTableFilter = new QFilter("exctable", "=", (Object)exchangeTableID);
        filterList.add(exchangeTableFilter);
        QFilter sourceCurrencyFilter = new QFilter("orgcur", "=", (Object)sourceCurrencyID);
        filterList.add(sourceCurrencyFilter);
        QFilter targetCurrencyFilter = new QFilter("cur", "=", (Object)targetCurrencyID);
        filterList.add(targetCurrencyFilter);
        QFilter targetEnableFilter = new QFilter(ENABLE, "=", (Object)Character.valueOf('1'));
        filterList.add(targetEnableFilter);
        if (date != null) {
            QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
            filterList.add(dateFilter);
        }
        String selectFields = "id,excval,indirectexrate";
        String orderBys = "effectdate desc";
        int top = 1;
        QFilter[] filters = new QFilter[filterList.size()];
        for (int i = 0; i < filterList.size(); ++i) {
            filters[i] = (QFilter)filterList.get(i);
        }
        DynamicObjectCollection list = orm.query(ENTITYID_EXCHANGERATE, selectFields, filters, orderBys, top);
        if (list != null && list.size() > 0) {
            DynamicObject exchangeRateInfo = (DynamicObject)list.get(0);
            switch (convertMode) {
                case "1": {
                    exchangeRate = exchangeRateInfo.getBigDecimal("excval");
                    break;
                }
                case "2": {
                    exchangeRate = exchangeRateInfo.getBigDecimal("indirectexrate");
                    break;
                }
            }
        }
        return exchangeRate;
    }

    public IOperationResult deleteFormGroup(Object[] ids, GroupProp prop) {
        BasedataGroupManager manager = new BasedataGroupManager();
        return manager.deleteFormGroup(ids, prop);
    }

    public boolean treeNodeUpdate(Object currentId, Object newParentId, GroupProp prop) {
        BasedataGroupManager manager = new BasedataGroupManager();
        return manager.treeNodeUpdate(currentId, newParentId, prop);
    }

    public DynamicObject getWorkCalendar(Long orgId) {
        int top;
        String orderBys;
        QFilter orgIdFilter;
        QFilter[] filters;
        String selectFields;
        DynamicObject workCalendar = null;
        ORM orm = ORM.create();
        DynamicObjectCollection list = orm.query(ENTITYID_WORKCALENDAR, selectFields = "*, dateentry.*", filters = new QFilter[]{orgIdFilter = new QFilter(CREATEORG, "=", (Object)orgId)}, orderBys = "dateentry.workdate asc", top = 1);
        if (list != null && list.size() > 0) {
            workCalendar = (DynamicObject)list.get(0);
        } else {
            List superiorOrgs = OrgServiceHelper.getSuperiorOrgs((long)orgId);
            if (superiorOrgs != null && superiorOrgs.size() == 1) {
                return this.getWorkCalendar((Long)superiorOrgs.get(0));
            }
        }
        return workCalendar;
    }

    public DynamicObject getWorkCalendar(Long orgId, Date startDate, Date endDate) {
        DynamicObject workCalendar = null;
        startDate = (Date)startDate.clone();
        startDate.setHours(0);
        startDate.setMinutes(0);
        startDate.setSeconds(0);
        endDate = (Date)endDate.clone();
        endDate.setHours(0);
        endDate.setMinutes(0);
        endDate.setSeconds(0);
        ORM orm = ORM.create();
        QFilter orgIdFilter = new QFilter(CREATEORGID, "=", (Object)orgId);
        QFilter startDateFilter = new QFilter("dateentry.workdate", ">=", (Object)startDate);
        QFilter endDateFilter = new QFilter("dateentry.workdate", "<=", (Object)endDate);
        String selectFields = "*, dateentry.*";
        String orderBys = "dateentry.workdate asc";
        int top = 1;
        QFilter[] filters = new QFilter[]{orgIdFilter, startDateFilter, endDateFilter};
        DynamicObjectCollection list = orm.query(ENTITYID_WORKCALENDAR, selectFields, filters, orderBys, top);
        if (list != null && list.size() > 0) {
            workCalendar = (DynamicObject)list.get(0);
        }
        return workCalendar;
    }

    public String getVerifyOrgPropertyName(String entityType, String operationKey) {
        String orgPropertyName = "";
        String key = entityType + "_" + operationKey;
        orgPropertyName = BaseDataCtrlCache.getVerifyOrgProperty((String)key);
        if (!StringUtils.isEmpty((CharSequence)orgPropertyName)) {
            if ("DATA_LOADED".equals(orgPropertyName)) {
                orgPropertyName = null;
            }
            return orgPropertyName;
        }
        String selectProperties = "id, orgproperty";
        QFilter entityFilter = new QFilter("basedata", "=", (Object)entityType);
        QFilter operationFilter = new QFilter("operation", "=", (Object)operationKey);
        QFilter[] filters = new QFilter[]{entityFilter, operationFilter};
        ORM orm = ORM.create();
        DynamicObjectCollection result = orm.query(ENTITYID_ENTITYOPORGVIEW, selectProperties, filters);
        if (result != null && result.size() > 0) {
            orgPropertyName = (String)((DynamicObject)result.get(0)).get("orgproperty");
        } else {
            selectProperties = "id, parentid.id, parentid.number";
            entityFilter = new QFilter(NUMBER, "=", (Object)entityType);
            filters = new QFilter[]{entityFilter};
            result = orm.query(ENTITYID_ENTITYMETA, selectProperties, filters);
            if (result != null && result.size() > 0) {
                DynamicObject parent = (DynamicObject)((DynamicObject)result.get(0)).get("parentid");
                if (parent == null) {
                    orgPropertyName = "DATA_LOADED";
                    BaseDataCtrlCache.updateVerifyOrgPropertyCache((String)key, (String)orgPropertyName);
                    return null;
                }
                orgPropertyName = this.getVerifyOrgPropertyName(parent.getString(NUMBER), operationKey);
                BaseDataCtrlCache.updateVerifyOrgPropertyCache((String)key, (String)orgPropertyName);
                return orgPropertyName;
            }
        }
        BaseDataCtrlCache.updateVerifyOrgPropertyCache((String)key, (String)orgPropertyName);
        return orgPropertyName;
    }

    public QFilter getBaseDataCreaterOrgFilter(String entityID, Long orgID) {
        return this.getBaseDataProFilter(entityID, orgID, CREATEORG);
    }

    @Deprecated
    public QFilter getBaseDataIdInFilter(String entityID, Long orgID) {
        return BaseDataOrgUseRangAdapter.getBaseDataIdInFilter(entityID, orgID);
    }

    public QFilter getBaseDataFilter(String entityID, Long orgID) {
        return BaseDataOrgUseRangAdapter.getBaseDataFilter(entityID, orgID);
    }

    public QFilter getBaseDataFilter(String entityID, List<Long> orgIDs, boolean isRemoveDup) {
        return BaseDataOrgUseRangAdapter.getBaseDataFilter(entityID, orgIDs, isRemoveDup);
    }

    public void refreshBaseDataUseRange(String entityID, List<Long> orgIdParamList) {
        BaseDataOrgUseRangAdapter.refreshBaseDataUseRange(entityID, orgIdParamList);
    }

    public void baseDataSubmitHandler(DynamicObject[] datas) {
        BaseDataAddAdapter.baseDataSubmitHandler(datas);
    }

    public void baseDataAuditHandler(DynamicObject[] datas) {
        new BaseDataAuditService().baseDataAuditHandler(datas);
    }

    public QFilter getBaseDataProFilter(String entityID, Long orgID, String property) {
        return BaseDataOrgUseRangAdapter.getBaseDataProFilter(entityID, orgID, property);
    }

    public DynamicObjectCollection getAllUseOrg(String entityType) {
        return BaseDataCtrlAdapter.getAllUseOrg(entityType);
    }

    protected String getDataBaseFieldName() {
        return "FDataID";
    }

    protected String getUsingOrgFieldName() {
        return FUSEORGID;
    }

    protected static String getDataBaseUsingTableName(String entityId) {
        return "T_BD_MaterialPurchasUse";
    }

    public Map<Long, Map<Long, String>> batchAssign(String entityID, List<Long> dataIDs, List<Long> orgIDs) {
        return this.batchAssign(entityID, 0L, dataIDs, orgIDs);
    }

    public Map<Long, Map<Long, String>> batchAssign(String entityID, Long assignOrgID, List<Long> dataIDs, List<Long> orgIDs) {
        return BaseDataAssignAdapter.batchAssign(entityID, assignOrgID, dataIDs, orgIDs);
    }

    public List<Object[]> getUnInsertExcHistory(String entityID, List<Long> uesOrgIDs) {
        return IndividualizeAdapter.getUnInsertExcHistory(entityID, uesOrgIDs);
    }

    public void fixExcTable(String entityID, List<Long> orgIDs) {
        IndividualizeAdapter.fixExcTable(entityID, orgIDs);
    }

    public void batchUnAssign(String entityID, Long[] dataIDs, Long[] orgIDs) {
    }

    public void handleDisable(String entityID, DynamicObject[] objs) {
        BaseDataCtrlAdapter.handleDisable(entityID, objs);
    }

    public void handleBatchDisable(String entityID, List<Object> orgIds, List<Object> masterIds) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityID);
        DBRoute dbRoute = DBRoute.of((String)entityType.getDBRouteKey());
        String baseDataTableName = entityType.getAlias();
        SqlBuilder sql = new SqlBuilder();
        sql.append("update ", new Object[0]).append(baseDataTableName, new Object[0]).append(" set fenable = '0' where ", new Object[0]);
        sql.appendIn("fcreateorgid", orgIds);
        sql.append("and", new Object[0]);
        sql.appendIn("fmasterid", masterIds);
        DB.execute((DBRoute)dbRoute, (SqlBuilder)sql);
    }

    public boolean handleEnable(String entityID, DynamicObject[] objs) {
        return BaseDataCtrlAdapter.handleEnable(entityID, objs);
    }

    public List<Long> getAssignUseOrgSet(DynamicObject dataInfo, Long orgID, Long createorgId) {
        return BaseDataAssignAdapter.getAssignUseOrgSet(dataInfo, orgID, createorgId);
    }

    @Deprecated
    public void baseDataAssignHandler(DynamicObject dataInfo, Long orgID, Long createorgId) {
        BaseDataAssignAdapter.baseDataAssignHandler(dataInfo, orgID, createorgId);
    }

    public void baseDataAddnewHandler(DynamicObject dataInfo, Long createOrgID) {
        if (dataInfo != null) {
            this.baseDataAddnewHandler(new DynamicObject[]{dataInfo});
        }
    }

    public void baseDataAddnewHandler(DynamicObject[] objs) {
        BaseDataAddAdapter.baseDataAddnewHandler(objs);
    }

    public void baseDataOrgChangeHandler(DynamicObject dataInfo) {
        BaseDataDrmAdapter.baseDataOrgChangeHandler(dataInfo);
    }

    public void baseDataSubmitHandler(DynamicObject dataInfo, Long createOrgID) {
        if (dataInfo != null) {
            BaseDataAddAdapter.baseDataSubmitHandler(new DynamicObject[]{dataInfo});
        }
    }

    public void baseDataAuditHandler(DynamicObject dataInfo, Long createOrgID) {
        if (null != dataInfo) {
            new BaseDataAuditService().baseDataAuditHandler(new DynamicObject[]{dataInfo});
        }
    }

    public void baseDataCtrlChangeHandler(List<DynamicObject> dataList) {
        ChangeCtrlStrategyAdapter.baseDataCtrlChangeHandler(dataList);
    }

    public void baseDataCtrlChangeHandler(DynamicObject dataInfo) {
        ChangeCtrlStrategyAdapter.baseDataCtrlChangeHandler(dataInfo);
    }

    public void clearCache(DynamicObject dataInfo) {
        BaseDataOrgRelationAdapter.clearCache(dataInfo);
    }

    public void clearCache(DynamicObject[] datas) {
        BaseDataOrgRelationAdapter.clearCache(datas);
    }

    public DynamicObject getDefaultCtrlStrtgy(String entityID) {
        return BaseDataCtrlAdapter.getDefaultCtrlStrategy(entityID);
    }

    public Boolean checkBaseDataCtrl(String entityID) {
        return BaseDataCtrlAdapter.checkBaseDataCtrl(entityID);
    }

    public DynamicObject getCtrlview(String entityID) {
        Map<String, DynamicObject> ctrlViews = this.getCtrlViews(new HashSet<String>(Collections.singleton(entityID)));
        return ctrlViews.get(entityID);
    }

    private Long getManageOrg(DynamicObject dataInfo) {
        Long manageOrg = null;
        DynamicObject bdctrlstrtgy = this.getCtrlStrtgy(dataInfo);
        if (bdctrlstrtgy == null) {
            return manageOrg;
        }
        List entrys = (List)bdctrlstrtgy.get("entryentity");
        DynamicObject entry = (DynamicObject)entrys.get(0);
        String managestrategy = (String)entry.get("managestrategy");
        if ("2".equals(managestrategy)) {
            Object createorgObj = dataInfo.get(CREATEORG);
            if (createorgObj instanceof Long) {
                manageOrg = (Long)createorgObj;
            } else if (createorgObj instanceof DynamicObject) {
                manageOrg = (Long)((DynamicObject)createorgObj).getPkValue();
            }
        } else if ("1".equals(managestrategy)) {
            Object cuObj = bdctrlstrtgy.get("cu");
            if (cuObj instanceof Long) {
                manageOrg = (Long)cuObj;
            } else if (cuObj instanceof DynamicObject) {
                manageOrg = (Long)((DynamicObject)cuObj).getPkValue();
            }
        }
        return manageOrg;
    }

    public void baseDataDeleteHandler(DynamicObject[] dataInfos) {
        BaseDataDeleteAdapter.baseDataDeleteHandler(dataInfos);
    }

    public void baseDataDeleteHandler(DynamicObject dataInfo, Long orgID) {
        if (dataInfo != null) {
            this.baseDataDeleteHandler(new DynamicObject[]{dataInfo});
        }
    }

    public void orgAddnewHandler(Long orgId) {
        BaseDataOrgRelationAdapter.orgAddNewHandler(orgId);
    }

    public void orgAddnewHandler(Long orgViewId, List<Long> orgs) {
        BaseDataOrgRelationAdapter.orgAddNewHandler(orgViewId, orgs);
    }

    public void afterSetCtrlUintHandle(String orgViewId, List<String> orgIdList) {
        BaseDataOrgUseRangAdapter.afterSetCtrlUintHandle(orgViewId, orgIdList);
    }

    public void handleManageOrg(DynamicObject dataInfo) {
        if (dataInfo == null) {
            return;
        }
        Long manageOrg = this.getManageOrg(dataInfo);
        if (manageOrg != null) {
            dataInfo.set("org", (Object)manageOrg);
        }
    }

    public DynamicObject getCtrlStrtgy(DynamicObject dataObj) {
        return BaseDataCtrlAdapter.getCtrlStrategy(dataObj);
    }

    public boolean handleModify(DynamicObject dataInfo) {
        return IndividualizeAdapter.individualize(dataInfo);
    }

    public void saveBaseDataExc(String entityID, List<Long> dataIds, Long createOrgID, List<Long> orgIds) {
        IndividualizeAdapter.saveBaseDataExc(entityID, dataIds, createOrgID, orgIds);
    }

    public void saveBaseDataExc(DynamicObject dataInfo, Long dataPk, Long createOrgID, List<Long> orgList) {
        IndividualizeAdapter.saveBaseDataExc(dataInfo, dataPk, createOrgID, orgList);
    }

    public List<Long> getAssignDesOrgs(Long srcOrgID, String ctrlType, Long orgViewID) {
        return BaseDataAssignAdapter.getAssignDesOrgList(srcOrgID, ctrlType, orgViewID);
    }

    public List<Long> getCreateOrgList(String entity, String appid) {
        return BaseDataCtrlAdapter.getCreateOrgList(entity, appid);
    }

    public List<Long> getCreateOrgList(String entity) {
        return this.getCreateOrgList(entity, null);
    }

    public List<Long> getBdCtrlOrgs(String entity) {
        return BaseDataCtrlAdapter.getBdCtrlOrgList(entity);
    }

    public String getBdCtrlStrgy(String entity, String createOrg) {
        return BaseDataCtrlAdapter.getOrgCtrlStrategy(entity, createOrg);
    }

    public String getUseOrgFunc(String entity) {
        Map map = EntityMetadataCache.getDataEntityType((String)entity).getAllFields();
        OrgProp pro = (OrgProp)map.get(USEORG);
        return pro == null ? null : pro.getOrgFunc();
    }

    public String getCtrlStgyViewSchema(String entity) {
        return BaseDataCtrlAdapter.getCtrlStrategyViewSchema(entity);
    }

    public Boolean chectDuplicate(String entityType, Map<String, String> chectProperties, Long orgID, Long dataID) {
        QFilter dataIDFilter = this.getBaseDataFilter(entityType, orgID);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(chectProperties.size());
        filterList.add(dataIDFilter);
        for (Map.Entry<String, String> entry : chectProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            filterList.add(new QFilter(key, "=", (Object)value));
        }
        if (dataID != 0L) {
            QFilter dataFilter = new QFilter("id", "!=", (Object)dataID);
            filterList.add(dataFilter);
        }
        QFilter[] filters = filterList.toArray(new QFilter[0]);
        return QueryServiceHelper.exists((String)entityType, (QFilter[])filters);
    }

    public Boolean chectDuplicate(String entityType, Long orgID, List numberList) {
        QFilter filter = this.getBaseDataFilter(entityType, orgID);
        QFilter numberFilter = new QFilter(NUMBER, "in", (Object)numberList);
        QFilter[] filters = new QFilter[]{filter, numberFilter};
        return QueryServiceHelper.exists((String)entityType, (QFilter[])filters);
    }

    public boolean isAlreadyAssign(String entity, Object pkId, Long useOrgId) {
        return BaseDataAssignAdapter.isAlreadyAssign(entity, pkId, useOrgId);
    }

    public static boolean isAssignData(String number, Object primaryKeyValue, Long useOrgId) {
        return BaseDataAssignAdapter.isAlreadyAssign(number, primaryKeyValue, useOrgId);
    }

    public boolean isHasAssignData(String entityNumber, Object dataID) {
        return BaseDataAssignAdapter.isHasAssignData(entityNumber, dataID);
    }

    public List<Long> checkHasAssignData(String entityNumber, List<Long> dataIDs) {
        return BaseDataAssignAdapter.checkHasAssignData(entityNumber, dataIDs);
    }

    @Deprecated
    public DynamicObject getBaseData(String entityID, Long orgID, String number, String selectFields) {
        return BaseDataOrgUseRangAdapter.getBaseData(entityID, orgID, number, selectFields);
    }

    public QFilter getLookUpListFilter(String entityId, Long orgId, QFilter customFilter) {
        return BaseDataOrgUseRangAdapter.getLookUpListFilter(entityId, orgId, customFilter);
    }

    public DynamicObjectCollection queryBaseData(String entityID, Long orgID, QFilter filter, String selectFields) {
        return BaseDataOrgUseRangAdapter.queryBaseData(entityID, orgID, filter, selectFields);
    }

    public Map<Object, DynamicObject> queryBaseDataFromCache(String entityID, Long orgID, QFilter filter, String selectFields) {
        return BaseDataOrgUseRangAdapter.queryBaseDataFromCache(entityID, orgID, filter, selectFields);
    }

    public IBaseDataCtrlPlugin getBaseDataCtrlPlugin(String entityType) {
        return BaseDataCtrlAdapter.getBaseDataCtrlPlugin(entityType);
    }

    public static DynamicObjectCollection getAccountingSysBaseInfo(Long[] orgIds) {
        String selectFields = "id,basecurrrency,exratetable,baseacctorg";
        QFilter orgqf = new QFilter("baseacctorg", "in", (Object)orgIds);
        DynamicObjectCollection baseColl = QueryServiceHelper.query((String)BD_ACCOUNTINGSYS_BASE, (String)selectFields, (QFilter[])orgqf.toArray(), (String)"id");
        return baseColl;
    }

    public static DynamicObjectCollection getAccountingSysBizOrg(Long acctSysId, Long[] acctorgs) {
        String selectFields = "id,bizorgentry.bizorg bizorg,bizorgentry.bizacctorg bizacctorg";
        QFilter acctQf = new QFilter("id", "=", (Object)acctSysId);
        QFilter orgqf = new QFilter("bizorgentry.bizacctorg", "in", (Object)acctorgs);
        DynamicObjectCollection bizColl = QueryServiceHelper.query((String)BD_ACCOUNTINGSYS, (String)selectFields, (QFilter[])new QFilter[]{acctQf, orgqf}, (String)"id");
        return bizColl;
    }

    public static DynamicObjectCollection getAccountingSysAcctOrg(Long acctSysId, Long[] bizacctorgs) {
        String selectFields = "id,bizorgentry.bizorg bizorg,bizorgentry.bizacctorg bizacctorg";
        QFilter acctQf = new QFilter("id", "=", (Object)acctSysId);
        QFilter orgqf = new QFilter("bizorgentry.bizorg", "in", (Object)bizacctorgs);
        DynamicObjectCollection bizColl = QueryServiceHelper.query((String)BD_ACCOUNTINGSYS, (String)selectFields, (QFilter[])new QFilter[]{acctQf, orgqf}, (String)"id");
        return bizColl;
    }

    public static Map<String, String> getAccountingSysView(Long acctSysId) {
        String selectFields = "id,viewentry.id viewid";
        QFilter acctQf = new QFilter("id", "=", (Object)acctSysId);
        DynamicObjectCollection bizColl = QueryServiceHelper.query((String)BD_ACCOUNTINGSYS, (String)selectFields, (QFilter[])new QFilter[]{acctQf}, (String)"id");
        HashMap<String, String> viewIds = new HashMap<String, String>();
        if (bizColl != null) {
            HashSet viewSet = new HashSet();
            bizColl.forEach(v -> viewSet.add(v.getString("viewid")));
            DynamicObjectCollection viewColl = QueryServiceHelper.query((String)BD_ACCOUNTINGSYSVIEWSCH, (String)"id,ismainview", (QFilter[])new QFilter("id", "in", viewSet).toArray(), (String)"id");
            if (viewColl != null) {
                viewColl.forEach(v -> viewIds.put(v.getString("id"), v.getString("ismainview")));
                return viewIds;
            }
        }
        return viewIds;
    }

    public static Map<String, Long> getBaseAccountingInfo(Long accountOrgID) {
        if (accountOrgID == 0L) {
            return new HashMap<String, Long>(0);
        }
        Map<String, Long> baseAccountingInfo = BaseDataServiceImpl.getBaseAccountingInfo(Collections.singletonList(accountOrgID));
        if (baseAccountingInfo.isEmpty()) {
            List parentOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", (long)accountOrgID);
            baseAccountingInfo = BaseDataServiceImpl.getBaseAccountingInfo(parentOrgIds);
        }
        return baseAccountingInfo;
    }

    private static Map<String, Long> getBaseAccountingInfo(List<Long> accountingOrgIds) {
        HashMap<String, Long> baseAccountingInfo = new HashMap<String, Long>(2);
        if (accountingOrgIds == null || accountingOrgIds.isEmpty()) {
            return baseAccountingInfo;
        }
        String selectFields = "baseacctorg.id,exratetable.id,basecurrrency.id";
        QFilter orgFilter = new QFilter("baseacctorg", "in", accountingOrgIds);
        QFilter[] filters = new QFilter[]{orgFilter};
        Map accountingObjMap = BusinessDataServiceHelper.loadFromCache((String)BD_ACCOUNTINGSYS_BASE, (String)selectFields, (QFilter[])filters);
        if (accountingObjMap == null || accountingObjMap.isEmpty()) {
            return baseAccountingInfo;
        }
        DynamicObject baseAccountingObj = null;
        if (accountingObjMap.size() == 1) {
            baseAccountingObj = (DynamicObject)accountingObjMap.entrySet().iterator().next().getValue();
        } else {
            HashMap<Long, DynamicObject> orgAccountingObjMap = new HashMap<Long, DynamicObject>(accountingObjMap.size());
            for (DynamicObject accountingObj : accountingObjMap.values()) {
                orgAccountingObjMap.put(accountingObj.getLong("baseacctorg.id"), accountingObj);
            }
            for (int i = accountingOrgIds.size() - 1; i >= 0 && (baseAccountingObj = (DynamicObject)orgAccountingObjMap.get(accountingOrgIds.get(i))) == null; --i) {
            }
        }
        if (baseAccountingObj != null) {
            baseAccountingInfo.put("baseCurrencyID", baseAccountingObj.getLong("basecurrrency.id"));
            baseAccountingInfo.put("exchangeRateTableID", baseAccountingObj.getLong("exratetable.id"));
        }
        return baseAccountingInfo;
    }

    public static QFilter getBdCtrlAssistantDataFilter(Long orgID) {
        QFilter baseDataPropertyFilter = null;
        HashSet<Long> baseDataPropertySet = new HashSet<Long>();
        if (StringUtils.isBlank((Object)orgID)) {
            return baseDataPropertyFilter;
        }
        try {
            String sql = "select cadt.FCtrlViewID from t_bd_ctrlassistdatatype cadt  inner join t_org_structure  os on cadt.FCtrlViewID = os.fviewid where forgID =  " + orgID;
            Set bdCtrlAssistantDataViewSet = (Set)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                public Set<Long> handle(ResultSet rs) throws SQLException {
                    HashSet<Long> set = new HashSet<Long>(16);
                    while (rs.next()) {
                        set.add(rs.getLong("FCtrlViewID"));
                    }
                    return set;
                }
            });
            HashSet<Long> bdCtrlAssistantData = new HashSet<Long>(16);
            for (Long viewid : bdCtrlAssistantDataViewSet) {
                bdCtrlAssistantData.add(orgID);
                BaseDataServiceImpl.getSuperiorOrg(viewid, orgID, bdCtrlAssistantData);
            }
            BaseDataServiceImpl.getBdCtrlassistdatatype(baseDataPropertySet, bdCtrlAssistantData);
            baseDataPropertyFilter = new QFilter("id", "in", baseDataPropertySet);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7ec4\u7ec7" + orgID + "\u53ef\u7528\u7684\u53d7\u63a7\u8f85\u52a9\u8d44\u6599\u8303\u56f4\u62a5\u9519:", (Throwable)e);
        }
        return baseDataPropertyFilter;
    }

    private static void getBdCtrlassistdatatype(Set<Long> baseDataPropertySet, Set<Long> bdCtrlAssistantData) {
        ORM ormOV = ORM.create();
        QFilter f1 = new QFilter(CREATEORG, "in", bdCtrlAssistantData);
        try (DataSet ds = ormOV.queryDataSet(BaseDataServiceImpl.class.getName(), BD_CTRLASSISTDATATYPE, "id", new QFilter[]{f1}, "id");){
            for (Row row : ds) {
                if (row.get("id") == null) continue;
                baseDataPropertySet.add(Long.parseLong(row.get("id").toString()));
            }
        }
    }

    private static Set<Long> getSuperiorOrg(Long viewid, Long orgID, Set<Long> bdCtrlAssistantData) {
        List superiorOrgs = OrgUnitServiceHelper.getSuperiorOrgs((String)viewid.toString(), (long)orgID);
        if (superiorOrgs == null || superiorOrgs.size() == 0 || (Long)superiorOrgs.get(0) == 0L) {
            bdCtrlAssistantData.add(orgID);
            return bdCtrlAssistantData;
        }
        return BaseDataServiceImpl.getSuperiorOrg(viewid, (Long)superiorOrgs.get(0), bdCtrlAssistantData);
    }

    public static QFilter getBdCtrlAssistDataFilter(Long dataTypeId) {
        QFilter baseDataPropertyFilter = null;
        HashSet<Long> baseDataPropertySet = new HashSet<Long>();
        if (StringUtils.isBlank((Object)dataTypeId)) {
            return baseDataPropertyFilter;
        }
        try {
            DynamicObject queryOne = QueryServiceHelper.queryOne((String)BD_CTRLASSISTDATATYPE, (String)"longnumber,createorg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dataTypeId)});
            String longnumber = queryOne.getString("longnumber");
            Long createOrgId = queryOne.getLong(CREATEORG);
            ORM ormOV = ORM.create();
            HashSet<Long> baseDataTypeSet = new HashSet<Long>();
            QFilter[] f = new QFilter[]{new QFilter("longnumber", "like", (Object)(longnumber + "%")), new QFilter(CREATEORG, "=", (Object)createOrgId)};
            BaseDataServiceImpl.getBdCtrlassistdatatype(ormOV, baseDataTypeSet, f);
            f = new QFilter[]{new QFilter("datatype", "in", baseDataTypeSet)};
            BaseDataServiceImpl.getBdCtrlassistdata(baseDataPropertySet, ormOV, f);
            baseDataPropertyFilter = new QFilter("id", "in", baseDataPropertySet);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7c7b\u578b\u4e3a" + dataTypeId + "\u53ef\u7528\u7684\u53d7\u63a7\u8f85\u52a9\u8d44\u6599\u8303\u56f4\u62a5\u9519:", (Throwable)e);
        }
        return baseDataPropertyFilter;
    }

    private static void getBdCtrlassistdata(Set<Long> baseDataPropertySet, ORM ormOV, QFilter[] f) {
        try (DataSet ds = ormOV.queryDataSet(BaseDataServiceImpl.class.getName(), "bd_ctrlassistdata", "id", f, "id");){
            for (Row row : ds) {
                if (row.get("id") == null) continue;
                baseDataPropertySet.add(Long.parseLong(row.get("id").toString()));
            }
        }
    }

    private static void getBdCtrlassistdatatype(ORM ormOV, Set<Long> baseDataTypeSet, QFilter[] f) {
        try (DataSet ds = ormOV.queryDataSet(BaseDataServiceImpl.class.getName(), BD_CTRLASSISTDATATYPE, "id", f, "id");){
            for (Row row : ds) {
                if (row.get("id") == null) continue;
                baseDataTypeSet.add(Long.parseLong(row.get("id").toString()));
            }
        }
    }

    public static String getFullTextIndex(String entityNumber) {
        String fullTextIndex = null;
        String fullTextIndexEntity = "bas_fulltextindex";
        QFilter entityFilter = new QFilter("fentitynumber.number", "=", (Object)entityNumber);
        QFilter[] filters = new QFilter[]{entityFilter};
        DynamicObject fullTextIndexObj = BusinessDataServiceHelper.loadSingleFromCache((String)fullTextIndexEntity, (QFilter[])filters);
        if (fullTextIndexObj != null && fullTextIndexObj.getString("ffieldname") != null) {
            fullTextIndex = fullTextIndexObj.getString("ffieldname");
        }
        return fullTextIndex;
    }

    public static Boolean isDBFulltext(String entityNumber, String propertyNumber) {
        boolean isDBFulltextProperty = false;
        String fullTextIndex = BaseDataServiceImpl.getFullTextIndex(entityNumber);
        if (fullTextIndex != null && fullTextIndex.toLowerCase().indexOf(propertyNumber.toLowerCase()) >= 0) {
            isDBFulltextProperty = true;
        }
        return isDBFulltextProperty;
    }

    public Boolean isNoneCustomEntity(String entityNumber) {
        return noneCustomEntityList.contains(entityNumber);
    }

    public Map<Long, String> batchModifyVerify(String entityID, Long orgID, List<DynamicObject> dataList) {
        return IndividualizeAdapter.individualizePreVerify(entityID, orgID, dataList);
    }

    public Map<Long, String> batchHandleModify(String entityID, Long orgID, List<DynamicObject[]> dataList) {
        return IndividualizeAdapter.batchIndividualize(entityID, orgID, dataList);
    }

    public void clearBaseDataFilterCache(String entityType, Long orgID) {
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        String key = entityType + orgID;
        BaseDataCtrlCacheMrg.clearCache((String)type, (String)key);
        BaseDataCtrlCache.clearBaseDataUseRange((String)entityType, (Long)orgID);
    }

    public void managePermChange(String entityNumber, List<Long> ids, Long orgId) {
        BaseDataDrmAdapter.managePermChange(entityNumber, ids, orgId);
    }

    public Map<String, String> getBdCtrlStrgyBatch(String entity, List<Long> createOrgs) {
        return BaseDataCtrlAdapter.batchSelectOrgCtrlStrategy(entity, createOrgs);
    }

    public String getMasterIdPropName(String entityName) {
        return BaseDataCtrlAdapter.getMasterIdPropName(entityName);
    }

    public String getMasterIdFieldName(String entityName) {
        return BaseDataCtrlAdapter.getMasterIdFieldName(entityName);
    }

    public List<CancelAssignResult> cancelAssign(String entityId, Set<Long> dataIds, Set<Long> orgIds) {
        CancelAssignService service = new CancelAssignService();
        return service.cancelAssign(entityId, dataIds, orgIds);
    }

    public DynamicObjectCollection queryBaseDataByDate(String entityID, Long orgID, QFilter filter, String selectFields, Date queryDate) {
        return BaseDataOrgUseRangAdapter.queryBaseDataByDate(entityID, orgID, filter, selectFields, queryDate);
    }

    public BaseDataResponse changeCtrlStrategy(String entityId, Set<Long> dataIds, String ctrlStrategy, String appId, Long useOrgId) {
        ChangeCtrlStrategyService service = new ChangeCtrlStrategyService(entityId);
        return service.changeCtrlStrategy(dataIds, ctrlStrategy, appId, useOrgId, true);
    }

    public Boolean isEnableNameVersion(String entityID) {
        MainEntityType dataEntityType;
        if (ObjectUtils.isEmpty((Object)entityID)) {
            return Boolean.FALSE;
        }
        try {
            dataEntityType = EntityMetadataCache.getDataEntityType((String)entityID);
        }
        catch (KDException e) {
            logger.error("BaseDataServiceImpl#isEnableNameVersion error", (Throwable)e);
            return Boolean.FALSE;
        }
        if (!(dataEntityType instanceof BasedataEntityType) || !((BasedataEntityType)dataEntityType).isEnableNameVersion()) {
            return Boolean.FALSE;
        }
        if (!"name".equals(this.getDataEntityTypeNameFieldId((IDataEntityType)dataEntityType))) {
            return Boolean.FALSE;
        }
        QFilter filter = new QFilter("basedataid", "=", (Object)entityID);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)"1");
        DynamicObject modifyConfigObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_bdversioncfg", (String)"fid", (QFilter[])new QFilter[]{filter, enableFilter});
        return !ObjectUtils.isEmpty((Object)modifyConfigObj);
    }

    private String getDataEntityTypeNameFieldId(IDataEntityType dataEntityType) {
        DataEntityPropertyCollection properties;
        if (dataEntityType == null) {
            return "";
        }
        String nameFieldId = null;
        if (dataEntityType instanceof BasedataEntityType) {
            nameFieldId = ((BasedataEntityType)dataEntityType).getNameProperty();
        } else if (dataEntityType instanceof BaseEntity) {
            nameFieldId = ((BaseEntity)dataEntityType).getNameFieldId();
        }
        if (StringUtils.isBlank((CharSequence)nameFieldId)) {
            nameFieldId = "name";
        }
        if ((properties = dataEntityType.getProperties()).containsKey((Object)nameFieldId)) {
            return nameFieldId;
        }
        return "";
    }

    public QFilter getBaseDataFilter(Long userID, String appID, String entityID, QFilter orgQFilter, boolean isRemoveDup) {
        return BaseDataOrgUseRangAdapter.getBaseDataFilter(userID, appID, entityID, orgQFilter, isRemoveDup);
    }

    public BaseDataResponse individualize(String entityId, Long useOrgId, String appId, Set<Long> dataIds) {
        IndividualizeService service = new IndividualizeService(entityId);
        return service.individualize(useOrgId, appId, dataIds);
    }

    public BaseDataResponse assign(String entityId, Long assignOrgId, String appId, Set<Long> dataIds, Set<Long> orgIds) {
        AssignService service = new AssignService(entityId);
        return service.assign(assignOrgId, appId, dataIds, orgIds, true);
    }

    public AssignQueryResponse assignQueryByData(List<Long> dataIds, String entity, Long orgId, String appId) {
        BaseDataQueryService service = new BaseDataQueryService();
        return service.assignQueryByData(dataIds, entity, orgId, appId);
    }

    public BaseDataResponse changeManageRight(String entityId, Long useOrgId, String appId, Set<Long> dataIds, Long targetOrgId) {
        ChangeManageRightService service = new ChangeManageRightService();
        return service.changeManageRight(entityId, useOrgId, appId, dataIds, targetOrgId, true);
    }

    public void orgSaveHandler(List<Long> orgIds) {
        BaseDataRepairService repairService = new BaseDataRepairService();
        repairService.orgSaveHandler(orgIds);
    }

    public UpgradeResult presetCtrlOrgUseRangData(String dbKey, String entity, String tableName, Map<Long, Long> dataOrgMap, boolean isTreeType) {
        return new BaseDataAutoUpgradeService().presetCtrlOrgUseRangData(dbKey, entity, tableName, dataOrgMap, isTreeType);
    }

    public Map<Long, String> executeIndividualizeOnFreeStrategy(String entity, Long useOrgId, String appId, Set<Long> dataIds, Object service) {
        if (service instanceof IBaseDataCtrlPlugin) {
            return new IndividualizeService(entity).executeIndividualizeOnFreeStrategy(useOrgId, appId, dataIds, (IBaseDataCtrlPlugin)service);
        }
        return new IndividualizeService(entity).executeIndividualizeOnFreeStrategy(useOrgId, appId, dataIds, null);
    }

    public BaseDataResponse batchAssignOnFreeStrategy(Long assignOrgId, String appId, Set<Long> dataIds, Set<Long> orgIds, String entity) {
        AssignService service = new AssignService(entity);
        return service.executeAssignOnFreeStrategy(assignOrgId, appId, dataIds, orgIds);
    }

    public boolean addCtrlTableColumns(String dbKey, String tableName) {
        return new BaseDataAutoUpgradeService().addCtrlTableColumns(dbKey, tableName);
    }

    public boolean repairNewPropsValue(String entity) {
        return new BaseDataAutoUpgradeService().repairNewPropsValue(entity);
    }

    public void fillCtrlStrategyFieldAfterCopy(String entity, List<DynamicObject> dataList) {
        new BaseDataSupplementService().fillCtrlStrategyFieldAfterCopy(entity, dataList);
    }

    public static boolean saveHistoryInfo(DynamicObject dataInfo) {
        return IndividualizeAdapter.saveHistoryInfo(dataInfo);
    }

    static {
        noneCustomEntityList.add(BD_MATERIAL);
        noneCustomEntityList.add("ap_payproperty");
        noneCustomEntityList.add("ar_payproperty");
    }
}

