/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.bd.ext.IBaseDataSubExtService;
import kd.bos.bd.ext.pojo.ExtActionInfo;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.service.BaseDataAssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.bd.utils.BaseDataThreadPoolUtils;
import kd.bos.bd.validator.BaseDataCancelAssignAPIValidator;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.CancelAssignResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.threads.ThreadPool;

public class CancelAssignService {
    private static final Log LOGGER = LogFactory.getLog(CancelAssignService.class);
    private static final String SYSTEM_TYPE = "bos-mservice-bd";
    private static final String ENTITY_ORG_STRUCTURE = "bos_org_structure";
    private static final String SUFFIX_BD_USE_REG = "UseReg";
    private static final String SUFFIX_BD_EXC = "Exc";
    private static final String SUFFIX_BD_USE_RANGE = "_U";
    private static final String FIELD_ORG_ID = "org.id";
    private static final String FIELD_ORG_PARENT_ID = "parent.id";
    private Map<String, Set<String>> personalDataMap = new HashMap<String, Set<String>>(16);
    private Map<Object, DynamicObject> baseDataMap = new HashMap<Object, DynamicObject>(16);
    private Map<Long, String> dataId2NumberMap = new HashMap<Long, String>(16);
    private Map<Long, Set<Long>> dataId2UseOrgIdMap = new HashMap<Long, Set<Long>>(16);
    private Map<Long, String> useOrgId2NameMap = new HashMap<Long, String>(16);
    private Map<Long, Long> dataId2PidMap = new HashMap<Long, Long>(16);
    private Map<Long, Long> allDataId2PidMap = new HashMap<Long, Long>(16);
    private Map<Long, String> dataId2OrgNameMap = new HashMap<Long, String>(16);
    private Map<Long, Set<String>> unableCancelAssignDataMap = new HashMap<Long, Set<String>>(16);
    private Map<Long, Long> child2ParentOrgMap = new HashMap<Long, Long>(16);
    private Map<Long, String> dataStrategyMap = new HashMap<Long, String>(16);
    private Set<String> unableCancelDataIdOrgSet = new HashSet<String>(16);
    private boolean isTreeTypeBaseData = false;
    private String numberField;
    private String masterIdPropName;
    private String appId = null;
    private List<CancelAssignResult> result = new ArrayList<CancelAssignResult>(16);
    private Map<Long, Set<Long>> unableCancelMap = new HashMap<Long, Set<Long>>(16);
    private static final String BASEDATAUSERANGESUFFIX = "_U";
    private static final String FIELD_DATA_ID = "fdataid";
    private static final String FIELD_USE_ORGID = "fuseorgid";

    public List<CancelAssignResult> cancelAssign(String entityId, Set<Long> dataIds, Set<Long> orgIds) {
        if (this.validateParam(entityId, dataIds, orgIds)) {
            return this.result;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        String appNumber = mainEntityType.getBizAppNumber();
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                this.appId = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                this.appId = mainEntityType.getAppId();
            }
        }
        Long currentOrgId = RequestContext.get().getOrgId();
        if (BaseDataCommonService.isNewModel((String)entityId)) {
            BaseDataCancelAssignAPIValidator validator = new BaseDataCancelAssignAPIValidator(entityId);
            BaseDataAssignService newService = new BaseDataAssignService(entityId);
            if (!validator.validate(dataIds, orgIds)) {
                BDCtrlLogHelper.saveCancelAssignLog((String)entityId, new ArrayList<Long>(dataIds), new ArrayList<Long>(orgIds), (List)validator.getResult(), null);
                return validator.getResult();
            }
            Map cancelData = validator.getCancelData();
            newService.setOpOrgId(currentOrgId);
            newService.setAppId(this.appId);
            List result = validator.getResult();
            try {
                ExtActionInfo extActionInfo = this.beforeUnAssign(entityId, cancelData, new ArrayList<Object[]>(16), result);
                if (!extActionInfo.isExecute()) {
                    return result;
                }
                newService.cancelAssign(cancelData);
                CancelAssignService.afterUnAssign(entityId, cancelData);
            }
            catch (Exception e) {
                LOGGER.error("BaseDataCancelAssignService error:", (Throwable)e);
            }
            BDCtrlLogHelper.saveCancelAssignLog((String)entityId, new ArrayList<Long>(dataIds), new ArrayList<Long>(orgIds), (List)validator.getResult(), null);
            return result;
        }
        this.init(entityId, dataIds, orgIds);
        boolean isSuccess = this.cancelAssignOnOldModel(entityId, currentOrgId);
        if (isSuccess) {
            BDCtrlLogHelper.saveCancelAssignLog((String)entityId, new ArrayList<Long>(dataIds), new ArrayList<Long>(orgIds), this.result, null);
        }
        return this.result;
    }

    private ExtActionInfo beforeUnAssign(String entityId, Map<Long, Set<Long>> cancelData, List<Object[]> params, List<CancelAssignResult> result) {
        if (CollectionUtils.isEmpty(cancelData)) {
            return new ExtActionInfo(true);
        }
        IBaseDataSubExtService ext = BaseDataBusinessServiceUtils.getBaseDataSubExtService((String)entityId);
        ExtActionInfo extActionInfo = ext.beforeUnAssign(entityId, cancelData);
        Map unAssignCheckResMap = extActionInfo.getData();
        if (CollectionUtils.isEmpty((Map)unAssignCheckResMap)) {
            return extActionInfo;
        }
        for (Map.Entry entry : unAssignCheckResMap.entrySet()) {
            Long dataId = (Long)entry.getKey();
            Map value = (Map)entry.getValue();
            CancelAssignResult rs = new CancelAssignResult();
            rs.setSuccess(false);
            rs.setDataId(dataId);
            rs.setOrgIds(new ArrayList(value.keySet()));
            rs.setErrorMsg(String.join((CharSequence)"\n", value.values()));
            result.add(rs);
            Set<Long> cancelDataSet = cancelData.get(dataId);
            if (CollectionUtils.isEmpty(cancelDataSet)) continue;
            cancelDataSet.removeAll(value.keySet());
        }
        params.clear();
        for (Map.Entry<Object, Object> entry : cancelData.entrySet()) {
            Set values = (Set)entry.getValue();
            values.forEach(orgId -> params.add(new Object[]{entry.getKey(), orgId}));
        }
        return extActionInfo;
    }

    private boolean validateParam(String entityId, Set<Long> dataIds, Set<Long> orgIds) {
        if (CollectionUtils.isEmpty(dataIds)) {
            this.setParamEmptyResult("dataIds is empty");
            return true;
        }
        if (CollectionUtils.isEmpty(orgIds)) {
            this.setParamEmptyResult("orgIds is empty");
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            this.setParamEmptyResult("entityId is empty");
            return true;
        }
        return false;
    }

    private void setParamEmptyResult(String errorMsg) {
        CancelAssignResult car = new CancelAssignResult();
        car.setSuccess(false);
        car.setErrorMsg(errorMsg);
        this.result.add(car);
    }

    private static void afterUnAssign(String entityId, Map<Long, Set<Long>> cancelData) {
        if (CollectionUtils.isEmpty(cancelData)) {
            return;
        }
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)entityId);
        if (baseDataCtrlPlugin != null) {
            ThreadPool threadPool = BaseDataThreadPoolUtils.getBdCommonThreadPool();
            threadPool.execute(() -> baseDataCtrlPlugin.afterUnAssign(entityId, cancelData));
        }
    }

    private boolean cancelAssignOnOldModel(String entity, Long currentOrgId) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        if (null == ctrlView) {
            LOGGER.info("cancelAssignOnOldModel ERROR:" + entity + ",ctrlView is null");
            return false;
        }
        if (this.isTreeTypeBaseData) {
            this.checkTreeDataIntegrity(entity);
        }
        HashSet<Long> dataIds = new HashSet<Long>(this.dataId2UseOrgIdMap.size());
        List<Long[]> unAssignDataList = this.getBusinessCancelAssignCheckData(dataIds);
        List<Object[]> checkResult = this.businessValidate(entity, unAssignDataList);
        this.initDataInfo(entity, dataIds);
        HashMap<Long, Set<Long>> unableCancelData = new HashMap<Long, Set<Long>>(this.dataId2UseOrgIdMap.size());
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        this.validateOnOldModel(entity, ctrlView, currentOrgId, unableCancelData, params);
        HashMap<Long, Set<Long>> cancelDataMap = new HashMap<Long, Set<Long>>(params.size());
        for (Object[] param : params) {
            Long dataId = (Long)param[0];
            Long orgId = (Long)param[1];
            cancelDataMap.computeIfAbsent(dataId, k -> new HashSet()).add(orgId);
        }
        ExtActionInfo extActionInfo = this.beforeUnAssign(entity, cancelDataMap, params, this.result);
        this.showCancelAssignErrorTip(checkResult, unableCancelData);
        if (extActionInfo.isExecute()) {
            HashSet<Long> userOrgIds = new HashSet<Long>(16);
            this.dataId2UseOrgIdMap.values().forEach(userOrgIds::addAll);
            this.deleteDataInfo(entity, params, userOrgIds);
            this.showCancelSuccessTip(entity, params);
            this.writOpLog(params, entity, currentOrgId);
            return !params.isEmpty();
        }
        return false;
    }

    private void validateOnOldModel(String entity, DynamicObject ctrlView, Long currentOrgId, Map<Long, Set<Long>> unableCancelData, List<Object[]> params) {
        Map<Long, Set<Long>> cancelDataMap = this.copyCancelData();
        long viewId = (Long)ctrlView.getPkValue();
        Map<Long, List<Long>> directSubOrgIdsMap = this.getDirectSubOrgIdsMap(viewId);
        Map<Long, List<Long>> allSubOrgIdsMap = this.getAllSubOrgIdsMap(viewId);
        Map<Long, List<Long>> dataUseRegMap = this.getDataCuUseRegMap(directSubOrgIdsMap, entity);
        Map<Long, List<Long>> isNotCuDataUseRegMap = this.getIsNotCuDataUseRegMap(directSubOrgIdsMap, entity, currentOrgId);
        boolean customEntity = BaseDataServiceHelper.isNoneCustomEntity((String)entity) == false;
        Map<Long, List<Long>> masterId2IdMap = this.getMasterIdToIdInfo();
        boolean isEnableHistory = BaseDataBusinessServiceUtils.isEnableVersion((String)entity);
        for (Map.Entry<Long, Set<Long>> entry : cancelDataMap.entrySet()) {
            Long currentDataId = entry.getKey();
            Long masterId = 0L;
            DynamicObject baseData = this.baseDataMap.get(currentDataId);
            if (null == baseData) continue;
            if (customEntity) {
                masterId = this.getMasterIdFromDynamicObject(baseData);
            }
            Set<Long> useOrgIds = entry.getValue();
            for (Long orgId : useOrgIds) {
                if (this.unableCancelDataIdOrgSet.contains(currentDataId.toString() + orgId)) {
                    this.treeDataSubUnCancelAssign(unableCancelData, currentDataId, orgId);
                    continue;
                }
                HashSet<Long> subOrgIds = new HashSet<Long>(16);
                if (customEntity && "1".equals(baseData.getString("ctrlstrategy")) && !CollectionUtils.isEmpty((Collection)allSubOrgIdsMap.get(orgId))) {
                    subOrgIds.addAll((Collection<Long>)allSubOrgIdsMap.get(orgId));
                }
                if (!isEnableHistory && customEntity && this.customValidate(masterId2IdMap, currentDataId, masterId, orgId, subOrgIds)) continue;
                List<Long> directSubOrgIds = directSubOrgIdsMap.get(orgId);
                if (CollectionUtils.isEmpty(directSubOrgIds)) {
                    params.add(this.packCancelParams(currentDataId, orgId));
                    continue;
                }
                Long unableOrgId = this.getAlreadyAssignSubOrgId(useOrgIds, currentDataId, directSubOrgIdsMap, dataUseRegMap, orgId);
                if (null != unableOrgId) {
                    unableCancelData.computeIfAbsent(currentDataId, k -> new HashSet(10)).add(orgId);
                    continue;
                }
                params.add(this.packCancelParams(currentDataId, orgId));
                params.addAll(this.packNotCuParams(isNotCuDataUseRegMap, currentDataId, useOrgIds, directSubOrgIds));
                params.addAll(this.packCustomDataParams(masterId2IdMap, currentDataId, masterId, orgId));
            }
        }
    }

    private void treeDataSubUnCancelAssign(Map<Long, Set<Long>> unableCancelData, Long dataId, Long orgId) {
        if (!this.isTreeTypeBaseData || CollectionUtils.isEmpty(unableCancelData)) {
            return;
        }
        unableCancelData.computeIfAbsent(dataId, k -> new HashSet(10)).add(orgId);
    }

    private Map<Long, List<Long>> getAllSubOrgIdsMap(long viewId) {
        Map<Long, Set<Long>> cancelDataMap = this.copyCancelData();
        HashSet useOrgIds = new HashSet(cancelDataMap.size());
        for (Map.Entry<Long, Set<Long>> entry : cancelDataMap.entrySet()) {
            useOrgIds.addAll(entry.getValue());
        }
        return OrgUnitServiceHelper.getAllSubordinateOrgMap((long)viewId, new ArrayList(useOrgIds), (boolean)true);
    }

    private void showCancelSuccessTip(String entityId, List<Object[]> params) {
        HashMap<Long, Set<Long>> successMap = new HashMap<Long, Set<Long>>(params.size());
        for (Object[] param : params) {
            Long dataId = Long.valueOf(param[0].toString());
            Long orgId = Long.valueOf(param[1].toString());
            successMap.computeIfAbsent(dataId, k -> new HashSet()).add(orgId);
        }
        CancelAssignService.afterUnAssign(entityId, successMap);
        this.addResult(successMap, "", true);
    }

    private Map<Long, Set<Long>> copyCancelData() {
        HashMap<Long, Set<Long>> copy = new HashMap<Long, Set<Long>>(this.dataId2UseOrgIdMap.size());
        for (Map.Entry<Long, Set<Long>> entry : this.dataId2UseOrgIdMap.entrySet()) {
            copy.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        return copy;
    }

    private void checkTreeDataIntegrity(String entity) {
        HashSet<Long> selectDataIds = new HashSet<Long>(16);
        selectDataIds.addAll(this.dataId2UseOrgIdMap.keySet());
        HashSet<Long> orgIds = new HashSet<Long>(this.useOrgId2NameMap.size());
        orgIds.addAll(this.useOrgId2NameMap.keySet());
        Map<Long, Set<Long>> assignDataInfo = this.getAssignDataInfo(selectDataIds, orgIds, entity);
        HashMap<Long, Set<Long>> unableCancelData2OrgMap = new HashMap<Long, Set<Long>>(16);
        for (Map.Entry<Long, Long> entry : this.dataId2PidMap.entrySet()) {
            Long dataId = entry.getKey();
            Long pid = entry.getValue();
            Set<Long> selectOrgIds = this.dataId2UseOrgIdMap.get(pid);
            if (selectDataIds.contains(dataId) || CollectionUtils.isEmpty(selectOrgIds)) continue;
            for (Long orgId : selectOrgIds) {
                Set<Long> assignDataId = assignDataInfo.get(orgId);
                if (CollectionUtils.isEmpty(assignDataId) || !assignDataId.contains(dataId)) continue;
                unableCancelData2OrgMap.computeIfAbsent(pid, k -> new HashSet(16)).add(orgId);
                this.unableCancelAssignDataMap.computeIfAbsent(pid, k -> new HashSet(16)).add(this.dataId2OrgNameMap.get(dataId));
                this.unableCancelMap.put(pid, orgIds);
            }
        }
        this.excludeUnableCancelData(unableCancelData2OrgMap);
    }

    private void excludeUnableCancelData(Map<Long, Set<Long>> unableCancelData2OrgMap) {
        for (Map.Entry<Long, Set<Long>> entry : unableCancelData2OrgMap.entrySet()) {
            Long dataId = entry.getKey();
            String strategy = this.dataStrategyMap.get(dataId);
            if (!"1".equals(strategy) && !"2".equals(strategy)) continue;
            Set<Long> unableCancelOrgIds = entry.getValue();
            Set<Long> selectOrgId = this.dataId2UseOrgIdMap.get(dataId);
            if (!CollectionUtils.isEmpty(selectOrgId)) {
                selectOrgId.removeAll(unableCancelOrgIds);
            }
            for (Long unableCancelOrgId : unableCancelOrgIds) {
                this.unableCancelDataIdOrgSet.add(dataId.toString() + unableCancelOrgId);
                if ("1".equals(strategy)) {
                    Long parentOrgId = this.child2ParentOrgMap.get(unableCancelOrgId);
                    this.eachExcludeUnableCancelOrg(parentOrgId, this.dataId2UseOrgIdMap.get(dataId), dataId);
                    this.eachExcludeUnableCancelData(unableCancelOrgId, dataId);
                    continue;
                }
                this.eachExcludeUnableCancelDataOnFreeType(dataId, unableCancelOrgId);
            }
        }
    }

    private void eachExcludeUnableCancelOrg(Long parentOrgId, Set<Long> selectOrgIds, Long dataId) {
        if (CollectionUtils.isEmpty(selectOrgIds) || null == parentOrgId) {
            return;
        }
        if (selectOrgIds.contains(parentOrgId)) {
            this.unableCancelMap.computeIfAbsent(dataId, k -> new HashSet()).add(parentOrgId);
        }
        this.unableCancelDataIdOrgSet.add(dataId.toString() + parentOrgId);
        selectOrgIds.remove(parentOrgId);
        parentOrgId = this.child2ParentOrgMap.get(parentOrgId);
        this.eachExcludeUnableCancelOrg(parentOrgId, selectOrgIds, dataId);
    }

    private void eachExcludeUnableCancelData(Long currentOrgId, Long currentDataId) {
        Long parentDataId = this.dataId2PidMap.get(currentDataId);
        if (null == parentDataId) {
            return;
        }
        Set<Long> selectOrgIds = this.dataId2UseOrgIdMap.get(parentDataId);
        if (!CollectionUtils.isEmpty(selectOrgIds)) {
            this.eachExcludeUnableCancelOrg(currentOrgId, selectOrgIds, parentDataId);
        }
        this.eachExcludeUnableCancelData(currentOrgId, parentDataId);
    }

    private void eachExcludeUnableCancelDataOnFreeType(Long dataId, Long currentOrgId) {
        if (null == dataId) {
            return;
        }
        this.unableCancelDataIdOrgSet.add(dataId.toString() + currentOrgId);
        Set<Long> selectOrgIds = this.dataId2UseOrgIdMap.get(dataId);
        if (!CollectionUtils.isEmpty(selectOrgIds)) {
            selectOrgIds.remove(currentOrgId);
        }
        dataId = this.dataId2PidMap.get(dataId);
        this.eachExcludeUnableCancelDataOnFreeType(dataId, currentOrgId);
    }

    private Map<Long, Set<Long>> getAssignDataInfo(Set<Long> dataIds, Set<Long> orgIds, String entity) {
        HashSet<Long> allDataIds = new HashSet<Long>(dataIds);
        allDataIds.addAll(this.dataId2PidMap.keySet());
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entity);
        SqlBuilder builder = new SqlBuilder();
        builder.append(String.format("select fdataid, fuseorgid from %s_u where ", dt.getAlias()), new Object[0]);
        builder.appendIn(FIELD_DATA_ID, allDataIds.toArray(new Object[0])).append(" and ", new Object[0]);
        builder.appendIn(FIELD_USE_ORGID, orgIds.toArray(new Object[0])).append(";", new Object[0]);
        return (Map)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)builder, rs -> {
            HashMap<Long, Set> resultMap = new HashMap<Long, Set>(16);
            while (rs.next()) {
                resultMap.computeIfAbsent(rs.getLong(FIELD_USE_ORGID), k -> new HashSet(16)).add(rs.getLong(FIELD_DATA_ID));
            }
            return resultMap;
        });
    }

    private List<Object[]> packCustomDataParams(Map<Long, List<Long>> masterId2IdMap, Long currentDataId, Long masterId, Long orgId) {
        List<Long> dataIds = masterId2IdMap.get(masterId);
        if (currentDataId.equals(masterId) || CollectionUtils.isEmpty(dataIds)) {
            return Collections.emptyList();
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(dataIds.size());
        dataIds.forEach(dataId -> params.add(this.packCancelParams((Long)dataId, orgId)));
        return params;
    }

    private List<Object[]> packNotCuParams(Map<Long, List<Long>> isNotCuDataUseRegMap, Long currentDataId, Set<Long> useOrgIds, List<Long> directSubOrgIds) {
        List<Long> isNotCuOrgIds = this.getIsNotCuOrgIds(currentDataId, directSubOrgIds, isNotCuDataUseRegMap);
        if (CollectionUtils.isEmpty(isNotCuOrgIds)) {
            return Collections.emptyList();
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(isNotCuOrgIds.size());
        for (Long notCuOrgId : isNotCuOrgIds) {
            if (useOrgIds.contains(notCuOrgId)) continue;
            params.add(this.packCancelParams(currentDataId, notCuOrgId));
        }
        return params;
    }

    private Object[] packCancelParams(Long dataId, Long orgId) {
        Object[] param = new Object[]{dataId, orgId};
        return param;
    }

    private List<Object[]> businessValidate(String entity, List<Long[]> unAssignDataList) {
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)entity);
        if (null == baseDataCtrlPlugin) {
            return Collections.emptyList();
        }
        HashMap<Long, Set<Long>> unableCancelData2OrgMap = new HashMap<Long, Set<Long>>(16);
        List checkResult = baseDataCtrlPlugin.unAssignCheckWitchDetail(unAssignDataList);
        if (CollectionUtils.isEmpty((Collection)checkResult)) {
            List checkResultOlds = baseDataCtrlPlugin.unAssignCheck(unAssignDataList);
            Object[] tempResult = null;
            Object tempDataId = null;
            Long tempUseOrgId = null;
            for (Long[] checkResultOld : checkResultOlds) {
                tempDataId = checkResultOld[0];
                tempUseOrgId = checkResultOld[1];
                tempResult = new Object[]{tempDataId, tempUseOrgId, ""};
                checkResult.add(tempResult);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)checkResult)) {
            Long tempDataId = null;
            Long tempUseOrgId = null;
            for (Object[] tempResult : checkResult) {
                tempDataId = Long.valueOf(String.valueOf(tempResult[0]));
                tempUseOrgId = Long.valueOf(String.valueOf(tempResult[1]));
                this.unableCancelMap.computeIfAbsent(tempDataId, k -> new HashSet()).add(tempUseOrgId);
            }
        }
        for (Object[] dataArr : checkResult) {
            Long curDataId = Long.valueOf(String.valueOf(dataArr[0]));
            Set<Long> useOrgIds = this.dataId2UseOrgIdMap.get(curDataId);
            if (CollectionUtils.isEmpty(useOrgIds)) continue;
            Long useOrgId = Long.valueOf(dataArr[1].toString());
            if (this.isTreeTypeBaseData) {
                unableCancelData2OrgMap.computeIfAbsent(curDataId, k -> new HashSet(16)).add(useOrgId);
                continue;
            }
            useOrgIds.remove(useOrgId);
        }
        if (this.isTreeTypeBaseData && !unableCancelData2OrgMap.isEmpty()) {
            this.excludeUnableCancelData(unableCancelData2OrgMap);
        }
        return checkResult;
    }

    private void deleteDataInfo(String entity, List<Object[]> params, Set<Long> userOrgIds) {
        boolean isCustomEntity;
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        IDataEntityType dt = ORM.create().getDataEntityType(entity);
        DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
        String dataTableName = dt.getAlias();
        this.executeDelete(params, dataTableName + SUFFIX_BD_USE_REG, dbRoute);
        boolean bl = isCustomEntity = BaseDataServiceHelper.isNoneCustomEntity((String)entity) == false;
        if (isCustomEntity) {
            this.executeDelete(params, dataTableName + SUFFIX_BD_EXC, dbRoute);
        }
        this.executeDelete(params, dataTableName + "_U", dbRoute);
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        ArrayList keys = new ArrayList(userOrgIds.size());
        userOrgIds.forEach(orgId -> keys.add(entity + orgId));
        if (!CollectionUtils.isEmpty(keys)) {
            BaseDataCtrlCacheMrg.clearCache((String)type, (String[])keys.toArray(new String[0]));
        }
    }

    private void executeDelete(List<Object[]> params, String dataTableName, DBRoute dbRoute) {
        try {
            String deleteUseRegSql = "delete from " + dataTableName + " where fdataid = ? and fuseorgid = ?";
            ArrayList<Object[]> deleteParamsList = new ArrayList<Object[]>(params.size());
            for (Object[] param : params) {
                deleteParamsList.add(param);
                if (deleteParamsList.size() % 50000 != 0) continue;
                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRegSql, deleteParamsList);
                deleteParamsList.clear();
            }
            if (!deleteParamsList.isEmpty()) {
                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRegSql, deleteParamsList);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void initDataInfo(String entity, Set<Long> dataIds) {
        Map dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)entity, (String)this.masterIdPropName, (QFilter[])new QFilter[]{new QFilter("id", "in", dataIds)});
        HashSet masterIdSet = new HashSet(dataIds.size());
        dynamicObjects.values().forEach(bd -> masterIdSet.add(this.getMasterIdFromDynamicObject((DynamicObject)bd)));
        ArrayList<String> selectFieldList = new ArrayList<String>(Arrays.asList(this.masterIdPropName, this.numberField, "createorg", "ctrlstrategy"));
        String selectFields = String.join((CharSequence)String.valueOf(','), selectFieldList);
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)entity, (String)selectFields, (QFilter[])new QFilter[]{new QFilter(this.masterIdPropName, "in", masterIdSet)});
        this.baseDataMap.putAll(objectMap);
    }

    private Map<Long, List<Long>> getMasterIdToIdInfo() {
        HashMap<Long, List<Long>> masterId2IdMap = new HashMap<Long, List<Long>>(16);
        for (DynamicObject dynamicObject : this.baseDataMap.values()) {
            Long masterId = this.getMasterIdFromDynamicObject(dynamicObject);
            masterId2IdMap.computeIfAbsent(masterId, k -> new ArrayList(1)).add((Long)dynamicObject.getPkValue());
        }
        return masterId2IdMap;
    }

    private boolean customValidate(Map<Long, List<Long>> masterId2IdMap, Long currentDataId, Long masterId, Long useOrgId, Set<Long> subOrgIds) {
        HashMap<Long, Set<Long>> unableCancelData2OrgMap = new HashMap<Long, Set<Long>>(16);
        boolean hasCustomData = false;
        List<Long> dataIds = masterId2IdMap.get(masterId);
        for (Long dataId : dataIds) {
            DynamicObject curObj = this.baseDataMap.get(dataId);
            if (null == curObj) continue;
            Long createOrgId = curObj.getLong("createorg.id");
            String ctrlStrategy = curObj.getString("ctrlstrategy");
            if ("1".equals(ctrlStrategy)) {
                if (masterId.equals(dataId) || !subOrgIds.contains(createOrgId)) continue;
                if (this.isTreeTypeBaseData) {
                    unableCancelData2OrgMap.computeIfAbsent(currentDataId, k -> new HashSet(16)).add(useOrgId);
                    this.excludeUnableCancelData(unableCancelData2OrgMap);
                }
                String createOrgName = String.valueOf(curObj.get("createorg.name"));
                String number = curObj.getString(this.numberField);
                this.personalDataMap.computeIfAbsent(number, k -> new HashSet(16)).add(createOrgName);
                hasCustomData = true;
                continue;
            }
            if (masterId.equals(dataId) || !useOrgId.equals(createOrgId)) continue;
            if (this.isTreeTypeBaseData) {
                unableCancelData2OrgMap.computeIfAbsent(currentDataId, k -> new HashSet(16)).add(createOrgId);
                this.excludeUnableCancelData(unableCancelData2OrgMap);
            }
            String number = curObj.getString(this.numberField);
            this.personalDataMap.computeIfAbsent(number, k -> new HashSet(16)).add(this.useOrgId2NameMap.get(useOrgId));
            hasCustomData = true;
        }
        if (this.isTreeTypeBaseData && !unableCancelData2OrgMap.isEmpty()) {
            this.excludeUnableCancelData(unableCancelData2OrgMap);
        }
        if (hasCustomData) {
            Set<Long> tempOrgIds = this.unableCancelMap.get(currentDataId);
            if (null == tempOrgIds) {
                tempOrgIds = new HashSet<Long>(16);
            }
            this.unableCancelMap.put(currentDataId, tempOrgIds);
            tempOrgIds.add(useOrgId);
        }
        return hasCustomData;
    }

    private void getAllParentDataId(Long dataId, List<Long> parentDataIds) {
        Long parentDataId = this.allDataId2PidMap.get(dataId);
        if (null != parentDataId) {
            if (parentDataIds.contains(parentDataId)) {
                return;
            }
            parentDataIds.add(parentDataId);
            this.getAllParentDataId(parentDataId, parentDataIds);
        }
    }

    private Long getMasterIdFromDynamicObject(DynamicObject baseData) {
        Long masterId = 0L;
        if (baseData == null) {
            return masterId;
        }
        Object value = baseData.get(this.masterIdPropName);
        if (null == value && "masterid".equals(this.masterIdPropName)) {
            value = baseData.get("masterid_id");
        }
        if (value instanceof DynamicObject) {
            DynamicObject masterObj = (DynamicObject)value;
            masterId = (Long)masterObj.getPkValue();
        } else if (value instanceof Long) {
            return (Long)value;
        }
        return masterId;
    }

    private Map<Long, List<Long>> getDirectSubOrgIdsMap(long viewId) {
        ORM orm = ORM.create();
        HashMap<Long, List<Long>> directSubOrgIdsMap = new HashMap<Long, List<Long>>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (Map.Entry<Long, Set<Long>> entry : this.dataId2UseOrgIdMap.entrySet()) {
            Set<Long> dataOrgIds = entry.getValue();
            orgIds.addAll(dataOrgIds);
            for (Long orgId : orgIds) {
                directSubOrgIdsMap.put(orgId, new ArrayList(16));
            }
        }
        QFilter[] filters = new QFilter[]{new QFilter("view.id", "=", (Object)viewId), new QFilter(FIELD_ORG_PARENT_ID, "in", orgIds)};
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), ENTITY_ORG_STRUCTURE, "org.id,parent.id", filters);){
            for (Row row : ds) {
                Long orgId = row.getLong(FIELD_ORG_ID);
                Long orgParentId = row.getLong(FIELD_ORG_PARENT_ID);
                if (null == orgId || null == orgParentId) continue;
                ((List)directSubOrgIdsMap.get(orgParentId)).add(orgId);
            }
        }
        return directSubOrgIdsMap;
    }

    private List<Long[]> getBusinessCancelAssignCheckData(Set<Long> dataIds) {
        ArrayList<Long[]> unAssignDataList = new ArrayList<Long[]>(10);
        for (Map.Entry<Long, Set<Long>> entry : this.dataId2UseOrgIdMap.entrySet()) {
            Long dataId = entry.getKey();
            dataIds.add(dataId);
            for (Long orgId : entry.getValue()) {
                Long[] unAssignData = new Long[]{dataId, orgId};
                unAssignDataList.add(unAssignData);
            }
        }
        return unAssignDataList;
    }

    private Map<Long, List<Long>> getDataCuUseRegMap(Map<Long, List<Long>> directSubOrgIdsMap, String entity) {
        return this.getDataUseRegMap(directSubOrgIdsMap, entity, null, true);
    }

    private Map<Long, List<Long>> getIsNotCuDataUseRegMap(Map<Long, List<Long>> directSubOrgIdsMap, String entity, Long createOrgId) {
        return this.getDataUseRegMap(directSubOrgIdsMap, entity, createOrgId, false);
    }

    private Map<Long, List<Long>> getDataUseRegMap(Map<Long, List<Long>> directSubOrgIdsMap, String entity, Long createOrgId, boolean isSelectCuData) {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        ArrayList<Long> dataIds = new ArrayList<Long>(this.dataId2UseOrgIdMap.size());
        for (Map.Entry<Long, Set<Long>> entry : this.dataId2UseOrgIdMap.entrySet()) {
            Long dataId = entry.getKey();
            dataIds.add(dataId);
            for (Long orgId : entry.getValue()) {
                List<Long> directSubOrgIds = directSubOrgIdsMap.get(orgId);
                if (CollectionUtils.isEmpty(directSubOrgIds)) continue;
                orgIds.addAll(directSubOrgIds);
            }
        }
        if (orgIds.isEmpty()) {
            return new HashMap<Long, List<Long>>(0);
        }
        IDataEntityType dt = ORM.create().getDataEntityType(entity);
        String dataTableName = dt.getAlias();
        String dataTableUseName = dataTableName + SUFFIX_BD_USE_REG;
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(String.format("SELECT mu.fdataid,mu.fuseorgid uoid from %s mu INNER JOIN %s m on m.fid = mu.fdataid where ", dataTableUseName, dataTableName), new Object[0]);
        sqlBuilder.appendIn("mu.fdataid", dataIds).append(" and ", new Object[0]);
        sqlBuilder.appendIn("mu.fuseorgid", orgIds.toArray(new Object[0]));
        if (isSelectCuData) {
            sqlBuilder.append(" and mu.FisAssign = '1' and mu.fctrlstrategy = '1';", new Object[0]);
        } else {
            sqlBuilder.append(" and mu.FisAssign = '0' and mu.fcreateorgid <> mu.fuseorgid;", new Object[0]);
        }
        return (Map)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (SqlBuilder)sqlBuilder, rs -> {
            HashMap<Long, List> map = new HashMap<Long, List>(orgIds.size());
            while (rs.next()) {
                Long dataId = rs.getLong(1);
                Long useOrgId = rs.getLong(2);
                if (isSelectCuData) {
                    map.computeIfAbsent(dataId, k -> new ArrayList(16)).add(useOrgId);
                    continue;
                }
                List orgIdList = map.computeIfAbsent(dataId, k -> new ArrayList(16));
                if (createOrgId.equals(useOrgId)) continue;
                orgIdList.add(useOrgId);
            }
            return map;
        });
    }

    private Long getAlreadyAssignSubOrgId(Set<Long> useOrgIds, Long dataId, Map<Long, List<Long>> directSubOrgIdsMap, Map<Long, List<Long>> dataUseRegMap, Long currentOrgId) {
        List<Long> useOrgList = dataUseRegMap.get(dataId);
        if (CollectionUtils.isEmpty(useOrgList)) {
            return null;
        }
        Set<Long> directAndInDirectSubOrgIds = this.getDirectAndInDirectSubOrgIds(directSubOrgIdsMap, currentOrgId);
        for (Long useOrgId : useOrgList) {
            if (!directAndInDirectSubOrgIds.contains(useOrgId) || useOrgIds.contains(useOrgId)) continue;
            if (this.isTreeTypeBaseData) {
                HashMap<Long, Set<Long>> unableCancelData2OrgMap = new HashMap<Long, Set<Long>>(16);
                unableCancelData2OrgMap.computeIfAbsent(dataId, k -> new HashSet(10)).add(currentOrgId);
                this.excludeUnableCancelData(unableCancelData2OrgMap);
            }
            return useOrgId;
        }
        return null;
    }

    private Set<Long> getDirectAndInDirectSubOrgIds(Map<Long, List<Long>> directSubOrgIdsMap, Long currentSelectOrgId) {
        HashSet<Long> directAndInDirectSubOrgIds = new HashSet<Long>(directSubOrgIdsMap.size());
        List<Long> directSubOrgIds = directSubOrgIdsMap.get(currentSelectOrgId);
        directAndInDirectSubOrgIds.addAll(directSubOrgIds);
        for (Long inDirectSubOrgId : directSubOrgIds) {
            List<Long> inDirectSubOrgIds = directSubOrgIdsMap.get(inDirectSubOrgId);
            if (CollectionUtils.isEmpty(inDirectSubOrgIds)) continue;
            directAndInDirectSubOrgIds.addAll(this.getDirectAndInDirectSubOrgIds(directSubOrgIdsMap, inDirectSubOrgId));
        }
        return directAndInDirectSubOrgIds;
    }

    private List<Long> getIsNotCuOrgIds(Long dataId, List<Long> directSubOrgIds, Map<Long, List<Long>> isNotCuDataUseRegMap) {
        List<Long> useOrgIds = isNotCuDataUseRegMap.get(dataId);
        ArrayList<Long> isNotCuOrgIds = new ArrayList<Long>(10);
        if (CollectionUtils.isEmpty(useOrgIds)) {
            return isNotCuOrgIds;
        }
        for (Long useOrgId : useOrgIds) {
            if (!directSubOrgIds.contains(useOrgId)) continue;
            isNotCuOrgIds.add(useOrgId);
        }
        return isNotCuOrgIds;
    }

    private void showCancelAssignErrorTip(List<Object[]> checkResult, Map<Long, Set<Long>> unableCancelData) {
        if (!this.unableCancelAssignDataMap.isEmpty()) {
            this.showTreeDataValidateTipNotification();
            return;
        }
        if (!this.personalDataMap.isEmpty()) {
            Map<Long, String> orgNameMap = CancelAssignService.getOrgNameMap(this.unableCancelMap);
            Set<Map.Entry<Long, Set<Long>>> unableCancelES = this.unableCancelMap.entrySet();
            for (Map.Entry<Long, Set<Long>> entry : unableCancelES) {
                String msg;
                Long dataId = entry.getKey();
                Set<Long> useOrgIds = entry.getValue();
                HashMap<Long, Set<Long>> unableCancelMapTemp = new HashMap<Long, Set<Long>>(1);
                unableCancelMapTemp.put(dataId, useOrgIds);
                String number = this.dataId2NumberMap.get(dataId);
                Set<String> customerOrgCol = this.personalDataMap.get(number);
                if (!CollectionUtils.isEmpty(customerOrgCol)) {
                    for (String orgName : customerOrgCol) {
                        msg = ResManager.loadKDString((String)"%1$s\uff1a\u5728\u7ec4\u7ec7\u3010%2$s\u3011\u4e2d\u5b58\u5728\u4e2a\u6027\u5316\u6570\u636e\uff0c\u8bf7\u5148\u5220\u9664\u4e2a\u6027\u5316\u6570\u636e\u518d\u53d6\u6d88\u5206\u914d\u3002", (String)"CancelAssignService_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                        this.addResult(unableCancelMapTemp, String.format(msg, number, orgName), false);
                    }
                    continue;
                }
                for (Long useOrgId : useOrgIds) {
                    msg = ResManager.loadKDString((String)"%1$s\uff1a\u5728\u3010%2$s\u3011\u53d6\u6d88\u5206\u914d\u5931\u8d25\uff0c\u8be5\u8bb0\u5f55\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u5b58\u5728\u5206\u914d\u8bb0\u5f55\uff0c\u8bf7\u5148\u5728\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u53d6\u6d88\u5206\u914d\u3002", (String)"CancelAssignService_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                    this.addResult(unableCancelMapTemp, String.format(msg, number, orgNameMap.get(useOrgId)), false);
                }
            }
            return;
        }
        if (unableCancelData.isEmpty()) {
            if (checkResult.isEmpty()) {
                return;
            }
            this.addBusinessValidateErrorTip(checkResult);
        } else {
            if (checkResult.isEmpty()) {
                this.getUnableCancelAssignMsg(unableCancelData);
                return;
            }
            this.addBusinessValidateErrorTip(checkResult);
        }
    }

    private static Map<Long, String> getOrgNameMap(Map<Long, Set<Long>> unableCancelData) {
        HashSet orgIds = new HashSet();
        Optional.ofNullable(unableCancelData).orElseGet(Collections::emptyMap).values().forEach(orgIds::addAll);
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", orgIds)};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])filters);
        HashMap<Long, String> orgNameMap = new HashMap<Long, String>(orgCol.size());
        orgCol.forEach(org -> orgNameMap.put(org.getLong("id"), org.getString("name")));
        return orgNameMap;
    }

    private void addBusinessValidateErrorTip(List<Object[]> checkResult) {
        if (checkResult.isEmpty()) {
            return;
        }
        HashMap<Long, Set<Long>> errorMap = null;
        HashSet<Long> errorSet = null;
        String number = null;
        String orgName = null;
        for (Object[] checkResultTemp : checkResult) {
            Long dataId = Long.valueOf(checkResultTemp[0].toString());
            Long orgId = Long.valueOf(checkResultTemp[1].toString());
            String errorMsg = null == checkResultTemp[2] ? "" : checkResultTemp[2].toString();
            errorMap = new HashMap<Long, Set<Long>>(1);
            errorSet = new HashSet<Long>(1);
            errorSet.add(orgId);
            errorMap.put(dataId, errorSet);
            number = this.dataId2NumberMap.get(dataId);
            orgName = this.useOrgId2NameMap.get(orgId);
            String msg = ResManager.loadKDString((String)"%1$s\uff1a\u5728\u7ec4\u7ec7\u3010%2$s\u3011\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002%3$s", (String)"CancelAssignService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.addResult(errorMap, String.format(msg, number, orgName, errorMsg), false);
        }
    }

    private void addResult(Map<Long, Set<Long>> unableCancelData, String errorMsg, boolean isSuccess) {
        Set<Map.Entry<Long, Set<Long>>> entrySet = unableCancelData.entrySet();
        for (Map.Entry<Long, Set<Long>> entry : entrySet) {
            CancelAssignResult cancelAssignResult = new CancelAssignResult();
            cancelAssignResult.setDataId(entry.getKey());
            cancelAssignResult.setOrgIds(new ArrayList(entry.getValue()));
            cancelAssignResult.setSuccess(isSuccess);
            cancelAssignResult.setErrorMsg(errorMsg);
            this.result.add(cancelAssignResult);
        }
    }

    private void showTreeDataValidateTipNotification() {
        String msg = ResManager.loadKDString((String)"%1$s\uff1a\u5728\u7ec4\u7ec7\u3010%2$s\u3011\u4e2d\u5b58\u5728\u4e0b\u7ea7\u8d44\u6599\uff0c\u8bf7\u5148\u53d6\u6d88\u8be5\u4e0b\u7ea7\u8d44\u6599\u7684\u5206\u914d\u6216\u8005\u5220\u9664\u8be5\u4e0b\u7ea7\u8d44\u6599\u3002", (String)"CancelAssignService_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        HashMap<Long, Set<Long>> tempErrorMap = null;
        HashSet<Long> tempOrgSet = null;
        for (Map.Entry<Long, Set<Long>> entry : this.unableCancelMap.entrySet()) {
            String dataNumber = this.dataId2NumberMap.get(entry.getKey());
            Set<Long> values = entry.getValue();
            for (Long value : values) {
                tempErrorMap = new HashMap<Long, Set<Long>>(1);
                tempOrgSet = new HashSet<Long>(1);
                tempOrgSet.add(value);
                tempErrorMap.put(entry.getKey(), tempOrgSet);
                String orgName = this.useOrgId2NameMap.get(value);
                this.addResult(tempErrorMap, String.format(msg, dataNumber, orgName), false);
            }
        }
    }

    private void getUnableCancelAssignMsg(Map<Long, Set<Long>> unableCancelData) {
        Map<Long, String> orgNameMap = CancelAssignService.getOrgNameMap(unableCancelData);
        for (Map.Entry<Long, Set<Long>> entry : unableCancelData.entrySet()) {
            Long dataId = entry.getKey();
            String dataNumber = this.dataId2NumberMap.get(dataId);
            Set<Long> values = entry.getValue();
            for (Long orgId : values) {
                String msg = ResManager.loadKDString((String)"%1$s\uff1a\u5728\u3010%2$s\u3011\u53d6\u6d88\u5206\u914d\u5931\u8d25\uff0c\u8be5\u8bb0\u5f55\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u5b58\u5728\u5206\u914d\u8bb0\u5f55\uff0c\u8bf7\u5148\u5728\u5176\u4e0b\u7ea7\u7ec4\u7ec7\u53d6\u6d88\u5206\u914d\u3002", (String)"CancelAssignService_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                HashMap<Long, Set<Long>> unableCancelDataTemp = new HashMap<Long, Set<Long>>(10);
                unableCancelDataTemp.put(dataId, values);
                this.addResult(unableCancelDataTemp, String.format(msg, dataNumber, orgNameMap.get(orgId)), false);
            }
        }
    }

    private void writOpLog(List<Object[]> params, String entity, Long currentOrgId) {
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        ArrayList<OpLogAppInfo> logs = new ArrayList<OpLogAppInfo>(1);
        Date opTime = new Date();
        RequestContext context = RequestContext.get();
        Long userId = context.getCurrUserId();
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setUserID(userId);
        appLogInfo.setOrgID(currentOrgId);
        appLogInfo.setAccountId(context.getAccountId());
        appLogInfo.setClientIP(context.getLoginIP());
        appLogInfo.setClientName(context.getClient());
        appLogInfo.setClientType(context.getClient());
        appLogInfo.setTenantId(context.getTenantId());
        appLogInfo.setLanguage(context.getLang().name());
        appLogInfo.setOpTime(opTime);
        appLogInfo.setOpName("Cancel Assign", new MultiLangEnumBridge("\u53d6\u6d88\u5206\u914d", "CancelAssignService_4", SYSTEM_TYPE));
        appLogInfo.setOpDesc(new MultiLangEnumBridge("\u64cd\u4f5c\u5b8c\u6210\uff0c\u8be6\u60c5\u53ef\u89c1\u7ba1\u63a7\u65e5\u5fd7\uff0c\u5177\u4f53\u8def\u5f84\uff1a\u3010\u57fa\u7840\u670d\u52a1\u4e91\u3011-\u3010\u4f01\u4e1a\u5efa\u6a21\u3011-\u3010\u7ba1\u63a7\u7b56\u7565\u3011-\u3010\u7ba1\u63a7\u65e5\u5fd7\u3011\u3002", "CancelAssignService_5", SYSTEM_TYPE), new String[0]);
        appLogInfo.setBizObjID(entity);
        appLogInfo.setBizAppID(this.appId);
        logs.add(appLogInfo);
        LogServiceHelper.addBatchLog(logs);
    }

    private void init(String entityId, Set<Long> allDataIds, Set<Long> allUseOrgIds) {
        this.isTreeTypeBaseData = BaseDataCommonService.isTreeType((String)entityId);
        boolean isOtherMasterIdType = BaseDataCommonService.isOtherMasterIdType((String)entityId);
        this.numberField = isOtherMasterIdType ? "masterid.number" : "number";
        this.masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
        HashMap cancelData = new HashMap(allDataIds.size());
        allDataIds.forEach(dataId -> cancelData.computeIfAbsent(dataId, k -> new HashSet()).addAll(allUseOrgIds));
        this.dataId2UseOrgIdMap = new HashMap<Long, Set<Long>>(cancelData);
        QFilter[] orgFilters = new QFilter[]{new QFilter("id", "in", allUseOrgIds)};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])orgFilters);
        orgCol.forEach(org -> this.useOrgId2NameMap.put(org.getLong("id"), org.getString("name")));
        QFilter[] dataFilters = new QFilter[]{new QFilter("id", "in", allDataIds)};
        DynamicObjectCollection dataCol = QueryServiceHelper.query((String)entityId, (String)("id," + this.numberField + ",ctrlstrategy,createorg.id"), (QFilter[])dataFilters);
        ArrayList useOrgList = new ArrayList(10);
        dataCol.forEach(data -> {
            this.dataId2NumberMap.put(data.getLong("id"), data.getString(this.numberField));
            useOrgList.add(data.getLong("createorg.id"));
        });
        if (!this.isTreeTypeBaseData || this.dataId2UseOrgIdMap.isEmpty()) {
            return;
        }
        HashSet<Long> selectDataIds = new HashSet<Long>(16);
        selectDataIds.addAll(this.dataId2UseOrgIdMap.keySet());
        String selectFields = "id,createorg.name,parent.id,ctrlstrategy";
        QFilter[] filters = new QFilter[]{new QFilter(FIELD_ORG_PARENT_ID, "in", selectDataIds).or(new QFilter("id", "in", selectDataIds))};
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)entityId, (String)selectFields, (QFilter[])filters);
        for (Map.Entry entry : dynamicObjectMap.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            Long dataId2 = dynamicObject.getLong("id");
            Long pId = dynamicObject.getLong(FIELD_ORG_PARENT_ID);
            this.dataStrategyMap.put(dataId2, dynamicObject.getString("ctrlstrategy"));
            this.dataId2OrgNameMap.put(dataId2, dynamicObject.getString("createorg.name"));
            if (!selectDataIds.contains(pId)) continue;
            this.dataId2PidMap.put(dataId2, pId);
        }
        filters = new QFilter[]{new QFilter(FIELD_ORG_PARENT_ID, "in", selectDataIds).or(new QFilter("id", "in", selectDataIds))};
        Map allObjectMap = BusinessDataServiceHelper.loadFromCache((String)entityId, (String)selectFields, (QFilter[])filters);
        for (Map.Entry entry : allObjectMap.entrySet()) {
            DynamicObject data3 = (DynamicObject)entry.getValue();
            Long dataId3 = data3.getLong("id");
            Long pId = data3.getLong(FIELD_ORG_PARENT_ID);
            if (!selectDataIds.contains(pId)) continue;
            this.allDataId2PidMap.put(dataId3, pId);
        }
        DynamicObject dynamicObject = BaseDataServiceHelper.getCtrlview((String)entityId);
        OrgTreeParam orgTreeParam = new OrgTreeParam();
        orgTreeParam.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        orgTreeParam.setOrgViewId(((Long)dynamicObject.getPkValue()).longValue());
        ArrayList<Long> orgIds = new ArrayList<Long>(this.useOrgId2NameMap.size());
        orgIds.addAll(this.useOrgId2NameMap.keySet());
        orgTreeParam.setOrgRangeList(orgIds);
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)orgTreeParam);
        Long topOrgId = Long.valueOf(rootNode.getId());
        this.child2ParentOrgMap.putAll(new BaseDataCommonService().getChild2ParentOrgMap(orgIds, topOrgId, entityId));
    }
}

