/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.service.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.basedata.service.internal.BaseDataCtrlAdapter;
import kd.bos.basedata.service.internal.BaseDataOrgRelationAdapter;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class BaseDataAddAdapter {
    private static Log logger = LogFactory.getLog(BaseDataAddAdapter.class);

    public static void baseDataSubmitHandler(DynamicObject[] dataArr) {
        if (dataArr == null || dataArr.length == 0) {
            return;
        }
        if (BaseDataCommonService.isNewModel((String)dataArr[0].getDataEntityType().getName())) {
            try {
                new BaseDataCommonService().handleSubmitNewCtrlData(dataArr);
            }
            catch (Exception e) {
                logger.error("\u63d0\u4ea4\u6570\u636e\u65f6\uff0c\u5904\u7406\u4f4d\u56fe\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("500", "submit data fail."), new Object[0]);
            }
        }
        HashMap<String, List> dataMap = new HashMap<String, List>(8);
        for (DynamicObject data : dataArr) {
            String ctrlStrategy = data.getString("ctrlstrategy");
            Long createOrgId = BaseDataCtrlAdapter.getBaseDataCreateOrgId(data);
            dataMap.computeIfAbsent(ctrlStrategy + "_" + createOrgId, k -> new ArrayList(10)).add(data);
        }
        for (Map.Entry entry : dataMap.entrySet()) {
            DynamicObject dataInfo = (DynamicObject)((List)entry.getValue()).get(0);
            String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
            String entity = dataInfo.getDataEntityType().getName();
            ArrayList<Long> useOrgSet = new ArrayList<Long>(10);
            Long createOrgId = BaseDataCtrlAdapter.getBaseDataCreateOrgId(dataInfo);
            String key = entity + createOrgId;
            BaseDataCtrlCacheMrg.clearCache((String)type, (String)key);
            if (createOrgId != null) {
                useOrgSet.add(createOrgId);
            }
            String ctrlStrategy = dataInfo.getString("ctrlstrategy");
            if (useOrgSet.size() <= 0) continue;
            DynamicObject[] dataInfos = ((List)entry.getValue()).toArray(new DynamicObject[0]);
            BaseDataOrgRelationAdapter.saveBaseDataUseReg(dataInfos, createOrgId, 0L, useOrgSet, ctrlStrategy);
            BaseDataOrgRelationAdapter.saveBaseDataUseRange(dataInfos, useOrgSet);
        }
    }

    public static void baseDataAddnewHandler(DynamicObject[] dataArr) {
        if (dataArr == null || dataArr.length == 0) {
            return;
        }
        String entityId = dataArr[0].getDataEntityType().getName();
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
        if (null == ctrlView) {
            return;
        }
        if (BaseDataCommonService.isNewModel((String)entityId)) {
            BaseDataCommonService service = new BaseDataCommonService();
            try {
                service.handleNewCtrlData(dataArr);
                return;
            }
            catch (Exception e) {
                logger.error("\u65b0\u589e\u6570\u636e\u65f6\uff0c\u751f\u6210\u4f4d\u56fe\u4fe1\u606f\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u53ef\u7528", (Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("", "fail to generate bit map."), new Object[0]);
            }
        }
        HashMap<Long, Map<Long, String>> orgDataStrategyMap = new HashMap<Long, Map<Long, String>>(16);
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        boolean isContainShareCtrl = false;
        boolean isContainCuShareCtrl = false;
        ArrayList<Object[]> saveUseRangeParams = new ArrayList<Object[]>(dataArr.length);
        for (DynamicObject dataInfo : dataArr) {
            if (dataInfo == null) continue;
            Long dataId = (Long)dataInfo.getPkValue();
            Long createOrgId = BaseDataCtrlAdapter.getBaseDataCreateOrgId(dataInfo);
            String ctrlStrategy = dataInfo.getString("ctrlstrategy");
            orgDataStrategyMap.computeIfAbsent(createOrgId, k -> new HashMap(1)).put(dataId, ctrlStrategy);
            saveUseRangeParams.add(new Object[]{dataId, createOrgId});
            BillEntityType billEntityType = (BillEntityType)dataInfo.getDataEntityType();
            String billStatusKey = billEntityType.getBillStatus();
            String status = "";
            if (StringUtils.isNotBlank((CharSequence)billStatusKey) && !billEntityType.getProperty(billStatusKey).isDbIgnore()) {
                status = dataInfo.getString(billStatusKey);
            }
            if (!StringUtils.isBlank((CharSequence)billStatusKey) && !BillStatus.C.name().equals(status)) continue;
            if ("5".equals(ctrlStrategy)) {
                isContainShareCtrl = true;
                continue;
            }
            if (!"6".equals(ctrlStrategy)) continue;
            isContainCuShareCtrl = true;
        }
        BaseDataOrgRelationAdapter.saveUseRegOnAddOp(entityId, orgDataStrategyMap);
        HashSet<Long> clearOrgSet = new HashSet<Long>(orgDataStrategyMap.keySet());
        if (!saveUseRangeParams.isEmpty()) {
            if (isContainCuShareCtrl) {
                saveUseRangeParams.addAll(BaseDataAddAdapter.buildCuShareRel(orgDataStrategyMap, (Long)ctrlView.getPkValue(), clearOrgSet));
            }
            BaseDataOrgRelationAdapter.saveBaseDataUseRange(entityId, saveUseRangeParams);
        }
        if (isContainShareCtrl) {
            BaseDataCtrlCacheMrg.clearCacheWithPrefix((String)type, (String)entityId);
        } else {
            BaseDataCtrlCache.clearBaseDataFilter((String)entityId, clearOrgSet);
        }
    }

    private static List<Object[]> buildCuShareRel(Map<Long, Map<Long, String>> orgDataStrategyMap, Long viewId, Set<Long> clearOrgSet) {
        HashMap<Long, Set> orgDataRel = new HashMap<Long, Set>(16);
        for (Map.Entry<Long, Map<Long, String>> entry : orgDataStrategyMap.entrySet()) {
            Long orgId = entry.getKey();
            Map<Long, String> dataStrategyMap = entry.getValue();
            if (CollectionUtils.isEmpty(dataStrategyMap)) continue;
            for (Map.Entry<Long, String> e2 : dataStrategyMap.entrySet()) {
                if (!"6".equals(e2.getValue())) continue;
                orgDataRel.computeIfAbsent(orgId, k -> new HashSet(6)).add(e2.getKey());
            }
        }
        QFilter[] filters = new QFilter[]{new QFilter("view.id", "=", (Object)viewId), new QFilter("isctrlunit", "=", (Object)Boolean.FALSE)};
        ArrayList<Long> unCuSubOrgIds = new ArrayList<Long>(10);
        DataSet ds = ORM.create().queryDataSet(BaseDataAddAdapter.class.getName(), "bos_org_structure", "org.id", filters);
        Object object = null;
        try {
            for (Row row : ds) {
                Long orgId = row.getLong("org.id");
                if (orgId == null) continue;
                unCuSubOrgIds.add(orgId);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        ArrayList<Object[]> saveUseRangeParams = new ArrayList<Object[]>(10);
        for (Map.Entry entry : orgDataRel.entrySet()) {
            ArrayList currOrgId = new ArrayList(Collections.singletonList(entry.getKey()));
            List orgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewId, currOrgId, (boolean)false, (boolean)true);
            orgIds.removeAll(unCuSubOrgIds);
            if (CollectionUtils.isEmpty((Collection)orgIds)) continue;
            clearOrgSet.addAll(orgIds);
            ((Set)entry.getValue()).forEach(e -> orgIds.forEach(o -> saveUseRangeParams.add(new Object[]{e, o})));
        }
        return saveUseRangeParams;
    }
}

