/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.service.internal;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.service.internal.BaseDataCtrlAdapter;
import kd.bos.basedata.service.internal.BaseDataOrgRelationAdapter;
import kd.bos.bd.ext.IBaseDataSubExtService;
import kd.bos.bd.ext.pojo.ExtActionInfo;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.service.AssignQueryService;
import kd.bos.bd.service.AssignService;
import kd.bos.bd.service.BaseDataAssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.BaseDataRepairService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class BaseDataAssignAdapter {
    private static Log logger = LogFactory.getLog(BaseDataAssignAdapter.class);

    public static Map<Long, Map<Long, String>> batchAssign(String entity, Long assignOrgId, List<Long> dataIds, List<Long> orgIds) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(dataIds) || org.apache.commons.collections4.CollectionUtils.isEmpty(orgIds)) {
            return new HashMap<Long, Map<Long, String>>(0);
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        if (null == ctrlView) {
            throw new NullPointerException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230%s\u5bf9\u5e94\u7684\u63a7\u5236\u89c6\u56fe", (String)"BaseDataAssignAdapter_0", (String)"bos-mservice-bd", (Object[])new Object[0]), entity));
        }
        if (BaseDataCommonService.isNewModel((String)entity)) {
            BaseDataAssignService service = new BaseDataAssignService(entity);
            Map assignResMap = service.batchAssignAdapter(assignOrgId, dataIds, orgIds);
            BDCtrlLogHelper.saveAssignLogNoSource((String)entity, (Long)assignOrgId, dataIds, orgIds, (Map)assignResMap, null);
            return assignResMap;
        }
        String masterIdProp = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", dataIds)};
        DynamicObjectCollection col = ORM.create().query(entity, "id, " + masterIdProp + ", createorg, org, ctrlstrategy", filters);
        if (org.apache.commons.collections4.CollectionUtils.isEmpty((Collection)col)) {
            return new HashMap<Long, Map<Long, String>>(0);
        }
        HashMap<Long, Map<Long, String>> assignCheckResMap = new HashMap<Long, Map<Long, String>>(16);
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataCtrlAdapter.getBaseDataCtrlPlugin(entity);
        if (baseDataCtrlPlugin != null) {
            BaseDataAssignAdapter.mergeErrorInformation(assignCheckResMap, baseDataCtrlPlugin.assignCheckWithDetail(dataIds, orgIds));
            if (assignCheckResMap.size() == 0) {
                BaseDataAssignAdapter.convertMapWithErrorMsg(dataIds, orgIds, assignCheckResMap, baseDataCtrlPlugin);
            }
        }
        IBaseDataSubExtService ext = BaseDataBusinessServiceUtils.getBaseDataSubExtService((String)entity);
        ExtActionInfo extActionInfo = ext.handleBeforeAssign(entity, assignOrgId, dataIds, orgIds);
        BaseDataAssignAdapter.mergeErrorInformation(assignCheckResMap, extActionInfo.getData());
        if (!extActionInfo.isExecute()) {
            return assignCheckResMap;
        }
        HashMap<String, Map<String, Long>> allFailUseRegMap = new HashMap<String, Map<String, Long>>(16);
        if (!CollectionUtils.isEmpty(assignCheckResMap)) {
            HashSet<Long> failOrgIds = new HashSet<Long>(16);
            assignCheckResMap.values().forEach(map -> failOrgIds.addAll(map.keySet()));
            BaseDataOrgRelationAdapter.getUseReg(entity, assignCheckResMap.keySet(), failOrgIds, new HashMap<Long, List<Long>>(failOrgIds.size()), allFailUseRegMap);
        }
        HashSet<Long> masterIds = new HashSet<Long>(col.size());
        HashMap<String, List> dataMap = new HashMap<String, List>(16);
        for (Object data : col) {
            String key = data.getString("ctrlstrategy") + "_" + BaseDataCtrlAdapter.getBaseDataCreateOrgId((DynamicObject)data);
            dataMap.computeIfAbsent(key, k -> new ArrayList(10)).add(data);
            masterIds.add(data.getLong(masterIdProp));
        }
        String ctrlStrategy = ((DynamicObject)col.get(0)).getString("ctrlstrategy");
        for (List values : dataMap.values()) {
            DynamicObject data = (DynamicObject)values.get(0);
            Long l = data.getLong("createorg");
            ArrayList<Long> tempDataIds = new ArrayList<Long>(16);
            values.forEach(v -> tempDataIds.add((Long)v.getPkValue()));
            BaseDataOrgRelationAdapter.saveBaseDataUseReg(entity, tempDataIds, l, l, orgIds, ctrlStrategy, true, assignOrgId);
            BaseDataOrgRelationAdapter.saveBaseDataUseRange(entity, tempDataIds, orgIds);
        }
        Map<Long, List<Long>> subordinateOrgsMap = BaseDataCtrlAdapter.getDirectSubordinateOrgList((Long)ctrlView.getPkValue(), orgIds);
        if (!CollectionUtils.isEmpty(assignCheckResMap)) {
            BaseDataAssignAdapter.unAssign(entity, assignCheckResMap, subordinateOrgsMap, allFailUseRegMap);
        }
        if ("1".equals(ctrlStrategy)) {
            HashSet<Long> allOrgSet = new HashSet<Long>(orgIds);
            for (Long l : orgIds) {
                List<Long> subordinateOrgList = subordinateOrgsMap.get(l);
                if (org.apache.commons.collections4.CollectionUtils.isEmpty(subordinateOrgList)) continue;
                allOrgSet.addAll(subordinateOrgList);
            }
            BaseDataCtrlCache.cleanIsHasBaseDataUseRange((String)entity, allOrgSet);
            if (!BaseDataBusinessServiceUtils.isEnableVersion((String)entity)) {
                new BaseDataRepairService().repairDupUseRang(entity, new ArrayList<Long>(allOrgSet), new ArrayList(masterIds));
            }
        }
        BaseDataCtrlCache.clearBaseDataFilter((String)entity, new HashSet<Long>(orgIds));
        if (TreeBaseDataCommonService.isAssignUnDetail((String)entity) && !BaseDataBusinessServiceUtils.isEnableVersion((String)entity)) {
            HashMap unableAssignMap = new HashMap(assignCheckResMap.size());
            if (!CollectionUtils.isEmpty(assignCheckResMap)) {
                for (Map.Entry entry : assignCheckResMap.entrySet()) {
                    Long dataId = (Long)entry.getKey();
                    Set failOrgIds = ((Map)entry.getValue()).keySet();
                    failOrgIds.forEach(failOrgId -> unableAssignMap.computeIfAbsent(failOrgId, k -> new HashSet(16)).add(dataId));
                }
            }
            new AssignService(entity).autoIndividualOnOriginalModel(assignOrgId, dataIds, new HashSet<Long>(orgIds), unableAssignMap);
        }
        extActionInfo = ext.handleAfterAssign(entity, assignOrgId, dataIds, orgIds);
        BaseDataAssignAdapter.mergeErrorInformation(assignCheckResMap, extActionInfo.getData());
        BDCtrlLogHelper.saveAssignLogNoSource((String)entity, (Long)assignOrgId, dataIds, orgIds, assignCheckResMap, null);
        return assignCheckResMap;
    }

    private static void mergeErrorInformation(Map<Long, Map<Long, String>> assignCheckResMap, Map<Long, Map<Long, String>> data) {
        for (Map.Entry<Long, Map<Long, String>> entry : data.entrySet()) {
            Map<Long, String> orgMsg = entry.getValue();
            if (null == orgMsg) continue;
            assignCheckResMap.computeIfAbsent(entry.getKey(), k -> new HashMap(16)).putAll(orgMsg);
        }
    }

    private static void convertMapWithErrorMsg(List<Long> dataIds, List<Long> orgIds, Map<Long, Map<Long, String>> assignCheckResMap, IBaseDataCtrlPlugin baseDataCtrlPlugin) {
        Map assignCheckRes = baseDataCtrlPlugin.assignCheck(dataIds, orgIds);
        if (null == assignCheckRes || assignCheckRes.isEmpty()) {
            return;
        }
        for (Map.Entry entry : assignCheckRes.entrySet()) {
            List tempOrgs = (List)entry.getValue();
            HashMap<Long, String> tempErrMsgMap = new HashMap<Long, String>(tempOrgs.size());
            for (Long tempOrg : tempOrgs) {
                tempErrMsgMap.put(tempOrg, ResManager.loadKDString((String)"\u4e1a\u52a1\u5206\u914d\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"BaseDataAssignAdapter_1", (String)"bos-mservice-bd", (Object[])new Object[0]));
            }
            Long key = (Long)entry.getKey();
            assignCheckResMap.put(key, tempErrMsgMap);
        }
    }

    private static void unAssign(String entityId, Map<Long, Map<Long, String>> assignCheckResMap, Map<Long, List<Long>> subordinateOrgsMap, Map<String, Map<String, Long>> allUseRegMap) {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (Map.Entry<Long, Map<Long, String>> entry : assignCheckResMap.entrySet()) {
            Long dataId = entry.getKey();
            Set<Long> orgs = entry.getValue().keySet();
            for (Long orgId : orgs) {
                List<Long> subordinateOrgs;
                if (null == allUseRegMap.get(orgId + "" + dataId)) {
                    paramsList.add(new Object[]{orgId, dataId});
                }
                if (org.apache.commons.collections4.CollectionUtils.isEmpty(subordinateOrgs = subordinateOrgsMap.get(orgId))) continue;
                for (Long subOrgId : subordinateOrgs) {
                    if (null != allUseRegMap.get(orgId + "" + dataId)) continue;
                    paramsList.add(new Object[]{subOrgId, dataId});
                }
            }
        }
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityId);
        DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
        String baseDataTableName = dt.getAlias();
        String dataBaseUsingTableName = baseDataTableName + "UseReg";
        String bsaeDataUseRangeTableName = baseDataTableName + "_U";
        String deleteUseReg = " delete from " + dataBaseUsingTableName + " where fuseorgid = ? and fdataid = ? ";
        String deleteUseRange = " delete from " + bsaeDataUseRangeTableName + " where fuseorgid = ? and fdataid = ? ";
        try (TXHandle h = TX.beginRequired();){
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(paramsList)) {
                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseReg, paramsList);
                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRange, paramsList);
            }
        }
    }

    public static List<Long> getAssignUseOrgSet(DynamicObject dataInfo, Long orgId, Long createOrgId) {
        ArrayList<Long> useOrgSet = new ArrayList<Long>();
        useOrgSet.add(orgId);
        String strategy = dataInfo.getString("ctrlstrategy");
        if ("1".equals(strategy) || "2".equals(strategy)) {
            String entityId;
            DynamicObject ctrlView;
            if (createOrgId != null) {
                useOrgSet.add(createOrgId);
            }
            if (null == (ctrlView = BaseDataServiceHelper.getCtrlview((String)(entityId = dataInfo.getDataEntityType().getName())))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230%s\u5bf9\u5e94\u7684\u63a7\u5236\u89c6\u56fe", (String)"BaseDataAssignAdapter_0", (String)"bos-mservice-bd", (Object[])new Object[0]), entityId));
            }
            List<Long> subordinateOrgList = BaseDataCtrlAdapter.getDirectSubordinateOrgList((Long)ctrlView.getPkValue(), orgId);
            useOrgSet.addAll(subordinateOrgList);
        } else if (("3".equals(strategy) || "4".equals(strategy)) && createOrgId != null) {
            useOrgSet.add(createOrgId);
        }
        return useOrgSet;
    }

    public static List<Long> getAssignDesOrgList(Long srcOrgId, String ctrlType, Long orgViewId) {
        List<Long> result = new ArrayList<Long>(10);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        filters.add(new QFilter("view", "=", (Object)orgViewId));
        if ("1".equals(ctrlType)) {
            filters.add(new QFilter("parent", "=", (Object)srcOrgId));
            filters.add(new QFilter("isctrlunit", "=", (Object)Boolean.TRUE));
            result = BaseDataAssignAdapter.queryDesOrgList(filters.toArray(new QFilter[0]));
        } else if ("2".equals(ctrlType)) {
            filters.add(new QFilter("isctrlunit", "=", (Object)Boolean.TRUE));
            filters.add(new QFilter("org", "!=", (Object)srcOrgId));
            result = BaseDataAssignAdapter.queryDesOrgList(filters.toArray(new QFilter[0]));
        } else if ("3".equals(ctrlType)) {
            filters.add(new QFilter("parent", "=", (Object)srcOrgId));
            result = BaseDataAssignAdapter.queryDesOrgList(filters.toArray(new QFilter[0]));
        } else if ("4".equals(ctrlType)) {
            filters.add(new QFilter("org", "!=", (Object)srcOrgId));
            result = BaseDataAssignAdapter.queryDesOrgList(filters.toArray(new QFilter[0]));
        }
        result.remove(srcOrgId);
        return result;
    }

    private static List<Long> queryDesOrgList(QFilter[] filters) {
        ArrayList<Long> result = new ArrayList<Long>(10);
        String selectFields = "id,org.id";
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (coll == null || coll.size() == 0) {
            return result;
        }
        for (DynamicObject org : coll) {
            result.add(org.getLong("org.id"));
        }
        return result;
    }

    public static boolean isAlreadyAssign(String entity, Object pkId, Long useOrgId) {
        if (BaseDataCommonService.isNewModel((String)entity)) {
            return new BaseDataAssignService(entity).isAssignData(Long.valueOf(pkId.toString()), useOrgId);
        }
        IDataEntityType dataEntityType = ORM.create().getDataEntityType(entity);
        String baseDataTableName = dataEntityType.getAlias();
        String dbRouteKey = dataEntityType.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        String regTableName = baseDataTableName + "UseReg";
        String countUseRegSql = "select FDataID from " + regTableName + " where FDataID = ? and fuseorgid = ? and fcreateorgid <> ?";
        Object[] params = new Object[]{pkId, useOrgId, useOrgId};
        return (Boolean)DB.query((DBRoute)dbRoute, (String)countUseRegSql, (Object[])params, ResultSet::next);
    }

    public static boolean isHasAssignData(String entity, Object dataId) {
        if (BaseDataCommonService.isNewModel((String)entity)) {
            return new BaseDataAssignService(entity).isHasAssignData(Long.valueOf(dataId.toString()));
        }
        IDataEntityType dataEntityType = ORM.create().getDataEntityType(entity);
        String baseDataTableName = dataEntityType.getAlias();
        DBRoute dbRoute = DBRoute.of((String)dataEntityType.getDBRouteKey());
        String regTableName = baseDataTableName + "UseReg";
        try {
            String countUseRegSql = "select FDataID from " + regTableName + " where FDataID = ? and fisassign = '1' and fuseorgid <> fcreateorgid ";
            Object[] params = new Object[]{dataId};
            return (Boolean)DB.query((DBRoute)dbRoute, (String)countUseRegSql, (Object[])params, ResultSet::next);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Long> checkHasAssignData(String entityNumber, List<Long> dataIds) {
        if (StringUtils.isEmpty((CharSequence)entityNumber)) return new ArrayList<Long>(0);
        if (dataIds == null) return new ArrayList<Long>(0);
        if (dataIds.size() == 0) {
            return new ArrayList<Long>(0);
        }
        if (BaseDataCommonService.isNewModel((String)entityNumber)) {
            return new AssignQueryService(entityNumber).checkHasAssignData(new HashSet<Long>(dataIds));
        }
        IDataEntityType dt = ORM.create().getDataEntityType(entityNumber);
        String baseDataTableName = dt.getAlias();
        DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
        String useRegTableName = baseDataTableName + "UseReg";
        try {
            ArrayList<Long> params = new ArrayList<Long>(dataIds);
            SqlBuilder countUseRegSql = new SqlBuilder();
            countUseRegSql.append(" select FDataID from ", new Object[0]);
            countUseRegSql.append(useRegTableName, new Object[0]);
            countUseRegSql.append(" where fisassign = '1' and ", new Object[0]);
            countUseRegSql.appendIn("FDataID", params);
            try (TXHandle h = TX.required();){
                List list = (List)DB.query((DBRoute)dbRoute, (SqlBuilder)countUseRegSql, rs -> {
                    ArrayList<Long> dataList = new ArrayList<Long>(16);
                    while (rs.next()) {
                        dataList.add(rs.getLong("FDataID"));
                    }
                    return dataList;
                });
                return list;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return new ArrayList<Long>(0);
        }
    }

    @Deprecated
    public static void baseDataAssignHandler(DynamicObject dataInfo, Long orgId, Long createOrgId) {
        if (dataInfo == null) {
            return;
        }
        String entityId = dataInfo.getDataEntityType().getName();
        if (BaseDataCommonService.isNewModel((String)entityId)) {
            BaseDataCommonService service = new BaseDataCommonService();
            try {
                service.handleNewCtrlData(new DynamicObject[]{dataInfo});
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u6570\u636e\u65f6\uff0c\u751f\u6210\u4f4d\u56fe\u4fe1\u606f\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u53ef\u7528", (Throwable)e);
            }
            return;
        }
        String strategy = dataInfo.getString("ctrlstrategy");
        List<Long> useOrgSet = BaseDataAssignAdapter.getAssignUseOrgSet(dataInfo, orgId, createOrgId);
        String orgField = "org";
        if (useOrgSet.size() > 0) {
            Long adminOrgId = 0L;
            if (dataInfo.get(orgField) instanceof DynamicObject) {
                adminOrgId = (Long)((DynamicObject)dataInfo.get(orgField)).getPkValue();
            } else if (dataInfo.get(orgField) instanceof Long) {
                adminOrgId = dataInfo.getLong(orgField);
            }
            ArrayList<Long> dataIds = new ArrayList<Long>(1);
            dataIds.add((Long)dataInfo.getPkValue());
            BaseDataOrgRelationAdapter.saveBaseDataUseReg(entityId, dataIds, createOrgId, adminOrgId, useOrgSet, strategy, true);
        }
    }
}

