/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.service.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class BaseDataCtrlAdapter {
    private static Log logger = LogFactory.getLog(BaseDataCtrlAdapter.class);
    private static final String NEW_PERMID = "47156aff000000ac";
    private static final String QUERY_PERM = "47150e89000000ac";
    private static final String BASEDATAVIEW_BASEDATA = "basedataview.basedata";
    private static final String ENTRYENTITY_CREATEORG = "entryentity.createorg";
    private static final String BASEDATAID = "basedataid";
    private static final String ENABLE = "enable";
    private static final String PLUGIN = "plugin";
    private static final String ORG_ID = "org.id";

    public static List<Long> getCreateOrgList(String entity, String appId) {
        ArrayList<Long> createOrgList = new ArrayList<Long>(10);
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entity, (String)NEW_PERMID);
        if (result == null) {
            return createOrgList;
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        Long viewId = ctrlView == null ? Long.valueOf(16L) : (Long)ctrlView.getPkValue();
        List hasPermOrgList = result.hasAllOrgPerm() ? OrgUnitServiceHelper.getAllOrgByViewId((long)viewId, (boolean)false) : result.getHasPermOrgs();
        List<Long> bdCtrlOrgList = BaseDataCtrlAdapter.getBdCtrlOrgList(entity);
        if (bdCtrlOrgList.isEmpty()) {
            return BaseDataCtrlAdapter.getCuOrgList(viewId, hasPermOrgList);
        }
        Iterator iterator = hasPermOrgList.iterator();
        while (iterator.hasNext()) {
            long hasPermOrg = (Long)iterator.next();
            for (long bdCtrlOrg : bdCtrlOrgList) {
                if (hasPermOrg != bdCtrlOrg) continue;
                createOrgList.add(hasPermOrg);
            }
        }
        return BaseDataCtrlAdapter.getCuOrgList(viewId, createOrgList);
    }

    public static List<Long> getBdCtrlOrgList(String entity) {
        ArrayList<Long> bdCtrlOrgs = new ArrayList<Long>();
        ORM orm = ORM.create();
        QFilter[] qfArr = new QFilter[1];
        String selectPro = "id, entryentity.id, entryentity.createorg";
        qfArr[0] = new QFilter(BASEDATAVIEW_BASEDATA, "=", (Object)entity);
        Map ctrlstrtgyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_bdctrlstrtgy", (String)"id, entryentity.id, entryentity.createorg", (QFilter[])qfArr);
        if (ctrlstrtgyMap == null || ctrlstrtgyMap.size() == 0) {
            return bdCtrlOrgs;
        }
        for (DynamicObject ctrlstrtgy : ctrlstrtgyMap.values()) {
            DynamicObjectCollection col = ctrlstrtgy.getDynamicObjectCollection("entryentity");
            for (DynamicObject detail : col) {
                if (detail.getDynamicObject("createorg") == null) continue;
                long org = (Long)detail.getDynamicObject("createorg").getPkValue();
                bdCtrlOrgs.add(org);
            }
        }
        return bdCtrlOrgs;
    }

    public static String getOrgCtrlStrategy(String entity, String createOrg) {
        String key = entity + "_" + createOrg;
        String bdCtrlStrgy = String.valueOf(BaseDataCtrlCacheMrg.getLocalCtrlCache().get(key));
        if (!StringUtils.isEmpty((CharSequence)bdCtrlStrgy) && !"null".equals(bdCtrlStrgy)) {
            if ("DATA_LOADED".equals(bdCtrlStrgy)) {
                bdCtrlStrgy = "";
            }
            return bdCtrlStrgy;
        }
        String selectPro = "id, entryentity.ctrlstrategy";
        QFilter[] qf = new QFilter[]{new QFilter(BASEDATAVIEW_BASEDATA, "=", (Object)entity), new QFilter(ENTRYENTITY_CREATEORG, "=", (Object)(StringUtils.isBlank((CharSequence)createOrg) ? 0L : Long.parseLong(createOrg)))};
        DynamicObjectCollection strgyCol = QueryServiceHelper.query((String)"bd_bdctrlstrtgy", (String)selectPro, (QFilter[])qf);
        if (strgyCol != null && strgyCol.size() > 0) {
            bdCtrlStrgy = ((DynamicObject)strgyCol.get(0)).getString("entryentity.ctrlstrategy");
            BaseDataCtrlCacheMrg.getLocalCtrlCache().put(key, (Object)bdCtrlStrgy);
            return bdCtrlStrgy;
        }
        selectPro = "defaultctrlstrategy";
        qf = new QFilter[]{new QFilter(BASEDATAID, "=", (Object)entity)};
        DynamicObjectCollection defStrgyCol = QueryServiceHelper.query((String)"bd_bddefctrlstrtgy", (String)selectPro, (QFilter[])qf);
        if (defStrgyCol != null && defStrgyCol.size() > 0) {
            bdCtrlStrgy = ((DynamicObject)defStrgyCol.get(0)).getString("defaultctrlstrategy");
            BaseDataCtrlCacheMrg.getLocalCtrlCache().put(key, (Object)bdCtrlStrgy);
            return bdCtrlStrgy;
        }
        bdCtrlStrgy = "DATA_LOADED";
        BaseDataCtrlCacheMrg.getLocalCtrlCache().put(key, (Object)bdCtrlStrgy);
        bdCtrlStrgy = "";
        return bdCtrlStrgy;
    }

    public static Map<String, String> batchSelectOrgCtrlStrategy(String entity, List<Long> createOrgs) {
        DynamicObjectCollection defStrgyCol;
        HashMap<String, String> allBdCtrlStrgyMap = new HashMap<String, String>(16);
        String bdCtrlStrgy = null;
        String key = null;
        String selectPro = "id, entryentity.ctrlstrategy, entryentity.createorg";
        QFilter[] qf = new QFilter[]{new QFilter(BASEDATAVIEW_BASEDATA, "=", (Object)entity), new QFilter(ENTRYENTITY_CREATEORG, "in", createOrgs)};
        DynamicObjectCollection strgyCol = QueryServiceHelper.query((String)"bd_bdctrlstrtgy", (String)selectPro, (QFilter[])qf);
        if (strgyCol != null && strgyCol.size() > 0) {
            for (DynamicObject strgy : strgyCol) {
                Object object = strgy.get(ENTRYENTITY_CREATEORG);
                key = entity + "_" + object;
                bdCtrlStrgy = strgy.getString("entryentity.ctrlstrategy");
                BaseDataCtrlCacheMrg.getLocalCtrlCache().put(key, (Object)bdCtrlStrgy);
                allBdCtrlStrgyMap.put(String.valueOf(object), bdCtrlStrgy);
            }
        }
        if ((defStrgyCol = QueryServiceHelper.query((String)"bd_bddefctrlstrtgy", (String)(selectPro = "defaultctrlstrategy"), (QFilter[])(qf = new QFilter[]{new QFilter(BASEDATAID, "=", (Object)entity)}))) != null && defStrgyCol.size() > 0) {
            bdCtrlStrgy = ((DynamicObject)defStrgyCol.get(0)).getString("defaultctrlstrategy");
            if (allBdCtrlStrgyMap.isEmpty()) {
                for (Long l : createOrgs) {
                    key = entity + "_" + l;
                    BaseDataCtrlCacheMrg.getLocalCtrlCache().put(key, (Object)bdCtrlStrgy);
                    allBdCtrlStrgyMap.put(String.valueOf(l), bdCtrlStrgy);
                }
            }
        }
        return allBdCtrlStrgyMap;
    }

    public static String getCtrlStrategyViewSchema(String entity) {
        QFilter entityFilter = new QFilter("basedata.number", "=", (Object)entity);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bd_basedataview", (String)"ctrlview.id", (QFilter[])new QFilter[]{entityFilter});
        if (obj != null) {
            return obj.getString("ctrlview.id");
        }
        return null;
    }

    public static Boolean checkBaseDataCtrl(String entityId) {
        DynamicObject defaultCtrlStrategy = BaseDataCtrlAdapter.getDefaultCtrlStrategy(entityId);
        if (defaultCtrlStrategy == null) {
            return Boolean.FALSE;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityId);
        return dt.getProperty("ctrlstrategy") != null;
    }

    public static DynamicObject getDefaultCtrlStrategy(String entityId) {
        String selectFields = "id,defaultctrlstrategy";
        QFilter[] filters = new QFilter[]{new QFilter(BASEDATAID, "=", (Object)entityId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bddefctrlstrtgy", (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObject getCtrlStrategy(DynamicObject dataObj) {
        QFilter createorgFilter;
        QFilter basedataFilter;
        QFilter[] filters;
        String selectFields;
        DynamicObject bdctrlstrtgy = null;
        DynamicObject dataInfo = dataObj;
        String entityID = dataInfo.getDataEntityType().getName();
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityID);
        Object masterid = dataInfo.get(masteridPropName);
        if ((dataInfo = BaseDataCtrlAdapter.getDataInfo(dataInfo, masterid)) == null) {
            return null;
        }
        Long orgID = BaseDataCtrlAdapter.getBaseDataCreateOrgId(dataInfo);
        ORM orm = ORM.create();
        DynamicObjectCollection list = orm.query("bd_bdctrlstrtgy", selectFields = "id,basedataview.id, basedataview.ctrlview.id,cu.id, entryentity.id, entryentity.ctrltype, entryentity.ctrlstrategy, entryentity.managestrategy", filters = new QFilter[]{basedataFilter = new QFilter(BASEDATAVIEW_BASEDATA, "=", (Object)entityID), createorgFilter = new QFilter(ENTRYENTITY_CREATEORG, "=", (Object)orgID)});
        if (list != null && list.size() == 1) {
            bdctrlstrtgy = (DynamicObject)list.get(0);
        }
        return bdctrlstrtgy;
    }

    private static DynamicObject getDataInfo(DynamicObject dataInfo, Object masterId) {
        if (dataInfo.getPkValue() != null && masterId != null) {
            if (masterId instanceof Long && (Long)masterId != 0L) {
                if (!dataInfo.getPkValue().equals(masterId)) {
                    dataInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)masterId, (String)dataInfo.getDataEntityType().getName());
                }
            } else if (masterId instanceof DynamicObject && !dataInfo.getPkValue().equals(((DynamicObject)masterId).getPkValue())) {
                dataInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)masterId).getPkValue(), (String)dataInfo.getDataEntityType().getName());
            }
        }
        return dataInfo;
    }

    static Long getBaseDataCreateOrgId(DynamicObject baseData) {
        Object org = baseData.get("createorg");
        if (Objects.isNull(org)) {
            return 0L;
        }
        if (org instanceof DynamicObject) {
            DynamicObject createOrg = (DynamicObject)org;
            return null == createOrg.getPkValue() ? Long.valueOf(createOrg.getLong("id")) : (Long)createOrg.getPkValue();
        }
        if (org instanceof Long) {
            return (Long)baseData.get("createorg");
        }
        return 0L;
    }

    public static String getMasterIdPropName(String entityName) {
        String masterIdCfg = "masterid";
        String selectProperties = "masteridpropname";
        QFilter[] filters = new QFilter[]{new QFilter(BASEDATAID, "=", (Object)entityName)};
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bddefctrlstrtgy", (String)selectProperties, (QFilter[])filters);
        if (null == obj) {
            return masterIdCfg;
        }
        masterIdCfg = obj.getString("masteridpropname");
        if (StringUtils.isEmpty((CharSequence)masterIdCfg)) {
            masterIdCfg = "masterid";
        }
        return masterIdCfg;
    }

    public static String getMasterIdFieldName(String entityName) {
        String masterIdCfg = "fmasterid";
        String selectProperties = "masteridfieldname";
        QFilter[] filters = new QFilter[]{new QFilter(BASEDATAID, "=", (Object)entityName)};
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bddefctrlstrtgy", (String)selectProperties, (QFilter[])filters);
        if (null == obj) {
            return masterIdCfg;
        }
        masterIdCfg = obj.getString("masteridfieldname");
        if (StringUtils.isEmpty((CharSequence)masterIdCfg)) {
            masterIdCfg = "fmasterid";
        }
        return masterIdCfg;
    }

    public static void handleDisable(String entity, DynamicObject[] objs) {
        String masterIdProp = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        HashSet<Object> idSet = new HashSet<Object>(16);
        for (DynamicObject obj : objs) {
            idSet.add(obj.getPkValue());
        }
        QFilter masterIdFilter = new QFilter(masterIdProp, "in", idSet);
        QFilter[] filters = new QFilter[]{masterIdFilter.or(new QFilter("id", "in", idSet))};
        Object[] load = BusinessDataServiceHelper.load((String)entity, (String)"disabler,disabledate,enable", (QFilter[])filters);
        if (load == null || load.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : load) {
            dynamicObject.set(ENABLE, (Object)0);
        }
        SaveServiceHelper.save((IDataEntityType)load[0].getDynamicObjectType(), (Object[])load);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean handleEnable(String entity, DynamicObject[] objs) {
        String masterIdProp = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        HashSet<void> idSet = new HashSet<void>();
        for (DynamicObject obj : objs) {
            void var9_13;
            Object pkValue = obj.getPkValue();
            Object object = obj.get(masterIdProp);
            if (object instanceof DynamicObject) {
                Object object2 = ((DynamicObject)object).getPkValue();
            }
            if (StringUtils.equals((CharSequence)(pkValue + ""), (CharSequence)(var9_13 + ""))) continue;
            idSet.add(var9_13);
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", idSet)};
        Object[] load = BusinessDataServiceHelper.load((String)entity, (String)"enable,disabler,disabledate", (QFilter[])filters);
        if (load == null || load.length == 0) {
            return true;
        }
        for (DynamicObject dynamicObject : load) {
            if (dynamicObject.getBoolean(ENABLE)) continue;
            return false;
        }
        SaveServiceHelper.save((IDataEntityType)load[0].getDataEntityType(), (Object[])load);
        return true;
    }

    static List<Long> getCuOrgList(Long viewId, List<Long> orgIds) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("view.id", "=", (Object)viewId), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE), new QFilter(ENABLE, "=", (Object)Boolean.TRUE)};
        ArrayList<Long> cuOrgIds = new ArrayList<Long>(10);
        try (DataSet ds = ORM.create().queryDataSet(BaseDataCtrlAdapter.class.getName(), "bos_org_structure", ORG_ID, filters);){
            for (Row row : ds) {
                Long orgId = row.getLong(ORG_ID);
                if (orgId == null) continue;
                cuOrgIds.add(orgId);
            }
        }
        return cuOrgIds;
    }

    public static IBaseDataCtrlPlugin getBaseDataCtrlPlugin(String entityType) {
        IBaseDataCtrlPlugin baseDataCtrlPlugin = null;
        String baseDataCtrlPluginStr = BaseDataCtrlCache.getBaseDataCtrlPlugin((String)entityType);
        if (!StringUtils.isEmpty((CharSequence)baseDataCtrlPluginStr)) {
            if ("DATA_LOADED".equals(baseDataCtrlPluginStr)) {
                return null;
            }
            try {
                baseDataCtrlPlugin = (IBaseDataCtrlPlugin)Class.forName(baseDataCtrlPluginStr).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error((Throwable)e);
            }
            return baseDataCtrlPlugin;
        }
        QFilter[] filters = new QFilter[]{new QFilter(BASEDATAID, "=", (Object)entityType)};
        DynamicObjectCollection defStrgyCol = QueryServiceHelper.query((String)"bd_bddefctrlstrtgy", (String)PLUGIN, (QFilter[])filters);
        if (defStrgyCol != null && defStrgyCol.size() > 0 && !StringUtils.isEmpty((CharSequence)((DynamicObject)defStrgyCol.get(0)).getString(PLUGIN))) {
            baseDataCtrlPluginStr = ((DynamicObject)defStrgyCol.get(0)).getString(PLUGIN);
            BaseDataCtrlCache.updateBaseDataCtrlPlugin((String)entityType, (String)baseDataCtrlPluginStr);
            try {
                baseDataCtrlPlugin = (IBaseDataCtrlPlugin)Class.forName(baseDataCtrlPluginStr).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error((Throwable)e);
            }
            return baseDataCtrlPlugin;
        }
        baseDataCtrlPluginStr = "DATA_LOADED";
        BaseDataCtrlCache.updateBaseDataCtrlPlugin((String)entityType, (String)baseDataCtrlPluginStr);
        return null;
    }

    static Map<Long, List<Long>> getDirectSubordinateOrgList(Long orgViewId, List<Long> orgIDs) {
        QFilter[] filters = new QFilter[]{new QFilter("view.id", "=", (Object)orgViewId), new QFilter("isctrlunit", "=", (Object)Boolean.FALSE), new QFilter("parent.id", "in", orgIDs), new QFilter("org.enable", "=", (Object)Boolean.TRUE), new QFilter("isfreeze", "=", (Object)Boolean.FALSE)};
        HashMap<Long, List<Long>> subordinateOrgsMap = new HashMap<Long, List<Long>>(orgIDs.size());
        try (DataSet ds = ORM.create().queryDataSet(BaseDataCtrlAdapter.class.getName(), "bos_org_structure", "org.id,parent.id,longnumber", filters);){
            for (Row row : ds) {
                Long orgId = row.getLong(ORG_ID);
                if (orgId == null) continue;
                Long parentOrgId = row.getLong("parent.id");
                subordinateOrgsMap.computeIfAbsent(parentOrgId, k -> new ArrayList(16)).add(orgId);
            }
        }
        return subordinateOrgsMap;
    }

    public static List<Long> getDirectSubordinateOrgList(Long orgViewId, Long parentOrgId) {
        ArrayList<Long> directSubOrgIds = new ArrayList<Long>(16);
        QFilter[] filters = new QFilter[]{new QFilter("view.id", "=", (Object)orgViewId), new QFilter("parent.id", "=", (Object)parentOrgId), new QFilter("org.enable", "=", (Object)Boolean.TRUE), new QFilter("isctrlunit", "=", (Object)Boolean.FALSE), new QFilter("isfreeze", "=", (Object)Boolean.FALSE)};
        try (DataSet ds = ORM.create().queryDataSet(BaseDataCtrlAdapter.class.getName(), "bos_org_structure", "org.id,longnumber", filters);){
            for (Row row : ds) {
                if (row.getLong(ORG_ID) == null) continue;
                directSubOrgIds.add(row.getLong(ORG_ID));
            }
        }
        return directSubOrgIds;
    }

    public static DynamicObjectCollection getAllUseOrg(String entityType) {
        QFilter extendOrgFilter;
        DynamicObject ctrlView;
        String orgFuncPro;
        long userId = Long.parseLong(RequestContext.get().getUserId());
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityType);
        String appId = met.getAppId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityType, (String)QUERY_PERM);
        if (result == null) {
            return new DynamicObjectCollection();
        }
        String useOrgFunc = BaseDataServiceHelper.getUseOrgFunc((String)entityType);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        if (!StringUtils.isEmpty((CharSequence)useOrgFunc) && StringUtils.isNotEmpty((CharSequence)(orgFuncPro = OrgServiceHelper.getOrgBizPro((String)useOrgFunc)))) {
            QFilter orgFuncFilter = new QFilter(orgFuncPro, "=", (Object)Boolean.TRUE);
            filterList.add(orgFuncFilter);
        }
        String view = null == (ctrlView = BaseDataServiceHelper.getCtrlview((String)entityType)) ? "16" : ctrlView.getString("id");
        QFilter[] filters = result.hasAllOrgPerm() ? new QFilter[]{new QFilter("view.id", "=", (Object)Long.valueOf(view))} : new QFilter[]{new QFilter("view.id", "=", (Object)Long.valueOf(view)), new QFilter("org", "in", (Object)result.getHasPermOrgs())};
        DynamicObject[] viewOrgArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"org", (QFilter[])filters);
        if (null == viewOrgArr) {
            return new DynamicObjectCollection();
        }
        ArrayList<Long> viewOrgIds = new ArrayList<Long>(viewOrgArr.length);
        for (DynamicObject viewOrg : viewOrgArr) {
            if (viewOrg.getDynamicObject("org") == null) continue;
            viewOrgIds.add((Long)viewOrg.getDynamicObject("org").getPkValue());
        }
        filterList.add(new QFilter("id", "in", viewOrgIds));
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataCtrlAdapter.getBaseDataCtrlPlugin(entityType);
        if (baseDataCtrlPlugin != null && (extendOrgFilter = baseDataCtrlPlugin.getExtendOrgQFilter()) != null) {
            filterList.add(extendOrgFilter);
        }
        return QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])filterList.toArray(new QFilter[0]), (String)"id");
    }
}

