/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.service.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.bd.utils.FieldPropUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.collections4.CollectionUtils;

@SdkInternal
public class BaseDataDeleteAdapter {
    private static Log logger = LogFactory.getLog(BaseDataDeleteAdapter.class);

    public static void baseDataDeleteHandler(DynamicObject[] dataInfos) {
        Object h;
        if (null == dataInfos || 0 == dataInfos.length) {
            return;
        }
        String entity = dataInfos[0].getDataEntityType().getName();
        if (BaseDataCommonService.isNewModel((String)entity)) {
            Map<Long, List<DynamicObject>> orgDataMap = Arrays.stream(dataInfos).collect(Collectors.groupingBy(e -> (Long)e.getDynamicObject("createorg").getPkValue()));
            BaseDataCommonService service = new BaseDataCommonService();
            for (Map.Entry<Long, List<DynamicObject>> entry : orgDataMap.entrySet()) {
                service.deleteData(entry.getValue().toArray(new DynamicObject[0]), entity, entry.getKey());
            }
            return;
        }
        IDataEntityType dt = dataInfos[0].getDataEntityType();
        DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
        String tableName = dt.getAlias();
        String useRegTableName = tableName + "UseReg";
        String excTableName = tableName + "Exc";
        String useRangeTableName = tableName + "_U";
        try {
            StringBuilder deleteUseRegSql = new StringBuilder();
            deleteUseRegSql.append("delete from ").append(useRegTableName).append(" where FDataID = ? ");
            DynamicObject[] deleteUseRangeSql = new StringBuilder();
            deleteUseRangeSql.append("delete from ").append(useRangeTableName).append(" where FDataID = ? ");
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(dataInfos.length);
            for (DynamicObject object : dataInfos) {
                paramsList.add(new Object[]{object.getPkValue()});
            }
            h = TX.required();
            Throwable throwable = null;
            try {
                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRegSql.toString(), paramsList);
                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRangeSql.toString(), paramsList);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        catch (Exception e2) {
            logger.error((Throwable)e2);
        }
        if (BaseDataServiceHelper.isNoneCustomEntity((String)entity).booleanValue()) {
            return;
        }
        try {
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(dataInfos.length);
            for (DynamicObject object : dataInfos) {
                paramsList.add(new Object[]{object.getPkValue()});
            }
            StringBuilder deleteExcSql = new StringBuilder();
            deleteExcSql.append("delete from ").append(excTableName).append(" where FDataID = ? ");
            TXHandle h2 = TX.required();
            h = null;
            try {
                DB.executeBatch((DBRoute)dbRoute, (String)deleteExcSql.toString(), paramsList);
            }
            catch (Throwable object) {
                h = object;
                throw object;
            }
            finally {
                if (h2 != null) {
                    if (h != null) {
                        try {
                            h2.close();
                        }
                        catch (Throwable object) {
                            ((Throwable)h).addSuppressed(object);
                        }
                    } else {
                        h2.close();
                    }
                }
            }
        }
        catch (Exception e3) {
            logger.error((Throwable)e3);
        }
        try {
            DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
            if (null == ctrlView) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230%s\u5bf9\u5e94\u7684\u63a7\u5236\u89c6\u56fe\u3002", (String)"BaseDataDeleteAdapter_0", (String)"bos-mservice-bd", (Object[])new Object[0]), entity));
            }
            boolean enableVersion = BaseDataBusinessServiceUtils.isEnableVersion((String)entity);
            Map<Object, Object> historyDataCountMap = Collections.emptyMap();
            if (enableVersion) {
                historyDataCountMap = BaseDataDeleteAdapter.getHistoryDataCountMap(dataInfos, tableName, dbRoute, entity);
            }
            String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entity);
            Set orgIds = Arrays.stream(dataInfos).filter(v -> !Objects.equals(v.getPkValue(), BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)v, (String)masterIdPropName))).mapToLong(v -> BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)v, (String)"createorg")).boxed().collect(Collectors.toSet());
            Map allSubordinateOrgMap = OrgUnitServiceHelper.getAllSubordinateOrgMap((long)((Long)ctrlView.getPkValue()), new ArrayList(orgIds), (boolean)true);
            ArrayList<Object[]> recoverParamsList = new ArrayList<Object[]>(10);
            ArrayList<Object[]> deleteParamsList = new ArrayList<Object[]>(10);
            ArrayList<Object[]> recoverParamCushareList = new ArrayList<Object[]>(10);
            List<Long[]> allExcData = BaseDataDeleteAdapter.getAllExcData(dataInfos, excTableName, dbRoute, entity);
            for (DynamicObject dataInfo : dataInfos) {
                boolean recoverUseRel;
                Long masterId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)dataInfo, (String)masterIdPropName);
                if (dataInfo.getPkValue().equals(masterId)) continue;
                Long createOrgPk = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)dataInfo, (String)"createorg");
                String key = masterId + "_" + createOrgPk;
                if (historyDataCountMap.get(key) != null && (Long)historyDataCountMap.get(key) > 0L) continue;
                DynamicObject masterObj = BusinessDataServiceHelper.loadSingle((Object)masterId, (String)entity);
                String strategy = masterObj.getString("ctrlstrategy");
                if (CollectionUtils.isNotEmpty(allExcData) && ("1".equals(strategy) || "6".equals(strategy))) {
                    String viewNum = ctrlView.getString("number");
                    List superiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)viewNum, (long)createOrgPk);
                    boolean founded = false;
                    for (int i = superiorOrgs.size() - 1; i >= 0; --i) {
                        Long superiorOrg = (Long)superiorOrgs.get(i);
                        for (Long[] excData : allExcData) {
                            Long createOrgId = excData[1];
                            if (!createOrgId.equals(superiorOrg)) continue;
                            founded = true;
                            Long dataId = excData[0];
                            Long useOrgId = excData[2];
                            Object[] params = new Object[]{useOrgId, dataId};
                            deleteParamsList.add(params);
                            if ("6".equals(strategy)) {
                                recoverParamCushareList.add(params);
                                List subordinateOrgList = (List)allSubordinateOrgMap.get(createOrgPk);
                                if (!CollectionUtils.isNotEmpty((Collection)subordinateOrgList)) break;
                                for (Long orgId : subordinateOrgList) {
                                    if (BaseDataDeleteAdapter.ifOrgIdAndPkIdInParamList(orgId, dataId, recoverParamCushareList)) continue;
                                    recoverParamCushareList.add(new Object[]{orgId, dataId});
                                }
                                break;
                            }
                            if (BaseDataDeleteAdapter.ifOrgIdAndPkIdInParamList(useOrgId, dataId, recoverParamsList)) break;
                            recoverParamsList.add(params);
                            break;
                        }
                        if (founded) break;
                    }
                }
                boolean bl = recoverUseRel = !enableVersion && ("7".equals(strategy) || "5".equals(strategy));
                if (!"2".equals(strategy) && !recoverUseRel) continue;
                if (!BaseDataDeleteAdapter.ifOrgIdAndPkIdInParamList(createOrgPk, masterId, recoverParamsList)) {
                    recoverParamsList.add(new Object[]{createOrgPk, masterId});
                }
                deleteParamsList.add(new Object[]{createOrgPk, masterId});
            }
            try (TXHandle h3 = TX.required();){
                if (CollectionUtils.isNotEmpty(recoverParamsList)) {
                    String recoverUseRangeSql = " insert into " + useRangeTableName + "(fdataid, fuseorgid)  select fdataid, fuseorgid from  " + useRegTableName + " where fuseorgid = ? and fdataid = ?  ";
                    DB.executeBatch((DBRoute)dbRoute, (String)recoverUseRangeSql, recoverParamsList);
                }
                if (CollectionUtils.isNotEmpty(recoverParamCushareList)) {
                    String recoverUseRangeCuShareSql = " insert into " + useRangeTableName + "(fuseorgid,fdataid ) values (?,?); ";
                    DB.executeBatch((DBRoute)dbRoute, (String)recoverUseRangeCuShareSql, recoverParamCushareList);
                }
                if (CollectionUtils.isNotEmpty(deleteParamsList)) {
                    DB.executeBatch((DBRoute)dbRoute, (String)("delete from " + excTableName + " where FUseOrgID = ? and FDataID = ? "), deleteParamsList);
                }
            }
            HashSet clearOrgSet = new HashSet(orgIds);
            allSubordinateOrgMap.values().forEach(e -> {
                if (null != e) {
                    clearOrgSet.addAll(e);
                }
            });
            BaseDataCtrlCache.clearBaseDataFilter((String)entity, clearOrgSet);
        }
        catch (Exception e4) {
            logger.error((Throwable)e4);
        }
    }

    private static boolean ifOrgIdAndPkIdInParamList(Long orgId, Long dataPk, List<Object[]> recoverParamsList) {
        boolean ifExsis = false;
        for (Object[] tempParam : recoverParamsList) {
            Object tempOrgId = tempParam[0];
            Object tempDataPk = tempParam[1];
            if (!tempOrgId.equals(orgId) || !tempDataPk.equals(dataPk)) continue;
            ifExsis = true;
            break;
        }
        return ifExsis;
    }

    private static List<Long[]> getAllExcData(DynamicObject[] dataInfos, String baseDataExcTableName, DBRoute dbRoute, String entity) {
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        if (null == dataInfos || ((DynamicObject[])dataInfos).length <= 0) {
            return new ArrayList<Long[]>(1);
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        ArrayList<Long> masterIds = new ArrayList<Long>(((DynamicObject[])dataInfos).length);
        ArrayList<Long> createOrgList = new ArrayList<Long>(((DynamicObject[])dataInfos).length);
        for (DynamicObject dataInfo : dataInfos) {
            Long dataPk = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)dataInfo, (String)masterIdPropName);
            if (dataInfo.getPkValue().equals(dataPk)) continue;
            DynamicObject createOrg = dataInfo.getDynamicObject("createorg");
            createOrgList.add((Long)createOrg.getPkValue());
            masterIds.add(dataPk);
        }
        Map<Object, Object> id2CtrlStrategyMap = Collections.emptyMap();
        Map allSuperiorOrgListMap = Collections.emptyMap();
        Map<String, Long> masterIdCreateOrg2DataId = Collections.emptyMap();
        HashMap<String, List<Long>> masterIdCreateOrg2Id = new HashMap<String, List<Long>>(16);
        boolean enableVersion = BaseDataBusinessServiceUtils.isEnableVersion((String)entity);
        if (CollectionUtils.isNotEmpty(masterIds)) {
            String selectField = FieldPropUtils.getSelectField((String[])new String[]{"id", masterIdPropName, "ctrlstrategy"});
            QFilter[] masterIdFilter = new QFilter[]{new QFilter(masterIdPropName, "in", masterIds)};
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entity, (String)selectField, (QFilter[])masterIdFilter);
            id2CtrlStrategyMap = dynamicObjects.stream().collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getString("ctrlstrategy")));
            allSuperiorOrgListMap = OrgUnitServiceHelper.getAllSuperiorOrgs((String)ctrlView.getString("number"), createOrgList);
            List allSuperiorOrgs = allSuperiorOrgListMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            QFilter[] filters = new QFilter[]{new QFilter("createorg", "in", allSuperiorOrgs), new QFilter(masterIdPropName, "in", masterIds)};
            String selectFields = FieldPropUtils.getSelectField((String[])new String[]{"id", masterIdPropName, "createorg"});
            DynamicObjectCollection superiorDataCol = QueryServiceHelper.query((String)entity, (String)selectFields, (QFilter[])filters);
            if (enableVersion) {
                superiorDataCol.forEach(e -> {
                    String key = e.getLong(masterIdPropName) + "_" + e.getLong("createorg");
                    masterIdCreateOrg2Id.computeIfAbsent(key, k -> new ArrayList(10)).add(e.getLong("id"));
                });
            } else {
                masterIdCreateOrg2DataId = superiorDataCol.stream().collect(Collectors.toMap(data -> data.getLong(masterIdPropName) + "_" + data.getLong("createorg"), data -> data.getLong("id")));
            }
        }
        HashSet<Long> dataIds = new HashSet<Long>(((DynamicObject[])dataInfos).length);
        HashSet<Long> createOrgIds = new HashSet<Long>(((DynamicObject[])dataInfos).length);
        for (DynamicObject dataInfo : dataInfos) {
            Long masterId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)dataInfo, (String)masterIdPropName);
            if (dataInfo.getPkValue().equals(masterId)) continue;
            DynamicObject createOrg = dataInfo.getDynamicObject("createorg");
            String strategy = (String)id2CtrlStrategyMap.get(masterId);
            if (!"1".equals(strategy) && !"6".equals(strategy)) continue;
            List superiorOrgList = (List)allSuperiorOrgListMap.get((Long)createOrg.getPkValue());
            if (enableVersion) {
                dataIds.addAll(BaseDataDeleteAdapter.getSuperDataIds(masterIdCreateOrg2Id, masterId, superiorOrgList));
            } else {
                Long superDataId = BaseDataDeleteAdapter.getSuperDataId(masterIdCreateOrg2DataId, masterId, superiorOrgList);
                if (superDataId != null) {
                    dataIds.add(superDataId);
                }
            }
            createOrgIds.add((Long)createOrg.getPkValue());
        }
        if (CollectionUtils.isEmpty(dataIds) || CollectionUtils.isEmpty(createOrgIds)) {
            return new ArrayList<Long[]>(1);
        }
        SqlBuilder getSupExcSql = new SqlBuilder();
        getSupExcSql.append("select fdataid,fcreateorgid,fuseorgid from ", new Object[0]);
        getSupExcSql.append(baseDataExcTableName, new Object[0]).append(" where ", new Object[0]);
        getSupExcSql.appendIn("fuseorgid", createOrgIds.toArray());
        getSupExcSql.append(" and ", new Object[0]).appendIn("fdataid", dataIds.toArray());
        return (List)DB.query((DBRoute)dbRoute, (SqlBuilder)getSupExcSql, rs -> {
            ArrayList<Long[]> list = new ArrayList<Long[]>(16);
            while (rs.next()) {
                long dataId = rs.getLong(1);
                long createOrgId = rs.getLong(2);
                long useOrgId = rs.getLong(3);
                list.add(new Long[]{dataId, createOrgId, useOrgId});
            }
            return list;
        });
    }

    private static Long getSuperDataId(Map<String, Long> masterIdCreateOrg2DataId, Long masterId, List<Long> superiorOrgList) {
        Long superDataId = null;
        for (int i = superiorOrgList.size() - 1; i >= 0; --i) {
            superDataId = masterIdCreateOrg2DataId.get(masterId + "_" + superiorOrgList.get(i));
            if (null == superDataId) continue;
            return superDataId;
        }
        return superDataId;
    }

    private static List<Long> getSuperDataIds(Map<String, List<Long>> masterIdCreateOrg2Id, Long masterId, List<Long> superiorOrgList) {
        for (int i = superiorOrgList.size() - 1; i >= 0; --i) {
            List<Long> superDataIds = masterIdCreateOrg2Id.get(masterId + "_" + superiorOrgList.get(i));
            if (!CollectionUtils.isNotEmpty(superDataIds)) continue;
            return superDataIds;
        }
        return new ArrayList<Long>(0);
    }

    private static Map<String, Long> getHistoryDataCountMap(DynamicObject[] dataInfos, String baseDataTableName, DBRoute dbRoute, String entity) {
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        ArrayList<Long> masterIdList = new ArrayList<Long>(dataInfos.length);
        ArrayList<Long> createOrgIdList = new ArrayList<Long>(dataInfos.length);
        for (DynamicObject dataInfo : dataInfos) {
            Long masterId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)dataInfo, (String)masterIdPropName);
            if (dataInfo.getPkValue().equals(masterId)) continue;
            masterIdList.add(masterId);
            createOrgIdList.add(BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)dataInfo, (String)"createorg"));
        }
        if (masterIdList.size() == 0) {
            return new HashMap<String, Long>(0);
        }
        SqlBuilder builder = new SqlBuilder();
        builder.append(" select fid, fmasterid, fcreateorgid from ", new Object[0]);
        builder.append(baseDataTableName, new Object[0]);
        builder.append(" where ", new Object[0]);
        builder.appendIn("fmasterid", masterIdList);
        builder.append(" and ", new Object[0]);
        builder.appendIn("fcreateorgid", createOrgIdList);
        return (Map)DB.query((DBRoute)dbRoute, (SqlBuilder)builder, rs -> {
            HashMap<String, Long> historyDataCountMap = new HashMap<String, Long>(dataInfos.length);
            while (rs.next()) {
                historyDataCountMap.merge(rs.getLong("fmasterid") + "_" + rs.getLong("fcreateorgid"), 1L, Long::sum);
            }
            return historyDataCountMap;
        });
    }
}

