/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.service.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.basedata.service.internal.BaseDataCtrlAdapter;
import kd.bos.basedata.service.internal.BaseDataOrgRelationAdapter;
import kd.bos.bd.ext.IBaseDataSubExtService;
import kd.bos.bd.ext.pojo.ExtActionInfo;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.collections4.CollectionUtils;

@SdkInternal
public class BaseDataDrmAdapter {
    private static Log logger = LogFactory.getLog(BaseDataDrmAdapter.class);

    public static void managePermChange(String entity, List<Long> dataIds, Long orgId) {
        if (CollectionUtils.isEmpty(dataIds)) {
            return;
        }
        BaseDataDrmAdapter.permChangeExt(entity, dataIds, orgId);
        if (dataIds.isEmpty()) {
            return;
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataCtrlAdapter.getBaseDataCtrlPlugin(entity);
        Map bizCheckResultMap = new HashMap(8);
        if (baseDataCtrlPlugin != null) {
            bizCheckResultMap = baseDataCtrlPlugin.orgPermChangeCheck(new ArrayList<Long>(dataIds), org);
        }
        dataIds.removeAll(bizCheckResultMap.keySet());
        if (dataIds.isEmpty()) {
            return;
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])dataIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entity));
        if (null == load || load.length == 0) {
            return;
        }
        if (BaseDataCommonService.isNewModel((String)entity)) {
            HashMap<String, Map> strategyDataMap = new HashMap<String, Map>(5);
            for (DynamicObject data : load) {
                String string = data.getString("ctrlstrategy");
                Map orgDataMap = strategyDataMap.computeIfAbsent(string, k -> new HashMap(16));
                Long createOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)data, (String)"createorg");
                orgDataMap.computeIfAbsent(createOrgId, k -> new ArrayList(10)).add((Long)data.getPkValue());
            }
            BaseDataCommonService service = new BaseDataCommonService();
            for (Map orgDataMap : strategyDataMap.values()) {
                for (Map.Entry entry : orgDataMap.entrySet()) {
                    service.changeOrgPermOnNewModel(entity, org, (List)entry.getValue(), (Long)entry.getKey());
                }
            }
            if (baseDataCtrlPlugin != null) {
                baseDataCtrlPlugin.afterPermChangeCheck(dataIds);
            }
            return;
        }
        BaseDataServiceHelper.clearCache((DynamicObject[])load);
        BaseDataDrmAdapter.deleteBaseDataUseRange(entity, dataIds);
        ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(load.length);
        for (DynamicObject data : load) {
            data.set("createorg", (Object)org);
            data.set("org", (Object)org);
            saveData.add(data);
        }
        if (saveData.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveData.toArray(new DynamicObject[0]));
            BaseDataDrmAdapter.handleUseData(saveData);
        }
        if (baseDataCtrlPlugin != null) {
            baseDataCtrlPlugin.afterPermChangeCheck(dataIds);
        }
    }

    private static void permChangeExt(String entity, List<Long> dataIds, Long orgId) {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)entity, (String)"id, createorg", (QFilter[])new QFilter[]{new QFilter("id", "in", dataIds)});
        HashMap<Long, Set> org2DataMap = new HashMap<Long, Set>(16);
        for (DynamicObject e : coll) {
            org2DataMap.computeIfAbsent(e.getLong("createorg"), k -> new HashSet(16)).add(e.getLong("id"));
        }
        IBaseDataSubExtService ext = BaseDataBusinessServiceUtils.getBaseDataSubExtService((String)entity);
        for (Map.Entry entry : org2DataMap.entrySet()) {
            ExtActionInfo extActionInfo = ext.beforePermChange(entity, (Long)entry.getKey(), orgId, (Set)entry.getValue());
            if (!extActionInfo.isExecute()) {
                dataIds.removeAll((Collection)entry.getValue());
                continue;
            }
            Map data = extActionInfo.getData();
            if (data.isEmpty()) continue;
            dataIds.removeAll(data.keySet());
        }
    }

    private static void deleteBaseDataUseRange(String entity, List<Long> dataIds) {
        try {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entity);
            DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
            String useRangeTableName = dt.getAlias() + "_U";
            String deleteUseRangeSql = "delete from " + useRangeTableName + " where fdataid = ?";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(dataIds.size());
            for (Long dataId : dataIds) {
                paramsList.add(new Object[]{dataId});
            }
            DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRangeSql, paramsList);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private static void handleUseData(List<DynamicObject> saveData) {
        DynamicObject dataInfo = saveData.get(0);
        String baseDataTableName = dataInfo.getDataEntityType().getAlias();
        String bsaeDataUseRegTableName = baseDataTableName + "UseReg";
        String dbRouteKey = dataInfo.getDataEntityType().getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        StringBuilder sb = new StringBuilder();
        sb.append("delete from ").append(bsaeDataUseRegTableName).append(" where fdataid in (");
        Object[] param = new Object[saveData.size()];
        for (int i = 0; i < saveData.size(); ++i) {
            sb.append(" ?");
            param[i] = saveData.get(i).getPkValue();
            if (i == saveData.size() - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.execute((DBRoute)dbRoute, (String)sb.toString(), (Object[])param);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        for (DynamicObject obj : saveData) {
            BaseDataServiceHelper.baseDataOrgChangeHandler((DynamicObject)obj);
        }
    }

    public static void baseDataOrgChangeHandler(DynamicObject dataInfo) {
        if (dataInfo == null) {
            return;
        }
        String entityId = dataInfo.getDataEntityType().getName();
        if (BaseDataCommonService.isNewModel((String)entityId)) {
            throw new KDBizException("the model has been upgraded, please call new method <BaseDataCommonService.changeOrgPermOnNewModel()>.");
        }
        ArrayList<Long> useOrgSet = new ArrayList<Long>(10);
        HashSet<Long> clearOrgSet = new HashSet<Long>(16);
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        Long createOrgId = BaseDataCtrlAdapter.getBaseDataCreateOrgId(dataInfo);
        String key = entityId + createOrgId;
        BaseDataCtrlCacheMrg.clearCache((String)type, (String)key);
        BaseDataCtrlCache.clearBaseDataUseRange((String)entityId, (Long)createOrgId);
        clearOrgSet.add(createOrgId);
        useOrgSet.add(createOrgId);
        String ctrlStrategy = dataInfo.getString("ctrlstrategy");
        BillEntityType billEntityType = (BillEntityType)dataInfo.getDataEntityType();
        String billStatusKey = billEntityType.getBillStatus();
        String status = "";
        if (StringUtils.isNotBlank((CharSequence)billStatusKey) && !billEntityType.getProperty(billStatusKey).isDbIgnore()) {
            status = dataInfo.getString(billStatusKey);
        }
        if ((StringUtils.isBlank((CharSequence)billStatusKey) || BillStatus.C.name().equals(status)) && !"7".equals(ctrlStrategy)) {
            DynamicObject ctrlView;
            if ("1".equals(ctrlStrategy) || "2".equals(ctrlStrategy) || "3".equals(ctrlStrategy) || "4".equals(ctrlStrategy)) {
                ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
                if (null == ctrlView) {
                    return;
                }
            } else if ("6".equals(ctrlStrategy)) {
                try {
                    ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
                    if (null == ctrlView) {
                        return;
                    }
                    ArrayList<Long> useorgList = new ArrayList<Long>(10);
                    useorgList.add(createOrgId);
                    List orgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)((Long)ctrlView.getPkValue()), useorgList, (boolean)true);
                    if (CollectionUtils.isNotEmpty((Collection)orgList)) {
                        List<Long> cuOrgIds = BaseDataCtrlAdapter.getCuOrgList((Long)ctrlView.getPkValue(), orgList);
                        useOrgSet.addAll(cuOrgIds);
                        clearOrgSet.addAll(cuOrgIds);
                    }
                }
                catch (Exception e) {
                    logger.error("BaseDataServiceHelper.baseDataOrgChangeHandler", (Throwable)e);
                }
            }
        }
        if (useOrgSet.size() > 0) {
            ArrayList<Long> dataIds = new ArrayList<Long>(1);
            dataIds.add((Long)dataInfo.getPkValue());
            BaseDataOrgRelationAdapter.saveBaseDataUseReg(entityId, dataIds, createOrgId, createOrgId, useOrgSet, ctrlStrategy, false);
            BaseDataOrgRelationAdapter.saveBaseDataUseRange(entityId, dataIds, useOrgSet);
            BaseDataCtrlCache.clearBaseDataFilter((String)entityId, clearOrgSet);
        }
    }
}

