/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.service.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.basedata.service.AbstractBaseDataService;
import kd.bos.basedata.service.internal.BaseDataCtrlAdapter;
import kd.bos.bd.service.BaseDataAuditService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class BaseDataOrgRelationAdapter {
    private static Log logger = LogFactory.getLog(BaseDataOrgRelationAdapter.class);
    private static BaseDataOrgRelationService service = new BaseDataOrgRelationService();

    static void saveBaseDataUseReg(DynamicObject[] dataArr, Long createOrgId, Long adminOrgId, List<Long> useOrgList, String strategy) {
        BaseDataOrgRelationAdapter.service.insertBaseDataUseReg(dataArr, createOrgId, adminOrgId, useOrgList, strategy);
    }

    static void saveBaseDataUseRange(DynamicObject[] dataArr, List<Long> useOrgList) {
        service.saveBaseDataUseRange(dataArr, useOrgList);
    }

    static void saveBaseDataUseReg(String entityId, List<Long> dataIds, Long createOrgId, Long adminOrgId, List<Long> useOrgIds, String strategy, boolean isAssign) {
        BaseDataOrgRelationAdapter.service.insertBaseDataUseReg(entityId, dataIds, createOrgId, adminOrgId, useOrgIds, strategy, isAssign);
    }

    static void saveUseRegOnAddOp(String entityId, Map<Long, Map<Long, String>> orgDataStrategyMap) {
        Map<Long, String> dataStrategy;
        ArrayList dataIds = new ArrayList(10);
        orgDataStrategyMap.values().forEach(m -> dataIds.addAll(m.keySet()));
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityId);
        String tableName = dt.getAlias() + "UseReg";
        DBRoute route = DBRoute.of((String)dt.getDBRouteKey());
        SqlBuilder builder = new SqlBuilder();
        builder.append(" select fdataid,fuseorgid,fcreateorgid,fadminorgid,fassignorgid,FCtrlStrategy from ", new Object[0]).append(tableName, new Object[0]).append("  where ", new Object[0]).appendIn("fuseorgid", orgDataStrategyMap.keySet().toArray()).append("  and ", new Object[0]).appendIn("fdataid", dataIds.toArray());
        HashSet<String> existInfos = new HashSet<String>(16);
        ArrayList<Object[]> fixUseRegParamList = new ArrayList<Object[]>(10);
        try (DataSet ds = DB.queryDataSet((String)BaseDataOrgRelationAdapter.class.getName(), (DBRoute)route, (SqlBuilder)builder);){
            for (Row row : ds) {
                Long dataId;
                String strategy;
                Long useOrgId = row.getLong("fuseorgid");
                dataStrategy = orgDataStrategyMap.get(useOrgId);
                if (CollectionUtils.isEmpty(dataStrategy) || null == (strategy = dataStrategy.get(dataId = row.getLong("fdataid")))) continue;
                existInfos.add(useOrgId + "?" + dataId);
                Long createOrgId = row.getLong("fcreateorgid");
                boolean needFix = !Objects.equals(useOrgId, createOrgId) || !Objects.equals(useOrgId, row.getLong("fadminorgid")) || !Objects.equals(0L, row.getLong("fassignorgid")) || !Objects.equals(strategy, row.getString("FCtrlStrategy"));
                if (!needFix) continue;
                fixUseRegParamList.add(new Object[]{useOrgId, useOrgId, 0L, "0", strategy, useOrgId, dataId});
            }
        }
        try (TXHandle h = TX.required();){
            if (!fixUseRegParamList.isEmpty()) {
                StringBuilder fixSql = new StringBuilder();
                fixSql.append("update ").append(tableName).append(" set ").append(" fcreateorgid = ?,fadminorgid = ?,fassignorgid = ?,fisassign = ?,FCtrlStrategy = ?").append(" where fuseorgid = ? and fdataid = ? ");
                DB.executeBatch((DBRoute)route, (String)fixSql.toString(), fixUseRegParamList);
            }
            String insertSql = " insert into " + tableName + "(FUseOrgID, FDataID, FCreateOrgID, FAdminOrgID, FCtrlStrategy,FIsAssign, FAssignOrgID) values(?, ?, ?, ?, ?, ?, ?) ";
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
            for (Map.Entry<Long, Map<Long, String>> e : orgDataStrategyMap.entrySet()) {
                dataStrategy = e.getValue();
                if (null == dataStrategy) continue;
                Long useOrgId = e.getKey();
                for (Map.Entry<Long, String> entry : dataStrategy.entrySet()) {
                    Long dataId = entry.getKey();
                    if (existInfos.contains(useOrgId + "?" + dataId)) continue;
                    paramsList.add(new Object[]{useOrgId, dataId, useOrgId, useOrgId, entry.getValue(), "0", 0L});
                    if (paramsList.size() != 10000) continue;
                    DB.executeBatch((DBRoute)route, (String)insertSql, paramsList);
                    paramsList = new ArrayList(10);
                }
            }
            if (!paramsList.isEmpty()) {
                DB.executeBatch((DBRoute)route, (String)insertSql, paramsList);
            }
        }
    }

    @Deprecated
    static void saveBaseDataUseRange(String entityId, List<Long> dataIds, List<Long> useOrgIds) {
        service.saveBaseDataUseRange(entityId, dataIds, useOrgIds);
    }

    static void getUseReg(String entityId, Set<Long> dataIds, Set<Long> orgIds, Map<Long, List<Long>> allUseReg, Map<String, Map<String, Long>> allUseRegMap) {
        BaseDataOrgRelationAdapter.service.selectUseReg(entityId, dataIds, orgIds, allUseReg, allUseRegMap);
    }

    static void saveBaseDataUseReg(String entityId, List<Long> dataIds, Long createOrgId, Long adminOrgId, List<Long> useOrgIds, String strategy, boolean isAssign, Long assignOrgId) {
        BaseDataOrgRelationAdapter.service.insertBaseDataUseReg(entityId, dataIds, createOrgId, adminOrgId, useOrgIds, strategy, isAssign, assignOrgId);
    }

    static void saveBaseDataUseRange(String entityId, List<Object[]> saveParams) {
        service.saveBaseDataUseRange(entityId, saveParams);
    }

    public static void clearCache(DynamicObject[] dataArr) {
        if (dataArr == null || dataArr.length == 0) {
            return;
        }
        if (BaseDataCommonService.isNewModel((String)dataArr[0].getDataEntityType().getName())) {
            try {
                new BaseDataAuditService().baseDataUnAuditHandler(dataArr);
                return;
            }
            catch (Exception e) {
                logger.error("\u53cd\u5ba1\u6838\u6570\u636e\u751f\u6210\u4f4d\u56fe\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                throw new KDBizException("fail to generate bitmap data on unaudit operation...");
            }
        }
        HashMap<String, List> dataMap = new HashMap<String, List>(8);
        for (DynamicObject data : dataArr) {
            Long createOrgId = BaseDataCtrlAdapter.getBaseDataCreateOrgId(data);
            String ctrlStrategy = data.getString("ctrlstrategy");
            dataMap.computeIfAbsent(ctrlStrategy + "_" + createOrgId, k -> new ArrayList(10)).add(data);
        }
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        IDataEntityType dt = dataArr[0].getDataEntityType();
        String entityId = dt.getName();
        String baseDataTableName = dt.getAlias();
        String useRegTableName = baseDataTableName + "UseReg";
        DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
        for (Map.Entry entry : dataMap.entrySet()) {
            DynamicObject dataInfo = (DynamicObject)((List)entry.getValue()).get(0);
            Long createOrgId = BaseDataCtrlAdapter.getBaseDataCreateOrgId(dataInfo);
            if (createOrgId == 0L) continue;
            String ctrlStrategy = ((String)entry.getKey()).split("_")[0];
            if ("5".equals(ctrlStrategy)) {
                BaseDataCtrlCacheMrg.clearCacheWithPrefix((String)type, (String)entityId);
                BaseDataCtrlCache.clearWithPrefixBaseDataUseRange((String)entityId);
                continue;
            }
            if ("1".equals(ctrlStrategy) || "2".equals(ctrlStrategy)) {
                List dataInfos = (List)entry.getValue();
                ArrayList<Object> params = new ArrayList<Object>(dataInfos.size());
                for (DynamicObject data : dataInfos) {
                    params.add(data.getPkValue());
                }
                SqlBuilder sql = new SqlBuilder();
                sql.append("select fuseorgid from ", new Object[0]).append(useRegTableName, new Object[0]).append(" where ", new Object[0]).appendIn("fdataid", params);
                Set result = (Set)DB.query((DBRoute)dbRoute, (SqlBuilder)sql, rs -> {
                    HashSet<Long> set = new HashSet<Long>(16);
                    while (rs.next()) {
                        set.add(rs.getLong("fuseorgid"));
                    }
                    return set;
                });
                BaseDataCtrlCache.clearBaseDataUseRange((String)entityId, (Set)result);
                BaseDataCtrlCache.clearBaseDataFilter((String)entityId, (Set)result);
                continue;
            }
            if ("6".equals(ctrlStrategy)) {
                DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
                if (null == ctrlView) {
                    return;
                }
                ArrayList<Long> useorgList = new ArrayList<Long>(Collections.singletonList(createOrgId));
                List orgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)((Long)ctrlView.getPkValue()), useorgList, (boolean)true);
                HashSet clearOrgSet = new HashSet(orgList);
                BaseDataCtrlCache.clearBaseDataUseRange((String)entityId, clearOrgSet);
                BaseDataCtrlCache.clearBaseDataFilter((String)entityId, clearOrgSet);
                continue;
            }
            if (!"7".equals(ctrlStrategy)) continue;
            String key = entityId + createOrgId;
            BaseDataCtrlCacheMrg.clearCache((String)type, (String)key);
            BaseDataCtrlCache.clearBaseDataUseRange((String)entityId, (Long)createOrgId);
        }
    }

    public static void clearCache(DynamicObject dataInfo) {
        String ctrlStrategy;
        try {
            dataInfo = BusinessDataServiceHelper.loadSingle((Object)dataInfo.getPkValue(), (String)dataInfo.getDynamicObjectType().getName());
            ctrlStrategy = dataInfo.getString("ctrlstrategy");
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            return;
        }
        if (ctrlStrategy == null) {
            return;
        }
        String entityId = dataInfo.getDataEntityType().getName();
        if (BaseDataCommonService.isNewModel((String)entityId)) {
            BaseDataOrgRelationAdapter.clearCache(new DynamicObject[]{dataInfo});
            return;
        }
        String baseDataTableName = dataInfo.getDataEntityType().getAlias();
        String useRegTableName = baseDataTableName + "UseReg";
        String dbRouteKey = ORM.create().getDataEntityType(entityId).getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        Long createOrgId = BaseDataCtrlAdapter.getBaseDataCreateOrgId(dataInfo);
        if (createOrgId == 0L) {
            return;
        }
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        BaseDataOrgRelationAdapter.clearCacheWithStrategyType(dataInfo, ctrlStrategy, useRegTableName, entityId, dbRoute, createOrgId, type);
    }

    private static void clearCacheWithStrategyType(DynamicObject dataInfo, String ctrlStrategy, String useRegTableName, String entity, DBRoute dbRoute, Long createOrgId, String type) {
        if ("5".equals(ctrlStrategy)) {
            BaseDataCtrlCacheMrg.clearCacheWithPrefix((String)type, (String)entity);
            BaseDataCtrlCache.clearWithPrefixBaseDataUseRange((String)entity);
        } else if ("1".equals(ctrlStrategy) || "2".equals(ctrlStrategy)) {
            String sql = "select fuseorgid from " + useRegTableName + " where fdataid = ?";
            Object[] param = new Object[]{dataInfo.getPkValue()};
            Set result = (Set)DB.query((DBRoute)dbRoute, (String)sql, (Object[])param, rs -> {
                HashSet<Long> set = new HashSet<Long>(16);
                while (rs.next()) {
                    set.add(rs.getLong("fuseorgid"));
                }
                return set;
            });
            BaseDataCtrlCache.clearBaseDataUseRange((String)entity, (Set)result);
            BaseDataCtrlCache.clearBaseDataFilter((String)entity, (Set)result);
        } else if ("6".equals(ctrlStrategy)) {
            DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
            if (null != ctrlView) {
                ArrayList<Long> useorgList = new ArrayList<Long>(Collections.singletonList(createOrgId));
                List orgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)((Long)ctrlView.getPkValue()), useorgList, (boolean)true);
                HashSet clearOrgSet = new HashSet(orgList);
                BaseDataCtrlCache.clearBaseDataFilter((String)entity, clearOrgSet);
                BaseDataCtrlCache.clearBaseDataUseRange((String)entity, clearOrgSet);
            }
        } else if ("7".equals(ctrlStrategy)) {
            String key = entity + createOrgId;
            BaseDataCtrlCacheMrg.clearCache((String)type, (String)key);
            BaseDataCtrlCache.clearBaseDataUseRange((String)entity, (Long)createOrgId);
        }
    }

    public static void orgAddNewHandler(Long orgId) {
        DynamicObject orgInfo = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
        String selectFields = "id,fnumber number,fname name,ffieldname,propertyname";
        QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE), new QFilter("visiable", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection orgBizCol = QueryServiceHelper.query((String)"bos_org_biz", (String)selectFields, (QFilter[])filters);
        if (orgBizCol == null || orgBizCol.size() == 0) {
            logger.info("\u5f02\u5e38\uff0c\u7ec4\u7ec7\u804c\u80fd\u5217\u8868\u4e3a\u7a7a\u3002");
            return;
        }
        for (DynamicObject orgBiz : orgBizCol) {
            String orgType = orgBiz.getString("number");
            String propertyName = orgBiz.getString("propertyname");
            if (propertyName != null && !StringUtils.isEmpty((CharSequence)propertyName.trim()) && !orgInfo.getBoolean(propertyName)) continue;
            selectFields = "id,basedata.id entityID,ctrlview.treetype";
            QFilter orgTypeFilter = new QFilter("ctrlview.treetype", "=", (Object)orgType);
            filters = new QFilter[]{orgTypeFilter};
            DynamicObjectCollection baseDataTypeCol = QueryServiceHelper.query((String)"bd_basedataview", (String)selectFields, (QFilter[])filters);
            if (baseDataTypeCol == null || baseDataTypeCol.size() == 0) continue;
            Long ctrlOrgId = OrgServiceHelper.getCtrlUnitByOrgId((Long)Long.valueOf(orgType), (Long)orgId);
            for (DynamicObject baseDataType : baseDataTypeCol) {
                DBRoute dbRoute;
                MainEntityType entityType;
                String entity = baseDataType.getString("entityID");
                if (BaseDataCommonService.isNewModel((String)entity)) continue;
                try {
                    entityType = EntityMetadataCache.getDataEntityType((String)entity);
                    String dbRouteKey = entityType.getDBRouteKey();
                    dbRoute = DBRoute.of((String)dbRouteKey);
                }
                catch (Exception ex) {
                    logger.error("\u83b7\u53d6\u5bf9\u8c61\u62a5\u9519", (Throwable)ex);
                    continue;
                }
                String baseDataTableName = entityType.getAlias();
                String dataBaseUsingTableName = baseDataTableName + "UseReg";
                StringBuilder insertSql = new StringBuilder();
                insertSql.append(" insert into ").append(dataBaseUsingTableName);
                insertSql.append(" (FUseOrgID,FDataID,FCreateOrgID,FAdminOrgID,FCtrlStrategy)");
                insertSql.append(" select ? FUseOrgID,FDataID,FCreateOrgID,FAdminOrgID,FCtrlStrategy ");
                insertSql.append(" from ").append(dataBaseUsingTableName).append(" p ");
                insertSql.append(" where FUseOrgID = ? ");
                insertSql.append(" and (FCtrlStrategy = '").append("1").append('\'');
                insertSql.append("  or FCtrlStrategy = '").append("2").append("')");
                insertSql.append(" and not exists(SELECT FDataID from ").append(dataBaseUsingTableName).append(" c ");
                insertSql.append("   where c.FUseOrgID = ? and c.FDataID = p.FDataID) ");
                Object[] params = new Object[]{orgId, ctrlOrgId, orgId};
                try {
                    TXHandle h = TX.beginRequired();
                    Throwable throwable = null;
                    try {
                        DB.execute((DBRoute)dbRoute, (String)insertSql.toString(), (Object[])params);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (h == null) continue;
                        if (throwable != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        h.close();
                    }
                }
                catch (Exception ex) {
                    logger.info("\u65b0\u589e\u6570\u636e\u5e94\u7528\u5173\u7cfb\u62a5\u9519", (Object)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void orgAddNewHandler(Long orgViewId, List<Long> orgIds) {
        block23: {
            if (orgViewId == null || orgIds == null) {
                return;
            }
            String selectFields = "id,basedata.id entityID,ctrlview.treetype";
            QFilter orgViewFilter = new QFilter("ctrlview.id", "=", (Object)orgViewId);
            QFilter[] filters = new QFilter[]{orgViewFilter};
            DynamicObjectCollection baseDataCol = QueryServiceHelper.query((String)"bd_basedataview", (String)selectFields, (QFilter[])filters);
            if (baseDataCol == null || baseDataCol.size() == 0) {
                return;
            }
            String lockKey = "bos/orgAddnewHandler/add";
            DLock lock = DLock.create((String)lockKey);
            try {
                if (lock.tryLock()) break block23;
                for (DynamicObject baseData : baseDataCol) {
                    DBRoute dbRoute;
                    MainEntityType entityType;
                    String entity = baseData.getString("entityID");
                    if (BaseDataCommonService.isNewModel((String)entity)) continue;
                    try {
                        entityType = EntityMetadataCache.getDataEntityType((String)entity);
                        String dbRouteKey = entityType.getDBRouteKey();
                        dbRoute = DBRoute.of((String)dbRouteKey);
                    }
                    catch (Exception ex) {
                        logger.info("\u83b7\u53d6\u5bf9\u8c61\u62a5\u9519", (Object)ex);
                        continue;
                    }
                    String tableName = entityType.getAlias();
                    String regTableName = tableName + "UseReg";
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
                    StringBuilder insertSql = new StringBuilder();
                    insertSql.append(" insert into ").append(regTableName);
                    insertSql.append(" (FUseOrgID,FDataID,FCreateOrgID,FAdminOrgID,FCtrlStrategy)");
                    insertSql.append(" select ? FUseOrgID,FDataID,FCreateOrgID,FAdminOrgID,FCtrlStrategy ");
                    insertSql.append(" from ").append(regTableName).append(" p ");
                    insertSql.append(" where FUseOrgID = ? ");
                    insertSql.append(" and (FCtrlStrategy = '").append("1").append('\'');
                    insertSql.append("  or FCtrlStrategy = '").append("2").append("')");
                    insertSql.append(" and not exists(SELECT FDataID from ").append(regTableName).append(" c ");
                    insertSql.append("   where c.FUseOrgID = ? and c.FDataID = p.FDataID) ");
                    for (Long orgId : orgIds) {
                        Long ctrlOrgId = OrgServiceHelper.getCtrlUnitByOrgId((Long)orgViewId, (Long)orgId);
                        Object[] params = new Object[]{orgId, ctrlOrgId, orgId};
                        paramsList.add(params);
                    }
                    try {
                        TXHandle h = TX.beginRequired();
                        Throwable throwable = null;
                        try {
                            DB.executeBatch((DBRoute)dbRoute, (String)insertSql.toString(), paramsList);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (h == null) continue;
                            if (throwable != null) {
                                try {
                                    h.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            h.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.info("\u65b0\u589e\u6570\u636e\u5e94\u7528\u5173\u7cfb\u62a5\u9519", (Object)ex);
                    }
                }
            }
            catch (Exception e) {
                logger.info("orgAddnewHandler Exception:", (Object)e);
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static class BaseDataOrgRelationService
    extends AbstractBaseDataService {
        private BaseDataOrgRelationService() {
        }

        private void insertBaseDataUseReg(DynamicObject[] dataArr, Long createOrgId, Long adminOrgId, List<Long> useOrgList, String strategy) {
            super.saveBaseDataUseReg(dataArr, createOrgId, adminOrgId, useOrgList, strategy);
        }

        private void insertBaseDataUseReg(String entityId, List<Long> dataIds, Long createOrgId, Long adminOrgId, List<Long> useOrgIds, String strategy, boolean isAssign) {
            Long assignOrgId = 0L;
            this.insertBaseDataUseReg(entityId, dataIds, createOrgId, adminOrgId, useOrgIds, strategy, isAssign, assignOrgId);
        }

        private void selectUseReg(String entityId, Set<Long> dataIds, Set<Long> orgIds, Map<Long, List<Long>> allUseReg, Map<String, Map<String, Long>> allUseRegMap) {
            super.getUseReg(entityId, dataIds, orgIds, allUseReg, allUseRegMap);
        }

        private void insertBaseDataUseReg(String entityId, List<Long> dataIds, Long createOrgId, Long adminOrgId, List<Long> useOrgIds, String strategy, boolean isAssign, Long assignOrgId) {
            super.saveBaseDataUseReg(entityId, dataIds, createOrgId, adminOrgId, useOrgIds, strategy, isAssign, assignOrgId);
        }
    }
}

