/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.service.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.basedata.service.internal.BaseDataCtrlAdapter;
import kd.bos.bd.ext.IBaseDataUseRangeExtService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.BaseDataMaintenanceService;
import kd.bos.bd.service.BaseDataRepairService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.bd.utils.BaseDataThreadPoolUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.collections4.CollectionUtils;

@SdkInternal
public class BaseDataOrgUseRangAdapter {
    private static Log logger = LogFactory.getLog(BaseDataOrgUseRangAdapter.class);

    public static void afterSetCtrlUintHandle(String orgViewId, List<String> orgIdList) {
        if (orgViewId == null || CollectionUtils.isEmpty(orgIdList)) {
            logger.debug("BaseDataOrgUseRangAdapter.afterSetCtrlUnitHandle:orgViewId or orgIdList is null");
            return;
        }
        String selectFields = "id,basedataid.id entityID,ctrlview.treetype";
        QFilter orgViewFilter = new QFilter("ctrlview.id", "=", (Object)Long.valueOf(orgViewId));
        QFilter[] filters = new QFilter[]{orgViewFilter};
        DynamicObjectCollection baseDataCol = QueryServiceHelper.query((String)"bd_bddefctrlstrtgy", (String)selectFields, (QFilter[])filters);
        if (baseDataCol == null || baseDataCol.isEmpty()) {
            return;
        }
        List orgIds = orgIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        List subordinateOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf(orgViewId), orgIds, (boolean)true);
        for (DynamicObject baseData : baseDataCol) {
            String entityID = baseData.getString("entityID");
            try {
                DBRoute dbRoute;
                MainEntityType entityType;
                if (BaseDataCommonService.isNewModel((String)entityID)) {
                    new BaseDataRepairService().repairCushare(entityID, orgIds);
                    continue;
                }
                try {
                    entityType = EntityMetadataCache.getDataEntityType((String)entityID);
                    String dbRouteKey = entityType.getDBRouteKey();
                    dbRoute = DBRoute.of((String)dbRouteKey);
                }
                catch (Exception ex) {
                    logger.error("\u83b7\u53d6\u5bf9\u8c61\u62a5\u9519", (Throwable)ex);
                    continue;
                }
                BaseDataRepairService baseDataRepairService = new BaseDataRepairService();
                baseDataRepairService.repairCushare(entityID, orgIds);
                try {
                    String baseDataTableName = entityType.getAlias();
                    if (StringUtils.isEmpty((CharSequence)baseDataTableName)) {
                        logger.info("\u57fa\u7840\u8d44\u6599" + entityType + ",\u8868\u540d\u4e3a\u7a7a");
                        continue;
                    }
                    String dataBaseUseReg = baseDataTableName + "UseReg";
                    String baseDataUseRange = baseDataTableName + "_U";
                    SqlBuilder queryAssignDataSql = new SqlBuilder();
                    queryAssignDataSql.append("select fdataid,fuseorgid,fcreateorgid,fctrlstrategy,fisassign from ", new Object[0]);
                    queryAssignDataSql.append(dataBaseUseReg, new Object[0]).append(" where fisassign = '0' and ", new Object[0]);
                    queryAssignDataSql.appendIn("fuseorgid", new ArrayList(subordinateOrgList));
                    List dataIds = (List)DB.query((DBRoute)dbRoute, (SqlBuilder)queryAssignDataSql, rs -> {
                        ArrayList<Object[]> dataIds1 = new ArrayList<Object[]>(16);
                        while (rs.next()) {
                            boolean unShareData;
                            Long dataId = rs.getLong(1);
                            Long useOrgId = rs.getLong(2);
                            Long createOrgId = rs.getLong(3);
                            String ctrlStrategy = rs.getString(4);
                            String fisassign = rs.getString(5);
                            boolean bl = unShareData = "1".equals(ctrlStrategy) || "2".equals(ctrlStrategy) || "7".equals(ctrlStrategy);
                            if (createOrgId.equals(useOrgId) || !unShareData || !"0".equals(fisassign)) continue;
                            dataIds1.add(new Object[]{dataId, useOrgId});
                        }
                        return dataIds1;
                    });
                    StringBuilder deleteUseRangeSql = new StringBuilder();
                    deleteUseRangeSql.append("delete ").append(baseDataUseRange).append(" where fdataid = ? ");
                    deleteUseRangeSql.append(" and fuseorgid =? ");
                    StringBuilder deleteUseRegSql = new StringBuilder();
                    deleteUseRegSql.append("delete ").append(dataBaseUseReg).append(" where fdataid = ? ");
                    deleteUseRegSql.append(" and fuseorgid = ? ");
                    try (TXHandle h = TX.requiresNew();){
                        if (!CollectionUtils.isEmpty((Collection)dataIds)) {
                            ArrayList<Object[]> params = new ArrayList<Object[]>(1000);
                            for (Object[] tempDataIds : dataIds) {
                                params.add(tempDataIds);
                                if (params.size() != 1000) continue;
                                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRangeSql.toString(), params);
                                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRegSql.toString(), params);
                                params.clear();
                            }
                            if (!CollectionUtils.isEmpty(params)) {
                                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRangeSql.toString(), params);
                                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRegSql.toString(), params);
                                params.clear();
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u5220\u9664\u5206\u914d\u6570\u636e\u62a5\u9519", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error("\u5904\u7406\u5f02\u5e38entityID:" + entityID, (Throwable)e);
                }
                BaseDataCtrlCache.clearBaseDataFilter((String)entityID, new HashSet(subordinateOrgList));
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u5f02\u5e38entityID:" + entityID, (Throwable)e);
            }
        }
    }

    public static QFilter getBaseDataFilter(String entity, Long orgId) {
        QFilter useRangeFilter;
        if (null == orgId || orgId == 0L) {
            return null;
        }
        if (!BaseDataCtrlAdapter.checkBaseDataCtrl(entity).booleanValue()) {
            return null;
        }
        if (BaseDataCommonService.isNewModel((String)entity)) {
            return new BaseDataCommonService().getBaseDataFilter(entity, orgId);
        }
        if (null == (orgId = new BaseDataCommonService().getSupCtrlUnitIfIsUnCtrlUint(entity, orgId)) || orgId == 0L) {
            return null;
        }
        IBaseDataUseRangeExtService service = BaseDataBusinessServiceUtils.getBaseDataUseRangeExtService((String)entity);
        if (null != service) {
            return service.getBaseDataFilter(entity, orgId);
        }
        QFilter globalShareFilter = new QFilter("ctrlstrategy", "=", (Object)"5");
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entity);
        String billStatusKey = dt.getBillStatus();
        if (StringUtils.isNotBlank((CharSequence)billStatusKey) && !dt.getProperty(billStatusKey).isDbIgnore()) {
            QFilter statusFilter = new QFilter(billStatusKey, "=", (Object)BillStatus.C.name());
            globalShareFilter.and(statusFilter);
        }
        String baseDataTableName = dt.getAlias();
        String bsaeDataUseRangeTableName = baseDataTableName + "_U";
        Boolean hasUseRangeData = BaseDataCtrlCache.isHasBaseDataUseRange((String)entity, (Long)orgId);
        if (null == hasUseRangeData) {
            hasUseRangeData = BaseDataOrgUseRangAdapter.checkHasUseRangeData((DynamicObjectType)dt, bsaeDataUseRangeTableName, orgId, entity);
        }
        boolean isHasGlobalShareData = false;
        Boolean hasGlobalShareData = BaseDataCtrlCache.hasGlobalShareData((String)entity);
        isHasGlobalShareData = null != hasGlobalShareData ? hasGlobalShareData : BaseDataOrgUseRangAdapter.checkHasGlobalShareData((DynamicObjectType)dt, baseDataTableName, entity);
        QFilter baseDataFilter = useRangeFilter = QFilter.sqlExpress((String)"id", (String)"in", (String)(" ( select fdataid from " + bsaeDataUseRangeTableName + " where fuseorgid = " + orgId + " )"));
        if (isHasGlobalShareData && hasUseRangeData.booleanValue()) {
            baseDataFilter = globalShareFilter.or(useRangeFilter);
        } else if (isHasGlobalShareData) {
            baseDataFilter = globalShareFilter;
        } else if (hasUseRangeData.booleanValue()) {
            String useRangeAliasName = "ur" + DB.genLongId((String)"ur");
            StringBuilder join = new StringBuilder();
            join.append("inner join ").append(bsaeDataUseRangeTableName).append(" ");
            join.append(useRangeAliasName).append(" on ").append(useRangeAliasName).append(".fdataid = ");
            join.append(entity).append(".fid and ").append(useRangeAliasName).append(".fuseorgid=");
            join.append(orgId);
            baseDataFilter = QFilter.joinSQL((String)entity, (String)join.toString(), (Object[])new Object[0]);
        }
        return baseDataFilter;
    }

    public static QFilter getBaseDataFilter(String entity, List<Long> orgIds, boolean isRemoveDup) {
        Boolean hasGlobalShareData;
        Collection useRangeDataCol;
        if (CollectionUtils.isEmpty(orgIds)) {
            return null;
        }
        if (Boolean.FALSE.equals(BaseDataCtrlAdapter.checkBaseDataCtrl(entity))) {
            return null;
        }
        if (BaseDataCommonService.isNewModel((String)entity)) {
            return new BaseDataCommonService().getBaseDataFilter(entity, orgIds, isRemoveDup);
        }
        if (CollectionUtils.isEmpty((Collection)(orgIds = new BaseDataCommonService().getSupCtrlUnitIfIsUnCtrlUint(entity, orgIds)))) {
            return null;
        }
        QFilter globalShareFilter = new QFilter("ctrlstrategy", "=", (Object)"5");
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entity);
        String billStatusKey = dt.getBillStatus();
        if (StringUtils.isNotBlank((CharSequence)billStatusKey) && !dt.getProperty(billStatusKey).isDbIgnore()) {
            QFilter statusFilter = new QFilter(billStatusKey, "=", (Object)BillStatus.C.name());
            globalShareFilter.and(statusFilter);
        }
        String baseDataTableName = dt.getAlias();
        String baseDataUseRangeTableName = baseDataTableName + "_U";
        boolean hasUseRangeData = false;
        Map orgBbUseRangeMap = BaseDataCtrlCache.isHasBaseDataUseRangeBatch((String)entity, (List)orgIds);
        if (!orgBbUseRangeMap.isEmpty() && (useRangeDataCol = orgBbUseRangeMap.values()).contains(Boolean.TRUE)) {
            hasUseRangeData = true;
        }
        if (!hasUseRangeData) {
            hasUseRangeData = BaseDataOrgUseRangAdapter.checkHasUseRangeDataBatch((DynamicObjectType)dt, baseDataUseRangeTableName, orgIds, entity);
        }
        boolean isHasGlobalShareData = null != (hasGlobalShareData = BaseDataCtrlCache.hasGlobalShareData((String)entity)) ? hasGlobalShareData : BaseDataOrgUseRangAdapter.checkHasGlobalShareData((DynamicObjectType)dt, baseDataTableName, entity);
        StringJoiner orgIdJoiner = new StringJoiner(",");
        orgIds.stream().map(String::valueOf).forEach(orgIdJoiner::add);
        StringBuilder useRangeBuilder = new StringBuilder();
        useRangeBuilder.append(" ( select fdataid from ").append(baseDataUseRangeTableName).append(" where fuseorgid in (").append(orgIdJoiner).append(") )");
        QFilter useRangeFilter = QFilter.sqlExpress((String)"id", (String)"in", (String)useRangeBuilder.toString());
        if (hasUseRangeData && isRemoveDup) {
            useRangeFilter = BaseDataOrgUseRangAdapter.removeDuplicateData(entity, baseDataTableName, useRangeBuilder, useRangeFilter);
        }
        QFilter baseDataFilter = isHasGlobalShareData && hasUseRangeData ? globalShareFilter.or(useRangeFilter) : (isHasGlobalShareData ? globalShareFilter : (hasUseRangeData ? useRangeFilter : useRangeFilter));
        return baseDataFilter;
    }

    public static QFilter getBaseDataFilter(Long userId, String appId, String entityId, QFilter orgFilter, boolean isRemoveDup) {
        if (null == userId || StringUtils.isEmpty((CharSequence)appId) || StringUtils.isEmpty((CharSequence)entityId)) {
            return null;
        }
        if (Boolean.FALSE.equals(BaseDataCtrlAdapter.checkBaseDataCtrl(entityId))) {
            return null;
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
        if (null == ctrlView) {
            return null;
        }
        try (EntityTraceSpan span = EntityTracer.create((String)"BaseDataOrgUseRangAdapter", (String)"getBaseDataFilter_with_org_filter");){
            List<Long> orgIds;
            if (span.isRealtime()) {
                span.addLocaleTag("userId", (Object)userId);
                span.addTag("appId", appId);
                span.addTag("entityId", entityId);
                span.addLocaleTag("isRemoveDup", (Object)isRemoveDup);
                span.addLocaleTag("orgFilter", (Object)orgFilter);
            }
            if (CollectionUtils.isEmpty(orgIds = BaseDataOrgUseRangAdapter.getDependOrgIds(orgFilter, ctrlView.getLong("id")))) {
                QFilter qFilter = new QFilter("1", "!=", (Object)1);
                return qFilter;
            }
            QFilter dataPermissionFilter = ((PermissionService)ServiceFactory.getService(PermissionService.class)).getDataRuleWithoutDim(userId.longValue(), appId, entityId, "47150e89000000ac", orgIds);
            if (null == orgFilter && !isRemoveDup) {
                QFilter qFilter = dataPermissionFilter;
                return qFilter;
            }
            if (null == orgFilter) {
                String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityId);
                QFilter filter = QFilter.of((String)String.join((CharSequence)" ", "id", "=", masterIdPropName), (Object[])new Object[0]);
                if (null == dataPermissionFilter) {
                    QFilter qFilter = filter;
                    return qFilter;
                }
                QFilter qFilter = filter.and(dataPermissionFilter);
                return qFilter;
            }
            QFilter baseDataFilter = BaseDataOrgUseRangAdapter.getBaseDataFilter(entityId, orgIds, isRemoveDup);
            if (null != baseDataFilter && null != dataPermissionFilter) {
                baseDataFilter.and(dataPermissionFilter);
            } else if (null == baseDataFilter && null != dataPermissionFilter) {
                baseDataFilter = dataPermissionFilter;
            }
            QFilter qFilter = baseDataFilter;
            return qFilter;
        }
    }

    private static List<Long> getDependOrgIds(QFilter orgFilter, long viewId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        QFilter viewFilter = QFilter.of((String)"bos_org_structure.view = ?", (Object[])new Object[]{viewId});
        if (null == orgFilter) {
            QFilter structureFilter = viewFilter.and(new QFilter("bos_org_structure.isctrlunit", "=", (Object)Boolean.TRUE));
            QFilter joinFilter = QFilter.join((String)"id", (String)"bos_org_structure.org", (QFilter)structureFilter);
            filters.add(joinFilter);
        } else {
            QFilter joinFilter = QFilter.join((String)"id", (String)"bos_org_structure.org", (QFilter)viewFilter);
            filters.add(joinFilter);
            filters.add(orgFilter);
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        try (DataSet ds = ORM.create().queryDataSet(BaseDataOrgUseRangAdapter.class.getName(), "bos_org", "id", filters.toArray(new QFilter[0]));){
            for (Row row : ds) {
                Long orgId = row.getLong("id");
                if (orgId == null) continue;
                orgIds.add(orgId);
            }
        }
        return orgIds;
    }

    public static QFilter getLookUpListFilter(String entityId, Long orgId, QFilter customFilter) {
        if (orgId == null || orgId.equals(0L) || !BaseDataCtrlAdapter.checkBaseDataCtrl(entityId).booleanValue()) {
            return customFilter;
        }
        if (null == customFilter) {
            return BaseDataOrgUseRangAdapter.getBaseDataFilter(entityId, orgId);
        }
        if (!BaseDataCommonService.isNewModel((String)entityId)) {
            QFilter filter = BaseDataOrgUseRangAdapter.getBaseDataFilter(entityId, orgId);
            if (null != filter) {
                return filter.and(customFilter);
            }
            return customFilter;
        }
        DynamicObjectCollection coll = new BaseDataCommonService().queryBaseData(entityId, orgId, customFilter, "id");
        if (coll.isEmpty()) {
            return new QFilter("id", "in", Collections.emptyList());
        }
        if (coll.size() == 1) {
            return new QFilter("id", "=", (Object)((DynamicObject)coll.get(0)).getLong("id"));
        }
        Integer maxSize = Integer.getInteger("orm.opt.in.maxsize", 500000);
        if (maxSize < coll.size()) {
            QFilter filter = BaseDataOrgUseRangAdapter.getBaseDataFilter(entityId, orgId);
            if (null != filter) {
                return filter.and(customFilter);
            }
            return customFilter;
        }
        ArrayList dataIds = new ArrayList(10);
        coll.forEach(v -> dataIds.add(v.getLong("id")));
        return new QFilter("id", "in", dataIds);
    }

    public static QFilter getBaseDataProFilter(String entity, Long orgId, String property) {
        if (!BaseDataCtrlAdapter.checkBaseDataCtrl(entity).booleanValue()) {
            return null;
        }
        if (BaseDataCommonService.isNewModel((String)entity)) {
            return new BaseDataCommonService().getBaseDataProFilter(entity, orgId, property);
        }
        Set<Long> baseDataPropertySet = new HashSet<Long>();
        ORM orm = ORM.create();
        String temp = "";
        if ("id".equals(property)) {
            temp = "fdataid";
        } else if ("createorg".equals(property)) {
            temp = "fcreateorgid";
        }
        String dbProperty = temp;
        DynamicObject dataInfo = orm.newDynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entity));
        DynamicObject createorg = orm.getById("bos_org", (Object)orgId);
        try {
            dataInfo.set("createorg", (Object)createorg);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
        DynamicObject bdctrlstrtgy = BaseDataCtrlAdapter.getCtrlStrategy(dataInfo);
        DynamicObject defaultCtrlStrtgy = BaseDataCtrlAdapter.getDefaultCtrlStrategy(dataInfo.getDataEntityType().getName());
        if (bdctrlstrtgy == null && defaultCtrlStrtgy == null) {
            return new QFilter("id", "in", baseDataPropertySet);
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        DBRoute dbRoute = DBRoute.of((String)entityType.getDBRouteKey());
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entity);
        String baseDataTableName = dataInfo.getDataEntityType().getAlias();
        String dataBaseUsingTableName = baseDataTableName + "UseReg";
        BillEntityType billEntityType = (BillEntityType)dataInfo.getDataEntityType();
        String billStatusKey = billEntityType.getBillStatus();
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("select fdataid as fdataid ,fcreateorgid as fcreateorgid from ").append(dataBaseUsingTableName).append(" where fuseorgid = ").append(orgId);
            sb.append(" UNION ALL ");
            sb.append("select fid as fdataid ,fcreateorgid as fcreateorgid from ").append(baseDataTableName).append(" where (fctrlstrategy = '").append("5").append("'");
            if (StringUtils.isNotBlank((CharSequence)billStatusKey) && !billEntityType.getProperty(billStatusKey).isDbIgnore()) {
                String status = billEntityType.getProperty(billStatusKey).getAlias();
                sb.append(" and ").append(status).append(" = '").append(BillStatus.C.name()).append("'");
            }
            sb.append(" ) or  fcreateorgid = ").append(orgId);
            baseDataPropertySet = (Set)DB.query((DBRoute)dbRoute, (String)sb.toString(), null, rs -> {
                HashSet<Long> set = new HashSet<Long>(10);
                while (rs.next()) {
                    set.add(rs.getLong(dbProperty));
                }
                return set;
            });
            if (ctrlview != null) {
                Set<Long> parentOrgBaseDataIdSet = BaseDataOrgUseRangAdapter.getParentOrgBaseData(orgId, ctrlview.getString("number"), dbRoute, baseDataTableName, dbProperty, billEntityType);
                baseDataPropertySet.addAll(parentOrgBaseDataIdSet);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return BaseDataOrgUseRangAdapter.getBaseDataExc(orgId, property, baseDataPropertySet, dbProperty, dbRoute, baseDataTableName);
    }

    @Deprecated
    public static QFilter getBaseDataIdInFilter(String entity, Long orgId) {
        if (BaseDataCommonService.isNewModel((String)entity)) {
            return BaseDataOrgUseRangAdapter.getBaseDataProFilter(entity, orgId, "id");
        }
        QFilter baseDataIdsFilter = null;
        orgId = new BaseDataCommonService().getSupCtrlUnitIfIsUnCtrlUint(entity, orgId);
        String key = entity + orgId;
        String baseDataIdsFilterCache = BaseDataCtrlCache.getBaseDataFilter((String)key);
        if (BaseDataCtrlCacheMrg.isLoaded((String)baseDataIdsFilterCache)) {
            if (BaseDataCtrlCacheMrg.isData((String)baseDataIdsFilterCache)) {
                try {
                    baseDataIdsFilter = QFilter.fromSerializedString((String)baseDataIdsFilterCache);
                }
                catch (Exception e) {
                    BaseDataCtrlCacheMrg.clearCache((String)BaseDataCtrlCacheMrg.getType4BaseDataFilter(), (String)key);
                    return BaseDataOrgUseRangAdapter.getBaseDataIdInFilter(entity, orgId);
                }
            }
        } else {
            baseDataIdsFilter = BaseDataOrgUseRangAdapter.getBaseDataProFilter(entity, orgId, "id");
            baseDataIdsFilterCache = baseDataIdsFilter == null ? null : baseDataIdsFilter.toSerializedString();
            BaseDataCtrlCache.updateBaseDataFilter((String)key, (String)baseDataIdsFilterCache);
        }
        return baseDataIdsFilter;
    }

    @Deprecated
    public static DynamicObject getBaseData(String entity, Long orgId, String number, String selectFields) {
        QFilter[] filters;
        DynamicObject dataObj = null;
        BillEntityType billEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entity);
        QFilter numberFilter = new QFilter(billEntityType.getBillNo(), "=", (Object)number);
        if (orgId == 0L) {
            filters = new QFilter[]{numberFilter};
        } else {
            QFilter baseDataIdsFilter = BaseDataOrgUseRangAdapter.getBaseDataProFilter(entity, orgId, "id");
            filters = new QFilter[]{baseDataIdsFilter, numberFilter};
        }
        DynamicObjectCollection doCol = QueryServiceHelper.query((String)entity, (String)selectFields, (QFilter[])filters);
        if (doCol != null && doCol.size() > 0) {
            dataObj = (DynamicObject)doCol.get(0);
        }
        return dataObj;
    }

    private static QFilter getBaseDataExc(Long orgId, String property, Set<Long> baseDataPropertySet, String dbProperty, DBRoute dbRoute, String tableName) {
        String excTableName = tableName + "Exc";
        try {
            String sql = "select fdataid as fdataid ,fcreateorgid as fcreateorgid from " + excTableName + " where FUseOrgID = " + orgId;
            Set baseDataOutIdSet = (Set)DB.query((DBRoute)dbRoute, (String)sql, null, rs -> {
                HashSet<Long> set = new HashSet<Long>(16);
                while (rs.next()) {
                    set.add(rs.getLong(dbProperty));
                }
                return set;
            });
            if (baseDataOutIdSet.size() > 0) {
                for (Long id : baseDataOutIdSet) {
                    baseDataPropertySet.remove(id);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        QFilter baseDataPropertyFilter = null;
        if ("id".equals(property)) {
            baseDataPropertyFilter = new QFilter("id", "in", baseDataPropertySet);
        } else if ("createorg".equals(property)) {
            baseDataPropertyFilter = new QFilter("entryentity.createorg", "in", baseDataPropertySet);
        }
        return baseDataPropertyFilter;
    }

    private static Set<Long> getParentOrgBaseData(long orgId, String viewId, DBRoute dbRoute, String dataTableName, String property, BillEntityType billEntityType) {
        String dbProperty;
        List superiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)viewId, (long)orgId);
        String billStatusKey = billEntityType.getBillStatus();
        String string = dbProperty = "fdataid".equalsIgnoreCase(property) ? "fid" : property;
        if (superiorOrgs == null || superiorOrgs.size() == 0) {
            return new HashSet<Long>();
        }
        StringBuilder orgIdStr = new StringBuilder();
        for (Long id : superiorOrgs) {
            orgIdStr.append(id).append(',');
        }
        String sql = "select fid,fcreateorgid  from " + dataTableName + " where fcreateorgid in ( " + orgIdStr.substring(0, orgIdStr.length() - 1) + ")";
        if (StringUtils.isNotBlank((CharSequence)billStatusKey) && !billEntityType.getProperty(billStatusKey).isDbIgnore()) {
            String status = billEntityType.getProperty(billStatusKey).getAlias();
            sql = sql + " and " + status + " = '" + BillStatus.C.name() + "'";
        }
        sql = sql + " and fctrlstrategy = '6'";
        return (Set)DB.query((DBRoute)dbRoute, (String)sql, null, rs -> {
            HashSet<Long> set = new HashSet<Long>(16);
            while (rs.next()) {
                set.add(rs.getLong(dbProperty));
            }
            return set;
        });
    }

    private static boolean checkHasUseRangeData(DynamicObjectType dt, String tableName, Long orgId, String entity) {
        DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
        return (Boolean)DB.query((DBRoute)dbRoute, (String)(" select top 1 fdataid from " + tableName + " where fuseorgid = ?"), (Object[])new Object[]{orgId}, rs -> {
            boolean hasData = rs.next();
            BaseDataCtrlCache.updateIsHasBaseDataUseRange((String)entity, (Long)orgId, (Boolean)hasData);
            return hasData;
        });
    }

    private static boolean checkHasGlobalShareData(DynamicObjectType dt, String tableName, String entity) {
        DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
        return (Boolean)DB.query((DBRoute)dbRoute, (String)(" select top 1 fid from " + tableName + " where FCTRLSTRATEGY = '5'"), (Object[])new Object[0], rs -> {
            boolean hasData = rs.next();
            BaseDataCtrlCache.updateHasGlobalShareData((String)entity, (Boolean)hasData);
            return hasData;
        });
    }

    private static boolean checkHasUseRangeDataBatch(DynamicObjectType dt, String tableName, List<Long> useOrgIds, String entity) {
        SqlBuilder builder = new SqlBuilder();
        builder.append("select fuseorgid,count(1) as dataNum from ", new Object[0]).append(tableName, new Object[0]);
        builder.append(" where ", new Object[0]).appendIn("fuseorgid", new ArrayList<Long>(useOrgIds));
        builder.append(" group by fuseorgid", new Object[0]);
        DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
        Map resultMap = (Map)DB.query((DBRoute)dbRoute, (SqlBuilder)builder, rs -> {
            HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(useOrgIds.size());
            while (rs.next()) {
                Long useOrgId = rs.getLong("fuseorgid");
                result.put(useOrgId, Boolean.TRUE);
            }
            return result;
        });
        if (resultMap.isEmpty()) {
            return false;
        }
        HashMap<Long, Boolean> unLoadToCacheMap = new HashMap<Long, Boolean>(resultMap.size());
        for (Long orgId : useOrgIds) {
            Boolean isLoad = null == resultMap.get(orgId) ? Boolean.FALSE : Boolean.TRUE;
            unLoadToCacheMap.put(orgId, isLoad);
        }
        BaseDataCtrlCache.updateIsHasBaseDataUseRangeBatch((String)entity, unLoadToCacheMap);
        return true;
    }

    private static QFilter removeDuplicateData(String entity, String tableName, StringBuilder builder, QFilter useRangeFilter) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        DBRoute dbRoute = DBRoute.of((String)entityType.getDBRouteKey());
        String masterIdFieldName = BaseDataServiceHelper.getMasterIdFieldName((String)entity);
        Boolean isHasIndividualData = BaseDataCtrlCache.isHasIndividualData((String)entity);
        boolean hasIdentify = false;
        if (null != isHasIndividualData) {
            hasIdentify = isHasIndividualData;
        } else {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append(" select  top 1 fid from ", new Object[0]).append(tableName, new Object[0]);
            sqlBuilder.append(" where fid <> ", new Object[0]).append(masterIdFieldName, new Object[0]);
            try (DataSet ds = DB.queryDataSet((String)BaseDataOrgUseRangAdapter.class.getName(), (DBRoute)dbRoute, (SqlBuilder)sqlBuilder);){
                Iterator iter = ds.iterator();
                if (iter.hasNext()) {
                    hasIdentify = true;
                }
            }
            BaseDataCtrlCache.updateIsHasIndividualData((String)entity, (Boolean)hasIdentify);
        }
        if (hasIdentify) {
            StringBuilder sql = new StringBuilder();
            sql.append("select ").append(masterIdFieldName);
            sql.append(" from ").append(tableName);
            sql.append(" where ").append("fid in ").append((CharSequence)builder);
            useRangeFilter = QFilter.sqlExpress((String)"id", (String)"in", (String)sql.toString());
        }
        return useRangeFilter;
    }

    public static DynamicObjectCollection queryBaseData(String entityId, Long orgId, QFilter filter, String selectFields) {
        if (orgId == null || orgId.equals(0L) || !BaseDataCtrlAdapter.checkBaseDataCtrl(entityId).booleanValue()) {
            return QueryServiceHelper.query((String)entityId, (String)selectFields, (QFilter[])new QFilter[]{filter});
        }
        if (BaseDataCommonService.isNewModel((String)entityId)) {
            return new BaseDataCommonService().queryBaseData(entityId, orgId, filter, selectFields);
        }
        QFilter baseDataIdsFilter = BaseDataOrgUseRangAdapter.getBaseDataFilter(entityId, orgId);
        return QueryServiceHelper.query((String)entityId, (String)selectFields, (QFilter[])new QFilter[]{baseDataIdsFilter, filter});
    }

    public static Map<Object, DynamicObject> queryBaseDataFromCache(String entityId, Long orgId, QFilter filter, String selectFields) {
        if (orgId == null || orgId.equals(0L) || !BaseDataCtrlAdapter.checkBaseDataCtrl(entityId).booleanValue()) {
            return BusinessDataServiceHelper.loadFromCache((String)entityId, (String)selectFields, (QFilter[])new QFilter[]{filter});
        }
        if (BaseDataCommonService.isNewModel((String)entityId)) {
            return new BaseDataCommonService().queryBaseDataFromCache(entityId, orgId, filter, selectFields);
        }
        QFilter baseDataIdsFilter = BaseDataOrgUseRangAdapter.getBaseDataFilter(entityId, orgId);
        return BusinessDataServiceHelper.loadFromCache((String)entityId, (String)selectFields, (QFilter[])new QFilter[]{baseDataIdsFilter, filter});
    }

    public static DynamicObjectCollection queryBaseDataByDate(String entityId, Long orgId, QFilter filter, String selectFields, Date queryDate) {
        if (orgId == null || orgId.equals(0L) || !BaseDataCtrlAdapter.checkBaseDataCtrl(entityId).booleanValue()) {
            return QueryServiceHelper.queryByDate((String)entityId, (String)selectFields, (QFilter[])new QFilter[]{filter}, (Date)queryDate);
        }
        if (BaseDataCommonService.isNewModel((String)entityId)) {
            return new BaseDataCommonService().queryBaseDataByDate(entityId, orgId, filter, selectFields, queryDate);
        }
        QFilter baseDataIdsFilter = BaseDataOrgUseRangAdapter.getBaseDataFilter(entityId, orgId);
        return QueryServiceHelper.queryByDate((String)entityId, (String)selectFields, (QFilter[])new QFilter[]{baseDataIdsFilter, filter}, (Date)queryDate);
    }

    public static void refreshBaseDataUseRange(String entity, List<Long> orgIdParamList) {
        if (CollectionUtils.isEmpty(orgIdParamList)) {
            return;
        }
        HashSet<Long> tempOrgIds = new HashSet<Long>(orgIdParamList);
        if (BaseDataCommonService.isNewModel((String)entity)) {
            new BaseDataMaintenanceService(entity).correctOrgUseData(tempOrgIds);
            return;
        }
        orgIdParamList.clear();
        orgIdParamList.addAll(tempOrgIds);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entity);
        ORM orm = ORM.create();
        DynamicObject dataInfo = orm.newDynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entity));
        BillEntityType billEntityType = (BillEntityType)dataInfo.getDataEntityType();
        String billStatusKey = billEntityType.getBillStatus();
        String baseDataTableName = dt.getAlias();
        String dataBaseUsingTableName = baseDataTableName + "UseReg";
        String baseDataExcTableName = baseDataTableName + "Exc";
        String baseDataUseRangeTableName = baseDataTableName + "_U";
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        ArrayList<Long> orgIdList = new ArrayList<Long>(2000);
        for (Long orgId : orgIdParamList) {
            orgIdList.add(orgId);
            if (orgIdList.size() != 2000) continue;
            BaseDataOrgUseRangAdapter.refreshBaseDataUseRangeBatch(entity, billEntityType, billStatusKey, baseDataTableName, dataBaseUsingTableName, baseDataExcTableName, baseDataUseRangeTableName, ctrlView, orgIdList);
            orgIdList.clear();
        }
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            BaseDataOrgUseRangAdapter.refreshBaseDataUseRangeBatch(entity, billEntityType, billStatusKey, baseDataTableName, dataBaseUsingTableName, baseDataExcTableName, baseDataUseRangeTableName, ctrlView, orgIdList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshBaseDataUseRangeBatch(String entity, BillEntityType billEntityType, String billStatusKey, String baseDataTableName, String dataBaseUsingTableName, String excTableName, String useRangeTableName, DynamicObject ctrlView, List<Long> orgIdList) {
        block28: {
            ArrayList<Object[]> clearUseRegParamList = new ArrayList<Object[]>(10);
            ArrayList<Object[]> useRegParamList = new ArrayList<Object[]>(10);
            ArrayList<Object[]> selfParamList = new ArrayList<Object[]>(10);
            Iterator<Long> iterator = orgIdList.iterator();
            ArrayList<DLock> lockObjs = new ArrayList<DLock>(orgIdList.size());
            while (iterator.hasNext()) {
                Long orgId = iterator.next();
                DLock dl = DLock.create((String)("BD_CTRL_" + entity + "_" + orgId));
                if (!dl.tryLock()) {
                    iterator.remove();
                    continue;
                }
                lockObjs.add(dl);
            }
            if (orgIdList.isEmpty()) {
                return;
            }
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
            DBRoute dbRoute = DBRoute.of((String)entityType.getDBRouteKey());
            try (TXHandle h = TX.requiresNew();){
                for (Long orgId : orgIdList) {
                    ArrayList<Long> paramList = new ArrayList<Long>();
                    paramList.add(orgId);
                    clearUseRegParamList.add(paramList.toArray(new Object[0]));
                }
                DB.executeBatch((DBRoute)dbRoute, (String)String.valueOf(" delete from " + useRangeTableName + " where fuseorgid = ? "), clearUseRegParamList);
                for (Long orgId : orgIdList) {
                    List orgIds = new ArrayList(10);
                    if (ctrlView != null && orgId != null) {
                        orgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)ctrlView.getString("number"), (long)orgId);
                    }
                    ArrayList<Long> paramList = new ArrayList<Long>(1);
                    paramList.add(orgId);
                    paramList = new ArrayList(3);
                    paramList.add(orgId);
                    paramList.add(orgId);
                    paramList.add(orgId);
                    useRegParamList.add(paramList.toArray(new Object[0]));
                    paramList = new ArrayList(2);
                    paramList.add(orgId);
                    paramList.add(orgId);
                    selfParamList.add(paramList.toArray(new Object[0]));
                    StringBuffer useRangeTable = new StringBuffer();
                    useRangeTable.append(" insert into ").append(useRangeTableName).append(" (fdataid, fuseorgid)").append(" SELECT fid AS fdataid ,? AS fuseorgid FROM ").append(baseDataTableName).append(" WHERE fctrlstrategy = '6' ");
                    if (StringUtils.isNotBlank((CharSequence)billStatusKey) && !billEntityType.getProperty(billStatusKey).isDbIgnore()) {
                        String status = billEntityType.getProperty(billStatusKey).getAlias();
                        useRangeTable.append(" and ").append(status).append(" = '").append(BillStatus.C.name()).append("' ");
                    }
                    useRangeTable.append(" AND fcreateorgid IN ( ");
                    for (int i = 0; i < orgIds.size(); ++i) {
                        if (i > 0) {
                            useRangeTable.append(",");
                        }
                        useRangeTable.append("?");
                    }
                    useRangeTable.append(" ) ");
                    useRangeTable.append(" and not exists(select ").append(useRangeTableName).append(".fdataid from ").append(useRangeTableName).append(" ");
                    useRangeTable.append(" where ").append(useRangeTableName).append(".fuseorgid = ? AND ").append(baseDataTableName).append(".fid = ").append(useRangeTableName).append(".fdataid ) ");
                    useRangeTable.append(" and not EXISTS( SELECT ").append(excTableName).append(".fdataid FROM ").append(excTableName);
                    useRangeTable.append(" WHERE ").append(excTableName).append(".fuseorgid = ? ");
                    useRangeTable.append(" AND ").append(excTableName).append(".fdataid = ").append(baseDataTableName).append(".fid)");
                    if (orgIds.isEmpty()) continue;
                    paramList = new ArrayList(10);
                    paramList.add(orgId);
                    paramList.addAll(orgIds);
                    paramList.add(orgId);
                    paramList.add(orgId);
                    DB.execute((DBRoute)dbRoute, (String)String.valueOf(useRangeTable), (Object[])paramList.toArray(new Object[0]));
                }
                StringBuffer useRangeTable = new StringBuffer();
                useRangeTable.append(" insert into ").append(useRangeTableName).append(" (fdataid, fuseorgid)");
                useRangeTable.append(" SELECT fdataid AS fdataid, fuseorgid AS fuseorgid FROM ").append(dataBaseUsingTableName).append(" WHERE fuseorgid = ? ");
                useRangeTable.append(" and not exists(select ").append(useRangeTableName).append(".fdataid from ").append(useRangeTableName).append(" ");
                useRangeTable.append(" where ").append(useRangeTableName).append(".fuseorgid = ? AND ").append(dataBaseUsingTableName).append(".fdataid = ").append(useRangeTableName).append(".fdataid) ");
                useRangeTable.append(" and not EXISTS( SELECT ").append(excTableName).append(".fdataid FROM ").append(excTableName);
                useRangeTable.append(" WHERE ").append(excTableName).append(".fuseorgid = ? ");
                useRangeTable.append(" AND ").append(excTableName).append(".fdataid = ").append(dataBaseUsingTableName).append(".fdataid)");
                DB.executeBatch((DBRoute)dbRoute, (String)String.valueOf(useRangeTable), useRegParamList);
                useRangeTable = new StringBuffer();
                useRangeTable.append(" insert into ").append(useRangeTableName).append(" (fdataid, fuseorgid)");
                useRangeTable.append(" SELECT fid AS fdataid, fcreateorgid AS fuseorgid FROM ").append(baseDataTableName).append(" WHERE fcreateorgid = ? ");
                useRangeTable.append(" and not exists(select ").append(useRangeTableName).append(".fdataid from ").append(useRangeTableName);
                useRangeTable.append(" where ").append(useRangeTableName).append(".fuseorgid = ? AND ").append(baseDataTableName).append(".fid = ").append(useRangeTableName).append(".fdataid ) ");
                DB.executeBatch((DBRoute)dbRoute, (String)String.valueOf(useRangeTable), selfParamList);
                BaseDataCtrlCache.cleanIsHasBaseDataUseRange((String)entity, orgIdList);
                HashMap<String, String> baseDataUseRangeUnLoad = new HashMap<String, String>(orgIdList.size());
                for (Long orgId : orgIdList) {
                    String key = entity + orgId;
                    baseDataUseRangeUnLoad.put(key, "true");
                }
                BaseDataCtrlCache.updateBaseDataUseRangeBatch(baseDataUseRangeUnLoad);
            }
            catch (Exception e) {
                logger.error("\u5728\u8bfb\u5199\u5206\u4eab\u73af\u5883\uff0c\u5237\u65b0\u57fa\u7840\u8d44\u6599\u4f7f\u7528\u8303\u56f4\u53ef\u80fd\u6709\u5f02\u5e38\u3002\u6682\u4e0d\u5904\u7406\u3002", (Throwable)e);
            }
            finally {
                if (!CollectionUtils.isNotEmpty(lockObjs)) break block28;
                for (DLock dl : lockObjs) {
                    dl.unlock();
                }
            }
        }
        BaseDataOrgUseRangAdapter.addBatchLog(orgIdList, entity);
    }

    private static void addBatchLog(List<Long> orgIdList, String entity) {
        Date opTime = new Date();
        BaseDataThreadPoolUtils.getBdCommonThreadPool().submit(() -> {
            RequestContext context = RequestContext.get();
            String opName = ResManager.loadKDString((String)"\u6e05\u9664\u7f13\u5b58", (String)"BaseDataOrgUseRangAdapter_0", (String)"bos-mservice-bd", (Object[])new Object[0]);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
            String appId = null != mainEntityType ? mainEntityType.getAppId() : null;
            ArrayList<AppLogInfo> logInfos = new ArrayList<AppLogInfo>(orgIdList.size());
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)orgIdList)};
            Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,name", (QFilter[])filters);
            for (Long orgId : orgIdList) {
                AppLogInfo appLogInfo = new AppLogInfo();
                appLogInfo.setUserID(Long.valueOf(context.getCurrUserId()));
                appLogInfo.setClientIP(context.getLoginIP());
                appLogInfo.setClientType(context.getClient());
                appLogInfo.setClientName(context.getClient());
                appLogInfo.setAccountId(context.getAccountId());
                appLogInfo.setTenantId(context.getTenantId());
                appLogInfo.setLanguage(context.getLang().name());
                appLogInfo.setOrgID(Long.valueOf(context.getOrgId()));
                appLogInfo.setOpTime(opTime);
                appLogInfo.setOpName(opName);
                appLogInfo.setBizObjID(entity);
                appLogInfo.setBizAppID(appId);
                DynamicObject org = (DynamicObject)orgMap.get(orgId);
                String orgName = null == org ? "" : org.getString("name");
                String opDescription = String.format(ResManager.loadKDString((String)"\u6e05\u9664\u7f13\u5b58\u6210\u529f\uff0c\u7ec4\u7ec7\uff1a%1$s\uff0c\u5b9e\u4f53\uff1a%2$s", (String)"BaseDataOrgUseRangAdapter_1", (String)"bos-mservice-bd", (Object[])new Object[0]), orgName, entity);
                appLogInfo.setOpDescription(opDescription);
                logInfos.add(appLogInfo);
            }
            LogServiceHelper.addBatchLog(logInfos);
            return true;
        }, RequestContext.get());
    }
}

