/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.service.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.basedata.service.internal.BaseDataCtrlAdapter;
import kd.bos.basedata.service.internal.BaseDataOrgRelationAdapter;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.collections4.CollectionUtils;

@SdkInternal
public class ChangeCtrlStrategyAdapter {
    private static Log logger = LogFactory.getLog(ChangeCtrlStrategyAdapter.class);

    public static void baseDataCtrlChangeHandler(DynamicObject dataInfo) {
        if (dataInfo == null) {
            return;
        }
        String entityId = dataInfo.getDataEntityType().getName();
        if (BaseDataCommonService.isNewModel((String)entityId)) {
            try {
                ArrayList<Long> dataIds = new ArrayList<Long>();
                dataIds.add((Long)dataInfo.getPkValue());
                new BaseDataCommonService().changeStrategyOnNewModel(entityId, dataInfo.getString("ctrlstrategy"), dataIds);
            }
            catch (Exception e) {
                logger.error("ChangeCtrlStrategyAdapter\uff0c\u63a7\u5236\u7b56\u7565\u53d8\u66f4\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
            return;
        }
        ArrayList<Long> useOrgSet = new ArrayList<Long>(10);
        ArrayList<Long> useRangeOrgList = new ArrayList<Long>(10);
        HashSet<Long> clearOrgSet = new HashSet<Long>(16);
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        Long createOrgId = BaseDataCtrlAdapter.getBaseDataCreateOrgId(dataInfo);
        useOrgSet.add(createOrgId);
        useRangeOrgList.add(createOrgId);
        clearOrgSet.add(createOrgId);
        String ctrlStrategy = dataInfo.getString("ctrlstrategy");
        BillEntityType billEntityType = (BillEntityType)dataInfo.getDataEntityType();
        String billStatusKey = billEntityType.getBillStatus();
        String status = "";
        if (StringUtils.isNotBlank((CharSequence)billStatusKey) && !billEntityType.getProperty(billStatusKey).isDbIgnore()) {
            status = dataInfo.getString(billStatusKey);
        }
        if (StringUtils.isBlank((CharSequence)billStatusKey) || BillStatus.C.name().equals(status)) {
            DynamicObject ctrlview;
            if (!"7".equals(ctrlStrategy) && ("1".equals(ctrlStrategy) || "2".equals(ctrlStrategy) || "3".equals(ctrlStrategy) || "4".equals(ctrlStrategy)) && null == (ctrlview = BaseDataServiceHelper.getCtrlview((String)entityId))) {
                return;
            }
            if ("5".equals(ctrlStrategy)) {
                BaseDataCtrlCacheMrg.clearCacheWithPrefix((String)type, (String)entityId);
            } else if ("6".equals(ctrlStrategy)) {
                try {
                    ctrlview = BaseDataServiceHelper.getCtrlview((String)entityId);
                    if (null == ctrlview) {
                        return;
                    }
                    ArrayList<Long> useorgList = new ArrayList<Long>();
                    useorgList.add(createOrgId);
                    List orgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)((Long)ctrlview.getPkValue()), useorgList, (boolean)true);
                    List<Long> cuOrgIds = BaseDataCtrlAdapter.getCuOrgList((Long)ctrlview.getPkValue(), orgList);
                    clearOrgSet.addAll(cuOrgIds);
                    useRangeOrgList.addAll(cuOrgIds);
                }
                catch (Exception e) {
                    logger.error("BaseDataServiceHelper.baseDataCtrlChangeHandler", (Throwable)e);
                }
            }
        }
        if (useOrgSet.size() > 0) {
            ArrayList<Long> dataIds = new ArrayList<Long>(1);
            dataIds.add((Long)dataInfo.getPkValue());
            BaseDataOrgRelationAdapter.saveBaseDataUseReg(entityId, dataIds, createOrgId, createOrgId, useOrgSet, ctrlStrategy, false);
            BaseDataOrgRelationAdapter.saveBaseDataUseRange(entityId, dataIds, useRangeOrgList);
            BaseDataCtrlCache.clearBaseDataFilter((String)entityId, clearOrgSet);
        }
    }

    public static void baseDataCtrlChangeHandler(List<DynamicObject> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        BillEntityType billEntityType = (BillEntityType)dataList.get(0).getDataEntityType();
        String entityId = billEntityType.getName();
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityId);
        if (null == ctrlView) {
            return;
        }
        if (BaseDataCommonService.isNewModel((String)entityId)) {
            try {
                ArrayList dataIds = new ArrayList(dataList.size());
                dataList.forEach(data -> dataIds.add((Long)data.getPkValue()));
                String newBdCtrl = dataList.get(0).getString("ctrlstrategy");
                new BaseDataCommonService().changeStrategyOnNewModel(entityId, newBdCtrl, dataIds);
            }
            catch (Exception e) {
                logger.error("ChangeCtrlStrategyAdapter\uff0c\u63a7\u5236\u7b56\u7565\u53d8\u66f4\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
            return;
        }
        HashMap<String, List> dataMap = new HashMap<String, List>(16);
        for (DynamicObject data2 : dataList) {
            String ctrlStrategy = data2.getString("ctrlstrategy");
            Long createOrgId = BaseDataCtrlAdapter.getBaseDataCreateOrgId(data2);
            String key = ctrlStrategy + "_" + createOrgId;
            dataMap.computeIfAbsent(key, k -> new ArrayList(10)).add(data2);
        }
        ArrayList<Long> useOrgSet = new ArrayList<Long>(10);
        ArrayList<Long> useRangeOrgList = new ArrayList<Long>(10);
        HashSet<Long> clearOrgSet = new HashSet<Long>(16);
        ArrayList<Long> dataIds = new ArrayList<Long>(10);
        ArrayList<Long> cuShareDataIds = new ArrayList<Long>(10);
        String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
        String billStatusKey = billEntityType.getBillStatus();
        for (Map.Entry entry : dataMap.entrySet()) {
            DynamicObject data3 = (DynamicObject)((List)entry.getValue()).get(0);
            String ctrlStrategy = data3.getString("ctrlstrategy");
            Long createOrgId = BaseDataCtrlAdapter.getBaseDataCreateOrgId(data3);
            ArrayList<Long> useorgList = new ArrayList<Long>(10);
            useorgList.add(createOrgId);
            List allSubOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)((Long)ctrlView.getPkValue()), useorgList, (boolean)true);
            List<Long> cuOrgIds = BaseDataCtrlAdapter.getCuOrgList((Long)ctrlView.getPkValue(), allSubOrgIds);
            for (DynamicObject dataInfo : (List)entry.getValue()) {
                dataIds.add((Long)dataInfo.getPkValue());
                String status = "";
                if (StringUtils.isNotBlank((CharSequence)billStatusKey) && !billEntityType.getProperty(billStatusKey).isDbIgnore()) {
                    status = dataInfo.getString(billStatusKey);
                }
                if (!StringUtils.isBlank((CharSequence)billStatusKey) && !BillStatus.C.name().equals(status)) continue;
                if ("5".equals(ctrlStrategy)) {
                    BaseDataCtrlCacheMrg.clearCacheWithPrefix((String)type, (String)entityId);
                    continue;
                }
                if (!"6".equals(ctrlStrategy)) continue;
                cuShareDataIds.add((Long)dataInfo.getPkValue());
            }
            if (dataIds.size() > 0) {
                useOrgSet.add(createOrgId);
                useRangeOrgList.add(createOrgId);
                clearOrgSet.add(createOrgId);
                BaseDataOrgRelationAdapter.saveBaseDataUseReg(entityId, dataIds, createOrgId, createOrgId, useOrgSet, ctrlStrategy, false);
                BaseDataOrgRelationAdapter.saveBaseDataUseRange(entityId, dataIds, useRangeOrgList);
                BaseDataCtrlCache.clearBaseDataFilter((String)entityId, clearOrgSet);
                useOrgSet.clear();
                useRangeOrgList.clear();
                clearOrgSet.clear();
            }
            if (cuShareDataIds.size() > 0 && cuOrgIds.size() > 0) {
                clearOrgSet.addAll(cuOrgIds);
                useRangeOrgList.addAll(cuOrgIds);
                BaseDataOrgRelationAdapter.saveBaseDataUseRange(entityId, cuShareDataIds, useRangeOrgList);
                BaseDataCtrlCache.clearBaseDataFilter((String)entityId, clearOrgSet);
                useOrgSet.clear();
                useRangeOrgList.clear();
                clearOrgSet.clear();
            }
            useOrgSet.clear();
            useRangeOrgList.clear();
            clearOrgSet.clear();
            dataIds.clear();
            cuShareDataIds.clear();
        }
    }
}

