/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.basedata.service.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.service.AbstractBaseDataService;
import kd.bos.basedata.service.internal.BaseDataCtrlAdapter;
import kd.bos.basedata.service.internal.BaseDataOrgRelationAdapter;
import kd.bos.bd.ext.IBaseDataSubExtService;
import kd.bos.bd.log.enums.BDCtrlOperateSource;
import kd.bos.bd.log.helper.BDCtrlLogHelper;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.service.BaseDataCustomService;
import kd.bos.bd.service.BaseDataRepairService;
import kd.bos.bd.service.TreeBaseDataCommonService;
import kd.bos.bd.service.internal.BaseDataSupplementService;
import kd.bos.bd.utils.BaseDataBusinessServiceUtils;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.collections4.CollectionUtils;

@SdkInternal
public class IndividualizeAdapter {
    private static Log logger = LogFactory.getLog(IndividualizeAdapter.class);

    public static Map<Long, String> individualizePreVerify(String entity, Long orgId, List<DynamicObject> dataList) {
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        HashMap<Long, String> verifyResult = new HashMap<Long, String>(16);
        boolean isNewModel = BaseDataCommonService.isNewModel((String)entity);
        DataMutex dataMutex = DataMutex.create();
        for (DynamicObject dynamicObject : dataList) {
            Map lockInfo;
            Long dataId = (Long)dynamicObject.getPkValue();
            String ctrlStrategy = dynamicObject.getString("ctrlstrategy");
            if ("5".equals(ctrlStrategy)) {
                verifyResult.put(dataId, ResManager.loadKDString((String)"\u5168\u5c40\u5171\u4eab\u7c7b\u578b\u6570\u636e\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u3002", (String)"IndividualizeAdapter_0", (String)"bos-mservice-bd", (Object[])new Object[0]));
                continue;
            }
            if ("7".equals(ctrlStrategy)) {
                verifyResult.put(dataId, ResManager.loadKDString((String)"\u79c1\u6709\u7c7b\u578b\u6570\u636e\u4e0d\u5141\u8bb8\u4e2a\u6027\u5316\u3002", (String)"IndividualizeAdapter_1", (String)"bos-mservice-bd", (Object[])new Object[0]));
                continue;
            }
            Long masterId = dynamicObject.getLong(masterIdPropName);
            if (!dataId.equals(masterId)) {
                verifyResult.put(dataId, ResManager.loadKDString((String)"\u5df2\u4e2a\u6027\u5316\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u518d\u4e2a\u6027\u5316\u3002", (String)"IndividualizeAdapter_2", (String)"bos-mservice-bd", (Object[])new Object[0]));
                continue;
            }
            Long createOrg = dynamicObject.getLong("createorg");
            if (createOrg.equals(orgId)) {
                verifyResult.put(dataId, ResManager.loadKDString((String)"\u4e0d\u80fd\u4e2a\u6027\u5316\u81ea\u5df1\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"IndividualizeAdapter_3", (String)"bos-mservice-bd", (Object[])new Object[0]));
                continue;
            }
            if (!isNewModel || null == (lockInfo = dataMutex.getLockInfo(dataId.toString(), "individuation", entity))) continue;
            verifyResult.put(dataId, ResManager.loadKDString((String)"\u8be5\u6570\u636e\u6b63\u5728\u4e2a\u6027\u5316\u4e2d\uff0c\u4e0d\u80fd\u540c\u65f6\u5bf9\u540c\u4e00\u6761\u6570\u636e\u8fdb\u884c\u4e2a\u6027\u5316\u3002", (String)"IndividualizeAdapter_4", (String)"bos-mservice-bd", (Object[])new Object[0]));
        }
        return verifyResult;
    }

    public static boolean individualize(DynamicObject dataInfo) {
        TreeBaseDataCommonService service;
        IBaseDataCtrlPlugin baseDataCtrlPlugin;
        Object[] saveObjs;
        DynamicObjectType dt;
        Long createOrgId = BaseDataCtrlAdapter.getBaseDataCreateOrgId(dataInfo);
        Long useOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)dataInfo, (String)"useorg");
        if (createOrgId == 0L || useOrgId == 0L || createOrgId.equals(useOrgId)) {
            return false;
        }
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject newDataInfo = (DynamicObject)cloneUtils.clone((IDataEntityBase)dataInfo);
        String entityType = dataInfo.getDataEntityType().getName();
        boolean isNewModel = BaseDataCommonService.isNewModel((String)entityType);
        if (isNewModel) {
            new BaseDataCustomService(entityType).setIndexAndSourceId(newDataInfo, (Long)dataInfo.getPkValue());
        } else {
            try {
                newDataInfo.set("bitindex", null);
                newDataInfo.set("sourcedata", null);
                newDataInfo.set("srcindex", null);
            }
            catch (Exception e) {
                logger.error("\u65b0\u6a21\u578b\u4e2a\u6027\u5316\u6570\u636e\uff0c\u8bbe\u7f6e\u76f8\u5173\u4f4d\u56fe\u5b57\u6bb5\u4fe1\u606f\u53d1\u751f\u5f02\u5e38...", (Throwable)e);
            }
        }
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityType);
        Object oldPk = dataInfo.getPkValue();
        Object masterId = dataInfo.get(masterIdPropName);
        newDataInfo.set("id", null);
        newDataInfo.set("createorg", (Object)useOrgId);
        newDataInfo.set("createorg_id", (Object)useOrgId);
        newDataInfo.set("org_id", (Object)useOrgId);
        newDataInfo.set(masterIdPropName, masterId);
        ArrayList<DynamicObject[]> dataList = new ArrayList<DynamicObject[]>(1);
        DynamicObject[] individualizeData = new DynamicObject[]{dataInfo, newDataInfo};
        dataList.add(individualizeData);
        new BaseDataSupplementService().individualizeSupplement(entityType, dataList);
        boolean enableVersion = BaseDataBusinessServiceUtils.isEnableVersion((String)entityType);
        String ctrlStrategy = dataInfo.getString("ctrlstrategy");
        if ("5".equals(ctrlStrategy) && !enableVersion) {
            newDataInfo.set("ctrlstrategy", (Object)"7");
        }
        if ((dt = dataInfo.getDynamicObjectType()).getProperty("level") != null && !enableVersion) {
            QFilter[] filters;
            DynamicObject[] load;
            String entity = dataInfo.getDataEntityType().getName();
            DynamicObject parentObj = null;
            Long parentMasterId = -1L;
            if (dataInfo.get("parent") instanceof DynamicObject) {
                parentObj = dataInfo.getDynamicObject("parent");
            } else if (dataInfo.get("parent") instanceof Long) {
                parentObj = BusinessDataServiceHelper.loadSingle((Object)dataInfo.get("parent"), (String)entity);
            }
            if (parentObj != null) {
                if (parentObj.get(masterIdPropName) instanceof DynamicObject) {
                    DynamicObject master = parentObj.getDynamicObject(masterIdPropName);
                    parentMasterId = (Long)master.getPkValue();
                } else if (parentObj.get(masterIdPropName) instanceof Long) {
                    parentMasterId = (Long)parentObj.get(masterIdPropName);
                }
            }
            if ((load = BusinessDataServiceHelper.load((String)entity, (String)"", (QFilter[])(filters = new QFilter[]{new QFilter(masterIdPropName, "=", (Object)parentMasterId), new QFilter("createorg", "=", (Object)useOrgId), new QFilter(masterIdPropName, "!=", (Object)"id", true)}))) != null && load.length > 0) {
                newDataInfo.set("parent_id", load[0].getPkValue());
            }
        }
        if ((saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDataInfo})) != null && saveObjs.length > 0) {
            String baseDataTableName = dataInfo.getDataEntityType().getAlias();
            String r3TableName = baseDataTableName + "_r3";
            String dbRouteKey = dataInfo.getDataEntityType().getDBRouteKey();
            DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
            DynamicObject saveObj = (DynamicObject)saveObjs[0];
            String insertSql = "insert into " + r3TableName + "(fid,frefstatus) values(" + saveObj.getPkValue() + ",'1')";
            try (TXHandle h = TX.requiresNew();){
                try {
                    DB.execute((DBRoute)dbRoute, (String)insertSql, null);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    h.markRollback();
                }
            }
        }
        if ((baseDataCtrlPlugin = BaseDataCtrlAdapter.getBaseDataCtrlPlugin(entityType)) != null) {
            baseDataCtrlPlugin.handleModify(newDataInfo);
        }
        IBaseDataSubExtService ext = BaseDataBusinessServiceUtils.getBaseDataSubExtService((String)entityType);
        ext.handleModify(dataInfo, newDataInfo);
        Long newPk = (Long)newDataInfo.getPkValue();
        boolean isAssignUnDetail = TreeBaseDataCommonService.isAssignUnDetail((String)entityType);
        if (isNewModel) {
            try {
                new BaseDataCustomService(entityType).handleCustomBaseData(entityType, useOrgId, newDataInfo);
                if (isAssignUnDetail && !newDataInfo.getBoolean("isleaf")) {
                    if (enableVersion) {
                        ext.correctTreeDataHierarchy(entityType, useOrgId, Collections.singletonList(newPk), Collections.singletonMap((Long)oldPk, newPk));
                    } else if ("2".equals(ctrlStrategy)) {
                        new TreeBaseDataCommonService(entityType).correctTreeDataHierarchy(useOrgId, Collections.singletonList(newPk), Collections.emptyMap());
                    } else if ("1".equals(ctrlStrategy)) {
                        new TreeBaseDataCommonService(entityType).correctTreeDataHierarchy(useOrgId, Collections.singletonList(newPk), Collections.singletonMap((Long)oldPk, newPk));
                    }
                }
                dataInfo.set("id", (Object)newPk);
                return true;
            }
            catch (Exception e) {
                logger.error("\u66f4\u65b0\u4f4d\u56fe\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u4f4d\u56fe\u4fe1\u606f\u5f02\u5e38\u3002", (String)"IndividualizeAdapter_7", (String)"bos-mservice-bd", (Object[])new Object[0]));
            }
        }
        ArrayList<Long> useOrgSet = new ArrayList<Long>(Collections.singletonList(useOrgId));
        ArrayList<Long> dataIds = new ArrayList<Long>(Collections.singletonList((Long)newDataInfo.getPkValue()));
        BaseDataOrgRelationAdapter.saveBaseDataUseReg(entityType, dataIds, useOrgId, useOrgId, useOrgSet, ctrlStrategy, false);
        BaseDataOrgRelationAdapter.saveBaseDataUseRange(entityType, dataIds, useOrgSet);
        ArrayList<Long> useOrgs = new ArrayList<Long>(Collections.singletonList(useOrgId));
        IndividualizeAdapter.saveBaseDataExc(dataInfo, (Long)oldPk, createOrgId, useOrgs);
        IndividualizeAdapter.deleteBaseDataUseRange(dataInfo, useOrgs);
        BaseDataCtrlCache.clearBaseDataFilter((String)entityType, new HashSet<Long>(useOrgSet));
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)dataInfo.getDataEntityType().getName());
        if (null == ctrlView) {
            return false;
        }
        if ("2".equals(ctrlStrategy) || "4".equals(ctrlStrategy)) {
            if (isAssignUnDetail && !newDataInfo.getBoolean("isleaf")) {
                if (enableVersion) {
                    ext.correctTreeDataHierarchy(entityType, useOrgId, Collections.singletonList(newPk), Collections.singletonMap((Long)oldPk, newPk));
                } else {
                    service = new TreeBaseDataCommonService(entityType);
                    service.correctTreeDataHierarchy(useOrgId, Collections.singletonList(newPk), Collections.emptyMap());
                }
            }
            BaseDataCtrlCache.clearBaseDataFilter((String)entityType, new HashSet<Long>(Collections.singletonList(useOrgId)));
        } else if ("1".equals(ctrlStrategy) || "3".equals(ctrlStrategy)) {
            IndividualizeAdapter.handleCuAssignExc(dataInfo, (Long)oldPk, newDataInfo, (Long)ctrlView.getPkValue());
            if (isAssignUnDetail && !newDataInfo.getBoolean("isleaf")) {
                if (enableVersion) {
                    ext.correctTreeDataHierarchy(entityType, useOrgId, Collections.singletonList(newPk), Collections.singletonMap((Long)oldPk, newPk));
                } else {
                    service = new TreeBaseDataCommonService(entityType);
                    service.correctTreeDataHierarchy(useOrgId, Collections.singletonList(newPk), Collections.singletonMap((Long)oldPk, newPk));
                }
            }
        } else if ("6".equals(ctrlStrategy)) {
            ArrayList<Long> orgIds = new ArrayList<Long>(1);
            orgIds.add(useOrgId);
            List allSubordinateOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)((Long)ctrlView.getPkValue()), orgIds, (boolean)false);
            if (allSubordinateOrgList != null && allSubordinateOrgList.size() > 0) {
                ArrayList<Long> orgIdList = new ArrayList<Long>(allSubordinateOrgList);
                BaseDataOrgRelationAdapter.saveBaseDataUseRange(new DynamicObject[]{dataInfo}, orgIdList);
                if (!enableVersion) {
                    IndividualizeAdapter.saveBaseDataExc(dataInfo, (Long)oldPk, createOrgId, orgIdList);
                    IndividualizeAdapter.deleteBaseDataUseRange(dataInfo, orgIdList);
                    ArrayList<Long> masterIds = new ArrayList<Long>(1);
                    masterIds.add(dataInfo.getLong(masterIdPropName));
                    BaseDataRepairService baseDataRepairService = new BaseDataRepairService();
                    baseDataRepairService.repairDupUseRang(entityType, orgIdList, masterIds);
                }
            }
        }
        dataInfo.set("id", (Object)newPk);
        BaseDataCtrlCache.updateIsHasIndividualData((String)entityType, (Boolean)true);
        return true;
    }

    public static Map<Long, String> batchIndividualize(String entity, Long orgId, List<DynamicObject[]> dataList) {
        Map threadLocal;
        if (BaseDataCommonService.isNewModel((String)entity)) {
            return new BaseDataCustomService(entity).batchCustomBaseData(entity, orgId, dataList);
        }
        IndividualizeAdapter.saveCustomData(orgId, dataList, entity);
        boolean isAssignUnDetail = TreeBaseDataCommonService.isAssignUnDetail((String)entity);
        HashMap<Long, Long> original2CurrPkMap = new HashMap<Long, Long>(dataList.size());
        ArrayList<Long> resetLeaves = new ArrayList<Long>(dataList.size());
        HashMap<Long, String> verifyResult = new HashMap<Long, String>(dataList.size());
        ArrayList<Long> oldDataIds = new ArrayList<Long>(dataList.size());
        HashMap<Long, String> failedDetail = new HashMap<Long, String>(dataList.size());
        for (DynamicObject[] dynamicObjects : dataList) {
            DynamicObject oldObj = dynamicObjects[0];
            DynamicObject newObj = dynamicObjects[1];
            if (oldObj == null || newObj == null) continue;
            Long oldDataId = (Long)oldObj.getPkValue();
            oldDataIds.add(oldDataId);
            String ctrlStrategy = newObj.getString("ctrlstrategy");
            Long newPk = (Long)newObj.getPkValue();
            if (ctrlStrategy == null) {
                String msg = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u63a7\u5236\u7b56\u7565\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndividualizeAdapter_5", (String)"bos-mservice-bd", (Object[])new Object[0]);
                verifyResult.put(newPk, msg);
                failedDetail.put(oldDataId, msg);
            }
            Long newDataCreateOrg = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)newObj, (String)"createorg");
            Long oldDataCreateOrg = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)oldObj, (String)"createorg");
            ArrayList<Long> useOrgSet = new ArrayList<Long>();
            useOrgSet.add(orgId);
            ArrayList<Long> dataIds = new ArrayList<Long>(1);
            dataIds.add((Long)newObj.getPkValue());
            BaseDataOrgRelationAdapter.saveBaseDataUseReg(entity, dataIds, newDataCreateOrg, newDataCreateOrg, useOrgSet, ctrlStrategy, false);
            BaseDataOrgRelationAdapter.saveBaseDataUseRange(entity, dataIds, useOrgSet);
            ArrayList<Long> useOrgs = new ArrayList<Long>();
            useOrgs.add(orgId);
            IndividualizeAdapter.saveBaseDataExc(oldObj, (Long)oldObj.getPkValue(), oldDataCreateOrg, useOrgs);
            IndividualizeAdapter.deleteBaseDataUseRange(oldObj, useOrgs);
            DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)oldObj.getDataEntityType().getName());
            if (null == ctrlView) {
                verifyResult.put(newPk, ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u63a7\u5236\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IndividualizeAdapter_6", (String)"bos-mservice-bd", (Object[])new Object[0]));
                return verifyResult;
            }
            if ("2".equals(ctrlStrategy) || "4".equals(ctrlStrategy)) {
                ArrayList<Long> useOrgIdList = new ArrayList<Long>();
                useOrgIdList.add(orgId);
                BaseDataOrgRelationAdapter.saveBaseDataUseReg(entity, dataIds, newDataCreateOrg, newDataCreateOrg, useOrgIdList, ctrlStrategy, false);
                BaseDataOrgRelationAdapter.saveBaseDataUseRange(entity, dataIds, useOrgIdList);
                IndividualizeAdapter.saveBaseDataExc(oldObj, (Long)oldObj.getPkValue(), oldDataCreateOrg, useOrgIdList);
                IndividualizeAdapter.deleteBaseDataUseRange(oldObj, useOrgIdList);
                if (!isAssignUnDetail || newObj.getBoolean("isleaf")) continue;
                resetLeaves.add(newPk);
                continue;
            }
            if ("1".equals(ctrlStrategy) || "3".equals(ctrlStrategy)) {
                IndividualizeAdapter.handleCuAssignExc(oldObj, (Long)oldObj.getPkValue(), newObj, (Long)ctrlView.getPkValue());
                if (!isAssignUnDetail || newObj.getBoolean("isleaf")) continue;
                resetLeaves.add(newPk);
                original2CurrPkMap.put((Long)oldObj.getPkValue(), newPk);
                continue;
            }
            if (!"6".equals(ctrlStrategy)) continue;
            ArrayList<Long> orgIds = new ArrayList<Long>(Collections.singletonList(orgId));
            ArrayList<Long> orgIdList = new ArrayList<Long>(OrgUnitServiceHelper.getAllSubordinateOrgs((Long)((Long)ctrlView.getPkValue()), orgIds, (boolean)true));
            IndividualizeAdapter.saveBaseDataExc(oldObj, (Long)oldObj.getPkValue(), oldDataCreateOrg, orgIdList);
        }
        if (isAssignUnDetail && !resetLeaves.isEmpty()) {
            new TreeBaseDataCommonService(entity).correctTreeDataHierarchy(orgId, resetLeaves, original2CurrPkMap);
        }
        if (null == (threadLocal = (Map)BDCtrlLogHelper.THREAD_LOCAL.get()) || null == threadLocal.get("source")) {
            BDCtrlLogHelper.setLogSourceType((BDCtrlOperateSource)BDCtrlOperateSource.OTHER);
        }
        BaseDataCtrlCache.updateIsHasIndividualData((String)entity, (Boolean)true);
        BDCtrlLogHelper.saveIndividualizeLog((String)entity, oldDataIds, (Long)orgId, failedDetail);
        return verifyResult;
    }

    private static void saveCustomData(Long useOrgId, List<DynamicObject[]> dataList, String entity) {
        Map dataMap = new BaseDataSupplementService().individualizeSupplement(entity, dataList);
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        ArrayList<DynamicObject> needSaveDataList = new ArrayList<DynamicObject>(dataList.size());
        for (DynamicObject[] node : dataList) {
            DynamicObject newObj = node[1];
            if (node[0] == null || newObj == null) continue;
            if (node[0].getPkValue().equals(newObj.getPkValue())) {
                CloneUtils cloneUtils = new CloneUtils(true, true);
                newObj = node[1] = (DynamicObject)cloneUtils.clone((IDataEntityBase)newObj);
                newObj.set("id", null);
                newObj.set("createorg", (Object)useOrgId);
                newObj.set("bitindex", null);
                newObj.set("sourcedata", null);
                newObj.set("srcindex", null);
                newObj.set("createorg_id", (Object)useOrgId);
                newObj.set("org_id", (Object)useOrgId);
                newObj.set(masterIdPropName, (Object)node[0].getLong(masterIdPropName));
            }
            if (newObj.getPkValue() != null && !newObj.getPkValue().equals(0L)) continue;
            needSaveDataList.add(newObj);
            Object masterId = newObj.get(masterIdPropName);
            if (dataMap.containsKey(masterId)) continue;
            dataMap.put(masterId, newObj);
        }
        if (!dataMap.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])dataMap.values().toArray(new DynamicObject[0]));
        }
        if (!needSaveDataList.isEmpty()) {
            try {
                IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataCtrlAdapter.getBaseDataCtrlPlugin(entity);
                if (baseDataCtrlPlugin == null) {
                    return;
                }
                QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)useOrgId)};
                DynamicObject useOrg = BusinessDataServiceHelper.loadSingle((String)"bos_org", (QFilter[])qFilters);
                for (DynamicObject newDataInfo : needSaveDataList) {
                    newDataInfo.set("useorg", (Object)useOrg);
                    baseDataCtrlPlugin.handleModify(newDataInfo);
                }
            }
            catch (Exception e) {
                logger.error("\u6279\u91cf\u4e2a\u6027\u5316\u4e1a\u52a1\u5904\u7406\u5f02\u5e38...", (Throwable)e);
            }
        }
    }

    private static void deleteBaseDataUseRange(DynamicObject dataInfo, List<Long> orgIds) {
        try {
            String baseDataTableName = dataInfo.getDataEntityType().getAlias();
            String dbRouteKey = dataInfo.getDataEntityType().getDBRouteKey();
            DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
            String useRangeTableName = baseDataTableName + "_U";
            String deleteUseRangeSql = "delete from " + useRangeTableName + " where fdataid = ? and fuseorgid = ?";
            Long dataId = (Long)dataInfo.getPkValue();
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(orgIds.size());
            for (Long orgId : orgIds) {
                paramsList.add(new Object[]{dataId, orgId});
            }
            DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRangeSql, paramsList);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private static void handleCuAssignExc(DynamicObject dataInfo, Long oldPk, DynamicObject newDataInfo, Long ctrlViewId) {
        String masteridPropName = BaseDataServiceHelper.getMasterIdPropName((String)dataInfo.getDataEntityType().getName());
        Long useOrgId = 0L;
        if (dataInfo.get("useorg") instanceof DynamicObject) {
            DynamicObject useorg = dataInfo.getDynamicObject("useorg");
            useOrgId = (Long)useorg.getPkValue();
        } else if (dataInfo.get("useorg") instanceof Long) {
            useOrgId = (Long)dataInfo.get("useorg");
        }
        ArrayList<Long> useorgList = new ArrayList<Long>(Collections.singletonList(useOrgId));
        List<Long> subordinateOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)ctrlViewId, useorgList, (boolean)false);
        subordinateOrgList = BaseDataCtrlAdapter.getCuOrgList(ctrlViewId, subordinateOrgList);
        Long createOrgId = BaseDataCtrlAdapter.getBaseDataCreateOrgId(dataInfo);
        IndividualizeAdapter.deleteBaseDataUseRange(dataInfo, subordinateOrgList);
        StringBuilder sb = new StringBuilder();
        HashSet useorgIds = new HashSet(16);
        Set assignOrgSet = new HashSet(10);
        Set shareOrgSet = new HashSet(10);
        try {
            String baseDataTableName = dataInfo.getDataEntityType().getAlias();
            String bsaeDataUseRegTableName = baseDataTableName + "UseReg";
            sb.append("select fuseorgid,FIsAssign from ").append(bsaeDataUseRegTableName).append(" where fdataid = ").append(oldPk);
            String dbRouteKey = dataInfo.getDataEntityType().getDBRouteKey();
            DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
            Set[] orgSets = (Set[])DB.query((DBRoute)dbRoute, (String)sb.toString(), null, rs -> {
                HashSet<Long> assignOrgSet1 = new HashSet<Long>(10);
                HashSet<Long> shareOrgSet1 = new HashSet<Long>(10);
                Set[] orgSets1 = new HashSet[]{assignOrgSet1, shareOrgSet1};
                while (rs.next()) {
                    if ("1".equals(rs.getString("FIsAssign"))) {
                        assignOrgSet1.add(rs.getLong("fuseorgid"));
                        continue;
                    }
                    shareOrgSet1.add(rs.getLong("fuseorgid"));
                }
                return orgSets1;
            });
            assignOrgSet = orgSets[0];
            shareOrgSet = orgSets[1];
            useorgIds.addAll(assignOrgSet);
            useorgIds.addAll(shareOrgSet);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        ArrayList<Long> useOrgIdList = new ArrayList<Long>();
        for (Object id : useorgIds) {
            if (!subordinateOrgList.contains(id)) continue;
            useOrgIdList.add((Long)id);
        }
        IndividualizeAdapter.saveBaseDataExc(dataInfo, oldPk, createOrgId, useOrgIdList);
        ArrayList<Object> shareOrgIdList = new ArrayList<Object>(10);
        for (Object id : shareOrgSet) {
            if (!subordinateOrgList.contains(id)) continue;
            shareOrgIdList.add(id);
        }
        ArrayList<Long> assignOrgIdList = new ArrayList<Long>(10);
        for (Long id : assignOrgSet) {
            if (!subordinateOrgList.contains(id)) continue;
            assignOrgIdList.add(id);
        }
        String ctrlStrategy = dataInfo.getString("ctrlstrategy");
        String entityId = dataInfo.getDataEntityType().getName();
        ArrayList<Long> dataIds = new ArrayList<Long>(1);
        dataIds.add((Long)newDataInfo.getPkValue());
        ArrayList<Long> masterIds = new ArrayList<Long>(1);
        masterIds.add(newDataInfo.getLong(masteridPropName));
        Long newCreateOrgId = BaseDataCtrlAdapter.getBaseDataCreateOrgId(newDataInfo);
        if (assignOrgIdList.size() > 0) {
            IndividualizeAdapter.copyBaseDataUseReg(entityId, newCreateOrgId, oldPk, (Long)newDataInfo.getPkValue(), assignOrgIdList);
        }
        if (useOrgIdList.size() > 0) {
            BaseDataOrgRelationAdapter.saveBaseDataUseRange(entityId, dataIds, useOrgIdList);
        }
        Set<Long> excludeOrgIds = IndividualizeAdapter.getExcludeOrgIds(newDataInfo, subordinateOrgList, ctrlViewId);
        IndividualizeAdapter.saveBaseDataExc(newDataInfo, (Long)newDataInfo.getPkValue(), createOrgId, new ArrayList<Long>(excludeOrgIds));
        if (!CollectionUtils.isEmpty(excludeOrgIds)) {
            IndividualizeAdapter.deleteBaseDataUseRange(newDataInfo, new ArrayList<Long>(excludeOrgIds));
        }
        if (!BaseDataBusinessServiceUtils.isEnableVersion((String)entityId)) {
            BaseDataRepairService baseDataRepairService = new BaseDataRepairService();
            baseDataRepairService.repairDupUseRang(entityId, subordinateOrgList, masterIds);
            if ("1".equals(ctrlStrategy)) {
                ArrayList<Long> dataIdList = new ArrayList<Long>(1);
                dataIdList.add((Long)dataInfo.getPkValue());
                HashSet<Long> uesOrgSet = new HashSet<Long>();
                uesOrgSet.addAll(shareOrgIdList);
                uesOrgSet.addAll(assignOrgIdList);
                IndividualizeAdapter.deleteBaseDataUseReg(entityId, dataIdList, createOrgId, uesOrgSet);
            }
        }
    }

    private static void copyBaseDataUseReg(String entity, Long createOrgId, Long oldPk, Long newPk, List<Long> useOrgIdList) {
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entity);
        String dbRouteKey = dt.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        String baseDataTableName = dt.getAlias();
        String baseDataUseRegTableName = baseDataTableName + "UseReg";
        StringBuilder orgParamFormat = new StringBuilder();
        useOrgIdList.forEach(useOrgId -> orgParamFormat.append("?,"));
        StringBuilder copySql = new StringBuilder();
        copySql.append(" insert into ").append(baseDataUseRegTableName).append("(FUSEORGID, FDATAID, FCREATEORGID,FADMINORGID,FCTRLSTRATEGY, FISASSIGN, FASSIGNORGID) ");
        copySql.append(" select FUSEORGID, ? FDATAID, ? FCREATEORGID, ? FADMINORGID,FCTRLSTRATEGY, FISASSIGN, FASSIGNORGID ");
        copySql.append(" from ").append(baseDataUseRegTableName).append(" where FDATAID = ? and FUSEORGID in(").append(orgParamFormat.substring(0, orgParamFormat.length() - 1)).append("); ");
        ArrayList<Long> params = new ArrayList<Long>(useOrgIdList.size() + 2);
        params.add(newPk);
        params.add(createOrgId);
        params.add(createOrgId);
        params.add(oldPk);
        params.addAll(useOrgIdList);
        DB.execute((DBRoute)dbRoute, (String)copySql.toString(), (Object[])params.toArray(new Object[0]));
    }

    private static Set<Long> getExcludeOrgIds(DynamicObject newDataInfo, List<Long> subordinateOrgList, Long ctrlViewId) {
        HashSet<Long> excOrgIds = new HashSet<Long>(subordinateOrgList.size());
        if (CollectionUtils.isEmpty(subordinateOrgList)) {
            return excOrgIds;
        }
        String entity = newDataInfo.getDataEntityType().getName();
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entity);
        String masterIdFieldName = BaseDataServiceHelper.getMasterIdFieldName((String)entity);
        String baseDataTableName = newDataInfo.getDataEntityType().getAlias();
        String useRegTableName = baseDataTableName + "UseReg";
        String dbRouteKey = newDataInfo.getDataEntityType().getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        Long masterId = newDataInfo.getLong(masterIdPropName);
        StringBuilder excSql = new StringBuilder();
        excSql.append(" select u.fcreateorgid,u.fuseorgid from  ");
        excSql.append(useRegTableName).append(" u ");
        excSql.append("inner join ").append(baseDataTableName).append(" t ");
        excSql.append("on t.fid = u.fdataid ");
        excSql.append(" where t.").append(masterIdFieldName).append(" = ? ");
        excSql.append(" and u.fcreateorgid = u.fuseorgid ");
        excSql.append(" and u.fcreateorgid in( ");
        for (int i = 0; i < subordinateOrgList.size(); ++i) {
            if (i > 0) {
                excSql.append(',');
            }
            excSql.append('?');
        }
        excSql.append(" ) ");
        ArrayList<Long> paramList = new ArrayList<Long>(subordinateOrgList.size() + 1);
        paramList.add(masterId);
        paramList.addAll(subordinateOrgList);
        try (DataSet ds = DB.queryDataSet((String)AbstractBaseDataService.class.getName(), (DBRoute)dbRoute, (String)excSql.toString(), (Object[])paramList.toArray());){
            for (Row row : ds) {
                Long createOrgId = row.getLong("fcreateorgid");
                if (null == createOrgId) continue;
                excOrgIds.add(createOrgId);
            }
        }
        if (!CollectionUtils.isEmpty(excOrgIds)) {
            ArrayList<Long> useOrgList = new ArrayList<Long>(excOrgIds);
            List excSubordinateOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)ctrlViewId, useOrgList, (boolean)true);
            excOrgIds.clear();
            excOrgIds.addAll(excSubordinateOrgIds);
        }
        return excOrgIds;
    }

    private static void deleteBaseDataUseReg(String entity, List<Long> dataIds, Long createOrgId, Set<Long> useOrgIds) {
        if (CollectionUtils.isEmpty(dataIds) || CollectionUtils.isEmpty(useOrgIds)) {
            return;
        }
        HashSet<Long> useOrgSet = new HashSet<Long>(useOrgIds);
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entity);
        String baseDataTableName = dt.getAlias();
        String useRegTableName = baseDataTableName + "UseReg";
        String excTableName = baseDataTableName + "Exc";
        String dbRouteKey = dt.getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        StringBuilder param = new StringBuilder();
        useOrgSet.forEach(useOrgId -> param.append("?,"));
        ArrayList<Long> useRegSQLParams = new ArrayList<Long>(useOrgSet.size() + dataIds.size());
        useRegSQLParams.addAll(useOrgSet);
        useRegSQLParams.addAll(dataIds);
        StringBuilder useRegQuery = new StringBuilder();
        useRegQuery.append(" select fdataid,fuseorgid,fcreateorgid from ");
        useRegQuery.append(useRegTableName);
        useRegQuery.append("  where fuseorgid in (");
        useRegQuery.append(param.substring(0, param.length() - 1));
        useRegQuery.append(")");
        useRegQuery.append("  and fdataid in(  ");
        for (int i = 0; i < dataIds.size(); ++i) {
            if (i > 0) {
                useRegQuery.append(',');
            }
            useRegQuery.append('?');
        }
        useRegQuery.append(" ) ");
        ArrayList<Object[]> deleteParamsList = new ArrayList<Object[]>(useOrgSet.size());
        try (DataSet ds = DB.queryDataSet((String)AbstractBaseDataService.class.getName(), (DBRoute)dbRoute, (String)useRegQuery.toString(), (Object[])useRegSQLParams.toArray());){
            for (Row row : ds) {
                Long dataId = row.getLong("fdataid");
                if (dataId == null) continue;
                Long useOrgId2 = row.getLong("fuseorgid");
                Object[] tempParams = new Object[]{dataId, useOrgId2};
                deleteParamsList.add(tempParams);
            }
            if (!CollectionUtils.isEmpty(deleteParamsList)) {
                String deleteUseRegSql = "delete from " + useRegTableName + " where fdataid = ? and fuseorgid = ?;";
                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRegSql, deleteParamsList);
                String deleteExcSql = "delete from " + excTableName + " where fdataid = ? and fuseorgid = ?;";
                DB.executeBatch((DBRoute)dbRoute, (String)deleteExcSql, deleteParamsList);
            }
        }
    }

    public static void saveBaseDataExc(DynamicObject dataInfo, Long dataPk, Long createOrgId, List<Long> orgList) {
        String entityId = dataInfo.getDataEntityType().getName();
        ArrayList<Long> dataIds = new ArrayList<Long>(1);
        dataIds.add((Long)dataInfo.getPkValue());
        IndividualizeAdapter.saveBaseDataExc(entityId, dataIds, createOrgId, orgList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBaseDataExc(String entity, List<Long> dataIds, Long createOrgId, List<Long> orgIds) {
        if (CollectionUtils.isEmpty(dataIds) || CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        HashSet<Long> useOrgSet = new HashSet<Long>(orgIds);
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entity);
        String baseDataTableName = dt.getAlias();
        String baseDataExcTableName = baseDataTableName + "Exc";
        DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
        StringBuilder excQuery = new StringBuilder();
        StringBuilder param = new StringBuilder();
        useOrgSet.forEach(useOrgId -> param.append("?,"));
        excQuery.append(" select fdataid,fuseorgid from ");
        excQuery.append(baseDataExcTableName);
        excQuery.append("  where fuseorgid in (");
        excQuery.append(param.substring(0, param.length() - 1));
        excQuery.append(")");
        HashMap allExc = new HashMap(useOrgSet.size());
        try (DataSet ds = DB.queryDataSet((String)AbstractBaseDataService.class.getName(), (DBRoute)dbRoute, (String)excQuery.toString(), (Object[])useOrgSet.toArray());){
            for (Row row : ds) {
                if (row.getLong("fdataid") == null) continue;
                Long useOrgId2 = row.getLong("fuseorgid");
                ArrayList<Long> tempDataIds = (ArrayList<Long>)allExc.get(useOrgId2);
                if (null == tempDataIds) {
                    tempDataIds = new ArrayList<Long>(16);
                }
                Long dataId = row.getLong("fdataid");
                tempDataIds.add(dataId);
                allExc.put(useOrgId2, tempDataIds);
            }
        }
        String insertSql = "insert into " + baseDataExcTableName + "(fuseorgid, FDataID, FCreateOrgID, FNEWDATAID) values(?, ?, ?, ?)";
        try (TXHandle h = TX.beginRequired();){
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(useOrgSet.size());
            HashSet savedDataIds = new HashSet(dataIds.size());
            HashSet<Long> needSaveDataIds = new HashSet<Long>(dataIds.size());
            for (Long useOrgId3 : useOrgSet) {
                List tempDataIds = (List)allExc.get(useOrgId3);
                if (!CollectionUtils.isEmpty((Collection)tempDataIds)) {
                    savedDataIds.addAll(tempDataIds);
                }
                needSaveDataIds.addAll(dataIds);
                needSaveDataIds.removeAll(savedDataIds);
                for (Long dataId : needSaveDataIds) {
                    Object[] params = new Object[]{useOrgId3, dataId, createOrgId, 0L};
                    paramsList.add(params);
                }
                savedDataIds.clear();
                needSaveDataIds.clear();
            }
            if (!paramsList.isEmpty()) {
                DB.executeBatch((DBRoute)dbRoute, (String)insertSql, paramsList);
            }
        }
    }

    public static List<Object[]> getUnInsertExcHistory(String entity, List<Long> uesOrgIds) {
        String masterIdFieldName = BaseDataServiceHelper.getMasterIdFieldName((String)entity);
        IDataEntityType dt = ORM.create().getDataEntityType(entity);
        String baseDataTableName = dt.getAlias();
        DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
        String useRegTableName = baseDataTableName + "UseReg";
        String excTableName = baseDataTableName + "Exc";
        Object[] paramList = new Object[]{};
        StringBuilder sql = new StringBuilder();
        sql.append("select ur.fuseorgid fuseorgid, ur.fdataid fdataid, ur.fcreateorgid fcreateorgid from ");
        sql.append(useRegTableName).append(" ur ");
        sql.append("inner join ").append(baseDataTableName).append(" t");
        sql.append(" on t.").append(masterIdFieldName).append(" = ur.fmasterid and t.fcreateorgid = ur.fuseorgid ");
        sql.append("where ");
        if (uesOrgIds.size() > 0) {
            sql.append("ur.fuseorgid in(");
            for (int i = 0; i < uesOrgIds.size(); ++i) {
                sql.append(uesOrgIds.get(i));
                if (i >= uesOrgIds.size() - 1) continue;
                sql.append(",");
            }
            sql.append(") and");
        }
        sql.append(" ur.fisassign = '1' and not exists ");
        sql.append("(select fdataid,fcreateorgid,fuseorgid from ");
        sql.append(excTableName).append(" exc ");
        sql.append("where exc.fuseorgid = ur.fuseorgid and exc.fdataid = ur.fdataid);");
        return (List)DB.query((DBRoute)dbRoute, (String)sql.toString(), (Object[])paramList, rs -> {
            ArrayList<Object[]> resultList = new ArrayList<Object[]>(rs.getFetchSize());
            while (rs.next()) {
                resultList.add(new Object[]{rs.getLong(1), rs.getLong(2), rs.getLong(3)});
            }
            return resultList;
        });
    }

    public static void fixExcTable(String entity, List<Long> orgIds) {
        if (BaseDataServiceHelper.isNoneCustomEntity((String)entity).booleanValue()) {
            return;
        }
        String masterIdFieldName = BaseDataServiceHelper.getMasterIdFieldName((String)entity);
        IDataEntityType dt = ORM.create().getDataEntityType(entity);
        DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
        String tableName = dt.getAlias();
        String regTableName = tableName + "UseReg";
        String excTableName = tableName + "Exc";
        String rangeTableName = tableName + "_U";
        try {
            SqlBuilder builder = new SqlBuilder();
            builder.append("update ", new Object[0]).append(regTableName, new Object[0]).append(" r set ", new Object[0]).append(masterIdFieldName, new Object[0]).append(" = (select d.", new Object[0]).append(masterIdFieldName, new Object[0]).append(" from ", new Object[0]).append(tableName, new Object[0]).append(" d where d.fid = r.fdataid) where ", new Object[0]).append(masterIdFieldName, new Object[0]).append(" = 0", new Object[0]);
            DB.execute((DBRoute)dbRoute, (SqlBuilder)builder);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        List<Object[]> fixHistoryExcList = IndividualizeAdapter.getUnInsertExcHistory(entity, orgIds);
        if (fixHistoryExcList.size() > 0) {
            String insertExcSQL = "insert into " + excTableName + "(fuseorgid, fdataid, fcreateorgid) values (?,?,?)";
            DB.executeBatch((DBRoute)dbRoute, (String)insertExcSQL, fixHistoryExcList);
            StringBuilder deleteUseRangeql = new StringBuilder();
            deleteUseRangeql.append("delete from ").append(rangeTableName);
            deleteUseRangeql.append(" where FDataID = ? and fuseorgid = ? ");
            ArrayList<Object[]> params = new ArrayList<Object[]>(fixHistoryExcList.size());
            for (Object[] objArr : fixHistoryExcList) {
                Object useOrgId = objArr[0];
                Object dataId = objArr[1];
                params.add(new Object[]{dataId, useOrgId});
            }
            try (TXHandle h = TX.required();){
                DB.executeBatch((DBRoute)dbRoute, (String)deleteUseRangeql.toString(), params);
            }
        }
    }

    public static boolean saveHistoryInfo(DynamicObject dataInfo) {
        boolean stepStrategy;
        String entityType = dataInfo.getDataEntityType().getName();
        boolean enableVersion = BaseDataBusinessServiceUtils.isEnableVersion((String)entityType);
        if (!enableVersion) {
            return true;
        }
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject newDataInfo = (DynamicObject)cloneUtils.clone((IDataEntityBase)dataInfo);
        boolean isNewModel = BaseDataCommonService.isNewModel((String)entityType);
        if (isNewModel) {
            new BaseDataCustomService(entityType).setIndexAndSourceId(newDataInfo, (Long)dataInfo.getPkValue());
        } else {
            try {
                newDataInfo.set("bitindex", null);
                newDataInfo.set("sourcedata", null);
                newDataInfo.set("srcindex", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Long useOrgId = BaseDataCommonService.getLongPropertyFromDynamicObject((DynamicObject)dataInfo, (String)"useorg");
        Object oldPk = dataInfo.getPkValue();
        newDataInfo.set("id", null);
        newDataInfo.set("createorg", (Object)useOrgId);
        newDataInfo.set("createorg_id", (Object)useOrgId);
        newDataInfo.set("org_id", (Object)useOrgId);
        String masterIdPropName = BaseDataServiceHelper.getMasterIdPropName((String)entityType);
        newDataInfo.set(masterIdPropName, dataInfo.get(masterIdPropName));
        ArrayList<DynamicObject[]> dataList = new ArrayList<DynamicObject[]>(1);
        DynamicObject[] individualizeData = new DynamicObject[]{dataInfo, newDataInfo};
        dataList.add(individualizeData);
        new BaseDataSupplementService().individualizeSupplement(entityType, dataList);
        String ctrlStrategy = dataInfo.getString("ctrlstrategy");
        Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDataInfo});
        if (saveObjs != null && saveObjs.length > 0) {
            String baseDataTableName = dataInfo.getDataEntityType().getAlias();
            String bsaeDataR3TableName = baseDataTableName + "_r3";
            DBRoute dbRoute = DBRoute.of((String)dataInfo.getDataEntityType().getDBRouteKey());
            DynamicObject saveObj = (DynamicObject)saveObjs[0];
            String insertSql = "insert into " + bsaeDataR3TableName + "(fid,frefstatus) values(" + saveObj.getPkValue() + ",'1')";
            try (TXHandle h = TX.requiresNew();){
                try {
                    DB.execute((DBRoute)dbRoute, (String)insertSql, null);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    h.markRollback();
                }
            }
        }
        Long newPk = (Long)newDataInfo.getPkValue();
        boolean isAssignUnDetail = TreeBaseDataCommonService.isAssignUnDetail((String)entityType);
        if (isNewModel) {
            try {
                new BaseDataCustomService(entityType).saveHistoryInfo(useOrgId, newDataInfo);
                if (isAssignUnDetail && !newDataInfo.getBoolean("isleaf")) {
                    IBaseDataSubExtService ext = BaseDataBusinessServiceUtils.getBaseDataSubExtService((String)entityType);
                    ext.correctTreeDataHierarchy(entityType, useOrgId, Collections.singletonList(newPk), Collections.singletonMap((Long)oldPk, newPk));
                }
                dataInfo.set("id", (Object)newPk);
                return true;
            }
            catch (Exception e) {
                logger.error("\u66f4\u65b0\u4f4d\u56fe\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u4f4d\u56fe\u4fe1\u606f\u5f02\u5e38\u3002", (String)"IndividualizeAdapter_7", (String)"bos-mservice-bd", (Object[])new Object[0]));
            }
        }
        ArrayList<Long> dataIds = new ArrayList<Long>(Collections.singletonList((Long)newDataInfo.getPkValue()));
        ArrayList<Long> useOrgSet = new ArrayList<Long>(Collections.singletonList(useOrgId));
        BaseDataOrgRelationAdapter.saveBaseDataUseReg(entityType, dataIds, useOrgId, useOrgId, useOrgSet, ctrlStrategy, false);
        BaseDataOrgRelationAdapter.saveBaseDataUseRange(entityType, dataIds, useOrgSet);
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)dataInfo.getDataEntityType().getName());
        if (null == ctrlView) {
            return false;
        }
        boolean freeStrategy = "2".equals(ctrlStrategy) || "4".equals(ctrlStrategy);
        boolean bl = stepStrategy = "1".equals(ctrlStrategy) || "3".equals(ctrlStrategy);
        if (freeStrategy || stepStrategy) {
            if (isAssignUnDetail && !newDataInfo.getBoolean("isleaf")) {
                IBaseDataSubExtService ext = BaseDataBusinessServiceUtils.getBaseDataSubExtService((String)entityType);
                ext.correctTreeDataHierarchy(entityType, useOrgId, Collections.singletonList(newPk), Collections.singletonMap((Long)oldPk, newPk));
            }
        } else if ("6".equals(ctrlStrategy)) {
            ArrayList<Long> orgIds = new ArrayList<Long>(Collections.singletonList(useOrgId));
            List allSubordinateOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)((Long)ctrlView.getPkValue()), orgIds, (boolean)false);
            if (allSubordinateOrgList != null && allSubordinateOrgList.size() > 0) {
                BaseDataOrgRelationAdapter.saveBaseDataUseRange(new DynamicObject[]{newDataInfo}, new ArrayList<Long>(allSubordinateOrgList));
            }
        }
        dataInfo.set("id", (Object)newPk);
        return true;
    }
}

