/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.ctsy.mq;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.algo.DataSet;
import kd.bos.bd.ctsy.pojo.CtsyRecordSyncStatus;
import kd.bos.bd.ctsy.pojo.SyncOpTypeEnum;
import kd.bos.bd.ctsy.pojo.TenantType;
import kd.bos.bd.ctsy.service.CtsyIndividualizeConsumerService;
import kd.bos.bd.service.AbstractBaseDataService;
import kd.bos.bd.service.AssignService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.utils.CtsyUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;

public class CtsyUseRecordMQConsumer
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(CtsyUseRecordMQConsumer.class);
    private static final String PRO_SERVER_IP = "serverip";
    private static final String PRO_WEB_APP = "web_app";
    private static final String PRO_SERVER_PORT = "serverport";
    private static final String PRO_TARGET_TENANT_NUMBER = "tartenantnumber";
    private static final String API_MAIN_TENANT_MARK = "/kapi/v2/ctsy/base/afterSyncRecordSave";

    public void onMessage(Object body, String mqMsgId, boolean resend, MessageAcker messageAcker) {
        LOGGER.debug("mqMsgId:" + mqMsgId);
        if (null == body) {
            LOGGER.error("message body is null.");
            messageAcker.discard(mqMsgId);
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("uid", "=", (Object)body.toString()), QFilter.emptyOrNotExists((String)PRO_TARGET_TENANT_NUMBER)};
        DynamicObject syncRecord = BusinessDataServiceHelper.loadSingle((String)"ctsy_ctrlstrategy_sync", (QFilter[])filters);
        if (null == syncRecord) {
            LOGGER.error(String.format(ResManager.loadKDString((String)"\u4e3b\u6570\u636e\u540c\u6b65\u8bb0\u5f55[uid = %s]\u4e0d\u5b58\u5728...", (String)"CtsyUseRecordMQConsumer_0", (String)"bos-bd-business", (Object[])new Object[0]), body));
            messageAcker.deny(mqMsgId);
            return;
        }
        if (SyncOpTypeEnum.OP_INDIVIDUALIZATION.getOpType().equals(syncRecord.getString("optype"))) {
            try {
                new CtsyIndividualizeConsumerService().handleIndividualize(syncRecord);
                messageAcker.ack(mqMsgId);
            }
            catch (Exception e) {
                LOGGER.error(ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u540c\u6b65\u5f02\u5e38...", (String)"CtsyUseRecordMQConsumer_1", (String)"bos-bd-business", (Object[])new Object[0]), (Throwable)e);
                messageAcker.discard(mqMsgId);
                this.markFailAfterAssign(syncRecord, ResManager.loadKDString((String)"\u540c\u6b65\u4e2a\u6027\u5316\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CtsyUseRecordMQConsumer_2", (String)"bos-bd-business", (Object[])new Object[0]));
            }
            return;
        }
        try {
            this.handleAssign(syncRecord);
            messageAcker.ack(mqMsgId);
        }
        catch (Exception e) {
            LOGGER.error(ResManager.loadKDString((String)"\u5206\u914d\u5173\u7cfb\u540c\u6b65\u5f02\u5e38...", (String)"CtsyUseRecordMQConsumer_3", (String)"bos-bd-business", (Object[])new Object[0]), (Throwable)e);
            messageAcker.discard(mqMsgId);
            this.markFailAfterAssign(syncRecord, ResManager.loadKDString((String)"\u540c\u6b65\u5206\u914d\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CtsyUseRecordMQConsumer_4", (String)"bos-bd-business", (Object[])new Object[0]));
        }
    }

    private void handleAssign(final DynamicObject syncRecord) {
        Long assignOrgId;
        String entityId = syncRecord.getString("entityid");
        final Map<Long, String> dataIdNumMap = this.getAssignDataInfo(syncRecord, entityId, assignOrgId = AbstractBaseDataService.getLongPropertyFromDynamicObject(syncRecord, "oporgid"));
        if (dataIdNumMap.isEmpty()) {
            this.markMasterTenantStatusAfterSync(syncRecord, ResManager.loadKDString((String)"\u79df\u6237\u4e2d\u65e0\u5f85\u5206\u914d\u7684\u6570\u636e\u3002", (String)"CtsyUseRecordMQConsumer_5", (String)"bos-bd-business", (Object[])new Object[0]), CtsyRecordSyncStatus.FAIL, () -> null);
            return;
        }
        final Map<Long, String> orgIdNumMap = this.getUseOrgInfo(syncRecord);
        if (orgIdNumMap.isEmpty()) {
            this.markMasterTenantStatusAfterSync(syncRecord, ResManager.loadKDString((String)"\u79df\u6237\u4e2d\u65e0\u5f85\u5206\u914d\u7684\u76ee\u6807\u7ec4\u7ec7\u3002", (String)"CtsyUseRecordMQConsumer_6", (String)"bos-bd-business", (Object[])new Object[0]), CtsyRecordSyncStatus.FAIL, () -> null);
            return;
        }
        BaseDataResponse response = (new AssignService(entityId){

            private BaseDataResponse executeAssign(Long assignOrgId) {
                String appId = syncRecord.getString("appid");
                HashSet<Long> dataIds = new HashSet<Long>(dataIdNumMap.keySet());
                HashSet<Long> orgIds = new HashSet<Long>(orgIdNumMap.keySet());
                return super.assign(assignOrgId, appId, dataIds, orgIds);
            }
        }).executeAssign(assignOrgId);
        if (response.isSuccess() && CollectionUtils.isEmpty((Map)response.getResult())) {
            this.markMasterTenantStatusAfterSync(syncRecord, "", CtsyRecordSyncStatus.SUCCESS, () -> null);
        } else {
            this.markFailAfterAssign(syncRecord, response, dataIdNumMap, orgIdNumMap);
        }
    }

    private Map<Long, String> getUseOrgInfo(DynamicObject syncRecord) {
        DynamicObjectCollection orgEntry = syncRecord.getDynamicObjectCollection("orgentryentity");
        HashSet numbers = new HashSet(orgEntry.size());
        orgEntry.forEach(o -> numbers.add(o.getString("orgnumber")));
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", numbers)};
        HashMap<Long, String> id2NumMap = new HashMap<Long, String>(16);
        try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), "bos_org", "id, number", filters);){
            ds.forEach(row -> id2NumMap.put(row.getLong("id"), row.getString("number")));
        }
        return id2NumMap;
    }

    private Map<Long, String> getAssignDataInfo(DynamicObject syncRecord, String entityId, Long assignOrgId) {
        DynamicObjectCollection dataEntry = syncRecord.getDynamicObjectCollection("dataentryentity");
        HashSet numbers = new HashSet(dataEntry.size());
        dataEntry.forEach(o -> numbers.add(o.getString("number")));
        String numPro = BaseDataCommonService.isOtherMasterIdType(entityId) ? "masterid.number" : "number";
        QFilter[] filters = new QFilter[]{new QFilter(numPro, "in", numbers), BaseDataServiceHelper.getBaseDataFilter((String)entityId, (Long)assignOrgId)};
        HashMap<Long, String> id2NumMap = new HashMap<Long, String>(16);
        try (DataSet ds = ORM.create().queryDataSet(this.getClass().getName(), entityId, "id, " + numPro, filters);){
            ds.forEach(row -> id2NumMap.put(row.getLong("id"), row.getString(numPro)));
        }
        return id2NumMap;
    }

    private void markFailAfterAssign(DynamicObject syncRecord, BaseDataResponse response, Map<Long, String> dataIdNumMap, Map<Long, String> orgIdNumMap) {
        if (!response.isSuccess()) {
            this.markFailAfterAssign(syncRecord, response.getErrorMsg());
            return;
        }
        Map result = response.getResult();
        String remark = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5206\u914d\u5173\u7cfb\u5931\u8d25\u6570\u636e\u6d89\u53ca%s\u6761\uff0c\u66f4\u8be6\u7ec6\u4fe1\u606f\u53ef\u4ee5\u5230\u5b50\u79df\u6237\u7684\u7ba1\u63a7\u65e5\u5fd7\u4e2d\u67e5\u770b\u3002", (String)"CtsyUseRecordMQConsumer_7", (String)"bos-bd-business", (Object[])new Object[0]), null == result ? 0 : result.size());
        this.markMasterTenantStatusAfterSync(syncRecord, remark, CtsyRecordSyncStatus.FAIL, () -> {
            HashMap<String, String> detailedMap = new HashMap<String, String>(16);
            if (CollectionUtils.isEmpty((Map)result)) {
                return detailedMap;
            }
            for (Map.Entry entry : result.entrySet()) {
                String dataNumber = (String)dataIdNumMap.get(entry.getKey());
                Map value = (Map)entry.getValue();
                if (CollectionUtils.isEmpty((Map)value)) {
                    detailedMap.put(dataNumber, ResManager.loadKDString((String)"\u6267\u884c\u5206\u914d\u65f6\uff0c\u4e1a\u52a1\u6821\u9a8c\u5931\u8d25\u3002", (String)"CtsyUseRecordMQConsumer_8", (String)"bos-bd-business", (Object[])new Object[0]));
                    continue;
                }
                Map.Entry next = value.entrySet().iterator().next();
                detailedMap.put(dataNumber, String.format(ResManager.loadKDString((String)"\u5206\u914d\u7ed9\u7ec4\u7ec7[%1$s]\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s\u3002", (String)"CtsyUseRecordMQConsumer_9", (String)"bos-bd-business", (Object[])new Object[0]), orgIdNumMap.get(next.getKey()), next.getValue()));
            }
            return detailedMap;
        });
    }

    private void markFailAfterAssign(DynamicObject syncRecord, String remark) {
        if (StringUtils.isBlank((CharSequence)remark)) {
            remark = ResManager.loadKDString((String)"\u540c\u6b65\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CtsyUseRecordMQConsumer_10", (String)"bos-bd-business", (Object[])new Object[0]);
        } else {
            int descLength = 255;
            if (remark.length() > descLength) {
                remark = remark.substring(0, descLength - 1);
            }
        }
        this.markMasterTenantStatusAfterSync(syncRecord, remark, CtsyRecordSyncStatus.FAIL, () -> null);
    }

    private void markMasterTenantStatusAfterSync(DynamicObject syncRecord, String remark, CtsyRecordSyncStatus status, Supplier<Map<String, Object>> supplier) {
        QFilter[] masterTenantFilters = new QFilter[]{new QFilter("tenanttype", "=", (Object)TenantType.GROUP.getType())};
        DynamicObject masterTenant = BusinessDataServiceHelper.loadSingle((String)"ctsy_tenant", (QFilter[])masterTenantFilters);
        if (null == masterTenant) {
            syncRecord.set("remark", (Object)ResManager.loadKDString((String)"\u4e3b\u79df\u6237\u4e0d\u5b58\u5728\u3002", (String)"CtsyUseRecordMQConsumer_11", (String)"bos-bd-business", (Object[])new Object[0]));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{syncRecord});
            return;
        }
        String uid = syncRecord.getString("uid");
        DeleteServiceHelper.delete((String)"ctsy_ctrlstrategy_sync", (QFilter[])new QFilter[]{new QFilter("uid", "=", (Object)uid)});
        Map<String, Object> params = this.buildMapParams(uid, status.getStatus(), remark, supplier.get());
        this.markMainTenant(masterTenant, params);
    }

    private Map<String, Object> buildMapParams(String uid, String syncStatus, String remark, Map<String, Object> detailedMap) {
        HashMap<String, Object> bodyMsg = new HashMap<String, Object>(10);
        bodyMsg.put("uid", uid);
        bodyMsg.put("syncStatus", syncStatus);
        bodyMsg.put("remark", remark);
        bodyMsg.put("detail", detailedMap);
        HashMap<String, Object> body = new HashMap<String, Object>(1);
        body.put("paramMap", bodyMsg);
        return body;
    }

    private void markMainTenant(DynamicObject masterTenant, Object body) {
        try {
            String server = masterTenant.getString(PRO_SERVER_IP);
            String web = masterTenant.getString(PRO_WEB_APP);
            String port = masterTenant.getString(PRO_SERVER_PORT);
            String serverUrl = StringUtils.isBlank((CharSequence)port) ? String.format("%s%s", server, web) : String.format("%s:%s%s", server, port, web);
            String accessToken = CtsyUtils.getAccessToken(serverUrl, masterTenant);
            if (null == accessToken) {
                String tenantNumber = masterTenant.getString("number");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u79df\u6237\u201c%s\u201d\u7684access_token\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"CtsyUseRecordMQConsumer_12", (String)"bos-bd-business", (Object[])new Object[0]), tenantNumber));
            }
            HashMap<String, String> header = new HashMap<String, String>(2);
            header.put("Content-Type", "application/json");
            header.put("accesstoken", accessToken);
            String markUrl = String.join((CharSequence)"", serverUrl, API_MAIN_TENANT_MARK);
            LOGGER.debug("ctsy tenant assign url " + markUrl + ", param " + JSON.toJSONString((Object)body));
            String result = HttpClientUtils.postjson((String)markUrl, header, (String)JSON.toJSONString((Object)body));
            LOGGER.debug("ctsy tenant assign result " + result);
        }
        catch (Exception e) {
            LOGGER.error("markMainTenant error! ", (Throwable)e);
        }
    }
}

