/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.ctsy.mq;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.support.partition.PartitionStrategy;

public class CtsyUseRecordMQPublisher {
    private static final Log LOGGER = LogFactory.getLog(CtsyUseRecordMQPublisher.class);

    private CtsyUseRecordMQPublisher() {
    }

    public static void publish(String entityId, String uid) {
        String appId = CtsyUseRecordMQPublisher.getAppId(entityId);
        MessagePublisher publisher = null;
        try {
            publisher = MQFactory.get().createPartitionPublisher("base", "bdctrl_ctsy_use_record_queue", PartitionStrategy.APP_ID);
            publisher.publish((Object)uid, appId);
        }
        catch (Exception e) {
            LOGGER.error("CtsyAssignRecordMQPublisher publish error:", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u5b50\u79df\u6237\u53d1\u9001\u5206\u914d\u64cd\u4f5cMQ\u6d88\u606f\u5931\u8d25\u3002", (String)"CtsyUseRecordMQPublisher_0", (String)"bos-bd-business", (Object[])new Object[0]));
        }
        finally {
            if (null != publisher) {
                publisher.close();
            }
        }
    }

    private static String getAppId(String entityId) {
        FormConfig config = FormMetadataCache.getFormConfig((String)entityId);
        String appId = config.getAppId();
        String[] appIds = Instance.getAppIds();
        if (null == appIds || appIds.length == 0) {
            appIds = Instance.getInnerAppIds();
        }
        String defaultAppId = "bos";
        if (null == appIds || appIds.length == 0) {
            return defaultAppId;
        }
        Set collect = Arrays.stream(appIds).collect(Collectors.toSet());
        collect.removeIf(StringUtils::isBlank);
        if (collect.isEmpty()) {
            return defaultAppId;
        }
        return collect.contains(appId) ? appId : (String)collect.iterator().next();
    }
}

