/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bd.ctsy.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bd.ctsy.pojo.AssignSyncRecord;
import kd.bos.bd.ctsy.pojo.CtsyParam;
import kd.bos.bd.ctsy.pojo.CtsyRecordSyncStatus;
import kd.bos.bd.ctsy.pojo.SyncOpTypeEnum;
import kd.bos.bd.ctsy.pojo.TenantType;
import kd.bos.bd.ctsy.service.CtsyCommonService;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.bd.utils.CtsyUtils;
import kd.bos.bd.utils.FieldPropUtils;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.HttpClientUtils;

public class CtsyAssignSyncService
extends CtsyCommonService {
    private static final Log LOGGER = LogFactory.getLog(CtsyAssignSyncService.class);
    private final String entityId;
    private final Long assignOrgId;
    private final String appId;
    private final String numberPro;
    private static final String ORG_ID = "orgid";

    public CtsyAssignSyncService(String entityId, Long assignOrgId, String appId) {
        this.entityId = entityId;
        this.assignOrgId = assignOrgId;
        this.appId = appId;
        this.numberPro = BaseDataCommonService.isOtherMasterIdType(entityId) ? "masterid.number" : "number";
    }

    public void ctsyAssign(Set<Long> dataIds, Set<Long> orgIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)};
        Map tenantMap = BusinessDataServiceHelper.loadFromCache((String)"ctsy_tenant", (QFilter[])qFilters);
        boolean isMasterTenant = CtsyAssignSyncService.ifCurrentTenantIsMaster(tenantMap);
        if (CollectionUtils.isEmpty((Map)tenantMap) || !isMasterTenant) {
            return;
        }
        if (this.validateParamIsEmpty(this.entityId, this.assignOrgId, dataIds, orgIds)) {
            return;
        }
        ArrayList<AssignSyncRecord> assignSyncRecordList = new ArrayList<AssignSyncRecord>(tenantMap.size());
        HashMap<Long, String> allDataId2Number = new HashMap<Long, String>(dataIds.size());
        HashMap<Long, String> allOrgId2Number = new HashMap<Long, String>(orgIds.size());
        Map dataMap = BusinessDataServiceHelper.loadFromCache((String)this.entityId, (String)this.numberPro, (QFilter[])new QFilter[]{new QFilter("id", "in", dataIds)});
        Set dataNumbers = dataMap.values().stream().map(dataObj -> dataObj.get(this.numberPro)).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet());
        Map<Long, String> dataId2Number = dataMap.entrySet().stream().collect(Collectors.toMap(entry -> Long.valueOf(entry.getKey().toString()), entry -> ((DynamicObject)entry.getValue()).getString(this.numberPro)));
        allDataId2Number.putAll(dataId2Number);
        orgIds.add(this.assignOrgId);
        Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)FieldPropUtils.getSelectField("id", "number"), (QFilter[])new QFilter[]{new QFilter("id", "in", orgIds)});
        Map<Long, String> orgId2Number = orgMap.values().stream().collect(Collectors.toMap(org -> org.getLong("id"), org -> org.getString("number")));
        allOrgId2Number.putAll(orgId2Number);
        orgIds.remove(this.assignOrgId);
        Set orgNumbers = orgMap.values().stream().map(orgObj -> orgObj.get("number")).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet());
        String useOrgNumber = Optional.ofNullable(orgMap.get(this.assignOrgId)).map(org -> org.getString("number")).orElse("");
        orgNumbers.remove(useOrgNumber);
        Map<Long, String> tenantId2NumberMap = tenantMap.values().stream().collect(Collectors.toMap(tenant -> tenant.getLong("id"), tenant -> tenant.getString("number")));
        Map<String, Set<String>> tenantNumber2BizOrgNumberMap = this.gerTenantOrgRelationship(allOrgId2Number, orgIds, tenantId2NumberMap);
        Iterator iterator = tenantMap.values().iterator();
        while (iterator.hasNext()) {
            DynamicObject tarTenant = (DynamicObject)iterator.next();
            String tenantNumber = tarTenant.getString("number");
            if (TenantType.GROUP.getType().equals(tarTenant.getString("tenanttype"))) {
                iterator.remove();
                continue;
            }
            long uid = DB.genLongId((String)"t_ctsy_ctrlstrategy_sync");
            assignSyncRecordList.add(new AssignSyncRecord(null, uid + "", this.entityId, this.assignOrgId, this.appId, dataIds, orgIds, tenantNumber));
        }
        Map<String, AssignSyncRecord> tenantNumber2SyncRecord = this.saveAssignSyncRecord(orgIds, assignSyncRecordList, allDataId2Number, allOrgId2Number, tenantNumber2BizOrgNumberMap);
        for (DynamicObject tarTenant : tenantMap.values()) {
            Set<String> orgNumberSet = tenantNumber2BizOrgNumberMap.get(tarTenant.getString("number"));
            if (CollectionUtils.isEmpty(orgNumberSet)) continue;
            CtsyParam.CSTY_BASE_ASSIGN_THREAD_POOL.execute(() -> this.assignToChildTenant(dataNumbers, orgNumberSet, useOrgNumber, tenantNumber2SyncRecord, tarTenant));
        }
    }

    private void assignToChildTenant(Set<String> dataNumbers, Set<String> orgNumbers, String useOrgNumber, Map<String, AssignSyncRecord> tenantNumber2SyncRecord, DynamicObject tarTenant) {
        String tenantNumber = tarTenant.getString("number");
        AssignSyncRecord assignSyncRecord = tenantNumber2SyncRecord.get(tenantNumber);
        if (null == assignSyncRecord) {
            LOGGER.error("CtsyAssignSyncService assignToChildTenant assignSyncRecord is null.");
            return;
        }
        long syncRecordId = assignSyncRecord.getId();
        try {
            String accessToken;
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(tarTenant.getString("serverip"));
            urlBuilder.append(":");
            urlBuilder.append(tarTenant.getString("serverport"));
            if (!StringUtils.isEmpty((CharSequence)tarTenant.getString("web_app"))) {
                urlBuilder.append(tarTenant.getString("web_app"));
            }
            if (null == (accessToken = CtsyUtils.getAccessToken(urlBuilder.toString(), tarTenant))) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u79df\u6237\u201c%s\u201d\u7684access_token\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CtsyAssignSyncService_0", (String)"bos-bd-business", (Object[])new Object[0]), tenantNumber);
                throw new KDBizException(new ErrorCode("ERROR_CODE_1", errorMsg), new Object[]{errorMsg});
            }
            urlBuilder.append("/kapi/v2/ctsy/base/assign");
            HashMap<String, String> header = new HashMap<String, String>(2);
            header.put("Content-Type", "application/json");
            header.put("accesstoken", accessToken);
            HashMap<String, Object> bodyMsg = new HashMap<String, Object>(10);
            HashMap<String, HashMap<String, Object>> map = new HashMap<String, HashMap<String, Object>>(1);
            map.put("paramMap", bodyMsg);
            bodyMsg.put("entityid", this.entityId);
            bodyMsg.put("useOrgNumber", useOrgNumber);
            bodyMsg.put("uid", assignSyncRecord.getUid());
            bodyMsg.put("appid", this.appId);
            bodyMsg.put("orgNumbers", orgNumbers);
            bodyMsg.put("dataNumbers", dataNumbers);
            LOGGER.info("ctsy tenant assign url " + urlBuilder + ", param " + JSON.toJSONString(map));
            String result = HttpClientUtils.postjson((String)urlBuilder.toString(), header, (String)JSON.toJSONString(map), (int)defaultConnectionTimeout, (int)defaultReadTimeout);
            LOGGER.info("ctsy tenant assign result " + result);
        }
        catch (KDBizException e) {
            LOGGER.error("ctsy tenant assign KDBizException:", (Throwable)e);
            CtsyAssignSyncService.markSyncFail(syncRecordId, e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("ctsy tenant assign error:", (Throwable)e);
            CtsyAssignSyncService.markSyncFail(syncRecordId, ResManager.loadKDString((String)"\u8c03\u7528\u8de8\u79df\u6237\u5206\u914d\u63a5\u53e3\u5f02\u5e38\u3002", (String)"CtsyAssignSyncService_1", (String)"bos-bd-business", (Object[])new Object[0]));
        }
    }

    private Map<String, AssignSyncRecord> saveAssignSyncRecord(Set<Long> orgIds, List<AssignSyncRecord> assignSyncRecordList, Map<Long, String> allDataId2Number, Map<Long, String> allOrgId2Number, Map<String, Set<String>> tenantNumber2BizOrgNumberMap) {
        ArrayList<DynamicObject> saveObjList = new ArrayList<DynamicObject>(assignSyncRecordList.size());
        for (AssignSyncRecord assignSyncRecord : assignSyncRecordList) {
            Set<Long> dataIds = assignSyncRecord.getDataIds();
            String tempAppId = assignSyncRecord.getAppId();
            String tenantNumber = assignSyncRecord.getTenantNumber();
            Set<String> orgNumbers = tenantNumber2BizOrgNumberMap.get(tenantNumber);
            DynamicObject recordObj = BusinessDataServiceHelper.newDynamicObject((String)"ctsy_ctrlstrategy_sync");
            DynamicObjectCollection dataCol = recordObj.getDynamicObjectCollection("dataentryentity");
            for (Long dataId : dataIds) {
                DynamicObject dataObj = dataCol.addNew();
                dataObj.set("dataid", (Object)dataId);
                dataObj.set("number", (Object)allDataId2Number.get(dataId));
            }
            DynamicObjectCollection orgCol = recordObj.getDynamicObjectCollection("orgentryentity");
            for (Long orgId : orgIds) {
                String orgNumber = allOrgId2Number.get(orgId);
                if (null == orgNumbers || !orgNumbers.contains(orgNumber)) continue;
                DynamicObject orgObj = orgCol.addNew();
                orgObj.set(ORG_ID, (Object)orgId);
                orgObj.set("orgnumber", (Object)allOrgId2Number.get(orgId));
            }
            recordObj.set("optype", (Object)SyncOpTypeEnum.OP_ASSIGN.getOpType());
            recordObj.set("entityid", (Object)this.entityId);
            recordObj.set("appid", (Object)tempAppId);
            recordObj.set("oporgid", (Object)this.assignOrgId);
            recordObj.set("uid", (Object)assignSyncRecord.getUid());
            recordObj.set("dataentryentity", (Object)dataCol);
            recordObj.set("orgentryentity", (Object)orgCol);
            recordObj.set("tartenantnumber", (Object)tenantNumber);
            recordObj.set("syncstatus", (Object)CtsyRecordSyncStatus.SYNCHRONIZED.getStatus());
            if (orgCol.isEmpty()) continue;
            saveObjList.add(recordObj);
        }
        if (saveObjList.isEmpty()) {
            return Collections.emptyMap();
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ctsy_ctrlstrategy_sync", (DynamicObject[])saveObjList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            List successPkIds = operationResult.getSuccessPkIds();
            QFilter[] idFilters = new QFilter[]{new QFilter("id", "in", (Object)successPkIds)};
            DynamicObjectCollection assignSyncRecordCol = QueryServiceHelper.query((String)"ctsy_ctrlstrategy_sync", (String)"id,tartenantnumber", (QFilter[])idFilters);
            Map<String, Long> tenantNumber2RecordId = assignSyncRecordCol.stream().collect(Collectors.toMap(obj -> obj.getString("tartenantnumber"), obj -> obj.getLong("id")));
            return assignSyncRecordList.stream().collect(Collectors.toMap(AssignSyncRecord::getTenantNumber, syncRecord -> {
                String tenantNumber = syncRecord.getTenantNumber();
                syncRecord.setId((Long)tenantNumber2RecordId.get(tenantNumber));
                return syncRecord;
            }));
        }
        return Collections.emptyMap();
    }
}

